/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.ClearCachesTaskArg;
import org.apache.ignite.internal.processors.cache.ClearCachesTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ClearCachesTask
extends VisorOneNodeTask<ClearCachesTaskArg, ClearCachesTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<ClearCachesTaskArg, ClearCachesTaskResult> job(ClearCachesTaskArg arg) {
        return new ClearCacheJob(arg, this.debug);
    }

    private static class ClearCacheJob
    extends VisorJob<ClearCachesTaskArg, ClearCachesTaskResult> {
        private static final long serialVersionUID = 0L;
        private Ignite ignite;

        private ClearCacheJob(ClearCachesTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ClearCachesTaskResult run(@Nullable ClearCachesTaskArg arg) throws IgniteException {
            ArrayList<String> clearedCaches = new ArrayList<String>();
            ArrayList<String> nonExistentCaches = new ArrayList<String>();
            for (String cache : arg.caches()) {
                IgniteCache ignCache = this.ignite.cache(cache);
                if (ignCache == null) {
                    nonExistentCaches.add(cache);
                    continue;
                }
                ignCache.clear();
                clearedCaches.add(cache);
            }
            return new ClearCachesTaskResult(clearedCaches, nonExistentCaches);
        }

        @IgniteInstanceResource
        public void setIgnite(Ignite ignite) {
            this.ignite = ignite;
        }
    }
}

