/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.mxbean.TransactionsMXBean;

public class TransactionsMXBeanImpl
implements TransactionsMXBean {
    private final GridKernalContext ctx;

    public TransactionsMXBeanImpl(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public String getActiveTransactions(Long minDuration, Integer minSize, String prj, String consistentIds, String xid, String lbRegex, Integer limit, String order, boolean detailed, boolean kill) {
        try {
            VisorTxProjection proj = null;
            if (prj != null) {
                if ("clients".equals(prj)) {
                    proj = VisorTxProjection.CLIENT;
                } else if ("servers".equals(prj)) {
                    proj = VisorTxProjection.SERVER;
                }
            }
            List<String> consIds = null;
            if (consistentIds != null) {
                consIds = Arrays.stream(consistentIds.split(",")).collect(Collectors.toList());
            }
            VisorTxSortOrder sortOrder = null;
            if (order != null) {
                sortOrder = VisorTxSortOrder.valueOf(order.toUpperCase());
            }
            VisorTxTaskArg arg = new VisorTxTaskArg(kill ? VisorTxOperation.KILL : VisorTxOperation.LIST, limit, minDuration == null ? null : Long.valueOf(minDuration * 1000L), minSize, null, proj, consIds, xid, lbRegex, sortOrder, null);
            Map res = (Map)this.ctx.task().execute(new VisorTxTask(), new VisorTaskArgument<VisorTxTaskArg>(this.ctx.cluster().get().localNode().id(), arg, false)).get();
            if (detailed) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                for (Map.Entry entry : res.entrySet()) {
                    if (((VisorTxTaskResult)entry.getValue()).getInfos().isEmpty()) continue;
                    ClusterNode key = (ClusterNode)entry.getKey();
                    w.println(key.toString());
                    for (VisorTxInfo info : ((VisorTxTaskResult)entry.getValue()).getInfos()) {
                        w.println(info.toUserString());
                    }
                }
                w.flush();
                return sw.toString();
            }
            int cnt = 0;
            for (VisorTxTaskResult result : res.values()) {
                cnt += result.getInfos().size();
            }
            return Integer.toString(cnt);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void cancel(String xid) {
        A.notNull(xid, "xid");
        try {
            this.ctx.task().execute(new VisorTxTask(), new VisorTaskArgument<VisorTxTaskArg>(this.ctx.localNodeId(), new VisorTxTaskArg(VisorTxOperation.KILL, 1, null, null, null, null, null, xid, null, null, null), false)).get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getTxTimeoutOnPartitionMapExchange() {
        return this.ctx.config().getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
    }

    @Override
    public void setTxTimeoutOnPartitionMapExchange(long timeout) {
        try {
            this.ctx.cache().context().tm().setTxTimeoutOnPartitionMapExchange(timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean getTxOwnerDumpRequestsAllowed() {
        return this.ctx.cache().context().tm().txOwnerDumpRequestsAllowed();
    }

    @Override
    public void setTxOwnerDumpRequestsAllowed(boolean allowed) {
        this.ctx.cache().context().tm().setTxOwnerDumpRequestsAllowedDistributed(allowed);
    }

    @Override
    public long getLongTransactionTimeDumpThreshold() {
        return this.ctx.cache().context().tm().longTransactionTimeDumpThreshold();
    }

    @Override
    public void setLongTransactionTimeDumpThreshold(long threshold) {
        this.ctx.cache().context().tm().longTransactionTimeDumpThresholdDistributed(threshold);
    }

    @Override
    public double getTransactionTimeDumpSamplesCoefficient() {
        return this.ctx.cache().context().tm().transactionTimeDumpSamplesCoefficient();
    }

    @Override
    public void setTransactionTimeDumpSamplesCoefficient(double coefficient) {
        this.ctx.cache().context().tm().transactionTimeDumpSamplesCoefficientDistributed(coefficient);
    }

    @Override
    public int getTransactionTimeDumpSamplesPerSecondLimit() {
        return this.ctx.cache().context().tm().transactionTimeDumpSamplesPerSecondLimit();
    }

    @Override
    public void setTransactionTimeDumpSamplesPerSecondLimit(int limit) {
        this.ctx.cache().context().tm().longTransactionTimeDumpSamplesPerSecondLimit(limit);
    }

    @Override
    public void setLongOperationsDumpTimeout(long timeout) {
        this.ctx.cache().context().tm().longOperationsDumpTimeoutDistributed(timeout);
    }

    @Override
    public long getLongOperationsDumpTimeout() {
        return this.ctx.cache().context().tm().longOperationsDumpTimeout();
    }

    @Override
    public void setTxKeyCollisionsInterval(int timeout) {
        this.ctx.cache().context().tm().collisionsDumpIntervalDistributed(timeout);
    }

    @Override
    public int getTxKeyCollisionsInterval() {
        return this.ctx.cache().context().tm().collisionsDumpInterval();
    }

    public String toString() {
        return S.toString(TransactionsMXBeanImpl.class, this);
    }
}

