/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.cache.configuration.Factory;
import javax.management.MBeanServer;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.ExecutorConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.OdbcConfiguration;
import org.apache.ignite.configuration.PersistentStoreConfiguration;
import org.apache.ignite.configuration.PlatformConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.configuration.SqlConnectorConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.apache.ignite.plugin.segmentation.SegmentationResolver;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.eventstorage.EventStorageSpi;
import org.apache.ignite.spi.failover.FailoverSpi;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.systemview.SystemViewExporterSpi;
import org.apache.ignite.spi.tracing.TracingSpi;
import org.jetbrains.annotations.Nullable;

public class IgniteConfiguration {
    public static final String COURTESY_LOGGER_NAME = "org.apache.ignite.CourtesyConfigNotice";
    public static final boolean DFLT_P2P_ENABLED = false;
    public static final int DFLT_METRICS_HISTORY_SIZE = 10000;
    public static final long DFLT_METRICS_UPDATE_FREQ = 2000L;
    public static final long DFLT_METRICS_EXPIRE_TIME = Long.MAX_VALUE;
    public static final long DFLT_NETWORK_TIMEOUT = 5000L;
    public static final int DFLT_NETWORK_COMPRESSION = 1;
    public static final long DFLT_SEND_RETRY_DELAY = 1000L;
    public static final int DFLT_SEND_RETRY_CNT = 3;
    public static final long DFLT_DISCOVERY_STARTUP_DELAY = 60000L;
    public static final DeploymentMode DFLT_DEPLOYMENT_MODE = DeploymentMode.SHARED;
    public static final int DFLT_P2P_MISSED_RESOURCES_CACHE_SIZE = 100;
    public static final int DFLT_TIME_SERVER_PORT_BASE = 31100;
    public static final int DFLT_TIME_SERVER_PORT_RANGE = 100;
    public static final int AVAILABLE_PROC_CNT = Runtime.getRuntime().availableProcessors();
    public static final int DFLT_PUBLIC_THREAD_CNT;
    public static final int DFLT_DATA_STREAMER_POOL_SIZE;
    public static final int DFLT_REBALANCE_THREAD_POOL_SIZE;
    public static final long DFLT_REBALANCE_TIMEOUT = 10000L;
    public static final long DFLT_REBALANCE_BATCHES_PREFETCH_COUNT = 3L;
    public static final long DFLT_REBALANCE_THROTTLE = 0L;
    public static final int DFLT_REBALANCE_BATCH_SIZE = 524288;
    public static final int DFLT_SYSTEM_CORE_THREAD_CNT;
    public static final int DFLT_QUERY_THREAD_POOL_SIZE;
    public static final int DFLT_BUILD_IDX_THREAD_POOL_SIZE;
    public static final long DFLT_THREAD_KEEP_ALIVE_TIME = 60000L;
    public static final int DFLT_P2P_THREAD_CNT = 2;
    public static final int DFLT_MGMT_THREAD_CNT = 4;
    public static final SegmentationPolicy DFLT_SEG_PLC;
    public static final boolean DFLT_WAIT_FOR_SEG_ON_START = true;
    public static final boolean DFLT_ALL_SEG_RESOLVERS_PASS_REQ = true;
    public static final int DFLT_SEG_RESOLVE_ATTEMPTS = 2;
    public static final long DFLT_SEG_CHK_FREQ = 10000L;
    public static final long DFLT_METRICS_LOG_FREQ = 60000L;
    public static final int DFLT_TCP_PORT = 11211;
    public static final boolean DFLT_MARSHAL_LOCAL_JOBS = false;
    public static final boolean DFLT_CACHE_SANITY_CHECK_ENABLED = true;
    public static final String DFLT_SNAPSHOT_DIRECTORY = "snapshots";
    public static final int DFLT_SNAPSHOT_THREAD_POOL_SIZE = 4;
    @Deprecated
    public static final boolean DFLT_LATE_AFF_ASSIGNMENT = true;
    public static final ClusterState DFLT_STATE_ON_START;
    @Deprecated
    public static final boolean DFLT_ACTIVE_ON_START = true;
    @Deprecated
    public static final boolean DFLT_AUTO_ACTIVATION = true;
    public static final Long DFLT_FAILURE_DETECTION_TIMEOUT;
    public static final Long DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT;
    public static final ShutdownPolicy DFLT_SHUTDOWN_POLICY;
    @Deprecated
    public static final long DFLT_LONG_QRY_WARN_TIMEOUT = 3000L;
    public static final int DFLT_MVCC_VACUUM_THREAD_CNT = 2;
    public static final long DFLT_MVCC_VACUUM_FREQUENCY = 5000L;
    @Deprecated
    public static final int DFLT_SQL_QUERY_HISTORY_SIZE = 1000;
    private String igniteInstanceName;
    private Map<String, ?> userAttrs;
    private IgniteLogger log;
    private int pubPoolSize = DFLT_PUBLIC_THREAD_CNT;
    private Integer svcPoolSize;
    private int callbackPoolSize = DFLT_PUBLIC_THREAD_CNT;
    private int stripedPoolSize = DFLT_PUBLIC_THREAD_CNT;
    private int sysPoolSize = DFLT_SYSTEM_CORE_THREAD_CNT;
    private int mgmtPoolSize = 4;
    private int dataStreamerPoolSize = DFLT_DATA_STREAMER_POOL_SIZE;
    private int utilityCachePoolSize = DFLT_SYSTEM_CORE_THREAD_CNT;
    private long utilityCacheKeepAliveTime = 60000L;
    private int p2pPoolSize = 2;
    private int qryPoolSize = DFLT_QUERY_THREAD_POOL_SIZE;
    private int buildIdxPoolSize = DFLT_BUILD_IDX_THREAD_POOL_SIZE;
    private String igniteHome;
    private String igniteWorkDir;
    private MBeanServer mbeanSrv;
    private UUID nodeId;
    private Marshaller marsh;
    private boolean marshLocJobs = false;
    private boolean p2pEnabled = false;
    private String[] p2pLocClsPathExcl;
    private int[] inclEvtTypes;
    private long netTimeout = 5000L;
    private int netCompressionLevel = 1;
    private long sndRetryDelay = 1000L;
    private int sndRetryCnt = 3;
    private int metricsHistSize = 10000;
    private long metricsUpdateFreq = 2000L;
    private long metricsExpTime = Long.MAX_VALUE;
    private LifecycleBean[] lifecycleBeans;
    private DiscoverySpi discoSpi;
    private SegmentationPolicy segPlc = DFLT_SEG_PLC;
    private SegmentationResolver[] segResolvers;
    private int segResolveAttempts = 2;
    private boolean waitForSegOnStart = true;
    private boolean allResolversPassReq = true;
    private long segChkFreq = 10000L;
    private CommunicationSpi commSpi;
    private EventStorageSpi evtSpi;
    private CollisionSpi colSpi;
    private DeploymentSpi deploySpi;
    private CheckpointSpi[] cpSpi;
    private FailoverSpi[] failSpi;
    private LoadBalancingSpi[] loadBalancingSpi;
    private IndexingSpi indexingSpi;
    private AddressResolver addrRslvr;
    private EncryptionSpi encryptionSpi;
    private MetricExporterSpi[] metricExporterSpi;
    private SystemViewExporterSpi[] sysViewExporterSpi;
    private TracingSpi tracingSpi;
    private CacheConfiguration[] cacheCfg;
    private Boolean clientMode;
    private int rebalanceThreadPoolSize = DFLT_REBALANCE_THREAD_POOL_SIZE;
    private long rebalanceTimeout = 10000L;
    private long rebalanceBatchesPrefetchCnt = 3L;
    private long rebalanceThrottle = 0L;
    private int rebalanceBatchSize = 524288;
    private TransactionConfiguration txCfg = new TransactionConfiguration();
    @Deprecated
    private PluginConfiguration[] pluginCfgs;
    private boolean cacheSanityCheckEnabled = true;
    @Deprecated
    private long discoStartupDelay = 60000L;
    private DeploymentMode deployMode = DFLT_DEPLOYMENT_MODE;
    private int p2pMissedCacheSize = 100;
    private String locHost;
    private int timeSrvPortBase = 31100;
    private int timeSrvPortRange = 100;
    private Long failureDetectionTimeout = DFLT_FAILURE_DETECTION_TIMEOUT;
    private Long sysWorkerBlockedTimeout;
    private Long clientFailureDetectionTimeout = DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT;
    private String[] includeProps;
    private long metricsLogFreq = 60000L;
    private Map<IgnitePredicate<? extends Event>, int[]> lsnrs;
    private ServiceConfiguration[] svcCfgs;
    private ConnectorConfiguration connectorCfg = new ConnectorConfiguration();
    @Deprecated
    private OdbcConfiguration odbcCfg;
    private IgniteInClosure<IgniteConfiguration> warmupClos;
    private AtomicConfiguration atomicCfg = new AtomicConfiguration();
    private ClassLoader classLdr;
    private Factory<CacheStoreSessionListener>[] storeSesLsnrs;
    private Serializable consistentId;
    private Factory<SSLContext> sslCtxFactory;
    private PlatformConfiguration platformCfg;
    private CacheKeyConfiguration[] cacheKeyCfg;
    private BinaryConfiguration binaryCfg;
    private ExecutorConfiguration[] execCfgs;
    @Deprecated
    private MemoryConfiguration memCfg;
    @Deprecated
    private PersistentStoreConfiguration pstCfg;
    private DataStorageConfiguration dsCfg;
    private String snapshotPath = "snapshots";
    private int snapshotThreadPoolSize = 4;
    @Deprecated
    private boolean activeOnStart = true;
    private boolean activeOnStartPropSetFlag;
    @Deprecated
    private boolean autoActivation = true;
    private boolean autoActivationPropSetFlag;
    private ClusterState clusterStateOnStart;
    @Deprecated
    private SqlConnectorConfiguration sqlConnCfg;
    private ClientConnectorConfiguration cliConnCfg = ClientListenerProcessor.DFLT_CLI_CFG;
    private int mvccVacuumThreadCnt = 2;
    private long mvccVacuumFreq = 5000L;
    private boolean authEnabled;
    private FailureHandler failureHnd;
    private CommunicationFailureResolver commFailureRslvr;
    private PluginProvider[] pluginProvs;
    private SqlConfiguration sqlCfg = new SqlConfiguration();
    private Executor asyncContinuationExecutor;
    public ShutdownPolicy shutdown = DFLT_SHUTDOWN_POLICY;

    public IgniteConfiguration() {
    }

    public IgniteConfiguration(IgniteConfiguration cfg) {
        assert (cfg != null);
        this.discoSpi = cfg.getDiscoverySpi();
        this.commSpi = cfg.getCommunicationSpi();
        this.deploySpi = cfg.getDeploymentSpi();
        this.evtSpi = cfg.getEventStorageSpi();
        this.cpSpi = cfg.getCheckpointSpi();
        this.colSpi = cfg.getCollisionSpi();
        this.failSpi = cfg.getFailoverSpi();
        this.loadBalancingSpi = cfg.getLoadBalancingSpi();
        this.indexingSpi = cfg.getIndexingSpi();
        this.encryptionSpi = cfg.getEncryptionSpi();
        this.metricExporterSpi = cfg.getMetricExporterSpi();
        this.sysViewExporterSpi = cfg.getSystemViewExporterSpi();
        this.tracingSpi = cfg.getTracingSpi();
        this.commFailureRslvr = cfg.getCommunicationFailureResolver();
        this.activeOnStart = cfg.isActiveOnStart();
        this.activeOnStartPropSetFlag = cfg.activeOnStartPropSetFlag;
        this.addrRslvr = cfg.getAddressResolver();
        this.allResolversPassReq = cfg.isAllSegmentationResolversPassRequired();
        this.atomicCfg = cfg.getAtomicConfiguration();
        this.authEnabled = cfg.isAuthenticationEnabled();
        this.autoActivation = cfg.isAutoActivationEnabled();
        this.autoActivationPropSetFlag = cfg.autoActivationPropSetFlag;
        this.binaryCfg = cfg.getBinaryConfiguration();
        this.clusterStateOnStart = cfg.getClusterStateOnStart();
        this.dsCfg = cfg.getDataStorageConfiguration();
        this.memCfg = cfg.getMemoryConfiguration();
        this.pstCfg = cfg.getPersistentStoreConfiguration();
        this.cacheCfg = cfg.getCacheConfiguration();
        this.cacheKeyCfg = cfg.getCacheKeyConfiguration();
        this.cacheSanityCheckEnabled = cfg.isCacheSanityCheckEnabled();
        this.callbackPoolSize = cfg.getAsyncCallbackPoolSize();
        this.classLdr = cfg.getClassLoader();
        this.clientFailureDetectionTimeout = cfg.getClientFailureDetectionTimeout();
        this.clientMode = cfg.isClientMode();
        this.cliConnCfg = cfg.getClientConnectorConfiguration();
        this.connectorCfg = cfg.getConnectorConfiguration();
        this.consistentId = cfg.getConsistentId();
        this.dataStreamerPoolSize = cfg.getDataStreamerThreadPoolSize();
        this.deployMode = cfg.getDeploymentMode();
        this.discoStartupDelay = cfg.getDiscoveryStartupDelay();
        this.execCfgs = cfg.getExecutorConfiguration();
        this.failureDetectionTimeout = cfg.getFailureDetectionTimeout();
        this.failureHnd = cfg.getFailureHandler();
        this.igniteHome = cfg.getIgniteHome();
        this.igniteInstanceName = cfg.getIgniteInstanceName();
        this.igniteWorkDir = cfg.getWorkDirectory();
        this.inclEvtTypes = cfg.getIncludeEventTypes();
        this.includeProps = cfg.getIncludeProperties();
        this.lifecycleBeans = cfg.getLifecycleBeans();
        this.locHost = cfg.getLocalHost();
        this.log = cfg.getGridLogger();
        this.lsnrs = cfg.getLocalEventListeners();
        this.marsh = cfg.getMarshaller();
        this.marshLocJobs = cfg.isMarshalLocalJobs();
        this.mbeanSrv = cfg.getMBeanServer();
        this.metricsExpTime = cfg.getMetricsExpireTime();
        this.metricsHistSize = cfg.getMetricsHistorySize();
        this.metricsLogFreq = cfg.getMetricsLogFrequency();
        this.metricsUpdateFreq = cfg.getMetricsUpdateFrequency();
        this.mgmtPoolSize = cfg.getManagementThreadPoolSize();
        this.mvccVacuumThreadCnt = cfg.getMvccVacuumThreadCount();
        this.mvccVacuumFreq = cfg.getMvccVacuumFrequency();
        this.netTimeout = cfg.getNetworkTimeout();
        this.nodeId = cfg.getNodeId();
        this.odbcCfg = cfg.getOdbcConfiguration();
        this.p2pEnabled = cfg.isPeerClassLoadingEnabled();
        this.p2pLocClsPathExcl = cfg.getPeerClassLoadingLocalClassPathExclude();
        this.p2pMissedCacheSize = cfg.getPeerClassLoadingMissedResourcesCacheSize();
        this.p2pPoolSize = cfg.getPeerClassLoadingThreadPoolSize();
        this.platformCfg = cfg.getPlatformConfiguration();
        this.pluginCfgs = cfg.getPluginConfigurations();
        this.pluginProvs = cfg.getPluginProviders();
        this.pubPoolSize = cfg.getPublicThreadPoolSize();
        this.qryPoolSize = cfg.getQueryThreadPoolSize();
        this.buildIdxPoolSize = cfg.getBuildIndexThreadPoolSize();
        this.rebalanceThreadPoolSize = cfg.getRebalanceThreadPoolSize();
        this.rebalanceTimeout = cfg.getRebalanceTimeout();
        this.rebalanceBatchesPrefetchCnt = cfg.getRebalanceBatchesPrefetchCount();
        this.rebalanceThrottle = cfg.getRebalanceThrottle();
        this.rebalanceBatchSize = cfg.getRebalanceBatchSize();
        this.segChkFreq = cfg.getSegmentCheckFrequency();
        this.segPlc = cfg.getSegmentationPolicy();
        this.segResolveAttempts = cfg.getSegmentationResolveAttempts();
        this.segResolvers = cfg.getSegmentationResolvers();
        this.snapshotPath = cfg.getSnapshotPath();
        this.snapshotThreadPoolSize = cfg.getSnapshotThreadPoolSize();
        this.sndRetryCnt = cfg.getNetworkSendRetryCount();
        this.sndRetryDelay = cfg.getNetworkSendRetryDelay();
        this.sqlConnCfg = cfg.getSqlConnectorConfiguration();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.storeSesLsnrs = cfg.getCacheStoreSessionListenerFactories();
        this.stripedPoolSize = cfg.getStripedPoolSize();
        this.svcCfgs = cfg.getServiceConfiguration();
        this.svcPoolSize = cfg.getServiceThreadPoolSize();
        this.sysPoolSize = cfg.getSystemThreadPoolSize();
        this.sysWorkerBlockedTimeout = cfg.getSystemWorkerBlockedTimeout();
        this.timeSrvPortBase = cfg.getTimeServerPortBase();
        this.timeSrvPortRange = cfg.getTimeServerPortRange();
        this.txCfg = cfg.getTransactionConfiguration();
        this.userAttrs = cfg.getUserAttributes();
        this.utilityCacheKeepAliveTime = cfg.getUtilityCacheKeepAliveTime();
        this.utilityCachePoolSize = cfg.getUtilityCacheThreadPoolSize();
        this.waitForSegOnStart = cfg.isWaitForSegmentOnStart();
        this.warmupClos = cfg.getWarmupClosure();
        this.sqlCfg = cfg.getSqlConfiguration();
        this.shutdown = cfg.getShutdownPolicy();
        this.asyncContinuationExecutor = cfg.getAsyncContinuationExecutor();
    }

    public CommunicationFailureResolver getCommunicationFailureResolver() {
        return this.commFailureRslvr;
    }

    public IgniteConfiguration setCommunicationFailureResolver(CommunicationFailureResolver commFailureRslvr) {
        this.commFailureRslvr = commFailureRslvr;
        return this;
    }

    @Deprecated
    public String getGridName() {
        return this.getIgniteInstanceName();
    }

    public String getIgniteInstanceName() {
        return this.igniteInstanceName;
    }

    @Deprecated
    public IgniteConfiguration setGridName(String gridName) {
        return this.setIgniteInstanceName(gridName);
    }

    public IgniteConfiguration setIgniteInstanceName(String instanceName) {
        this.igniteInstanceName = instanceName;
        return this;
    }

    public IgniteConfiguration setConsistentId(Serializable consistentId) {
        this.consistentId = consistentId;
        return this;
    }

    public Serializable getConsistentId() {
        return this.consistentId;
    }

    public Map<String, ?> getUserAttributes() {
        return this.userAttrs;
    }

    public IgniteConfiguration setUserAttributes(Map<String, ?> userAttrs) {
        this.userAttrs = userAttrs;
        return this;
    }

    public IgniteLogger getGridLogger() {
        return this.log;
    }

    public IgniteConfiguration setGridLogger(IgniteLogger log) {
        this.log = log;
        return this;
    }

    public int getStripedPoolSize() {
        return this.stripedPoolSize;
    }

    public IgniteConfiguration setStripedPoolSize(int stripedPoolSize) {
        this.stripedPoolSize = stripedPoolSize;
        return this;
    }

    public int getPublicThreadPoolSize() {
        return this.pubPoolSize;
    }

    public int getServiceThreadPoolSize() {
        return this.svcPoolSize != null ? this.svcPoolSize.intValue() : this.getPublicThreadPoolSize();
    }

    public int getSystemThreadPoolSize() {
        return this.sysPoolSize;
    }

    public int getAsyncCallbackPoolSize() {
        return this.callbackPoolSize;
    }

    public int getManagementThreadPoolSize() {
        return this.mgmtPoolSize;
    }

    public int getPeerClassLoadingThreadPoolSize() {
        return this.p2pPoolSize;
    }

    public int getDataStreamerThreadPoolSize() {
        return this.dataStreamerPoolSize;
    }

    public int getUtilityCacheThreadPoolSize() {
        return this.utilityCachePoolSize;
    }

    public long getUtilityCacheKeepAliveTime() {
        return this.utilityCacheKeepAliveTime;
    }

    public int getQueryThreadPoolSize() {
        return this.qryPoolSize;
    }

    public int getBuildIndexThreadPoolSize() {
        return this.buildIdxPoolSize;
    }

    public IgniteConfiguration setBuildIndexThreadPoolSize(int poolSize) {
        this.buildIdxPoolSize = poolSize;
        return this;
    }

    @Deprecated
    public int getSqlQueryHistorySize() {
        return this.sqlCfg.getSqlQueryHistorySize();
    }

    @Deprecated
    public IgniteConfiguration setSqlQueryHistorySize(int size) {
        this.sqlCfg.setSqlQueryHistorySize(size);
        return this;
    }

    public ShutdownPolicy getShutdownPolicy() {
        return this.shutdown;
    }

    public IgniteConfiguration setShutdownPolicy(ShutdownPolicy shutdownPolicy) {
        this.shutdown = shutdownPolicy != null ? shutdownPolicy : DFLT_SHUTDOWN_POLICY;
        return this;
    }

    @Deprecated
    public long getDefaultQueryTimeout() {
        return this.sqlCfg.getDefaultQueryTimeout();
    }

    @Deprecated
    public IgniteConfiguration setDefaultQueryTimeout(long dfltQryTimeout) {
        this.sqlCfg.setDefaultQueryTimeout(dfltQryTimeout);
        return this;
    }

    public IgniteConfiguration setPublicThreadPoolSize(int poolSize) {
        this.pubPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setServiceThreadPoolSize(int poolSize) {
        this.svcPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setSystemThreadPoolSize(int poolSize) {
        this.sysPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setAsyncCallbackPoolSize(int poolSize) {
        this.callbackPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setManagementThreadPoolSize(int poolSize) {
        this.mgmtPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setPeerClassLoadingThreadPoolSize(int poolSize) {
        this.p2pPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setDataStreamerThreadPoolSize(int poolSize) {
        this.dataStreamerPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setUtilityCachePoolSize(int poolSize) {
        this.utilityCachePoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setQueryThreadPoolSize(int poolSize) {
        this.qryPoolSize = poolSize;
        return this;
    }

    public IgniteConfiguration setUtilityCacheKeepAliveTime(long keepAliveTime) {
        this.utilityCacheKeepAliveTime = keepAliveTime;
        return this;
    }

    public String getIgniteHome() {
        return this.igniteHome;
    }

    public IgniteConfiguration setIgniteHome(String igniteHome) {
        this.igniteHome = igniteHome;
        return this;
    }

    public String getWorkDirectory() {
        return this.igniteWorkDir;
    }

    public IgniteConfiguration setWorkDirectory(String igniteWorkDir) {
        this.igniteWorkDir = igniteWorkDir;
        return this;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanSrv;
    }

    public IgniteConfiguration setMBeanServer(MBeanServer mbeanSrv) {
        this.mbeanSrv = mbeanSrv;
        return this;
    }

    @Deprecated
    public UUID getNodeId() {
        return this.nodeId;
    }

    @Deprecated
    public IgniteConfiguration setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Deprecated
    public Marshaller getMarshaller() {
        return this.marsh;
    }

    @Deprecated
    public IgniteConfiguration setMarshaller(Marshaller marsh) {
        this.marsh = marsh;
        return this;
    }

    public boolean isPeerClassLoadingEnabled() {
        return this.p2pEnabled;
    }

    public boolean isMarshalLocalJobs() {
        return this.marshLocJobs;
    }

    public IgniteConfiguration setMarshalLocalJobs(boolean marshLocJobs) {
        this.marshLocJobs = marshLocJobs;
        return this;
    }

    public IgniteConfiguration setPeerClassLoadingEnabled(boolean p2pEnabled) {
        this.p2pEnabled = p2pEnabled;
        return this;
    }

    public String[] getPeerClassLoadingLocalClassPathExclude() {
        return this.p2pLocClsPathExcl;
    }

    public IgniteConfiguration setPeerClassLoadingLocalClassPathExclude(String ... p2pLocClsPathExcl) {
        this.p2pLocClsPathExcl = p2pLocClsPathExcl;
        return this;
    }

    public int getMetricsHistorySize() {
        return this.metricsHistSize;
    }

    public IgniteConfiguration setMetricsHistorySize(int metricsHistSize) {
        this.metricsHistSize = metricsHistSize;
        return this;
    }

    public long getMetricsUpdateFrequency() {
        return this.metricsUpdateFreq;
    }

    public IgniteConfiguration setMetricsUpdateFrequency(long metricsUpdateFreq) {
        this.metricsUpdateFreq = metricsUpdateFreq;
        return this;
    }

    public long getMetricsExpireTime() {
        return this.metricsExpTime;
    }

    public IgniteConfiguration setMetricsExpireTime(long metricsExpTime) {
        this.metricsExpTime = metricsExpTime;
        return this;
    }

    public long getNetworkTimeout() {
        return this.netTimeout;
    }

    public IgniteConfiguration setNetworkTimeout(long netTimeout) {
        this.netTimeout = netTimeout;
        return this;
    }

    public int getNetworkCompressionLevel() {
        return this.netCompressionLevel;
    }

    public void setNetworkCompressionLevel(int netCompressionLevel) {
        this.netCompressionLevel = netCompressionLevel;
    }

    public long getNetworkSendRetryDelay() {
        return this.sndRetryDelay;
    }

    public IgniteConfiguration setNetworkSendRetryDelay(long sndRetryDelay) {
        this.sndRetryDelay = sndRetryDelay;
        return this;
    }

    public int getNetworkSendRetryCount() {
        return this.sndRetryCnt;
    }

    public IgniteConfiguration setNetworkSendRetryCount(int sndRetryCnt) {
        this.sndRetryCnt = sndRetryCnt;
        return this;
    }

    public int getSnapshotThreadPoolSize() {
        return this.snapshotThreadPoolSize;
    }

    public IgniteConfiguration setSnapshotThreadPoolSize(int snapshotThreadPoolSize) {
        this.snapshotThreadPoolSize = snapshotThreadPoolSize;
        return this;
    }

    public int getRebalanceThreadPoolSize() {
        return this.rebalanceThreadPoolSize;
    }

    public IgniteConfiguration setRebalanceThreadPoolSize(int rebalanceThreadPoolSize) {
        this.rebalanceThreadPoolSize = rebalanceThreadPoolSize;
        return this;
    }

    public long getRebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public IgniteConfiguration setRebalanceTimeout(long rebalanceTimeout) {
        this.rebalanceTimeout = rebalanceTimeout;
        return this;
    }

    public long getRebalanceBatchesPrefetchCount() {
        return this.rebalanceBatchesPrefetchCnt;
    }

    public IgniteConfiguration setRebalanceBatchesPrefetchCount(long rebalanceBatchesCnt) {
        this.rebalanceBatchesPrefetchCnt = rebalanceBatchesCnt;
        return this;
    }

    public long getRebalanceThrottle() {
        return this.rebalanceThrottle;
    }

    public IgniteConfiguration setRebalanceThrottle(long rebalanceThrottle) {
        this.rebalanceThrottle = rebalanceThrottle;
        return this;
    }

    public int getRebalanceBatchSize() {
        return this.rebalanceBatchSize;
    }

    public IgniteConfiguration setRebalanceBatchSize(int rebalanceBatchSize) {
        this.rebalanceBatchSize = rebalanceBatchSize;
        return this;
    }

    public LifecycleBean[] getLifecycleBeans() {
        return this.lifecycleBeans;
    }

    public IgniteConfiguration setLifecycleBeans(LifecycleBean ... lifecycleBeans) {
        this.lifecycleBeans = lifecycleBeans;
        return this;
    }

    public IgniteConfiguration setSslContextFactory(Factory<SSLContext> sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
        return this;
    }

    public Factory<SSLContext> getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public EventStorageSpi getEventStorageSpi() {
        return this.evtSpi;
    }

    public IgniteConfiguration setEventStorageSpi(EventStorageSpi evtSpi) {
        this.evtSpi = evtSpi;
        return this;
    }

    public DiscoverySpi getDiscoverySpi() {
        return this.discoSpi;
    }

    public IgniteConfiguration setDiscoverySpi(DiscoverySpi discoSpi) {
        this.discoSpi = discoSpi;
        return this;
    }

    public SegmentationPolicy getSegmentationPolicy() {
        return this.segPlc;
    }

    public IgniteConfiguration setSegmentationPolicy(SegmentationPolicy segPlc) {
        this.segPlc = segPlc;
        return this;
    }

    public boolean isWaitForSegmentOnStart() {
        return this.waitForSegOnStart;
    }

    public IgniteConfiguration setWaitForSegmentOnStart(boolean waitForSegOnStart) {
        this.waitForSegOnStart = waitForSegOnStart;
        return this;
    }

    public boolean isAllSegmentationResolversPassRequired() {
        return this.allResolversPassReq;
    }

    public IgniteConfiguration setAllSegmentationResolversPassRequired(boolean allResolversPassReq) {
        this.allResolversPassReq = allResolversPassReq;
        return this;
    }

    public int getSegmentationResolveAttempts() {
        return this.segResolveAttempts;
    }

    public IgniteConfiguration setSegmentationResolveAttempts(int segResolveAttempts) {
        this.segResolveAttempts = segResolveAttempts;
        return this;
    }

    public SegmentationResolver[] getSegmentationResolvers() {
        return this.segResolvers;
    }

    public IgniteConfiguration setSegmentationResolvers(SegmentationResolver ... segResolvers) {
        this.segResolvers = segResolvers;
        return this;
    }

    public long getSegmentCheckFrequency() {
        return this.segChkFreq;
    }

    public IgniteConfiguration setSegmentCheckFrequency(long segChkFreq) {
        this.segChkFreq = segChkFreq;
        return this;
    }

    public CommunicationSpi getCommunicationSpi() {
        return this.commSpi;
    }

    public IgniteConfiguration setCommunicationSpi(CommunicationSpi commSpi) {
        this.commSpi = commSpi;
        return this;
    }

    public CollisionSpi getCollisionSpi() {
        return this.colSpi;
    }

    public IgniteConfiguration setCollisionSpi(CollisionSpi colSpi) {
        this.colSpi = colSpi;
        return this;
    }

    public DeploymentSpi getDeploymentSpi() {
        return this.deploySpi;
    }

    public IgniteConfiguration setDeploymentSpi(DeploymentSpi deploySpi) {
        this.deploySpi = deploySpi;
        return this;
    }

    public CheckpointSpi[] getCheckpointSpi() {
        return this.cpSpi;
    }

    public IgniteConfiguration setCheckpointSpi(CheckpointSpi ... cpSpi) {
        this.cpSpi = cpSpi;
        return this;
    }

    public FailoverSpi[] getFailoverSpi() {
        return this.failSpi;
    }

    public IgniteConfiguration setFailoverSpi(FailoverSpi ... failSpi) {
        this.failSpi = failSpi;
        return this;
    }

    public Long getClientFailureDetectionTimeout() {
        return this.clientFailureDetectionTimeout;
    }

    public IgniteConfiguration setClientFailureDetectionTimeout(long clientFailureDetectionTimeout) {
        this.clientFailureDetectionTimeout = clientFailureDetectionTimeout;
        return this;
    }

    public Long getFailureDetectionTimeout() {
        return this.failureDetectionTimeout;
    }

    public IgniteConfiguration setFailureDetectionTimeout(long failureDetectionTimeout) {
        this.failureDetectionTimeout = failureDetectionTimeout;
        return this;
    }

    public Long getSystemWorkerBlockedTimeout() {
        return this.sysWorkerBlockedTimeout;
    }

    public IgniteConfiguration setSystemWorkerBlockedTimeout(long sysWorkerBlockedTimeout) {
        this.sysWorkerBlockedTimeout = sysWorkerBlockedTimeout;
        return this;
    }

    public LoadBalancingSpi[] getLoadBalancingSpi() {
        return this.loadBalancingSpi;
    }

    @Deprecated
    public long getDiscoveryStartupDelay() {
        return this.discoStartupDelay;
    }

    @Deprecated
    public IgniteConfiguration setDiscoveryStartupDelay(long discoStartupDelay) {
        this.discoStartupDelay = discoStartupDelay;
        return this;
    }

    public IgniteConfiguration setLoadBalancingSpi(LoadBalancingSpi ... loadBalancingSpi) {
        this.loadBalancingSpi = loadBalancingSpi;
        return this;
    }

    public IgniteConfiguration setIndexingSpi(IndexingSpi indexingSpi) {
        this.indexingSpi = indexingSpi;
        return this;
    }

    public IndexingSpi getIndexingSpi() {
        return this.indexingSpi;
    }

    public IgniteConfiguration setEncryptionSpi(EncryptionSpi encryptionSpi) {
        this.encryptionSpi = encryptionSpi;
        return this;
    }

    public EncryptionSpi getEncryptionSpi() {
        return this.encryptionSpi;
    }

    public IgniteConfiguration setMetricExporterSpi(MetricExporterSpi ... metricExporterSpi) {
        this.metricExporterSpi = metricExporterSpi;
        return this;
    }

    public IgniteConfiguration setSystemViewExporterSpi(SystemViewExporterSpi ... sysViewExporterSpi) {
        this.sysViewExporterSpi = sysViewExporterSpi;
        return this;
    }

    public MetricExporterSpi[] getMetricExporterSpi() {
        return this.metricExporterSpi;
    }

    public SystemViewExporterSpi[] getSystemViewExporterSpi() {
        return this.sysViewExporterSpi;
    }

    public IgniteConfiguration setTracingSpi(TracingSpi tracingSpi) {
        this.tracingSpi = tracingSpi;
        return this;
    }

    public TracingSpi getTracingSpi() {
        return this.tracingSpi;
    }

    public AddressResolver getAddressResolver() {
        return this.addrRslvr;
    }

    public IgniteConfiguration setAddressResolver(AddressResolver addrRslvr) {
        this.addrRslvr = addrRslvr;
        return this;
    }

    public IgniteConfiguration setDeploymentMode(DeploymentMode deployMode) {
        this.deployMode = deployMode;
        return this;
    }

    public DeploymentMode getDeploymentMode() {
        return this.deployMode;
    }

    public IgniteConfiguration setPeerClassLoadingMissedResourcesCacheSize(int p2pMissedCacheSize) {
        this.p2pMissedCacheSize = p2pMissedCacheSize;
        return this;
    }

    public int getPeerClassLoadingMissedResourcesCacheSize() {
        return this.p2pMissedCacheSize;
    }

    public CacheConfiguration[] getCacheConfiguration() {
        return this.cacheCfg;
    }

    public IgniteConfiguration setCacheConfiguration(CacheConfiguration ... cacheCfg) {
        this.cacheCfg = cacheCfg == null ? new CacheConfiguration[]{} : cacheCfg;
        return this;
    }

    public Boolean isClientMode() {
        return this.clientMode;
    }

    public IgniteConfiguration setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    public CacheKeyConfiguration[] getCacheKeyConfiguration() {
        return this.cacheKeyCfg;
    }

    public IgniteConfiguration setCacheKeyConfiguration(CacheKeyConfiguration ... cacheKeyCfg) {
        this.cacheKeyCfg = cacheKeyCfg;
        return this;
    }

    public BinaryConfiguration getBinaryConfiguration() {
        return this.binaryCfg;
    }

    public IgniteConfiguration setBinaryConfiguration(BinaryConfiguration binaryCfg) {
        this.binaryCfg = binaryCfg;
        return this;
    }

    public DataStorageConfiguration getDataStorageConfiguration() {
        return this.dsCfg;
    }

    public IgniteConfiguration setDataStorageConfiguration(DataStorageConfiguration dsCfg) {
        this.dsCfg = dsCfg;
        return this;
    }

    @Deprecated
    public MemoryConfiguration getMemoryConfiguration() {
        return this.memCfg;
    }

    @Deprecated
    public IgniteConfiguration setMemoryConfiguration(MemoryConfiguration memCfg) {
        this.memCfg = memCfg;
        return this;
    }

    @Deprecated
    public PersistentStoreConfiguration getPersistentStoreConfiguration() {
        return this.pstCfg;
    }

    @Deprecated
    public boolean isPersistentStoreEnabled() {
        return this.pstCfg != null;
    }

    @Deprecated
    public IgniteConfiguration setPersistentStoreConfiguration(PersistentStoreConfiguration pstCfg) {
        this.pstCfg = pstCfg;
        return this;
    }

    @Deprecated
    public boolean isActiveOnStart() {
        return this.activeOnStart;
    }

    @Deprecated
    public IgniteConfiguration setActiveOnStart(boolean activeOnStart) {
        U.warn(this.log, "Property activeOnStart deprecated. Use clusterStateOnStart instead.");
        this.activeOnStart = activeOnStart;
        this.activeOnStartPropSetFlag = true;
        return this;
    }

    @Deprecated
    public boolean isAutoActivationEnabled() {
        return this.autoActivation;
    }

    @Deprecated
    public IgniteConfiguration setAutoActivationEnabled(boolean autoActivation) {
        U.warn(this.log, "Property autoActivation deprecated. Use clusterStateOnStart instead.");
        this.autoActivation = autoActivation;
        this.autoActivationPropSetFlag = true;
        return this;
    }

    @Nullable
    public ClusterState getClusterStateOnStart() {
        return this.clusterStateOnStart;
    }

    public IgniteConfiguration setClusterStateOnStart(ClusterState state) {
        this.clusterStateOnStart = state;
        return this;
    }

    public boolean isCacheSanityCheckEnabled() {
        return this.cacheSanityCheckEnabled;
    }

    public IgniteConfiguration setCacheSanityCheckEnabled(boolean cacheSanityCheckEnabled) {
        this.cacheSanityCheckEnabled = cacheSanityCheckEnabled;
        return this;
    }

    public int[] getIncludeEventTypes() {
        return this.inclEvtTypes;
    }

    public IgniteConfiguration setIncludeEventTypes(int ... inclEvtTypes) {
        this.inclEvtTypes = inclEvtTypes;
        return this;
    }

    public IgniteConfiguration setLocalHost(String locHost) {
        this.locHost = locHost;
        return this;
    }

    public String getLocalHost() {
        return this.locHost;
    }

    public int getTimeServerPortBase() {
        return this.timeSrvPortBase;
    }

    public IgniteConfiguration setTimeServerPortBase(int timeSrvPortBase) {
        this.timeSrvPortBase = timeSrvPortBase;
        return this;
    }

    public int getTimeServerPortRange() {
        return this.timeSrvPortRange;
    }

    public IgniteConfiguration setTimeServerPortRange(int timeSrvPortRange) {
        this.timeSrvPortRange = timeSrvPortRange;
        return this;
    }

    public String[] getIncludeProperties() {
        return this.includeProps;
    }

    public IgniteConfiguration setIncludeProperties(String ... includeProps) {
        this.includeProps = includeProps;
        return this;
    }

    public long getMetricsLogFrequency() {
        return this.metricsLogFreq;
    }

    public IgniteConfiguration setMetricsLogFrequency(long metricsLogFreq) {
        this.metricsLogFreq = metricsLogFreq;
        return this;
    }

    public ConnectorConfiguration getConnectorConfiguration() {
        return this.connectorCfg;
    }

    public IgniteConfiguration setConnectorConfiguration(ConnectorConfiguration connectorCfg) {
        this.connectorCfg = connectorCfg;
        return this;
    }

    @Deprecated
    public OdbcConfiguration getOdbcConfiguration() {
        return this.odbcCfg;
    }

    @Deprecated
    public IgniteConfiguration setOdbcConfiguration(OdbcConfiguration odbcCfg) {
        this.odbcCfg = odbcCfg;
        return this;
    }

    public ServiceConfiguration[] getServiceConfiguration() {
        return this.svcCfgs;
    }

    public IgniteConfiguration setServiceConfiguration(ServiceConfiguration ... svcCfgs) {
        this.svcCfgs = svcCfgs;
        return this;
    }

    public Map<IgnitePredicate<? extends Event>, int[]> getLocalEventListeners() {
        return this.lsnrs;
    }

    public IgniteConfiguration setLocalEventListeners(Map<IgnitePredicate<? extends Event>, int[]> lsnrs) {
        this.lsnrs = lsnrs;
        return this;
    }

    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public IgniteConfiguration setSnapshotPath(String snapshotPath) {
        this.snapshotPath = snapshotPath;
        return this;
    }

    public IgniteInClosure<IgniteConfiguration> getWarmupClosure() {
        return this.warmupClos;
    }

    public IgniteConfiguration setWarmupClosure(IgniteInClosure<IgniteConfiguration> warmupClos) {
        this.warmupClos = warmupClos;
        return this;
    }

    public TransactionConfiguration getTransactionConfiguration() {
        return this.txCfg;
    }

    public IgniteConfiguration setTransactionConfiguration(TransactionConfiguration txCfg) {
        this.txCfg = txCfg;
        return this;
    }

    @Deprecated
    public PluginConfiguration[] getPluginConfigurations() {
        return this.pluginCfgs;
    }

    @Deprecated
    public IgniteConfiguration setPluginConfigurations(PluginConfiguration ... pluginCfgs) {
        this.pluginCfgs = pluginCfgs;
        return this;
    }

    public AtomicConfiguration getAtomicConfiguration() {
        return this.atomicCfg;
    }

    public IgniteConfiguration setAtomicConfiguration(AtomicConfiguration atomicCfg) {
        this.atomicCfg = atomicCfg;
        return this;
    }

    public IgniteConfiguration setClassLoader(ClassLoader classLdr) {
        this.classLdr = classLdr;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLdr;
    }

    public Factory<CacheStoreSessionListener>[] getCacheStoreSessionListenerFactories() {
        return this.storeSesLsnrs;
    }

    public IgniteConfiguration setCacheStoreSessionListenerFactories(Factory<CacheStoreSessionListener> ... storeSesLsnrs) {
        this.storeSesLsnrs = storeSesLsnrs;
        return this;
    }

    public PlatformConfiguration getPlatformConfiguration() {
        return this.platformCfg;
    }

    public IgniteConfiguration setPlatformConfiguration(PlatformConfiguration platformCfg) {
        this.platformCfg = platformCfg;
        return this;
    }

    @Deprecated
    public boolean isLateAffinityAssignment() {
        return true;
    }

    @Deprecated
    public IgniteConfiguration setLateAffinityAssignment(boolean lateAffAssignment) {
        return this;
    }

    public ExecutorConfiguration[] getExecutorConfiguration() {
        return this.execCfgs;
    }

    public IgniteConfiguration setExecutorConfiguration(ExecutorConfiguration ... execCfgs) {
        this.execCfgs = execCfgs;
        return this;
    }

    @Deprecated
    public long getLongQueryWarningTimeout() {
        return this.sqlCfg.getLongQueryWarningTimeout();
    }

    @Deprecated
    public IgniteConfiguration setLongQueryWarningTimeout(long longQryWarnTimeout) {
        this.sqlCfg.setLongQueryWarningTimeout(longQryWarnTimeout);
        return this;
    }

    @Deprecated
    public IgniteConfiguration setSqlConnectorConfiguration(SqlConnectorConfiguration sqlConnCfg) {
        this.sqlConnCfg = sqlConnCfg;
        return this;
    }

    @Deprecated
    public SqlConnectorConfiguration getSqlConnectorConfiguration() {
        return this.sqlConnCfg;
    }

    public IgniteConfiguration setClientConnectorConfiguration(@Nullable ClientConnectorConfiguration cliConnCfg) {
        this.cliConnCfg = cliConnCfg;
        return this;
    }

    public FailureHandler getFailureHandler() {
        return this.failureHnd;
    }

    public IgniteConfiguration setFailureHandler(FailureHandler failureHnd) {
        this.failureHnd = failureHnd;
        return this;
    }

    @Nullable
    public ClientConnectorConfiguration getClientConnectorConfiguration() {
        return this.cliConnCfg;
    }

    @IgniteExperimental
    public int getMvccVacuumThreadCount() {
        return this.mvccVacuumThreadCnt;
    }

    @IgniteExperimental
    public IgniteConfiguration setMvccVacuumThreadCount(int mvccVacuumThreadCnt) {
        this.mvccVacuumThreadCnt = mvccVacuumThreadCnt;
        return this;
    }

    @IgniteExperimental
    public long getMvccVacuumFrequency() {
        return this.mvccVacuumFreq;
    }

    @IgniteExperimental
    public IgniteConfiguration setMvccVacuumFrequency(long mvccVacuumFreq) {
        this.mvccVacuumFreq = mvccVacuumFreq;
        return this;
    }

    public boolean isAuthenticationEnabled() {
        return this.authEnabled;
    }

    public IgniteConfiguration setAuthenticationEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
        return this;
    }

    @Deprecated
    public String[] getSqlSchemas() {
        return this.sqlCfg.getSqlSchemas();
    }

    @Deprecated
    public IgniteConfiguration setSqlSchemas(String ... sqlSchemas) {
        this.sqlCfg.setSqlSchemas(sqlSchemas);
        return this;
    }

    public PluginProvider[] getPluginProviders() {
        return this.pluginProvs;
    }

    public IgniteConfiguration setPluginProviders(PluginProvider ... pluginProvs) {
        this.pluginProvs = pluginProvs;
        return this;
    }

    public SqlConfiguration getSqlConfiguration() {
        return this.sqlCfg;
    }

    public IgniteConfiguration setSqlConfiguration(SqlConfiguration sqlCfg) {
        A.ensure(sqlCfg != null, "SQL configuration cannot be null");
        this.sqlCfg = sqlCfg;
        return this;
    }

    public Executor getAsyncContinuationExecutor() {
        return this.asyncContinuationExecutor;
    }

    public IgniteConfiguration setAsyncContinuationExecutor(Executor asyncContinuationExecutor) {
        this.asyncContinuationExecutor = asyncContinuationExecutor;
        return this;
    }

    public String toString() {
        return S.toString(IgniteConfiguration.class, this);
    }

    static {
        DFLT_DATA_STREAMER_POOL_SIZE = DFLT_PUBLIC_THREAD_CNT = Math.max(8, AVAILABLE_PROC_CNT);
        DFLT_REBALANCE_THREAD_POOL_SIZE = Math.min(4, Math.max(1, AVAILABLE_PROC_CNT / 4));
        DFLT_SYSTEM_CORE_THREAD_CNT = DFLT_PUBLIC_THREAD_CNT;
        DFLT_QUERY_THREAD_POOL_SIZE = DFLT_PUBLIC_THREAD_CNT;
        DFLT_BUILD_IDX_THREAD_POOL_SIZE = Math.min(4, Math.max(1, AVAILABLE_PROC_CNT / 4));
        DFLT_SEG_PLC = SegmentationPolicy.USE_FAILURE_HANDLER;
        DFLT_STATE_ON_START = ClusterState.ACTIVE;
        DFLT_FAILURE_DETECTION_TIMEOUT = new Long(10000L);
        DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT = new Long(30000L);
        DFLT_SHUTDOWN_POLICY = ShutdownPolicy.IMMEDIATE;
    }
}

