/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.services;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceCallInterceptor;

public class ServiceConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected String name;
    @GridToStringExclude
    private Service svc;
    protected int totalCnt;
    protected int maxPerNodeCnt;
    protected String cacheName;
    protected Object affKey;
    @GridToStringExclude
    protected IgnitePredicate<ClusterNode> nodeFilter;
    protected boolean isStatisticsEnabled;
    @GridToStringExclude
    protected ServiceCallInterceptor[] interceptors;

    public String getName() {
        return this.name;
    }

    public ServiceConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public Service getService() {
        return this.svc;
    }

    public ServiceConfiguration setService(Service svc) {
        this.svc = svc;
        return this;
    }

    public int getTotalCount() {
        return this.totalCnt;
    }

    public ServiceConfiguration setTotalCount(int totalCnt) {
        this.totalCnt = totalCnt;
        return this;
    }

    public int getMaxPerNodeCount() {
        return this.maxPerNodeCnt;
    }

    public ServiceConfiguration setMaxPerNodeCount(int maxPerNodeCnt) {
        this.maxPerNodeCnt = maxPerNodeCnt;
        return this;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ServiceConfiguration setCacheName(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public Object getAffinityKey() {
        return this.affKey;
    }

    public ServiceConfiguration setAffinityKey(Object affKey) {
        this.affKey = affKey;
        return this;
    }

    public IgnitePredicate<ClusterNode> getNodeFilter() {
        return this.nodeFilter;
    }

    public ServiceConfiguration setNodeFilter(IgnitePredicate<ClusterNode> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return this;
    }

    public ServiceConfiguration setStatisticsEnabled(boolean enabled) {
        this.isStatisticsEnabled = enabled;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @IgniteExperimental
    public ServiceCallInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    @IgniteExperimental
    public ServiceConfiguration setInterceptors(ServiceCallInterceptor ... interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public boolean equals(Object o) {
        if (!this.equalsIgnoreNodeFilter(o)) {
            return false;
        }
        ServiceConfiguration that = (ServiceConfiguration)o;
        return !(this.nodeFilter != null && that.nodeFilter != null ? !this.nodeFilter.getClass().equals(that.nodeFilter.getClass()) : this.nodeFilter != null || that.nodeFilter != null);
    }

    public boolean equalsIgnoreNodeFilter(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceConfiguration that = (ServiceConfiguration)o;
        if (this.maxPerNodeCnt != that.maxPerNodeCnt) {
            return false;
        }
        if (this.totalCnt != that.totalCnt) {
            return false;
        }
        if (this.affKey != null ? !this.affKey.equals(that.affKey) : that.affKey != null) {
            return false;
        }
        if (this.cacheName != null ? !this.cacheName.equals(that.cacheName) : that.cacheName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.svc != null ? !this.svc.getClass().equals(that.svc.getClass()) : that.svc != null) {
            return false;
        }
        return Arrays.deepEquals(this.interceptors, that.interceptors);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        String svcCls = this.svc == null ? "" : this.svc.getClass().getSimpleName();
        String nodeFilterCls = this.nodeFilter == null ? "" : this.nodeFilter.getClass().getSimpleName();
        return S.toString(ServiceConfiguration.class, this, "svcCls", (Object)svcCls, "nodeFilterCls", (Object)nodeFilterCls);
    }
}

