/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.diagnostic;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedDataStructureException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentRouter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class DiagnosticProcessor
extends GridProcessorAdapter {
    public static final boolean DFLT_DUMP_PAGE_LOCK_ON_FAILURE = true;
    private static final boolean IGNITE_DUMP_PAGE_LOCK_ON_FAILURE = IgniteSystemProperties.getBoolean("IGNITE_DUMP_PAGE_LOCK_ON_FAILURE", true);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'_'HH-mm-ss_SSS");
    public static final String DEFAULT_TARGET_FOLDER = "diagnostic";
    private final Path diagnosticPath;
    @Nullable
    private final FileIOFactory fileIOFactory;

    public DiagnosticProcessor(GridKernalContext ctx) throws IgniteCheckedException {
        super(ctx);
        this.diagnosticPath = U.resolveWorkDirectory(ctx.config().getWorkDirectory(), DEFAULT_TARGET_FOLDER, false).toPath();
        this.fileIOFactory = GridCacheUtils.isPersistenceEnabled(ctx.config()) ? ctx.config().getDataStorageConfiguration().getFileIOFactory() : null;
    }

    public void onFailure(FailureContext failureCtx) {
        CorruptedDataStructureException corruptedDataStructureEx;
        if (IGNITE_DUMP_PAGE_LOCK_ON_FAILURE) {
            this.ctx.cache().context().diagnostic().pageLockTracker().dumpLocksToLog();
        }
        if ((corruptedDataStructureEx = X.cause(failureCtx.error(), CorruptedDataStructureException.class)) != null && !F.isEmpty(corruptedDataStructureEx.pageIds()) && this.fileIOFactory != null) {
            File[] walDirs = DiagnosticProcessor.walDirs(this.ctx);
            if (F.isEmpty(walDirs)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Skipping dump diagnostic info due to WAL not configured");
                }
            } else {
                try {
                    File corruptedPagesFile = DiagnosticProcessor.corruptedPagesFile(this.diagnosticPath, this.fileIOFactory, corruptedDataStructureEx.groupId(), corruptedDataStructureEx.pageIds());
                    String walDirsStr = Arrays.stream(walDirs).map(File::getAbsolutePath).collect(Collectors.joining(", ", "[", "]"));
                    String args = "walDir=" + walDirs[0].getAbsolutePath() + (walDirs.length == 1 ? "" : " walArchiveDir=" + walDirs[1].getAbsolutePath());
                    if (this.ctx.config().getDataStorageConfiguration().getPageSize() != 4096) {
                        args = args + " pageSize=" + this.ctx.config().getDataStorageConfiguration().getPageSize();
                    }
                    args = args + " pages=" + corruptedPagesFile.getAbsolutePath();
                    this.log.warning(corruptedDataStructureEx.getClass().getSimpleName() + " has occurred. To diagnose it, make a backup of the following directories: " + walDirsStr + ". Then, run the following command: java -cp <classpath> org.apache.ignite.development.utils.IgniteWalConverter " + args);
                }
                catch (Throwable t) {
                    String pages = LongStream.of(corruptedDataStructureEx.pageIds()).mapToObj(pageId -> corruptedDataStructureEx.groupId() + ":" + pageId).collect(Collectors.joining("\n", "", ""));
                    this.log.error("Failed to dump diagnostic info of partition corruption. Page ids:\n" + pages, t);
                }
            }
        }
    }

    public static File corruptedPagesFile(Path dirPath, FileIOFactory ioFactory, int grpId, long ... pageIds) throws IOException {
        dirPath.toFile().mkdirs();
        File f = dirPath.resolve("corruptedPages_" + LocalDateTime.now().format(TIME_FORMATTER) + ".txt").toFile();
        assert (!f.exists());
        try (FileIO fileIO = ioFactory.create(f);){
            for (long pageId : pageIds) {
                byte[] bytes = (grpId + ":" + pageId + U.nl()).getBytes(StandardCharsets.UTF_8);
                int left = bytes.length;
                while (left - fileIO.writeFully(bytes, bytes.length - left, left) > 0) {
                }
            }
            fileIO.force();
        }
        return f;
    }

    @Nullable
    static File[] walDirs(GridKernalContext ctx) {
        SegmentRouter sr;
        IgniteWriteAheadLogManager walMgr = ctx.cache().context().wal();
        if (walMgr instanceof FileWriteAheadLogManager && (sr = ((FileWriteAheadLogManager)walMgr).getSegmentRouter()) != null) {
            File workDir = sr.getWalWorkDir();
            return sr.hasArchive() ? F.asArray(workDir, sr.getWalArchiveDir()) : F.asArray(workDir);
        }
        return null;
    }
}

