/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastreamer;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.P2PClassLoadingIssues;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerCacheUpdaters;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.stream.StreamReceiver;
import org.jetbrains.annotations.Nullable;

class DataStreamerUpdateJob
implements GridPlainCallable<Object> {
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final String cacheName;
    private final Collection<DataStreamerEntry> col;
    private final boolean ignoreDepOwnership;
    private final boolean skipStore;
    private final StreamReceiver rcvr;
    private boolean keepBinary;

    DataStreamerUpdateJob(GridKernalContext ctx, IgniteLogger log, @Nullable String cacheName, Collection<DataStreamerEntry> col, boolean ignoreDepOwnership, boolean skipStore, boolean keepBinary, StreamReceiver<?, ?> rcvr) {
        this.ctx = ctx;
        this.log = log;
        assert (col != null && !col.isEmpty());
        assert (rcvr != null);
        this.cacheName = cacheName;
        this.col = col;
        this.ignoreDepOwnership = ignoreDepOwnership;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.rcvr = rcvr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Running put job [nodeId=" + this.ctx.localNodeId() + ", size=" + this.col.size() + ']');
        }
        IgniteCacheProxy cache = this.ctx.cache().jcache(this.cacheName).cacheNoGate();
        cache.context().awaitStarted();
        if (this.skipStore) {
            cache = (IgniteCacheProxy)cache.withSkipStore();
        }
        if (this.keepBinary) {
            cache = (IgniteCacheProxy)cache.withKeepBinary();
        }
        if (this.ignoreDepOwnership) {
            cache.context().deploy().ignoreOwnership(true);
        }
        try {
            final GridCacheContext cctx = cache.context();
            for (DataStreamerEntry e : this.col) {
                e.getKey().finishUnmarshal(cctx.cacheObjectContext(), cctx.deploy().globalLoader());
                CacheObject val = e.getValue();
                if (val != null) {
                    this.checkSecurityPermission(SecurityPermission.CACHE_PUT);
                    val.finishUnmarshal(cctx.cacheObjectContext(), cctx.deploy().globalLoader());
                    continue;
                }
                this.checkSecurityPermission(SecurityPermission.CACHE_REMOVE);
            }
            StreamReceiver receiver = SecurityUtils.sandboxedProxy(this.ctx, StreamReceiver.class, this.rcvr);
            if (this.unwrapEntries()) {
                Collection col0 = F.viewReadOnly(this.col, new C1<DataStreamerEntry, Map.Entry>(){

                    @Override
                    public Map.Entry apply(DataStreamerEntry e) {
                        return e.toEntry(cctx, DataStreamerUpdateJob.this.keepBinary);
                    }
                }, new IgnitePredicate[0]);
                receiver.receive(cache, col0);
            } else {
                receiver.receive(cache, this.col);
            }
            Object var4_6 = null;
            return var4_6;
        }
        catch (NoClassDefFoundError e) {
            Object t = P2PClassLoadingIssues.rethrowDisarmedP2PClassLoadingFailure(e);
            return t;
        }
        finally {
            if (this.ignoreDepOwnership) {
                cache.context().deploy().ignoreOwnership(false);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Update job finished on node: " + this.ctx.localNodeId());
            }
        }
    }

    private boolean unwrapEntries() {
        return !(this.rcvr instanceof DataStreamerCacheUpdaters.InternalUpdater);
    }

    private void checkSecurityPermission(SecurityPermission perm) throws SecurityException {
        if (this.ctx.security().enabled()) {
            this.ctx.security().authorize(this.cacheName, perm);
        }
    }
}

