/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.evict;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.evict.PageAbstractEvictionTracker;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;

public class Random2LruPageEvictionTracker
extends PageAbstractEvictionTracker {
    private static final int EVICT_ATTEMPTS_LIMIT = 30;
    private static final int SAMPLE_SIZE = 5;
    private static final int SAMPLE_SPIN_LIMIT = 5000;
    private final IgniteLogger log;
    private long trackingArrPtr;

    public Random2LruPageEvictionTracker(PageMemoryNoStoreImpl pageMem, DataRegionConfiguration plcCfg, GridCacheSharedContext<?, ?> sharedCtx) {
        super(pageMem, plcCfg, sharedCtx);
        DataStorageConfiguration memCfg = sharedCtx.kernalContext().config().getDataStorageConfiguration();
        assert (plcCfg.getMaxSize() / (long)memCfg.getPageSize() < Integer.MAX_VALUE);
        this.log = sharedCtx.logger(this.getClass());
    }

    @Override
    public void start() throws IgniteException {
        this.trackingArrPtr = GridUnsafe.allocateMemory((long)this.trackingSize * 8L);
        GridUnsafe.setMemory(this.trackingArrPtr, (long)this.trackingSize * 8L, (byte)0);
    }

    @Override
    public void stop() throws IgniteException {
        GridUnsafe.freeMemory(this.trackingArrPtr);
    }

    @Override
    public void touchPage(long pageId) throws IgniteCheckedException {
        int secondTs;
        int trackingIdx;
        int firstTs;
        boolean success;
        int pageIdx = PageIdUtils.pageIndex(pageId);
        long latestTs = this.compactTimestamp(U.currentTimeMillis());
        assert (latestTs >= 0L && latestTs < Integer.MAX_VALUE);
        while (!(success = (firstTs = GridUnsafe.getIntVolatile(null, this.trackingArrPtr + (long)((trackingIdx = this.trackingIdx(pageIdx)) * 8))) <= (secondTs = GridUnsafe.getIntVolatile(null, this.trackingArrPtr + (long)(trackingIdx * 8) + 4L)) ? GridUnsafe.compareAndSwapInt(null, this.trackingArrPtr + (long)(trackingIdx * 8), firstTs, (int)latestTs) : GridUnsafe.compareAndSwapInt(null, this.trackingArrPtr + (long)(trackingIdx * 8) + 4L, secondTs, (int)latestTs))) {
        }
    }

    @Override
    public void evictDataPage() throws IgniteCheckedException {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int evictAttemptsCnt = 0; evictAttemptsCnt < 30; ++evictAttemptsCnt) {
            int lruTrackingIdx = -1;
            int lruCompactTs = Integer.MAX_VALUE;
            int dataPagesCnt = 0;
            int sampleSpinCnt = 0;
            while (dataPagesCnt < 5) {
                int trackingIdx = rnd.nextInt(this.trackingSize);
                int firstTs = GridUnsafe.getIntVolatile(null, this.trackingArrPtr + (long)(trackingIdx * 8));
                int secondTs = GridUnsafe.getIntVolatile(null, this.trackingArrPtr + (long)(trackingIdx * 8) + 4L);
                int minTs = Math.min(firstTs, secondTs);
                int maxTs = Math.max(firstTs, secondTs);
                if (maxTs != 0) {
                    if (minTs < lruCompactTs) {
                        lruTrackingIdx = trackingIdx;
                        lruCompactTs = minTs;
                    }
                    ++dataPagesCnt;
                }
                if (++sampleSpinCnt <= 5000) continue;
                LT.warn(this.log, "Too many attempts to choose data page: 5000");
                return;
            }
            if (!this.evictDataPage(this.pageIdx(lruTrackingIdx))) continue;
            return;
        }
        LT.warn(this.log, "Too many failed attempts to evict page: 30");
    }

    @Override
    protected boolean checkTouch(long pageId) {
        int trackingIdx = this.trackingIdx(PageIdUtils.pageIndex(pageId));
        int firstTs = GridUnsafe.getIntVolatile(null, this.trackingArrPtr + (long)(trackingIdx * 8));
        return firstTs != 0;
    }

    @Override
    public void forgetPage(long pageId) {
        int pageIdx = PageIdUtils.pageIndex(pageId);
        int trackingIdx = this.trackingIdx(pageIdx);
        GridUnsafe.putLongVolatile(null, this.trackingArrPtr + (long)(trackingIdx * 8), 0L);
    }
}

