/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheEntryVersion;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheConsistencyViolationEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;

public abstract class GridNearReadRepairAbstractFuture
extends GridFutureAdapter<Map<KeyCacheObject, EntryGetResult>> {
    protected static final int MAX_REMAP_CNT = IgniteSystemProperties.getInteger("IGNITE_NEAR_GET_MAX_REMAPS", 3);
    private static final AtomicIntegerFieldUpdater<GridNearReadRepairAbstractFuture> LSNR_CALLS_UPD = AtomicIntegerFieldUpdater.newUpdater(GridNearReadRepairAbstractFuture.class, "lsnrCalls");
    private static final AtomicIntegerFieldUpdater<GridNearReadRepairAbstractFuture> REMAP_CALLS_UPD = AtomicIntegerFieldUpdater.newUpdater(GridNearReadRepairAbstractFuture.class, "remapCalls");
    protected final Map<ClusterNode, GridPartitionedGetFuture<KeyCacheObject, EntryGetResult>> futs;
    protected final GridCacheContext<?, ?> ctx;
    protected final Collection<KeyCacheObject> keys;
    protected final boolean readThrough;
    protected final String taskName;
    protected final boolean deserializeBinary;
    protected final boolean recovery;
    protected final IgniteCacheExpiryPolicy expiryPlc;
    protected final IgniteInternalTx tx;
    protected final Map<KeyCacheObject, ClusterNode> primaries;
    protected final ReadRepairStrategy strategy;
    protected final int remapCnt;
    private final AffinityTopologyVersion topVer;
    private volatile int lsnrCalls;
    private volatile int remapCalls;
    private volatile boolean inited;

    protected GridNearReadRepairAbstractFuture(AffinityTopologyVersion topVer, GridCacheContext<?, ?> ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx, GridNearReadRepairAbstractFuture remappedFut) {
        this.ctx = ctx;
        this.keys = Collections.unmodifiableCollection(keys);
        this.readThrough = readThrough;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.recovery = recovery;
        this.expiryPlc = expiryPlc;
        this.tx = tx;
        assert (strategy != null);
        this.strategy = strategy;
        this.remapCnt = remappedFut != null ? remappedFut.remapCnt + 1 : 0;
        this.topVer = topVer == null ? ctx.affinity().affinityTopologyVersion() : topVer;
        HashMap<KeyCacheObject, ClusterNode> primaries = new HashMap<KeyCacheObject, ClusterNode>();
        HashMap<ClusterNode, Collection> mappings = new HashMap<ClusterNode, Collection>();
        for (KeyCacheObject key : keys) {
            List<ClusterNode> nodes = ctx.affinity().nodesByKey(key, this.topVer);
            primaries.put(key, nodes.get(0));
            for (ClusterNode node : nodes) {
                mappings.computeIfAbsent(node, k -> new HashSet()).add(key);
            }
        }
        if (mappings.isEmpty()) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + this.topVer + ", cache=" + ctx.name() + ']'));
        }
        this.primaries = Collections.unmodifiableMap(primaries);
        HashMap futs = new HashMap();
        for (Map.Entry mapping : mappings.entrySet()) {
            ClusterNode node = (ClusterNode)mapping.getKey();
            GridPartitionedGetFuture fut = new GridPartitionedGetFuture(ctx, (Collection)mapping.getValue(), readThrough, false, taskName, deserializeBinary, recovery, expiryPlc, false, true, true, tx != null ? tx.label() : null, tx != null ? tx.mvccSnapshot() : null, node);
            futs.put(mapping.getKey(), fut);
            fut.listen(this::onResult);
        }
        this.futs = Collections.unmodifiableMap(futs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridNearReadRepairAbstractFuture init() {
        assert (!this.inited);
        IgniteInternalTx prevTx = this.ctx.tm().tx(this.tx);
        try {
            for (GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut : this.futs.values()) {
                assert (!fut.initialized());
                fut.init(this.topVer);
            }
        }
        finally {
            this.ctx.tm().tx(prevTx);
        }
        if (!this.ctx.kernalContext().cache().context().exchange().lastFinishedFuture().rebalanced()) {
            this.onDone(new IllegalStateException("Operation can not be performed on unstable topology. Rebalance is in progress?"));
        }
        this.inited = true;
        return this;
    }

    protected void remap(AffinityTopologyVersion topVer) {
        assert (!this.isDone());
        if (REMAP_CALLS_UPD.compareAndSet(this, 0, 1)) {
            GridNearReadRepairAbstractFuture fut = this.remapFuture(topVer);
            fut.listen(f -> {
                assert (!this.isDone());
                this.onDone(f.result(), f.error());
            });
        }
    }

    protected abstract GridNearReadRepairAbstractFuture remapFuture(AffinityTopologyVersion var1);

    protected final void onResult(IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> finished) {
        if (finished.error() != null) {
            if (finished.error() instanceof ClusterTopologyServerNotFoundException) {
                this.onDone(new UnsupportedOperationException("Operation can not be performed on unstable topology.", finished.error()));
            } else {
                this.onDone(finished.error());
            }
        } else if (LSNR_CALLS_UPD.incrementAndGet(this) == this.futs.size()) {
            assert (this.remapCalls == 0) : this.remapCalls;
            assert (!this.isDone());
            this.reduce();
        }
        assert (this.lsnrCalls <= this.futs.size());
    }

    protected abstract void reduce();

    protected final Map<KeyCacheObject, EntryGetResult> check() throws IgniteCheckedException {
        HashMap<KeyCacheObject, EntryGetResult> resMap = new HashMap<KeyCacheObject, EntryGetResult>(this.keys.size());
        HashSet<KeyCacheObject> inconsistentKeys = new HashSet<KeyCacheObject>();
        for (GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut : this.futs.values()) {
            for (KeyCacheObject key : fut.keys()) {
                EntryGetResult curRes = (EntryGetResult)((Map)fut.result()).get(key);
                if (!resMap.containsKey(key)) {
                    resMap.put(key, curRes);
                    continue;
                }
                EntryGetResult prevRes = (EntryGetResult)resMap.get(key);
                if (curRes != null) {
                    byte[] prevBytes;
                    if (prevRes == null || prevRes.version().compareTo(curRes.version()) != 0) {
                        inconsistentKeys.add(key);
                        continue;
                    }
                    CacheObject curVal = (CacheObject)curRes.value();
                    CacheObject prevVal = (CacheObject)prevRes.value();
                    byte[] curBytes = curVal.valueBytes(this.ctx.cacheObjectContext());
                    if (Arrays.equals(curBytes, prevBytes = prevVal.valueBytes(this.ctx.cacheObjectContext()))) continue;
                    inconsistentKeys.add(key);
                    continue;
                }
                if (prevRes == null) continue;
                inconsistentKeys.add(key);
            }
        }
        if (!inconsistentKeys.isEmpty()) {
            throw new IgniteConsistencyCheckFailedException(inconsistentKeys);
        }
        return resMap;
    }

    protected Map<KeyCacheObject, EntryGetResult> correct(Set<KeyCacheObject> keys) throws IgniteCheckedException {
        Map<KeyCacheObject, EntryGetResult> correctedMap;
        if (this.strategy == ReadRepairStrategy.LWW) {
            correctedMap = this.correctWithLww(keys);
        } else if (this.strategy == ReadRepairStrategy.PRIMARY) {
            correctedMap = this.correctWithPrimary(keys);
        } else if (this.strategy == ReadRepairStrategy.RELATIVE_MAJORITY) {
            correctedMap = this.correctWithMajority(keys);
        } else if (this.strategy == ReadRepairStrategy.REMOVE) {
            correctedMap = this.correctWithRemove(keys);
        } else {
            if (this.strategy == ReadRepairStrategy.CHECK_ONLY) {
                throw new IgniteConsistencyRepairFailedException(null, keys);
            }
            throw new UnsupportedOperationException("Unsupported strategy: " + (Object)((Object)this.strategy));
        }
        return correctedMap;
    }

    private Map<KeyCacheObject, EntryGetResult> correctWithLww(Set<KeyCacheObject> inconsistentKeys) throws IgniteCheckedException {
        HashMap<KeyCacheObject, EntryGetResult> newestMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        HashMap<KeyCacheObject, EntryGetResult> correctedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        HashSet<KeyCacheObject> irreparableSet = new HashSet<KeyCacheObject>();
        for (GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut : this.futs.values()) {
            for (KeyCacheObject key : inconsistentKeys) {
                if (!fut.keys().contains(key)) continue;
                EntryGetResult candidateRes = (EntryGetResult)((Map)fut.result()).get(key);
                boolean hasNewest = newestMap.containsKey(key);
                if (!hasNewest) {
                    newestMap.put(key, candidateRes);
                    continue;
                }
                EntryGetResult newestRes = (EntryGetResult)newestMap.get(key);
                if (candidateRes != null) {
                    byte[] newestBytes;
                    if (newestRes == null) {
                        if (hasNewest) {
                            irreparableSet.add(key);
                            continue;
                        }
                        newestMap.put(key, candidateRes);
                        correctedMap.put(key, candidateRes);
                        continue;
                    }
                    int compareRes = candidateRes.version().compareTo(newestRes.version());
                    if (compareRes > 0) {
                        newestMap.put(key, candidateRes);
                        correctedMap.put(key, candidateRes);
                        continue;
                    }
                    if (compareRes < 0) {
                        correctedMap.put(key, newestRes);
                        continue;
                    }
                    if (compareRes != 0) continue;
                    CacheObject candidateVal = (CacheObject)candidateRes.value();
                    CacheObject newestVal = (CacheObject)newestRes.value();
                    byte[] candidateBytes = candidateVal.valueBytes(this.ctx.cacheObjectContext());
                    if (Arrays.equals(candidateBytes, newestBytes = newestVal.valueBytes(this.ctx.cacheObjectContext()))) continue;
                    irreparableSet.add(key);
                    continue;
                }
                if (newestRes == null) continue;
                irreparableSet.add(key);
            }
        }
        assert (!correctedMap.containsValue(null)) : "null should never be considered as a fix";
        this.throwRepairFailedIfNecessary(correctedMap, irreparableSet);
        return correctedMap;
    }

    protected Map<KeyCacheObject, EntryGetResult> correctWithPrimary(Collection<KeyCacheObject> inconsistentKeys) {
        HashMap<KeyCacheObject, EntryGetResult> correctedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        for (GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut : this.futs.values()) {
            for (KeyCacheObject key : inconsistentKeys) {
                if (!fut.keys().contains(key) || !this.primaries.get(key).equals(fut.affNode())) continue;
                correctedMap.put(key, (EntryGetResult)((Map)fut.result()).get(key));
            }
        }
        return correctedMap;
    }

    private Map<KeyCacheObject, EntryGetResult> correctWithRemove(Collection<KeyCacheObject> inconsistentKeys) {
        HashMap<KeyCacheObject, EntryGetResult> correctedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        for (KeyCacheObject key : inconsistentKeys) {
            correctedMap.put(key, null);
        }
        return correctedMap;
    }

    private Map<KeyCacheObject, EntryGetResult> correctWithMajority(Collection<KeyCacheObject> inconsistentKeys) throws IgniteCheckedException {
        HashSet<KeyCacheObject> irreparableSet = new HashSet<KeyCacheObject>(inconsistentKeys.size());
        HashMap<KeyCacheObject, EntryGetResult> correctedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        block0: for (KeyCacheObject key : inconsistentKeys) {
            HashMap<T2, T2> cntMap = new HashMap<T2, T2>();
            for (GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut : this.futs.values()) {
                GridCacheVersion ver;
                ByteArrayWrapper wrapped;
                if (!fut.keys().contains(key)) continue;
                EntryGetResult res = (EntryGetResult)((Map)fut.result()).get(key);
                if (res != null) {
                    CacheObject val = (CacheObject)res.value();
                    wrapped = new ByteArrayWrapper(val.valueBytes(this.ctx.cacheObjectContext()));
                    ver = res.version();
                } else {
                    wrapped = new ByteArrayWrapper(null);
                    ver = null;
                }
                T2<ByteArrayWrapper, Object> keyVer = new T2<ByteArrayWrapper, Object>(wrapped, ver);
                cntMap.putIfAbsent(keyVer, new T2<EntryGetResult, Integer>(res, 0));
                cntMap.compute(keyVer, (kv, ri) -> new T2(ri.getKey(), (Integer)ri.getValue() + 1));
            }
            int[] sorted = cntMap.values().stream().map(IgniteBiTuple::getValue).sorted(Comparator.reverseOrder()).mapToInt(v -> v).toArray();
            int max = sorted[0];
            assert (max > 0);
            if (sorted.length > 1 && sorted[1] == max) {
                irreparableSet.add(key);
                continue;
            }
            for (Map.Entry count : cntMap.entrySet()) {
                if (!((Integer)((T2)count.getValue()).getValue()).equals(max)) continue;
                correctedMap.put(key, (EntryGetResult)((T2)count.getValue()).getKey());
                continue block0;
            }
        }
        this.throwRepairFailedIfNecessary(correctedMap, irreparableSet);
        return correctedMap;
    }

    private void throwRepairFailedIfNecessary(Map<KeyCacheObject, EntryGetResult> correctedMap, Set<KeyCacheObject> irreparableSet) throws IgniteConsistencyRepairFailedException {
        if (!irreparableSet.isEmpty()) {
            correctedMap.entrySet().removeIf(entry -> irreparableSet.contains(entry.getKey()));
            throw new IgniteConsistencyRepairFailedException(correctedMap, irreparableSet);
        }
    }

    protected final void recordConsistencyViolation(Collection<KeyCacheObject> inconsistentKeys, Map<KeyCacheObject, EntryGetResult> repairedEntries) {
        Map<Object, Object> repaired;
        GridEventStorageManager evtMgr = this.ctx.gridEvents();
        if (!evtMgr.isRecordable(135)) {
            return;
        }
        boolean includeSensitive = S.includeSensitive();
        HashMap<KeyCacheObject, Object> sensitiveKeyMap = new HashMap<KeyCacheObject, Object>();
        HashMap<ByteArrayWrapper, Object> sensitiveValMap = new HashMap<ByteArrayWrapper, Object>();
        HashMap<Object, CacheConsistencyViolationEvent.EntriesInfo> entries = new HashMap<Object, CacheConsistencyViolationEvent.EntriesInfo>();
        for (Map.Entry<ClusterNode, GridPartitionedGetFuture<KeyCacheObject, EntryGetResult>> pair : this.futs.entrySet()) {
            ClusterNode node = pair.getKey();
            GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut = pair.getValue();
            for (KeyCacheObject key : fut.keys()) {
                if (!inconsistentKeys.contains(key)) continue;
                sensitiveKeyMap.computeIfAbsent(key, k -> includeSensitive ? this.ctx.unwrapBinaryIfNeeded(k, true, false, null) : "[HIDDEN_KEY#" + UUID.randomUUID() + "]");
                CacheConsistencyViolationEvent.EntriesInfo entriesInfo = entries.computeIfAbsent(sensitiveKeyMap.get(key), k -> new EventEntriesInfo(key.partition()));
                EntryGetResult res = (EntryGetResult)((Map)fut.result()).get(key);
                GridCacheVersion ver = res != null ? res.version() : null;
                Object val = this.sensitiveValue(includeSensitive, res, sensitiveValMap);
                boolean primary = this.primaries.get(key).equals(fut.affNode());
                boolean correct = repairedEntries != null && (repairedEntries.get(key) != null && repairedEntries.get(key).equals(res) || repairedEntries.get(key) == null && res == null);
                entriesInfo.getMapping().put(node, new EventEntryInfo(val, ver, primary, correct));
            }
        }
        if (repairedEntries == null) {
            repaired = Collections.emptyMap();
        } else {
            repaired = new HashMap();
            for (Map.Entry<KeyCacheObject, EntryGetResult> entry : repairedEntries.entrySet()) {
                Object key = sensitiveKeyMap.get(entry.getKey());
                Object val = this.sensitiveValue(includeSensitive, entry.getValue(), sensitiveValMap);
                repaired.put(key, val);
            }
        }
        evtMgr.record(new CacheConsistencyViolationEvent(this.ctx.name(), this.ctx.discovery().localNode(), "Consistency violation was " + (repaired == null ? "NOT " : "") + "repaired.", entries, repaired, this.strategy));
    }

    private Object sensitiveValue(boolean includeSensitive, EntryGetResult res, Map<ByteArrayWrapper, Object> sensitiveValMap) {
        if (res != null) {
            CacheObject val = (CacheObject)res.value();
            try {
                ByteArrayWrapper wrapped = new ByteArrayWrapper(val.valueBytes(this.ctx.cacheObjectContext()));
                return sensitiveValMap.computeIfAbsent(wrapped, w -> includeSensitive ? this.ctx.unwrapBinaryIfNeeded(val, true, false, null) : "[HIDDEN_VALUE#" + UUID.randomUUID() + "]");
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to unmarshall object.", e);
            }
        }
        return null;
    }

    protected static final class IgniteConsistencyRepairFailedException
    extends IgniteCheckedException {
        private static final long serialVersionUID = 0L;
        private final Map<KeyCacheObject, EntryGetResult> correctedMap;
        private final Set<KeyCacheObject> irreparableKeys;

        public IgniteConsistencyRepairFailedException(Map<KeyCacheObject, EntryGetResult> correctedMap, Set<KeyCacheObject> irreparableKeys) {
            this.correctedMap = correctedMap != null ? Collections.unmodifiableMap(correctedMap) : null;
            this.irreparableKeys = Collections.unmodifiableSet(irreparableKeys);
        }

        public Map<KeyCacheObject, EntryGetResult> correctedMap() {
            return this.correctedMap;
        }

        public Set<KeyCacheObject> irreparableKeys() {
            return this.irreparableKeys;
        }
    }

    protected static final class IgniteConsistencyCheckFailedException
    extends IgniteCheckedException {
        private static final long serialVersionUID = 0L;
        private final Set<KeyCacheObject> keys;

        public IgniteConsistencyCheckFailedException(Set<KeyCacheObject> keys) {
            assert (keys != null && !keys.isEmpty());
            this.keys = Collections.unmodifiableSet(keys);
        }

        public Set<KeyCacheObject> keys() {
            return this.keys;
        }
    }

    protected static final class ByteArrayWrapper {
        final byte[] arr;

        public ByteArrayWrapper(byte[] arr) {
            this.arr = arr;
        }

        public boolean equals(Object o) {
            return Arrays.equals(this.arr, ((ByteArrayWrapper)o).arr);
        }

        public int hashCode() {
            return Arrays.hashCode(this.arr);
        }
    }

    private static final class EventEntryInfo
    implements CacheConsistencyViolationEvent.EntryInfo {
        final Object val;
        final CacheEntryVersion ver;
        final boolean primary;
        final boolean correct;

        public EventEntryInfo(Object val, CacheEntryVersion ver, boolean primary, boolean correct) {
            this.val = val;
            this.ver = ver;
            this.primary = primary;
            this.correct = correct;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public CacheEntryVersion getVersion() {
            return this.ver;
        }

        @Override
        public boolean isPrimary() {
            return this.primary;
        }

        @Override
        public boolean isCorrect() {
            return this.correct;
        }
    }

    private static final class EventEntriesInfo
    implements CacheConsistencyViolationEvent.EntriesInfo {
        final Map<ClusterNode, CacheConsistencyViolationEvent.EntryInfo> mapping = new HashMap<ClusterNode, CacheConsistencyViolationEvent.EntryInfo>();
        final int partition;

        public EventEntriesInfo(int partition) {
            this.partition = partition;
        }

        @Override
        public Map<ClusterNode, CacheConsistencyViolationEvent.EntryInfo> getMapping() {
            return this.mapping;
        }

        @Override
        public int partition() {
            return this.partition;
        }
    }
}

