/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeResult;
import org.apache.ignite.internal.visor.verify.ValidateIndexesContext;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class ValidateIndexesClosure
implements IgniteCallable<VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;
    public static final String CANCELLED_MSG = "Closure of index validation was cancelled.";
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;
    private final Set<String> cacheNames;
    private final int checkFirst;
    private final int checkThrough;
    private final boolean checkCrc;
    private final boolean checkSizes;
    private final AtomicInteger processedPartitions = new AtomicInteger(0);
    private volatile int totalPartitions;
    private final AtomicInteger processedIndexes = new AtomicInteger(0);
    private final AtomicInteger integrityCheckedIndexes = new AtomicInteger(0);
    private final AtomicInteger processedCacheSizePartitions = new AtomicInteger(0);
    private final AtomicInteger processedIdxSizes = new AtomicInteger(0);
    private volatile int totalIndexes;
    private volatile int totalCacheGrps;
    private final AtomicLong lastProgressPrintTs = new AtomicLong(0L);
    private volatile ExecutorService calcExecutor;
    private final Set<Integer> failCalcCacheSizeGrpIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ValidateIndexesContext validateCtx;

    public ValidateIndexesClosure(ValidateIndexesContext validateCtx, Set<String> cacheNames, int checkFirst, int checkThrough, boolean checkCrc, boolean checkSizes) {
        this.validateCtx = validateCtx;
        this.cacheNames = cacheNames;
        this.checkFirst = checkFirst;
        this.checkThrough = checkThrough;
        this.checkCrc = checkCrc;
        this.checkSizes = checkSizes;
    }

    @Override
    public VisorValidateIndexesJobResult call() throws Exception {
        this.calcExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            VisorValidateIndexesJobResult visorValidateIndexesJobResult = this.call0();
            return visorValidateIndexesJobResult;
        }
        finally {
            this.calcExecutor.shutdown();
        }
    }

    private Set<Integer> collectGroupIds() {
        HashSet<Integer> grpIds = new HashSet<Integer>();
        HashSet<String> missingCaches = new HashSet<String>();
        if (this.cacheNames != null) {
            for (String cacheName : this.cacheNames) {
                DynamicCacheDescriptor desc = this.ignite.context().cache().cacheDescriptor(cacheName);
                if (desc == null) {
                    missingCaches.add(cacheName);
                    continue;
                }
                if (!this.ignite.context().cache().cacheGroup(desc.groupId()).affinityNode()) continue;
                grpIds.add(desc.groupId());
            }
            if (!missingCaches.isEmpty()) {
                String errStr = "The following caches do not exist: " + String.join((CharSequence)", ", missingCaches);
                throw new IgniteException(errStr);
            }
        } else {
            Collection<CacheGroupContext> groups = this.ignite.context().cache().cacheGroups();
            for (CacheGroupContext grp : groups) {
                if (grp.systemCache() || !grp.affinityNode()) continue;
                grpIds.add(grp.groupId());
            }
        }
        return grpIds;
    }

    private VisorValidateIndexesJobResult call0() {
        if (this.validateCtx.isCancelled()) {
            throw new IgniteException(CANCELLED_MSG);
        }
        Set<Integer> grpIds = this.collectGroupIds();
        Map<Integer, Map<Integer, PartitionUpdateCounter>> partsWithCntrsPerGrp = IdleVerifyUtility.getUpdateCountersSnapshot(this.ignite, grpIds);
        IdleVerifyUtility.IdleChecker idleChecker = new IdleVerifyUtility.IdleChecker(this.ignite, partsWithCntrsPerGrp);
        ArrayList<T2<CacheGroupContext, GridDhtLocalPartition>> partArgs = new ArrayList<T2<CacheGroupContext, GridDhtLocalPartition>>();
        ArrayList<T2<GridCacheContext, InlineIndexImpl>> idxArgs = new ArrayList<T2<GridCacheContext, InlineIndexImpl>>();
        this.totalCacheGrps = grpIds.size();
        Map<Integer, IndexIntegrityCheckIssue> integrityCheckResults = this.integrityCheckIndexesPartitions(grpIds, idleChecker);
        for (Integer grpId : grpIds) {
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(grpId);
            if (Objects.isNull(grpCtx) || integrityCheckResults.containsKey(grpId)) continue;
            for (GridDhtLocalPartition gridDhtLocalPartition : grpCtx.topology().localPartitions()) {
                partArgs.add(new T2<CacheGroupContext, GridDhtLocalPartition>(grpCtx, gridDhtLocalPartition));
            }
            for (GridCacheContext gridCacheContext : grpCtx.caches()) {
                String string = gridCacheContext.name();
                if (this.cacheNames != null && !this.cacheNames.contains(string)) continue;
                Collection<Index> idxs = this.ignite.context().indexProcessor().indexes(string);
                for (Index idx : idxs) {
                    InlineIndexImpl idx0 = idx.unwrap(InlineIndexImpl.class);
                    if (idx0 == null) continue;
                    idxArgs.add(new T2<GridCacheContext, InlineIndexImpl>(gridCacheContext, idx0));
                }
            }
        }
        Collections.shuffle(partArgs);
        Collections.shuffle(idxArgs);
        this.totalPartitions = partArgs.size();
        this.totalIndexes = idxArgs.size();
        ArrayList procPartFutures = new ArrayList(partArgs.size());
        ArrayList procIdxFutures = new ArrayList(idxArgs.size());
        ArrayList<T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>> cacheSizeFutures = new ArrayList<T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>>(partArgs.size());
        ArrayList<T3<GridCacheContext, InlineIndexImpl, Future<T2<Throwable, Long>>>> idxSizeFutures = new ArrayList<T3<GridCacheContext, InlineIndexImpl, Future<T2<Throwable, Long>>>>(idxArgs.size());
        partArgs.forEach(k -> procPartFutures.add(this.processPartitionAsync((CacheGroupContext)k.get1(), (GridDhtLocalPartition)k.get2())));
        idxArgs.forEach(k -> procIdxFutures.add(this.processIndexAsync((T2<GridCacheContext, InlineIndexImpl>)k, idleChecker)));
        if (this.checkSizes) {
            for (T2 t2 : partArgs) {
                CacheGroupContext cacheGrpCtx = (CacheGroupContext)t2.get1();
                GridDhtLocalPartition locPart = (GridDhtLocalPartition)t2.get2();
                cacheSizeFutures.add(new T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>(cacheGrpCtx, locPart, this.calcCacheSizeAsync(cacheGrpCtx, locPart)));
            }
            for (T2 t2 : idxArgs) {
                GridCacheContext cacheCtx = (GridCacheContext)t2.get1();
                InlineIndexImpl idx = (InlineIndexImpl)t2.get2();
                idxSizeFutures.add(new T3<GridCacheContext, InlineIndexImpl, Future<T2<Throwable, Long>>>(cacheCtx, idx, this.calcIndexSizeAsync(cacheCtx, idx, idleChecker)));
            }
        }
        HashMap<PartitionKey, ValidateIndexesPartitionResult> hashMap = new HashMap<PartitionKey, ValidateIndexesPartitionResult>();
        HashMap<String, ValidateIndexesPartitionResult> hashMap2 = new HashMap<String, ValidateIndexesPartitionResult>();
        HashMap<String, ValidateIndexesCheckSizeResult> checkSizeResults = new HashMap<String, ValidateIndexesCheckSizeResult>();
        int curIdx = 0;
        int curCacheSize = 0;
        int curIdxSize = 0;
        try {
            Future fut;
            for (int curPart = 0; curPart < procPartFutures.size(); ++curPart) {
                fut = (Future)procPartFutures.get(curPart);
                Map partRes = (Map)fut.get();
                if (partRes.isEmpty() || !partRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty())) continue;
                hashMap.putAll(partRes);
            }
            while (curIdx < procIdxFutures.size()) {
                fut = (Future)procIdxFutures.get(curIdx);
                Map idxRes = (Map)fut.get();
                if (!idxRes.isEmpty() && idxRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty())) {
                    hashMap2.putAll(idxRes);
                }
                ++curIdx;
            }
            if (this.checkSizes) {
                String res;
                while (curCacheSize < cacheSizeFutures.size()) {
                    ((Future)((T3)cacheSizeFutures.get(curCacheSize)).get3()).get();
                    ++curCacheSize;
                }
                while (curIdxSize < idxSizeFutures.size()) {
                    ((Future)((T3)idxSizeFutures.get(curIdxSize)).get3()).get();
                    ++curIdxSize;
                }
                this.checkSizes(cacheSizeFutures, idxSizeFutures, checkSizeResults);
                Map<Integer, Map<Integer, PartitionUpdateCounter>> partsWithCntrsPerGrpAfterChecks = IdleVerifyUtility.getUpdateCountersSnapshot(this.ignite, grpIds);
                List<Integer> diff = IdleVerifyUtility.compareUpdateCounters(this.ignite, partsWithCntrsPerGrp, partsWithCntrsPerGrpAfterChecks);
                if (!F.isEmpty(diff) && !(res = IdleVerifyUtility.formatUpdateCountersDiff(this.ignite, diff)).isEmpty()) {
                    throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [" + res + "]");
                }
            }
            this.log.warning("ValidateIndexesClosure finished: processed " + this.totalPartitions + " partitions and " + this.totalIndexes + " indexes.");
        }
        catch (InterruptedException | ExecutionException e2) {
            int j;
            for (j = curPart; j < procPartFutures.size(); ++j) {
                ((Future)procPartFutures.get(j)).cancel(false);
            }
            for (j = curIdx; j < procIdxFutures.size(); ++j) {
                ((Future)procIdxFutures.get(j)).cancel(false);
            }
            for (j = curCacheSize; j < cacheSizeFutures.size(); ++j) {
                ((Future)((T3)cacheSizeFutures.get(j)).get3()).cancel(false);
            }
            for (j = curIdxSize; j < idxSizeFutures.size(); ++j) {
                ((Future)((T3)idxSizeFutures.get(j)).get3()).cancel(false);
            }
            throw this.unwrapFutureException(e2);
        }
        if (this.validateCtx.isCancelled()) {
            throw new IgniteException(CANCELLED_MSG);
        }
        return new VisorValidateIndexesJobResult(hashMap, hashMap2, integrityCheckResults.values(), checkSizeResults);
    }

    /*
     * WARNING - void declaration
     */
    private Map<Integer, IndexIntegrityCheckIssue> integrityCheckIndexesPartitions(Set<Integer> grpIds, final IgniteInClosure<Integer> idleChecker) {
        if (!this.checkCrc) {
            return Collections.emptyMap();
        }
        ArrayList<Future<T2<Integer, IndexIntegrityCheckIssue>>> integrityCheckFutures = new ArrayList<Future<T2<Integer, IndexIntegrityCheckIssue>>>(grpIds.size());
        HashMap<Integer, IndexIntegrityCheckIssue> integrityCheckResults = new HashMap<Integer, IndexIntegrityCheckIssue>();
        boolean curFut = false;
        IgniteCacheDatabaseSharedManager db = this.ignite.context().cache().context().database();
        try {
            for (Integer n : grpIds) {
                final CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(n);
                if (grpCtx == null || !grpCtx.persistenceEnabled()) {
                    this.integrityCheckedIndexes.incrementAndGet();
                    continue;
                }
                Future<T2<Integer, IndexIntegrityCheckIssue>> checkFut = this.calcExecutor.submit(new Callable<T2<Integer, IndexIntegrityCheckIssue>>(){

                    @Override
                    public T2<Integer, IndexIntegrityCheckIssue> call() {
                        IndexIntegrityCheckIssue issue = ValidateIndexesClosure.this.integrityCheckIndexPartition(grpCtx, idleChecker);
                        return new T2<Integer, IndexIntegrityCheckIssue>(grpCtx.groupId(), issue);
                    }
                });
                integrityCheckFutures.add(checkFut);
            }
            for (Future future : integrityCheckFutures) {
                T2 res = (T2)future.get();
                if (res.getValue() == null) continue;
                integrityCheckResults.put((Integer)res.getKey(), (IndexIntegrityCheckIssue)res.getValue());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            void var8_13;
            boolean bl = curFut;
            while (var8_13 < integrityCheckFutures.size()) {
                ((Future)integrityCheckFutures.get((int)var8_13)).cancel(false);
                ++var8_13;
            }
            throw this.unwrapFutureException(e);
        }
        return integrityCheckResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIntegrityCheckIssue integrityCheckIndexPartition(CacheGroupContext gctx, IgniteInClosure<Integer> idleChecker) {
        GridKernalContext ctx = this.ignite.context();
        GridCacheSharedContext cctx = ctx.cache().context();
        try {
            FilePageStoreManager pageStoreMgr = (FilePageStoreManager)cctx.pageStore();
            if (pageStoreMgr != null && gctx.persistenceEnabled()) {
                IdleVerifyUtility.checkPartitionsPageCrcSum(() -> (FilePageStore)pageStoreMgr.getStore(gctx.groupId(), 65535), 65535, (byte)2);
            }
            idleChecker.apply(gctx.groupId());
            IndexIntegrityCheckIssue indexIntegrityCheckIssue = null;
            return indexIntegrityCheckIssue;
        }
        catch (Throwable t) {
            this.log.error("Integrity check of index partition of cache group " + gctx.cacheOrGroupName() + " failed", t);
            IndexIntegrityCheckIssue indexIntegrityCheckIssue = new IndexIntegrityCheckIssue(gctx.cacheOrGroupName(), t);
            return indexIntegrityCheckIssue;
        }
        finally {
            this.integrityCheckedIndexes.incrementAndGet();
            this.printProgressIfNeeded(() -> "Current progress of ValidateIndexesClosure: checked integrity of " + this.integrityCheckedIndexes.get() + " index partitions of " + this.totalCacheGrps + " cache groups");
        }
    }

    private Future<Map<PartitionKey, ValidateIndexesPartitionResult>> processPartitionAsync(final CacheGroupContext grpCtx, final GridDhtLocalPartition part) {
        return this.calcExecutor.submit(new Callable<Map<PartitionKey, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<PartitionKey, ValidateIndexesPartitionResult> call() {
                return ValidateIndexesClosure.this.processPartition(grpCtx, part);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PartitionKey, ValidateIndexesPartitionResult> processPartition(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
        ValidateIndexesPartitionResult partRes;
        if (this.validateCtx.isCancelled() || !part.reserve()) {
            return Collections.emptyMap();
        }
        try {
            if (part.state() != GridDhtPartitionState.OWNING) {
                Map<PartitionKey, ValidateIndexesPartitionResult> map = Collections.emptyMap();
                return map;
            }
            @Nullable PartitionUpdateCounter updCntr = part.dataStore().partUpdateCounter();
            PartitionUpdateCounter updateCntrBefore = updCntr == null ? null : updCntr.copy();
            partRes = new ValidateIndexesPartitionResult();
            boolean hasMvcc = grpCtx.caches().stream().anyMatch(GridCacheContext::mvccEnabled);
            if (hasMvcc) {
                for (GridCacheContext context : grpCtx.caches()) {
                    IndexQueryContext qryCtx = this.mvccQueryContext(context);
                    GridIterator<CacheDataRow> iterator = grpCtx.offheap().cachePartitionIterator(context.cacheId(), part.id(), qryCtx.mvccSnapshot(), null);
                    this.processPartIterator(grpCtx, partRes, qryCtx, iterator);
                }
            } else {
                this.processPartIterator(grpCtx, partRes, null, grpCtx.offheap().partitionIterator(part.id()));
            }
            PartitionUpdateCounter updateCntrAfter = part.dataStore().partUpdateCounter();
            if (updateCntrAfter != null && !updateCntrAfter.equals(updateCntrBefore)) {
                throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [grpName=" + grpCtx.cacheOrGroupName() + ", grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "] changed during index validation [before=" + updateCntrBefore + ", after=" + updateCntrAfter + "]");
            }
        }
        catch (IgniteCheckedException e) {
            IgniteUtils.error(this.log, "Failed to process partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]", e);
            Map<PartitionKey, ValidateIndexesPartitionResult> map = Collections.emptyMap();
            return map;
        }
        finally {
            part.release();
            this.printProgressOfIndexValidationIfNeeded();
        }
        PartitionKey partKey = new PartitionKey(grpCtx.groupId(), part.id(), grpCtx.cacheOrGroupName());
        this.processedPartitions.incrementAndGet();
        return Collections.singletonMap(partKey, partRes);
    }

    private void processPartIterator(CacheGroupContext grpCtx, ValidateIndexesPartitionResult partRes, IndexQueryContext qryCtx, GridIterator<CacheDataRow> it) throws IgniteCheckedException {
        boolean enoughIssues = false;
        GridQueryProcessor qryProcessor = this.ignite.context().query();
        boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
        boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
        long current = 0L;
        long processedNumber = 0L;
        block2: while (it.hasNextX() && !this.validateCtx.isCancelled() && !enoughIssues) {
            GridCacheContext<?, ?> cacheCtx;
            CacheDataRow row = it.nextX();
            if (skipConditions) {
                if (bothSkipConditions) {
                    if (processedNumber > (long)this.checkFirst) break;
                    if (current++ % (long)this.checkThrough > 0L) continue;
                    ++processedNumber;
                } else if (this.checkFirst > 0) {
                    if (current++ > (long)this.checkFirst) {
                        break;
                    }
                } else if (current++ % (long)this.checkThrough > 0L) continue;
            }
            int cacheId = row.cacheId() == 0 ? grpCtx.groupId() : row.cacheId();
            GridCacheContext<?, ?> gridCacheContext = cacheCtx = row.cacheId() == 0 ? grpCtx.singleCacheContext() : grpCtx.shared().cacheContext(row.cacheId());
            if (cacheCtx == null) {
                throw new IgniteException("Unknown cacheId of CacheDataRow: " + cacheId);
            }
            if (row.link() == 0L) {
                String errMsg = "Invalid partition row, possibly deleted";
                this.log.error(errMsg);
                IndexValidationIssue is = new IndexValidationIssue(null, cacheCtx.name(), null, new IgniteCheckedException(errMsg));
                enoughIssues |= partRes.reportIssue(is);
                continue;
            }
            QueryTypeDescriptorImpl res = qryProcessor.typeByValue(cacheCtx.name(), cacheCtx.cacheObjectContext(), row.key(), row.value(), true);
            if (res == null) continue;
            Collection<Index> indexes = this.ignite.context().indexProcessor().indexes(cacheCtx.name());
            for (Index idx : indexes) {
                if (this.validateCtx.isCancelled()) continue block2;
                InlineIndexImpl idx0 = idx.unwrap(InlineIndexImpl.class);
                if (idx0 == null || !F.eq(idx0.indexDefinition().idxName().tableName(), res.tableName())) continue;
                IndexRowImpl idxRow = new IndexRowImpl(idx0.segment(0).rowHandler(), row);
                try {
                    GridCursor<IndexRow> cursor = idx0.find(idxRow, idxRow, true, true, qryCtx);
                    if (cursor != null && cursor.next()) continue;
                    throw new IgniteCheckedException("Key is present in CacheDataTree, but can't be found in SQL index.");
                }
                catch (Throwable t) {
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded(grpCtx.cacheObjectContext(), row.key(), true, true);
                    IndexValidationIssue is = new IndexValidationIssue(o.toString(), cacheCtx.name(), idx.name(), t);
                    this.log.error("Failed to lookup key: " + is.toString(), t);
                    enoughIssues |= partRes.reportIssue(is);
                }
            }
        }
    }

    private IndexQueryContext mvccQueryContext(GridCacheContext<?, ?> cctx) throws IgniteCheckedException {
        boolean mvccEnabled = cctx.mvccEnabled();
        if (mvccEnabled) {
            MvccQueryTracker tracker = MvccUtils.mvccTracker(cctx, true);
            MvccSnapshot mvccSnapshot = tracker.snapshot();
            return new IndexQueryContext(cacheName -> null, null, mvccSnapshot);
        }
        return null;
    }

    private void printProgressOfIndexValidationIfNeeded() {
        this.printProgressIfNeeded(() -> "Current progress of ValidateIndexesClosure: processed " + this.processedPartitions.get() + " of " + this.totalPartitions + " partitions, " + this.processedIndexes.get() + " of " + this.totalIndexes + " SQL indexes" + (this.checkSizes ? ", " + this.processedCacheSizePartitions.get() + " of " + this.totalPartitions + " calculate cache size per partitions, " + this.processedIdxSizes.get() + " of " + this.totalIndexes + "calculate index size" : ""));
    }

    private void printProgressIfNeeded(Supplier<String> msgSup) {
        long lastTs;
        long curTs = U.currentTimeMillis();
        if (curTs - (lastTs = this.lastProgressPrintTs.get()) >= 60000L && this.lastProgressPrintTs.compareAndSet(lastTs, curTs)) {
            this.log.warning(msgSup.get());
        }
    }

    private Future<Map<String, ValidateIndexesPartitionResult>> processIndexAsync(final T2<GridCacheContext, InlineIndexImpl> cacheCtxWithIdx, final IgniteInClosure<Integer> idleChecker) {
        return this.calcExecutor.submit(new Callable<Map<String, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<String, ValidateIndexesPartitionResult> call() {
                BPlusTree.suspendFailureDiagnostic.set(true);
                try {
                    Map map = ValidateIndexesClosure.this.processIndex(cacheCtxWithIdx, idleChecker);
                    return map;
                }
                finally {
                    BPlusTree.suspendFailureDiagnostic.set(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, ValidateIndexesPartitionResult> processIndex(T2<GridCacheContext, InlineIndexImpl> cacheCtxWithIdx, IgniteInClosure<Integer> idleChecker) {
        if (this.validateCtx.isCancelled()) {
            return Collections.emptyMap();
        }
        GridCacheContext ctx = (GridCacheContext)cacheCtxWithIdx.get1();
        InlineIndexImpl idx = (InlineIndexImpl)cacheCtxWithIdx.get2();
        ValidateIndexesPartitionResult idxValidationRes = new ValidateIndexesPartitionResult();
        boolean enoughIssues = false;
        GridCursor<IndexRow> cursor = null;
        try {
            cursor = idx.find(null, null, true, true, this.mvccQueryContext((GridCacheContext)cacheCtxWithIdx.get1()));
            if (cursor == null) {
                throw new IgniteCheckedException("Can't iterate through index: " + idx);
            }
        }
        catch (Throwable t) {
            IndexValidationIssue is = new IndexValidationIssue(null, ctx.name(), idx.name(), t);
            this.log.error("Find in index failed: " + is.toString());
            idxValidationRes.reportIssue(is);
            enoughIssues = true;
        }
        boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
        boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
        long current = 0L;
        long processedNumber = 0L;
        KeyCacheObject previousKey = null;
        while (!enoughIssues && !this.validateCtx.isCancelled()) {
            KeyCacheObject key = null;
            try {
                try {
                    try {
                        if (!cursor.next()) {
                            previousKey = key;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (X.hasCause((Throwable)e, CorruptedTreeException.class)) {
                            throw new IgniteCheckedException("Key is present in SQL index, but is missing in corresponding data page. Previous successfully read key: " + CacheObjectUtils.unwrapBinaryIfNeeded(ctx.cacheObjectContext(), previousKey, true, true), X.cause(e, CorruptedTreeException.class));
                        }
                        throw e;
                    }
                    IndexRow idxRow = cursor.get();
                    if (skipConditions) {
                        if (bothSkipConditions) {
                            if (processedNumber > (long)this.checkFirst) {
                                previousKey = key;
                                break;
                            }
                            if (current++ % (long)this.checkThrough > 0L) {
                                previousKey = key;
                                continue;
                            }
                            ++processedNumber;
                        } else if (this.checkFirst > 0) {
                            if (current++ > (long)this.checkFirst) {
                                previousKey = key;
                                break;
                            }
                        } else if (current++ % (long)this.checkThrough > 0L) {
                            previousKey = key;
                            continue;
                        }
                    }
                    key = idxRow.cacheDataRow().key();
                    if (idxRow.cacheDataRow().link() == 0L) {
                        throw new IgniteCheckedException("Invalid index row, possibly deleted " + idxRow);
                    }
                    CacheDataRow cacheDataStoreRow = ctx.group().offheap().read(ctx, key);
                    if (cacheDataStoreRow == null) {
                        throw new IgniteCheckedException("Key is present in SQL index, but can't be found in CacheDataTree.");
                    }
                    previousKey = key;
                }
                catch (Throwable t) {
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded(ctx.cacheObjectContext(), key, true, true);
                    IndexValidationIssue is = new IndexValidationIssue(String.valueOf(o), ctx.name(), idx.name(), t);
                    this.log.error("Failed to lookup key: " + is.toString());
                    enoughIssues |= idxValidationRes.reportIssue(is);
                    previousKey = key;
                }
            }
            catch (Throwable throwable) {
                previousKey = key;
                throw throwable;
            }
        }
        CacheGroupContext group = ctx.group();
        String uniqueIdxName = String.format("[cacheGroup=%s, cacheGroupId=%s, cache=%s, cacheId=%s, idx=%s]", group.name(), group.groupId(), ctx.name(), ctx.cacheId(), idx.name());
        idleChecker.apply(group.groupId());
        this.processedIndexes.incrementAndGet();
        this.printProgressOfIndexValidationIfNeeded();
        return Collections.singletonMap(uniqueIdxName, idxValidationRes);
    }

    private IgniteException unwrapFutureException(Exception e) {
        assert (e instanceof InterruptedException || e instanceof ExecutionException) : "Expecting either InterruptedException or ExecutionException";
        if (e instanceof InterruptedException) {
            return new IgniteInterruptedException((InterruptedException)e);
        }
        if (e.getCause() instanceof IgniteException) {
            return (IgniteException)e.getCause();
        }
        return new IgniteException(e.getCause());
    }

    private Future<CacheSize> calcCacheSizeAsync(CacheGroupContext grpCtx, GridDhtLocalPartition locPart) {
        return this.calcExecutor.submit(() -> this.calcCacheSize(grpCtx, locPart));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CacheSize calcCacheSize(CacheGroupContext grpCtx, GridDhtLocalPartition locPart) {
        try {
            if (this.validateCtx.isCancelled()) {
                CacheSize cacheSize = new CacheSize(null, Collections.emptyMap());
                return cacheSize;
            }
            @Nullable PartitionUpdateCounter updCntr = locPart.dataStore().partUpdateCounter();
            PartitionUpdateCounter updateCntrBefore = updCntr == null ? updCntr : updCntr.copy();
            int grpId = grpCtx.groupId();
            if (this.failCalcCacheSizeGrpIds.contains(grpId)) {
                CacheSize cacheSize = new CacheSize(null, null);
                return cacheSize;
            }
            boolean reserve = false;
            int partId = locPart.id();
            try {
                reserve = locPart.reserve();
                if (!reserve) {
                    throw new IgniteException("Can't reserve partition");
                }
                if (locPart.state() != GridDhtPartitionState.OWNING) {
                    throw new IgniteException("Partition not in state " + (Object)((Object)GridDhtPartitionState.OWNING));
                }
                HashMap<Integer, Map<String, AtomicLong>> cacheSizeByTbl = new HashMap<Integer, Map<String, AtomicLong>>();
                GridIterator<CacheDataRow> partIter = grpCtx.offheap().partitionIterator(partId);
                GridQueryProcessor qryProcessor = this.ignite.context().query();
                while (partIter.hasNextX() && !this.failCalcCacheSizeGrpIds.contains(grpId)) {
                    GridCacheContext<?, ?> cacheCtx;
                    CacheDataRow cacheDataRow = partIter.nextX();
                    int cacheId = cacheDataRow.cacheId();
                    GridCacheContext<?, ?> gridCacheContext = cacheCtx = cacheId == 0 ? grpCtx.singleCacheContext() : grpCtx.shared().cacheContext(cacheId);
                    if (cacheCtx == null) {
                        throw new IgniteException("Unknown cacheId of CacheDataRow: " + cacheId);
                    }
                    if (cacheDataRow.link() == 0L) {
                        throw new IgniteException("Contains invalid partition row, possibly deleted");
                    }
                    String cacheName = cacheCtx.name();
                    QueryTypeDescriptorImpl qryTypeDesc = qryProcessor.typeByValue(cacheName, cacheCtx.cacheObjectContext(), cacheDataRow.key(), cacheDataRow.value(), true);
                    if (Objects.isNull(qryTypeDesc)) continue;
                    String tableName = qryTypeDesc.tableName();
                    cacheSizeByTbl.computeIfAbsent(cacheCtx.cacheId(), i -> new HashMap()).computeIfAbsent(tableName, s -> new AtomicLong()).incrementAndGet();
                }
                PartitionUpdateCounter updateCntrAfter = locPart.dataStore().partUpdateCounter();
                if (updateCntrAfter != null && !updateCntrAfter.equals(updateCntrBefore)) {
                    throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [grpName=" + grpCtx.cacheOrGroupName() + ", grpId=" + grpCtx.groupId() + ", partId=" + locPart.id() + "] changed during size calculation [updCntrBefore=" + updateCntrBefore + ", updCntrAfter=" + updateCntrAfter + "]");
                }
                CacheSize cacheSize = new CacheSize(null, cacheSizeByTbl);
                if (reserve) {
                    locPart.release();
                }
                return cacheSize;
            }
            catch (Throwable t) {
                IgniteException cacheSizeErr = new IgniteException("Cache size calculation error [" + this.cacheGrpInfo(grpCtx) + ", locParId=" + partId + ", err=" + t.getMessage() + "]", t);
                IgniteUtils.error(this.log, cacheSizeErr);
                this.failCalcCacheSizeGrpIds.add(grpId);
                CacheSize cacheSize = new CacheSize(cacheSizeErr, null);
                if (reserve) {
                    locPart.release();
                }
                this.processedCacheSizePartitions.incrementAndGet();
                this.printProgressOfIndexValidationIfNeeded();
                return cacheSize;
                {
                    catch (Throwable throwable) {
                        if (reserve) {
                            locPart.release();
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.processedCacheSizePartitions.incrementAndGet();
            this.printProgressOfIndexValidationIfNeeded();
        }
    }

    private Future<T2<Throwable, Long>> calcIndexSizeAsync(GridCacheContext cacheCtx, InlineIndexImpl idx, IgniteInClosure<Integer> idleChecker) {
        return this.calcExecutor.submit(() -> this.calcIndexSize(cacheCtx, idx, idleChecker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T2<Throwable, Long> calcIndexSize(GridCacheContext cacheCtx, InlineIndexImpl idx, IgniteInClosure<Integer> idleChecker) {
        if (this.validateCtx.isCancelled()) {
            return new T2<Object, Long>(null, 0L);
        }
        try {
            if (this.failCalcCacheSizeGrpIds.contains(cacheCtx.groupId())) {
                T2<Object, Long> t2 = new T2<Object, Long>(null, 0L);
                return t2;
            }
            String cacheName = cacheCtx.name();
            String tblName = idx.indexDefinition().idxName().tableName();
            String idxName = idx.indexDefinition().idxName().idxName();
            try {
                long indexSize = idx.totalCount();
                idleChecker.apply(cacheCtx.groupId());
                T2<Object, Long> t2 = new T2<Object, Long>(null, indexSize);
                return t2;
            }
            catch (Throwable t) {
                IgniteException idxSizeErr = new IgniteException("Index size calculation error [" + this.cacheGrpInfo(cacheCtx.group()) + ", " + this.cacheInfo(cacheCtx) + ", tableName=" + tblName + ", idxName=" + idxName + ", err=" + t.getMessage() + "]", t);
                IgniteUtils.error(this.log, idxSizeErr);
                T2<Throwable, Long> t2 = new T2<Throwable, Long>(idxSizeErr, 0L);
                this.processedIdxSizes.incrementAndGet();
                this.printProgressOfIndexValidationIfNeeded();
                return t2;
            }
        }
        finally {
            this.processedIdxSizes.incrementAndGet();
            this.printProgressOfIndexValidationIfNeeded();
        }
    }

    private String cacheGrpInfo(CacheGroupContext cacheGrpCtx) {
        return "cacheGrpName=" + cacheGrpCtx.name() + ", cacheGrpId=" + cacheGrpCtx.groupId();
    }

    private String cacheInfo(GridCacheContext cacheCtx) {
        return "cacheName=" + cacheCtx.name() + ", cacheId=" + cacheCtx.cacheId();
    }

    private void checkSizes(List<T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>>> cacheSizesFutures, List<T3<GridCacheContext, InlineIndexImpl, Future<T2<Throwable, Long>>>> idxSizeFutures, Map<String, ValidateIndexesCheckSizeResult> checkSizeRes) throws ExecutionException, InterruptedException {
        if (!this.checkSizes) {
            return;
        }
        HashMap<Integer, CacheSize> cacheSizeTotal = new HashMap<Integer, CacheSize>();
        for (T3<CacheGroupContext, GridDhtLocalPartition, Future<CacheSize>> t3 : cacheSizesFutures) {
            CacheGroupContext cacheGrpCtx = (CacheGroupContext)t3.get1();
            CacheSize cacheSize = (CacheSize)((Future)t3.get3()).get();
            Throwable cacheSizeErr = cacheSize.err;
            int grpId = cacheGrpCtx.groupId();
            if (this.failCalcCacheSizeGrpIds.contains(grpId) && Objects.nonNull(cacheSizeErr)) {
                checkSizeRes.computeIfAbsent(this.cacheGrpInfo(cacheGrpCtx), s -> new ValidateIndexesCheckSizeResult(0L, new ArrayList<ValidateIndexesCheckSizeIssue>())).issues().add(new ValidateIndexesCheckSizeIssue(null, 0L, cacheSizeErr));
                continue;
            }
            cacheSizeTotal.computeIfAbsent(grpId, i -> new CacheSize(null, new HashMap<Integer, Map<String, AtomicLong>>())).merge(cacheSize.cacheSizePerTbl);
        }
        for (T3<Object, Object, Future<Object>> t3 : idxSizeFutures) {
            GridCacheContext cacheCtx = (GridCacheContext)t3.get1();
            int grpId = cacheCtx.groupId();
            if (this.failCalcCacheSizeGrpIds.contains(grpId)) continue;
            InlineIndexImpl idx = (InlineIndexImpl)t3.get2();
            String tblName = idx.indexDefinition().idxName().tableName();
            AtomicLong cacheSizeObj = (AtomicLong)((CacheSize)cacheSizeTotal.get((Object)Integer.valueOf((int)grpId))).cacheSizePerTbl.getOrDefault(cacheCtx.cacheId(), Collections.emptyMap()).get(tblName);
            long cacheSizeByTbl = Objects.isNull(cacheSizeObj) ? 0L : cacheSizeObj.get();
            T2 idxSizeRes = (T2)((Future)t3.get3()).get();
            Throwable err = (Throwable)idxSizeRes.get1();
            long idxSize = (Long)idxSizeRes.get2();
            if (Objects.isNull(err) && idxSize != cacheSizeByTbl) {
                err = new IgniteException("Cache and index size not same.");
            }
            if (!Objects.nonNull(err)) continue;
            checkSizeRes.computeIfAbsent("[" + this.cacheGrpInfo(cacheCtx.group()) + ", " + this.cacheInfo(cacheCtx) + ", tableName=" + tblName + "]", s -> new ValidateIndexesCheckSizeResult(cacheSizeByTbl, new ArrayList<ValidateIndexesCheckSizeIssue>())).issues().add(new ValidateIndexesCheckSizeIssue(idx.name(), idxSize, err));
        }
    }

    private static class CacheSize {
        final Throwable err;
        final Map<Integer, Map<String, AtomicLong>> cacheSizePerTbl;

        public CacheSize(@Nullable Throwable err, @Nullable Map<Integer, Map<String, AtomicLong>> cacheSizePerTbl) {
            this.err = err;
            this.cacheSizePerTbl = cacheSizePerTbl;
        }

        void merge(Map<Integer, Map<String, AtomicLong>> other) {
            assert (Objects.nonNull(this.cacheSizePerTbl));
            for (Map.Entry<Integer, Map<String, AtomicLong>> cacheEntry : other.entrySet()) {
                for (Map.Entry<String, AtomicLong> tableEntry : cacheEntry.getValue().entrySet()) {
                    this.cacheSizePerTbl.computeIfAbsent(cacheEntry.getKey(), i -> new HashMap()).computeIfAbsent(tableEntry.getKey(), s -> new AtomicLong()).addAndGet(tableEntry.getValue().get());
                }
            }
        }
    }
}

