/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.messaging;

import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractPredicate;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.message.PlatformMessageFilter;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;

public class PlatformMessageFilterImpl
extends PlatformAbstractPredicate
implements PlatformMessageFilter {
    private static final long serialVersionUID = 0L;

    public PlatformMessageFilterImpl() {
    }

    public PlatformMessageFilterImpl(Object pred, long ptr, PlatformContext ctx) {
        super(pred, ptr, ctx);
    }

    @Override
    public boolean apply(UUID uuid, Object m) {
        if (this.ptr == 0L) {
            return false;
        }
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(uuid);
            writer.writeObject(m);
            out.synchronize();
            boolean bl = this.ctx.gateway().messagingFilterApply(this.ptr, mem.pointer()) != 0;
            return bl;
        }
    }

    @Override
    public void initialize(GridKernalContext kernalCtx) {
        if (this.ptr != 0L) {
            return;
        }
        this.ctx = PlatformUtils.platformContext(kernalCtx.grid());
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(this.pred);
            out.synchronize();
            this.ptr = this.ctx.gateway().messagingFilterCreate(mem.pointer());
        }
    }

    @Override
    public void onClose() {
        if (this.ptr == 0L) {
            return;
        }
        try {
            assert (this.ctx != null);
            this.ctx.gateway().messagingFilterDestroy(this.ptr);
        }
        finally {
            this.ptr = 0L;
        }
    }
}

