/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSnapshot;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.SnapshotEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.communication.TransmissionCancelledException;
import org.apache.ignite.internal.managers.communication.TransmissionHandler;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.managers.communication.TransmissionPolicy;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.managers.systemview.walker.SnapshotViewWalker;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotVerifyException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFilesFailureMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFilesRequestMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFinishedFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerRestoreTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataCollectorTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataCollectorTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotResponseRemoteFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotRestoreCancelTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotRestoreProcess;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotRestoreStatusTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageImpl;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.BasicRateLimiter;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.distributed.InitMessage;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.systemview.view.SnapshotView;
import org.jetbrains.annotations.Nullable;

public class IgniteSnapshotManager
extends GridCacheSharedManagerAdapter
implements IgniteSnapshot,
PartitionsExchangeAware,
MetastorageLifecycleListener,
IgniteChangeGlobalStateSupport {
    public static final String DELTA_SUFFIX = ".delta";
    public static final String PART_DELTA_TEMPLATE = "part-%d.bin.delta";
    public static final String INDEX_DELTA_NAME = "index.bin.delta";
    public static final String CP_SNAPSHOT_REASON = "Checkpoint started to enforce snapshot operation: %s";
    public static final String RMT_SNAPSHOT_PREFIX = "snapshot_";
    public static final String DFLT_SNAPSHOT_TMP_DIR = "snp";
    public static final String SNP_IN_PROGRESS_ERR_MSG = "Operation rejected due to the snapshot operation in progress.";
    public static final String SNP_NODE_STOPPING_ERR_MSG = "The operation is cancelled due to the local node is stopping";
    public static final String SNAPSHOT_METRICS = "snapshot";
    public static final String SNAPSHOT_METAFILE_EXT = ".smf";
    public static final String SNAPSHOT_RUNNER_THREAD_PREFIX = "snapshot-runner";
    public static final String SNAPSHOT_TRANSFER_RATE_DMS_KEY = "snapshotTransferRate";
    public static final long DFLT_SNAPSHOT_TRANSFER_RATE_BYTES = 0L;
    public static final int SNAPSHOT_LIMITED_TRANSFER_BLOCK_SIZE_BYTES = 65536;
    private static final String SNP_RUNNING_DIR_KEY = "snapshot-running-dir";
    @Deprecated
    private static final String SNP_RUNNING_KEY = "snapshot-running";
    private static final String SNAPSHOT_FINISHED_MSG = "Cluster-wide snapshot operation finished successfully: ";
    private static final String SNAPSHOT_FAILED_MSG = "Cluster-wide snapshot operation failed: ";
    private static final Object DFLT_INITIAL_SNAPSHOT_TOPIC = GridTopic.TOPIC_SNAPSHOT.topic("rmt_snp");
    private static final String SNP_GRP_ID_PARAM = "grpId";
    private static final String SNP_PART_ID_PARAM = "partId";
    private static final String SNP_CACHE_DIR_NAME_PARAM = "cacheDirName";
    private static final String RQ_ID_NAME_PARAM = "rqId";
    private static final String SNP_PARTITIONS_CNT = "partsCnt";
    private final ThreadLocal<ByteBuffer> locBuff;
    private final ConcurrentMap<String, AbstractSnapshotFutureTask<?>> locSnpTasks = new ConcurrentHashMap();
    private final GridBusyLock busyLock = new GridBusyLock();
    private final Object snpOpMux = new Object();
    private final DistributedProcess<SnapshotOperationRequest, SnapshotOperationResponse> startSnpProc;
    private final DistributedProcess<SnapshotOperationRequest, SnapshotOperationResponse> endSnpProc;
    private final Marshaller marsh;
    private final SnapshotRestoreProcess restoreCacheGrpProc;
    private final BasicRateLimiter transferRateLimiter = new BasicRateLimiter(0.0);
    private volatile PdsFolderSettings pdsSettings;
    private volatile ReadWriteMetastorage metaStorage;
    private BiFunction<String, String, SnapshotSender> locSndrFactory = (x$0, x$1) -> new LocalSnapshotSender((String)x$0, (String)x$1);
    private BiFunction<String, UUID, SnapshotSender> rmtSndrFactory = this::remoteSnapshotSenderFactory;
    private volatile File locSnpDir;
    private File tmpWorkDir;
    private volatile FileIOFactory ioFactory = new RandomAccessFileIOFactory();
    private volatile FilePageStoreManager storeMgr;
    private volatile GridLocalConfigManager locCfgMgr;
    private DiscoveryEventListener discoLsnr;
    private ClusterSnapshotFuture clusterSnpFut;
    private volatile SnapshotOperationRequest clusterSnpReq;
    private volatile boolean recovered;
    private volatile ClusterSnapshotFuture lastSeenSnpFut = new ClusterSnapshotFuture();
    private final SnapshotHandlers handlers = new SnapshotHandlers();
    private final SequentialRemoteSnapshotManager snpRmtMgr;
    private final DistributedLongProperty snapshotTransferRate = DistributedLongProperty.detachedLongProperty("snapshotTransferRate");

    public IgniteSnapshotManager(GridKernalContext ctx) {
        this.locBuff = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(ctx.config().getDataStorageConfiguration().getPageSize()).order(ByteOrder.nativeOrder()));
        this.startSnpProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.START_SNAPSHOT, this::initLocalSnapshotStartStage, this::processLocalSnapshotStartStageResult, SnapshotStartDiscoveryMessage::new);
        this.endSnpProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.END_SNAPSHOT, this::initLocalSnapshotEndStage, this::processLocalSnapshotEndStageResult);
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
        this.restoreCacheGrpProc = new SnapshotRestoreProcess(ctx);
        this.snpRmtMgr = new SequentialRemoteSnapshotManager();
    }

    public static File partDeltaFile(File snapshotCacheDir, int partId) {
        return new File(snapshotCacheDir, IgniteSnapshotManager.partDeltaFileName(partId));
    }

    public static String partDeltaFileName(int partId) {
        assert (partId <= 65500 || partId == 65535);
        return partId == 65535 ? INDEX_DELTA_NAME : String.format(PART_DELTA_TEMPLATE, partId);
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        GridKernalContext ctx = this.cctx.kernalContext();
        if (ctx.clientNode()) {
            return;
        }
        if (!CU.isPersistenceEnabled(ctx.config())) {
            return;
        }
        assert (this.cctx.pageStore() instanceof FilePageStoreManager);
        this.storeMgr = (FilePageStoreManager)this.cctx.pageStore();
        this.locCfgMgr = this.cctx.cache().configManager();
        this.pdsSettings = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
        this.locSnpDir = IgniteSnapshotManager.resolveSnapshotWorkDirectory(ctx.config());
        this.tmpWorkDir = U.resolveWorkDirectory(this.storeMgr.workDir().getAbsolutePath(), DFLT_SNAPSHOT_TMP_DIR, true);
        U.ensureDirectory(this.locSnpDir, "snapshot work directory", this.log);
        U.ensureDirectory(this.tmpWorkDir, "temp directory for snapshot creation", this.log);
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                IgniteSnapshotManager.this.snapshotTransferRate.addListener((name, oldVal, newVal) -> {
                    if (!Objects.equals(oldVal, newVal)) {
                        if (newVal < 0L) {
                            IgniteSnapshotManager.this.log.warning("The snapshot transfer rate cannot be negative, the value '" + newVal + "' is ignored.");
                            return;
                        }
                        IgniteSnapshotManager.this.transferRateLimiter.setRate(newVal.longValue());
                        if (IgniteSnapshotManager.this.log.isInfoEnabled()) {
                            IgniteSnapshotManager.this.log.info("The snapshot transfer rate " + (newVal == 0L ? "is not limited." : "has been changed from '" + oldVal + "' to '" + newVal + "' bytes/sec."));
                        }
                    }
                });
                dispatcher.registerProperty(IgniteSnapshotManager.this.snapshotTransferRate);
            }

            @Override
            public void onReadyToWrite() {
                DistributedConfigurationUtils.setDefaultValue(IgniteSnapshotManager.this.snapshotTransferRate, 0L, IgniteSnapshotManager.this.log);
            }
        });
        this.handlers.initialize(ctx, ctx.pools().getSnapshotExecutorService());
        MetricRegistry mreg = this.cctx.kernalContext().metric().registry(SNAPSHOT_METRICS);
        mreg.register("LastSnapshotStartTime", () -> this.lastSeenSnpFut.startTime, "The system time of the last cluster snapshot request start time on this node.");
        mreg.register("LastSnapshotEndTime", () -> this.lastSeenSnpFut.endTime, "The system time of the last cluster snapshot request end time on this node.");
        mreg.register("LastSnapshotName", () -> this.lastSeenSnpFut.name, String.class, "The name of last started cluster snapshot request on this node.");
        mreg.register("LastSnapshotErrorMessage", () -> this.lastSeenSnpFut.error() == null ? "" : this.lastSeenSnpFut.error().getMessage(), String.class, "The error message of last started cluster snapshot request which fail with an error. This value will be empty if last snapshot request has been completed successfully.");
        mreg.register("LocalSnapshotNames", this::localSnapshotNames, List.class, "The list of names of all snapshots currently saved on the local node with respect to the configured via IgniteConfiguration snapshot working path.");
        mreg.register("CurrentSnapshotTotalSize", () -> {
            SnapshotFutureTask task = this.currentSnapshotTask();
            return task == null ? -1L : task.totalSize();
        }, "Estimated size of current cluster snapshot in bytes on this node. The value may grow during snapshot creation.");
        mreg.register("CurrentSnapshotProcessedSize", () -> {
            SnapshotFutureTask task = this.currentSnapshotTask();
            return task == null ? -1L : task.processedSize();
        }, "Processed size of current cluster snapshot in bytes on this node.");
        this.restoreCacheGrpProc.registerMetrics();
        this.cctx.exchange().registerExchangeAwareComponent(this);
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.discoLsnr = (evt, discoCache) -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            try {
                UUID leftNodeId = evt.eventNode().id();
                if (evt.type() == 11 || evt.type() == 12) {
                    boolean reqNodeLeft;
                    SnapshotOperationRequest snpReq = this.clusterSnpReq;
                    String err = "Snapshot operation interrupted, because baseline node left the cluster: " + leftNodeId;
                    boolean bl = reqNodeLeft = snpReq != null && snpReq.nodes().contains(leftNodeId);
                    if (reqNodeLeft && snpReq.startStageEnded() && U.isLocalNodeCoordinator(ctx.discovery())) {
                        snpReq.error(new ClusterTopologyCheckedException(err));
                        this.endSnpProc.start(snpReq.requestId(), snpReq);
                    }
                    for (AbstractSnapshotFutureTask sctx : this.locSnpTasks.values()) {
                        if (!sctx.sourceNodeId().equals(leftNodeId) && (!reqNodeLeft || !snpReq.snapshotName().equals(sctx.snapshotName()))) continue;
                        sctx.acceptException(new ClusterTopologyCheckedException(err));
                    }
                    this.restoreCacheGrpProc.onNodeLeft(leftNodeId);
                    this.snpRmtMgr.onNodeLeft(leftNodeId);
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
        this.cctx.gridEvents().addDiscoveryEventListener(this.discoLsnr, 11, 12);
        this.cctx.gridIO().addMessageListener(DFLT_INITIAL_SNAPSHOT_TOPIC, (GridMessageListener)this.snpRmtMgr);
        this.cctx.kernalContext().io().addTransmissionHandler(DFLT_INITIAL_SNAPSHOT_TOPIC, this.snpRmtMgr);
        ctx.systemView().registerView(SNAPSHOT_METRICS, "Snapshot", new SnapshotViewWalker(), () -> F.flatCollections(F.transform(this.localSnapshotNames(), name -> this.readSnapshotMetadatas((String)name, null))), this::snapshotViewSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stop0(boolean cancel) {
        this.busyLock.block();
        try {
            this.restoreCacheGrpProc.interrupt(new NodeStoppingException("Node is stopping."));
            for (AbstractSnapshotFutureTask sctx : this.locSnpTasks.values()) {
                sctx.acceptException(new NodeStoppingException(SNP_NODE_STOPPING_ERR_MSG));
            }
            this.locSnpTasks.clear();
            this.snpRmtMgr.stop();
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null) {
                    this.clusterSnpFut.onDone(new NodeStoppingException(SNP_NODE_STOPPING_ERR_MSG));
                    this.clusterSnpFut = null;
                }
            }
            this.cctx.kernalContext().io().removeMessageListener(DFLT_INITIAL_SNAPSHOT_TOPIC);
            this.cctx.kernalContext().io().removeTransmissionHandler(DFLT_INITIAL_SNAPSHOT_TOPIC);
            if (this.discoLsnr != null) {
                this.cctx.kernalContext().event().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
            }
            this.cctx.exchange().unregisterExchangeAwareComponent(this);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) {
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        this.restoreCacheGrpProc.interrupt(new IgniteCheckedException("The cluster has been deactivated."));
    }

    public void deleteSnapshot(File snpDir, String folderName) {
        if (!snpDir.exists()) {
            return;
        }
        if (!snpDir.isDirectory()) {
            return;
        }
        try {
            File binDir = CacheObjectBinaryProcessorImpl.binaryWorkDir(snpDir.getAbsolutePath(), folderName);
            File nodeDbDir = new File(snpDir.getAbsolutePath(), IgniteSnapshotManager.databaseRelativePath(folderName));
            U.delete(binDir);
            U.delete(nodeDbDir);
            File marshDir = MarshallerContextImpl.mappingFileStoreWorkDir(snpDir.getAbsolutePath());
            Files.walkFileTree(marshDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    U.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    dir.toFile().delete();
                    if (IgniteSnapshotManager.this.log.isInfoEnabled() && exc != null) {
                        IgniteSnapshotManager.this.log.info("Marshaller directory cleaned with an exception: " + exc.getMessage());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            File binMetadataDfltDir = new File(snpDir, "db/binary_meta");
            File marshallerDfltDir = new File(snpDir, "db/marshaller");
            U.delete(binMetadataDfltDir);
            U.delete(marshallerDfltDir);
            File db = new File(snpDir, "db");
            if (!db.exists() || F.isEmpty(db.list())) {
                marshDir.delete();
                db.delete();
                U.delete(snpDir);
            }
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    public File snapshotLocalDir(String snpName) {
        return this.snapshotLocalDir(snpName, null);
    }

    public File snapshotLocalDir(String snpName, @Nullable String snpPath) {
        assert (this.locSnpDir != null);
        assert (U.alphanumericUnderscore(snpName)) : snpName;
        return snpPath == null ? new File(this.locSnpDir, snpName) : new File(snpPath, snpName);
    }

    private File resolveSnapshotDir(String snpName, @Nullable String snpPath) throws IgniteCheckedException {
        File snpDir = this.snapshotLocalDir(snpName, snpPath);
        if (!snpDir.exists()) {
            throw new IgniteCheckedException("Snapshot directory doesn't exists: " + snpDir.getAbsolutePath());
        }
        return snpDir;
    }

    public File snapshotTmpDir() {
        assert (this.tmpWorkDir != null);
        return this.tmpWorkDir;
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalSnapshotStartStage(SnapshotOperationRequest req) {
        IgniteInternalFuture<Set<SnapshotOperationResponse>> task0;
        if (this.cctx.kernalContext().clientNode() || !CU.baselineNode(this.cctx.localNode(), this.cctx.kernalContext().state().clusterState())) {
            return new GridFinishedFuture<SnapshotOperationResponse>();
        }
        if (this.clusterSnpReq != null) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Another snapshot operation in progress [req=" + req + ", curr=" + this.clusterSnpReq + ']'));
        }
        HashSet<UUID> leftNodes = new HashSet<UUID>(req.nodes());
        leftNodes.removeAll(F.viewReadOnly(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), F.node2id(), new IgnitePredicate[0]));
        if (!leftNodes.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Some of baseline nodes left the cluster prior to snapshot operation start: " + leftNodes));
        }
        if (!this.cctx.localNode().isClient() && this.cctx.kernalContext().encryption().isMasterKeyChangeInProgress()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Master key changing process is not finished yet."));
        }
        if (!this.cctx.localNode().isClient() && this.cctx.kernalContext().encryption().reencryptionInProgress()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Caches re-encryption process is not finished yet."));
        }
        ArrayList<Integer> grpIds = new ArrayList<Integer>(F.viewReadOnly(req.groups(), GridCacheUtils::cacheId, new IgnitePredicate[0]));
        HashSet<Integer> leftGrps = new HashSet<Integer>(grpIds);
        leftGrps.removeAll(this.cctx.cache().cacheGroupDescriptors().keySet());
        boolean withMetaStorage = leftGrps.remove(MetaStorage.METASTORAGE_CACHE_ID);
        if (!leftGrps.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Some of requested cache groups doesn't exist on the local node [missed=" + leftGrps + ", nodeId=" + this.cctx.localNodeId() + ']'));
        }
        HashMap<Integer, Set<Integer>> parts = new HashMap<Integer, Set<Integer>>();
        for (Integer grpId : grpIds) {
            if (this.cctx.cache().cacheGroup(grpId) == null) continue;
            parts.put(grpId, null);
        }
        if (parts.isEmpty() && !withMetaStorage) {
            task0 = new GridFinishedFuture<Set<SnapshotOperationResponse>>(Collections.emptySet());
        } else {
            task0 = this.registerSnapshotTask(req.snapshotName(), req.operationalNodeId(), parts, withMetaStorage, this.locSndrFactory.apply(req.snapshotName(), req.snapshotPath()));
            if (withMetaStorage && task0 instanceof SnapshotFutureTask) {
                ((DistributedMetaStorageImpl)this.cctx.kernalContext().distributedMetastorage()).suspend(((SnapshotFutureTask)task0).started());
            }
            this.clusterSnpReq = req;
        }
        return task0.chain(fut -> {
            if (fut.error() != null) {
                throw F.wrap(fut.error());
            }
            try {
                Set<String> blts = req.nodes().stream().map(n -> this.cctx.discovery().node((UUID)n).consistentId().toString()).collect(Collectors.toSet());
                File snpDir = this.snapshotLocalDir(req.snapshotName(), req.snapshotPath());
                File smf = new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(this.cctx.localNode().consistentId().toString()));
                if (smf.exists()) {
                    throw new GridClosureException(new IgniteException("Snapshot metafile must not exist: " + smf.getAbsolutePath()));
                }
                snpDir.mkdirs();
                SnapshotMetadata meta = new SnapshotMetadata(req.requestId(), req.snapshotName(), this.cctx.localNode().consistentId().toString(), this.pdsSettings.folderName(), this.cctx.gridConfig().getDataStorageConfiguration().getPageSize(), grpIds, blts, (Set)fut.result(), this.cctx.gridConfig().getEncryptionSpi().masterKeyDigest());
                try (OutputStream out = Files.newOutputStream(smf.toPath(), new OpenOption[0]);){
                    byte[] bytes = U.marshal(this.marsh, (Object)meta);
                    int blockSize = 65536;
                    for (int off = 0; off < bytes.length; off += blockSize) {
                        int len = Math.min(blockSize, bytes.length - off);
                        this.transferRateLimiter.acquire(len);
                        out.write(bytes, off, len);
                    }
                }
                this.log.info("Snapshot metafile has been created: " + smf.getAbsolutePath());
                SnapshotHandlerContext ctx = new SnapshotHandlerContext(meta, req.groups(), this.cctx.localNode(), snpDir);
                return new SnapshotOperationResponse(this.handlers.invokeAll(SnapshotHandlerType.CREATE, ctx));
            }
            catch (IOException | IgniteCheckedException e) {
                throw F.wrap(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalSnapshotStartStageResult(UUID id, Map<UUID, SnapshotOperationResponse> res, Map<UUID, Exception> err) {
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        boolean cancelled = err.values().stream().anyMatch(e -> e instanceof IgniteFutureCancelledCheckedException);
        if (snpReq == null || !snpReq.requestId().equals(id)) {
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null && this.clusterSnpFut.rqId.equals(id)) {
                    if (cancelled) {
                        this.clusterSnpFut.onDone(new IgniteFutureCancelledCheckedException("Execution of snapshot tasks has been cancelled by external process [err=" + err + ", snpReq=" + snpReq + ']'));
                    } else {
                        this.clusterSnpFut.onDone(new IgniteCheckedException("Snapshot operation has not been fully completed [err=" + err + ", snpReq=" + snpReq + ']'));
                    }
                    this.clusterSnpFut = null;
                }
                return;
            }
        }
        snpReq.startStageEnded(true);
        if (IgniteUtils.isLocalNodeCoordinator(this.cctx.discovery())) {
            HashSet<UUID> missed = new HashSet<UUID>(snpReq.nodes());
            missed.removeAll(res.keySet());
            missed.removeAll(err.keySet());
            if (cancelled) {
                snpReq.error(new IgniteFutureCancelledCheckedException("Execution of snapshot tasks has been cancelled by external process [err=" + err + ", missed=" + missed + ']'));
            } else if (!missed.isEmpty()) {
                snpReq.error(new ClusterTopologyCheckedException("Snapshot operation interrupted, because baseline node left the cluster. Uncompleted snapshot will be deleted [missed=" + missed + ']'));
            } else if (!F.isEmpty(err)) {
                snpReq.error(new IgniteCheckedException("Execution of local snapshot tasks fails. Uncompleted snapshot will be deleted [err=" + err + ']'));
            }
            this.completeHandlersAsyncIfNeeded(snpReq, res.values()).listen(f -> {
                if (f.error() != null) {
                    snpReq.error(f.error());
                }
                this.endSnpProc.start(snpReq.requestId(), snpReq);
            });
        }
    }

    private IgniteInternalFuture<Void> completeHandlersAsyncIfNeeded(SnapshotOperationRequest req, Collection<SnapshotOperationResponse> res) {
        if (req.error() != null) {
            return new GridFinishedFuture<Void>();
        }
        HashMap<String, List> clusterHndResults = new HashMap<String, List>();
        for (SnapshotOperationResponse response : res) {
            if (response == null || response.handlerResults() == null) continue;
            for (Map.Entry<String, SnapshotHandlerResult<Object>> entry : response.handlerResults().entrySet()) {
                clusterHndResults.computeIfAbsent(entry.getKey(), v -> new ArrayList()).add(entry.getValue());
            }
        }
        if (clusterHndResults.isEmpty()) {
            return new GridFinishedFuture<Void>();
        }
        try {
            GridFutureAdapter<Void> resultFut = new GridFutureAdapter<Void>();
            this.handlers().execSvc.submit(() -> {
                try {
                    this.handlers.completeAll(SnapshotHandlerType.CREATE, req.snapshotName(), clusterHndResults, req.nodes());
                    resultFut.onDone();
                }
                catch (Exception e) {
                    this.log.warning("The snapshot operation will be aborted due to a handler error [snapshot=" + req.snapshotName() + "].", e);
                    resultFut.onDone(e);
                }
            });
            return resultFut;
        }
        catch (RejectedExecutionException e) {
            return new GridFinishedFuture<Void>(e);
        }
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalSnapshotEndStage(SnapshotOperationRequest req) {
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq == null || !F.eq(req.requestId(), snpReq.requestId())) {
            return new GridFinishedFuture<SnapshotOperationResponse>();
        }
        try {
            if (req.error() != null) {
                snpReq.error(req.error());
                this.deleteSnapshot(this.snapshotLocalDir(req.snapshotName(), req.snapshotPath()), this.pdsSettings.folderName());
            }
            this.removeLastMetaStorageKey();
        }
        catch (Exception e) {
            return new GridFinishedFuture<SnapshotOperationResponse>(e);
        }
        return new GridFinishedFuture<SnapshotOperationResponse>(new SnapshotOperationResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalSnapshotEndStageResult(UUID id, Map<UUID, SnapshotOperationResponse> res, Map<UUID, Exception> err) {
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq == null || !F.eq(id, snpReq.requestId())) {
            return;
        }
        HashSet<UUID> endFail = new HashSet<UUID>(snpReq.nodes());
        endFail.removeAll(res.keySet());
        this.clusterSnpReq = null;
        Object object = this.snpOpMux;
        synchronized (object) {
            if (this.clusterSnpFut != null) {
                if (endFail.isEmpty() && snpReq.error() == null) {
                    this.clusterSnpFut.onDone();
                    if (this.log.isInfoEnabled()) {
                        this.log.info(SNAPSHOT_FINISHED_MSG + snpReq);
                    }
                } else if (snpReq.error() == null) {
                    this.clusterSnpFut.onDone(new IgniteCheckedException("Snapshot creation has been finished with an error. Local snapshot tasks may not finished completely or finalizing results fails [fail=" + endFail + ", err=" + err + ']'));
                } else {
                    this.clusterSnpFut.onDone(snpReq.error());
                }
                this.clusterSnpFut = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSnapshotCreating() {
        if (this.clusterSnpReq != null) {
            return true;
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            return this.clusterSnpReq != null || this.clusterSnpFut != null;
        }
    }

    @Nullable
    public SnapshotOperationRequest currentCreateRequest() {
        return this.clusterSnpReq;
    }

    public boolean isRestoring() {
        return this.restoreCacheGrpProc.restoringSnapshotName() != null;
    }

    public boolean isRestoring(String snpName) {
        return snpName.equals(this.restoreCacheGrpProc.restoringSnapshotName());
    }

    public boolean isRestoring(CacheConfiguration<?, ?> ccfg) {
        return this.restoreCacheGrpProc.isRestoring(ccfg);
    }

    public IgniteFuture<Boolean> restoreStatus(String snpName) {
        return this.executeRestoreManagementTask(SnapshotRestoreStatusTask.class, snpName);
    }

    public Set<UUID> cacheStartRequiredAliveNodes(@Nullable IgniteUuid restoreId) {
        if (restoreId == null) {
            return Collections.emptySet();
        }
        return this.restoreCacheGrpProc.cacheStartRequiredAliveNodes(restoreId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> localSnapshotNames() {
        if (this.cctx.kernalContext().clientNode()) {
            throw new UnsupportedOperationException("Client and daemon nodes can not perform this operation.");
        }
        if (this.locSnpDir == null) {
            return Collections.emptyList();
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            return Arrays.stream(this.locSnpDir.listFiles(File::isDirectory)).map(File::getName).collect(Collectors.toList());
        }
    }

    @Override
    public IgniteFuture<Void> cancelSnapshot(String name) {
        A.notNullOrEmpty(name, "Snapshot name must be not empty or null");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        IgniteInternalFuture<Void> fut0 = this.cctx.kernalContext().closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new CancelSnapshotCallable(name), this.cctx.discovery().aliveServerNodes(), false, 0L, true);
        return new IgniteFutureImpl<Void>(fut0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLocalSnapshotTask(String name) {
        A.notNullOrEmpty(name, "Snapshot name must be not null or empty");
        ClusterSnapshotFuture fut0 = null;
        this.busyLock.enterBusy();
        try {
            for (AbstractSnapshotFutureTask sctx : this.locSnpTasks.values()) {
                if (!sctx.snapshotName().equals(name)) continue;
                sctx.cancel();
            }
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null) {
                    fut0 = this.clusterSnpFut;
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
        try {
            if (fut0 != null) {
                fut0.get();
            }
        }
        catch (IgniteCheckedException e) {
            if (e instanceof IgniteFutureCancelledCheckedException) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Expected cancelled exception: " + e.getMessage());
                }
            }
            throw new IgniteException(e);
        }
    }

    @Override
    public IgniteFuture<Boolean> cancelSnapshotRestore(String name) {
        return this.executeRestoreManagementTask(SnapshotRestoreCancelTask.class, name);
    }

    public IgniteFuture<Boolean> cancelLocalRestoreTask(String name) {
        return this.restoreCacheGrpProc.cancel(new IgniteCheckedException("Operation has been canceled by the user."), name);
    }

    public IgniteInternalFuture<IdleVerifyResultV2> checkSnapshot(String name, @Nullable String snpPath) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        return this.checkSnapshot(name, snpPath, null, false).chain(f -> {
            try {
                return ((SnapshotPartitionsVerifyTaskResult)f.get()).idleVerifyResult();
            }
            catch (Throwable t) {
                throw new GridClosureException(t);
            }
        });
    }

    public IgniteInternalFuture<SnapshotPartitionsVerifyTaskResult> checkSnapshot(String name, @Nullable String snpPath, @Nullable Collection<String> grps, boolean includeCustomHandlers) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        A.ensure(grps == null || grps.stream().filter(Objects::isNull).collect(Collectors.toSet()).isEmpty(), "Collection of cache groups names cannot contain null elements.");
        GridFutureAdapter<SnapshotPartitionsVerifyTaskResult> res = new GridFutureAdapter<SnapshotPartitionsVerifyTaskResult>();
        GridKernalContext kctx0 = this.cctx.kernalContext();
        Collection<ClusterNode> bltNodes = F.view(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), node -> CU.baselineNode(node, kctx0.state().clusterState()));
        kctx0.task().setThreadContext(GridTaskThreadContextKey.TC_SKIP_AUTH, true);
        kctx0.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, bltNodes);
        SnapshotMetadataCollectorTaskArg taskArg = new SnapshotMetadataCollectorTaskArg(name, snpPath);
        kctx0.task().execute(SnapshotMetadataCollectorTask.class, taskArg).listen(f0 -> {
            if (f0.error() == null) {
                Map metas = (Map)f0.result();
                Map grpIds = grps == null ? Collections.emptyMap() : grps.stream().collect(Collectors.toMap(GridCacheUtils::cacheId, v -> v));
                byte[] masterKeyDigest = kctx0.config().getEncryptionSpi().masterKeyDigest();
                for (List nodeMetas : metas.values()) {
                    for (SnapshotMetadata meta : nodeMetas) {
                        byte[] snpMasterKeyDigest = meta.masterKeyDigest();
                        if (masterKeyDigest == null && snpMasterKeyDigest != null) {
                            res.onDone(new SnapshotPartitionsVerifyTaskResult(metas, new IdleVerifyResultV2(Collections.singletonMap(this.cctx.localNode(), new IllegalArgumentException("Snapshot '" + meta.snapshotName() + "' has encrypted caches while encryption is disabled. To restore this snapshot, start Ignite with configured encryption and the same master key.")))));
                            return;
                        }
                        if (snpMasterKeyDigest != null && !Arrays.equals(snpMasterKeyDigest, masterKeyDigest)) {
                            res.onDone(new SnapshotPartitionsVerifyTaskResult(metas, new IdleVerifyResultV2(Collections.singletonMap(this.cctx.localNode(), new IllegalArgumentException("Snapshot '" + meta.snapshotName() + "' has different master key digest. To restore this snapshot, start Ignite with the same master key.")))));
                            return;
                        }
                        grpIds.keySet().removeAll(meta.partitions().keySet());
                    }
                }
                if (!grpIds.isEmpty()) {
                    res.onDone(new SnapshotPartitionsVerifyTaskResult(metas, new IdleVerifyResultV2(Collections.singletonMap(this.cctx.localNode(), new IllegalArgumentException("Cache group(s) was not found in the snapshot [groups=" + grpIds.values() + ", snapshot=" + name + ']')))));
                    return;
                }
                if (metas.isEmpty()) {
                    res.onDone(new SnapshotPartitionsVerifyTaskResult(metas, new IdleVerifyResultV2(Collections.singletonMap(this.cctx.localNode(), new IllegalArgumentException("Snapshot does not exists [snapshot=" + name + (snpPath != null ? ", baseDir=" + snpPath : "") + ']')))));
                    return;
                }
                kctx0.task().setThreadContext(GridTaskThreadContextKey.TC_SKIP_AUTH, true);
                kctx0.task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, new ArrayList(metas.keySet()));
                Class cls = includeCustomHandlers ? SnapshotHandlerRestoreTask.class : SnapshotPartitionsVerifyTask.class;
                kctx0.task().execute(cls, new SnapshotPartitionsVerifyTaskArg(grps, metas, snpPath)).listen(f1 -> {
                    if (f1.error() == null) {
                        res.onDone((SnapshotPartitionsVerifyTaskResult)f1.result());
                    } else if (f1.error() instanceof IgniteSnapshotVerifyException) {
                        res.onDone(new SnapshotPartitionsVerifyTaskResult(metas, new IdleVerifyResultV2(((IgniteSnapshotVerifyException)f1.error()).exceptions())));
                    } else {
                        res.onDone(f1.error());
                    }
                });
            } else if (f0.error() instanceof IgniteSnapshotVerifyException) {
                res.onDone(new SnapshotPartitionsVerifyTaskResult(null, new IdleVerifyResultV2(((IgniteSnapshotVerifyException)f0.error()).exceptions())));
            } else {
                res.onDone(f0.error());
            }
        });
        return res;
    }

    public List<File> snapshotCacheDirectories(String snpName, @Nullable String snpPath, String folderName, Predicate<String> names) {
        File snpDir = this.snapshotLocalDir(snpName, snpPath);
        if (!snpDir.exists()) {
            return Collections.emptyList();
        }
        return FilePageStoreManager.cacheDirectories(new File(snpDir, IgniteSnapshotManager.databaseRelativePath(folderName)), names);
    }

    public SnapshotMetadata readSnapshotMetadata(File snpDir, String consId) {
        return this.readSnapshotMetadata(new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(consId)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SnapshotMetadata readSnapshotMetadata(File smf) {
        if (!smf.exists()) {
            throw new IgniteException("Snapshot metafile cannot be read due to it doesn't exist: " + smf);
        }
        String smfName = smf.getName().substring(0, smf.getName().length() - SNAPSHOT_METAFILE_EXT.length());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(smf));){
            SnapshotMetadata meta = (SnapshotMetadata)this.marsh.unmarshal(in, U.resolveClassLoader(this.cctx.gridConfig()));
            if (!U.maskForFileName(meta.consistentId()).equals(smfName)) {
                throw new IgniteException("Error reading snapshot metadata [smfName=" + smfName + ", consId=" + U.maskForFileName(meta.consistentId()));
            }
            SnapshotMetadata snapshotMetadata = meta;
            return snapshotMetadata;
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException("An error occurred during reading snapshot metadata file [file=" + smf.getAbsolutePath() + "]", e);
        }
    }

    public List<SnapshotMetadata> readSnapshotMetadatas(String snpName, @Nullable String snpPath) {
        A.notNullOrEmpty(snpName, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(snpName), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        File snpDir = this.snapshotLocalDir(snpName, snpPath);
        if (!snpDir.exists() || !snpDir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<File> smfs = new ArrayList<File>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(snpDir.toPath());){
            for (Path d : ds) {
                if (!Files.isRegularFile(d, new LinkOption[0]) || !d.getFileName().toString().toLowerCase().endsWith(SNAPSHOT_METAFILE_EXT)) continue;
                smfs.add(d.toFile());
            }
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
        if (smfs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, SnapshotMetadata> metasMap = new HashMap<String, SnapshotMetadata>();
        SnapshotMetadata prev = null;
        for (File smf : smfs) {
            SnapshotMetadata curr = this.readSnapshotMetadata(smf);
            if (prev != null && !prev.sameSnapshot(curr)) {
                throw new IgniteException("Snapshot metadata files are from different snapshots [prev=" + prev + ", curr=" + curr);
            }
            metasMap.put(curr.consistentId(), curr);
            prev = curr;
        }
        SnapshotMetadata currNodeSmf = (SnapshotMetadata)metasMap.remove(this.cctx.localNode().consistentId().toString());
        if (currNodeSmf == null) {
            return new ArrayList<SnapshotMetadata>(metasMap.values());
        }
        ArrayList<SnapshotMetadata> result = new ArrayList<SnapshotMetadata>();
        result.add(currNodeSmf);
        result.addAll(metasMap.values());
        return result;
    }

    @Override
    public IgniteFuture<Void> createSnapshot(String name) {
        return this.createSnapshot(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFuture<Void> createSnapshot(String name, @Nullable String snpPath) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        try {
            ClusterSnapshotFuture snpFut0;
            this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
            if (!IgniteFeatures.allNodesSupports(this.cctx.discovery().aliveServerNodes(), IgniteFeatures.PERSISTENCE_CACHE_SNAPSHOT)) {
                throw new IgniteException("Not all nodes in the cluster support a snapshot operation.");
            }
            if (!CU.isPersistenceEnabled(this.cctx.gridConfig())) {
                throw new IgniteException("Create snapshot request has been rejected. Snapshots on an in-memory clusters are not allowed.");
            }
            if (!this.cctx.kernalContext().state().clusterState().state().active()) {
                throw new IgniteException("Snapshot operation has been rejected. The cluster is inactive.");
            }
            DiscoveryDataClusterState clusterState = this.cctx.kernalContext().state().clusterState();
            if (!clusterState.hasBaselineTopology()) {
                throw new IgniteException("Snapshot operation has been rejected. The baseline topology is not configured for cluster.");
            }
            if (this.cctx.kernalContext().clientNode()) {
                ClusterNode crd = U.oldest(this.cctx.kernalContext().discovery().aliveServerNodes(), null);
                if (crd == null) {
                    throw new IgniteException("There is no alive server nodes in the cluster");
                }
                return new IgniteSnapshotFutureImpl(this.cctx.kernalContext().closure().callAsyncNoFailover(GridClosureCallMode.BALANCE, new CreateSnapshotCallable(name), Collections.singletonList(crd), false, 0L, true));
            }
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null && !this.clusterSnpFut.isDone()) {
                    throw new IgniteException("Create snapshot request has been rejected. The previous snapshot operation was not completed.");
                }
                if (this.clusterSnpReq != null) {
                    throw new IgniteException("Create snapshot request has been rejected. Parallel snapshot processes are not allowed.");
                }
                if (this.localSnapshotNames().contains(name)) {
                    throw new IgniteException("Create snapshot request has been rejected. Snapshot with given name already exists on local node.");
                }
                if (this.isRestoring()) {
                    throw new IgniteException("Snapshot operation has been rejected. Cache group restore operation is currently in progress.");
                }
                this.clusterSnpFut = snpFut0 = new ClusterSnapshotFuture(UUID.randomUUID(), name);
                this.lastSeenSnpFut = snpFut0;
            }
            List<String> grps = this.cctx.cache().persistentGroups().stream().filter(g -> this.cctx.cache().cacheType(g.cacheOrGroupName()) == CacheType.USER).map(CacheGroupDescriptor::cacheOrGroupName).collect(Collectors.toList());
            grps.add("MetaStorage");
            List<ClusterNode> srvNodes = this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE);
            snpFut0.listen(f -> {
                if (f.error() == null) {
                    this.recordSnapshotEvent(name, SNAPSHOT_FINISHED_MSG + grps, 150);
                } else {
                    this.recordSnapshotEvent(name, SNAPSHOT_FAILED_MSG + f.error().getMessage(), 151);
                }
            });
            HashSet<UUID> bltNodeIds = new HashSet<UUID>(F.viewReadOnly(srvNodes, F.node2id(), node -> CU.baselineNode(node, clusterState)));
            this.startSnpProc.start(snpFut0.rqId, new SnapshotOperationRequest(snpFut0.rqId, this.cctx.localNodeId(), name, snpPath, grps, bltNodeIds));
            String msg = "Cluster-wide snapshot operation started [snpName=" + name + ", grps=" + grps + ']';
            this.recordSnapshotEvent(name, msg, 149);
            if (this.log.isInfoEnabled()) {
                this.log.info(msg);
            }
            return new IgniteFutureImpl<Void>(snpFut0);
        }
        catch (Exception e) {
            this.recordSnapshotEvent(name, SNAPSHOT_FAILED_MSG + e.getMessage(), 151);
            U.error(this.log, SNAPSHOT_FAILED_MSG, e);
            this.lastSeenSnpFut = new ClusterSnapshotFuture(name, e);
            return new IgniteFinishedFutureImpl<Void>(e);
        }
    }

    @Override
    public IgniteFuture<Void> restoreSnapshot(String name, @Nullable Collection<String> grpNames) {
        return this.restoreSnapshot(name, null, grpNames);
    }

    public IgniteFuture<Void> restoreSnapshot(String name, @Nullable String snpPath, @Nullable Collection<String> grpNames) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        A.ensure(grpNames == null || !grpNames.isEmpty(), "List of cache group names cannot be empty.");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        return this.restoreCacheGrpProc.start(name, snpPath, grpNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metaStorage) throws IgniteCheckedException {
        Object object = this.snpOpMux;
        synchronized (object) {
            this.metaStorage = metaStorage;
            if (this.recovered) {
                this.removeLastMetaStorageKey();
            }
            this.recovered = false;
        }
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metaStorage) throws IgniteCheckedException {
        File snpDir;
        String snpDirName;
        this.restoreCacheGrpProc.cleanup();
        String snpName = (String)((Object)metaStorage.read(SNP_RUNNING_KEY));
        String string = snpDirName = snpName == null ? (String)((Object)metaStorage.read(SNP_RUNNING_DIR_KEY)) : null;
        File file = snpName != null ? this.snapshotLocalDir(snpName, null) : (snpDir = snpDirName != null ? new File(snpDirName) : null);
        if (snpDir == null) {
            return;
        }
        this.recovered = true;
        for (File tmp : this.snapshotTmpDir().listFiles()) {
            U.delete(tmp);
        }
        this.deleteSnapshot(snpDir, this.pdsSettings.folderName());
        if (this.log.isInfoEnabled()) {
            this.log.info("Previous attempt to create snapshot fail due to the local node crash. All resources related to snapshot operation have been deleted: " + snpDir.getName());
        }
    }

    public static boolean isSnapshotOperation(DiscoveryEvent evt) {
        return !evt.eventNode().isClient() && evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof SnapshotStartDiscoveryMessage;
    }

    @Override
    public void onDoneBeforeTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (this.clusterSnpReq == null || this.cctx.kernalContext().clientNode()) {
            return;
        }
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        AbstractSnapshotFutureTask task = (AbstractSnapshotFutureTask)this.locSnpTasks.get(snpReq.snapshotName());
        if (task == null) {
            return;
        }
        if (task.start()) {
            this.cctx.database().forceNewCheckpoint(String.format("Start snapshot operation: %s", snpReq.snapshotName()), lsnr -> {});
            try {
                long start = U.currentTimeMillis();
                ((SnapshotFutureTask)task).started().get();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Finished waiting for a synchronized checkpoint under topology lock [snpName=" + task.snapshotName() + ", time=" + (U.currentTimeMillis() - start) + "ms]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Fail to wait while cluster-wide snapshot operation started", e);
            }
        }
    }

    public IgniteInternalFuture<Void> requestRemoteSnapshotFiles(UUID rmtNodeId, String snpName, @Nullable String rmtSnpPath, Map<Integer, Set<Integer>> parts, BooleanSupplier stopChecker, BiConsumer<@Nullable File, @Nullable Throwable> partHnd) throws IgniteCheckedException {
        assert (U.alphanumericUnderscore(snpName)) : snpName;
        assert (partHnd != null);
        ClusterNode rmtNode = this.cctx.discovery().node(rmtNodeId);
        if (rmtNode == null) {
            throw new ClusterTopologyCheckedException("Snapshot remote request cannot be performed. Remote node left the grid [rmtNodeId=" + rmtNodeId + ']');
        }
        if (!IgniteFeatures.nodeSupports(rmtNode, IgniteFeatures.PERSISTENCE_CACHE_SNAPSHOT)) {
            throw new IgniteCheckedException("Snapshot on remote node is not supported: " + rmtNode.id());
        }
        RemoteSnapshotFilesRecevier fut = new RemoteSnapshotFilesRecevier(this, rmtNodeId, snpName, rmtSnpPath, parts, stopChecker, partHnd);
        this.snpRmtMgr.submit(fut);
        return fut;
    }

    public void onCacheGroupsStopped(List<Integer> grps) {
        for (AbstractSnapshotFutureTask sctx : F.view(this.locSnpTasks.values(), t -> t instanceof SnapshotFutureTask)) {
            HashSet<Integer> retain = new HashSet<Integer>(grps);
            retain.retainAll(((SnapshotFutureTask)sctx).affectedCacheGroups());
            if (retain.isEmpty()) continue;
            sctx.acceptException(new IgniteCheckedException("Snapshot has been interrupted due to some of the required cache groups stopped: " + retain));
        }
    }

    private static String snapshotMetaFileName(String consId) {
        return U.maskForFileName(consId) + SNAPSHOT_METAFILE_EXT;
    }

    public StandaloneGridKernalContext createStandaloneKernalContext(File snpDir, String folderName) throws IgniteCheckedException {
        return new StandaloneGridKernalContext(this.log, CacheObjectBinaryProcessorImpl.resolveBinaryWorkDir(snpDir.getAbsolutePath(), folderName), MarshallerContextImpl.resolveMappingFileStoreWorkDir(snpDir.getAbsolutePath()));
    }

    public GridCloseableIterator<CacheDataRow> partitionRowIterator(GridKernalContext ctx, String grpName, int partId, FilePageStore pageStore) throws IgniteCheckedException {
        CacheObjectContext coctx = new CacheObjectContext(ctx, grpName, null, false, false, false, false, false);
        GridCacheSharedContext sctx = new GridCacheSharedContext(ctx, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return new DataPageIterator(sctx, coctx, pageStore, partId);
    }

    public GridCloseableIterator<CacheDataRow> partitionRowIterator(String snpName, String folderName, String grpName, int partId, @Nullable EncryptionCacheKeyProvider encrKeyProvider) throws IgniteCheckedException {
        File snpDir = this.resolveSnapshotDir(snpName, null);
        File nodePath = new File(snpDir, IgniteSnapshotManager.databaseRelativePath(folderName));
        if (!nodePath.exists()) {
            throw new IgniteCheckedException("Consistent id directory doesn't exists: " + nodePath.getAbsolutePath());
        }
        List<File> grps = FilePageStoreManager.cacheDirectories(nodePath, name -> name.equals(grpName));
        if (F.isEmpty(grps)) {
            throw new IgniteCheckedException("The snapshot cache group not found [dir=" + snpDir.getAbsolutePath() + ", grpName=" + grpName + ']');
        }
        if (grps.size() > 1) {
            throw new IgniteCheckedException("The snapshot cache group directory cannot be uniquely identified [dir=" + snpDir.getAbsolutePath() + ", grpName=" + grpName + ']');
        }
        File snpPart = FilePageStoreManager.getPartitionFile(new File(this.snapshotLocalDir(snpName, null), IgniteSnapshotManager.databaseRelativePath(folderName)), grps.get(0).getName(), partId);
        int grpId = CU.cacheId(grpName);
        final FilePageStore pageStore = (FilePageStore)this.storeMgr.getPageStoreFactory(grpId, encrKeyProvider == null || encrKeyProvider.getActiveKey(grpId) == null ? null : encrKeyProvider).createPageStore(GroupPartitionId.getTypeByPartId(partId), snpPart::toPath, val -> {});
        final GridCloseableIterator<CacheDataRow> partIter = this.partitionRowIterator(this.cctx.kernalContext(), grpName, partId, pageStore);
        return new GridCloseableIteratorAdapter<CacheDataRow>(){

            @Override
            protected CacheDataRow onNext() throws IgniteCheckedException {
                return (CacheDataRow)partIter.nextX();
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                return partIter.hasNextX();
            }

            @Override
            protected void onClose() {
                U.closeQuiet(pageStore);
            }
        };
    }

    AbstractSnapshotFutureTask<?> registerSnapshotTask(String snpName, UUID srcNodeId, Map<Integer, Set<Integer>> parts, boolean withMetaStorage, SnapshotSender snpSndr) {
        AbstractSnapshotFutureTask<?> task = this.registerTask(snpName, new SnapshotFutureTask(this.cctx, srcNodeId, snpName, this.tmpWorkDir, this.ioFactory, snpSndr, parts, withMetaStorage, this.locBuff));
        if (!withMetaStorage) {
            for (Integer grpId : parts.keySet()) {
                if (!this.cctx.cache().isEncrypted(grpId)) continue;
                task.onDone(new IgniteCheckedException("Snapshot contains encrypted cache group " + grpId + " but doesn't include metastore. Metastore is required because it holds encryption keys required to start with encrypted caches contained in the snapshot."));
                return task;
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSnapshotFutureTask<?> registerTask(String rqId, AbstractSnapshotFutureTask<?> task) {
        if (!this.busyLock.enterBusy()) {
            return new SnapshotFinishedFutureTask(new IgniteCheckedException("Snapshot manager is stopping [locNodeId=" + this.cctx.localNodeId() + ']'));
        }
        try {
            if (this.locSnpTasks.containsKey(rqId)) {
                SnapshotFinishedFutureTask snapshotFinishedFutureTask = new SnapshotFinishedFutureTask(new IgniteCheckedException("Snapshot with requested name is already scheduled: " + rqId));
                return snapshotFinishedFutureTask;
            }
            AbstractSnapshotFutureTask<?> prev = this.locSnpTasks.putIfAbsent(rqId, task);
            if (prev != null) {
                SnapshotFinishedFutureTask snapshotFinishedFutureTask = new SnapshotFinishedFutureTask(new IgniteCheckedException("Snapshot with requested name is already scheduled: " + rqId));
                return snapshotFinishedFutureTask;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Snapshot task has been registered on local node [sctx=" + this + ", task=" + task.getClass().getSimpleName() + ", topVer=" + this.cctx.discovery().topologyVersionEx() + ']');
            }
            task.listen(f -> {
                AbstractSnapshotFutureTask cfr_ignored_0 = (AbstractSnapshotFutureTask)this.locSnpTasks.remove(rqId);
            });
            AbstractSnapshotFutureTask<?> abstractSnapshotFutureTask = task;
            return abstractSnapshotFutureTask;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private SnapshotFutureTask currentSnapshotTask() {
        SnapshotOperationRequest req = this.clusterSnpReq;
        if (req == null) {
            return null;
        }
        AbstractSnapshotFutureTask task = (AbstractSnapshotFutureTask)this.locSnpTasks.get(req.snapshotName());
        if (!(task instanceof SnapshotFutureTask)) {
            return null;
        }
        return (SnapshotFutureTask)task;
    }

    void localSnapshotSenderFactory(BiFunction<String, String, SnapshotSender> factory) {
        this.locSndrFactory = factory;
    }

    BiFunction<String, String, SnapshotSender> localSnapshotSenderFactory() {
        return this.locSndrFactory;
    }

    void remoteSnapshotSenderFactory(BiFunction<String, UUID, SnapshotSender> factory) {
        this.rmtSndrFactory = factory;
    }

    RemoteSnapshotSender remoteSnapshotSenderFactory(String rqId, UUID nodeId) {
        return new RemoteSnapshotSender(this.log, this.cctx.kernalContext().pools().getSnapshotExecutorService(), this.cctx.gridIO().openTransmissionSender(nodeId, DFLT_INITIAL_SNAPSHOT_TOPIC), rqId);
    }

    private void removeLastMetaStorageKey() throws IgniteCheckedException {
        this.cctx.database().checkpointReadLock();
        try {
            this.metaStorage.remove(SNP_RUNNING_DIR_KEY);
            this.metaStorage.remove(SNP_RUNNING_KEY);
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    void recordSnapshotEvent(final String snpName, final String msg, final int type) {
        if (!this.cctx.gridEvents().isRecordable(type) || !this.cctx.gridEvents().hasListener(type)) {
            return;
        }
        this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

            @Override
            public void run() {
                IgniteSnapshotManager.this.cctx.gridEvents().record(new SnapshotEvent(IgniteSnapshotManager.this.cctx.localNode(), msg, snpName, type));
            }
        });
    }

    ExecutorService snapshotExecutorService() {
        return this.cctx.kernalContext().pools().getSnapshotExecutorService();
    }

    public void ioFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    public FileIOFactory ioFactory() {
        return this.ioFactory;
    }

    AbstractSnapshotFutureTask<?> lastScheduledSnapshotResponseRemoteTask(UUID nodeId) {
        return this.locSnpTasks.values().stream().filter(t -> t instanceof SnapshotResponseRemoteFutureTask).filter(t -> t.sourceNodeId().equals(nodeId)).findFirst().orElse(null);
    }

    static String databaseRelativePath(String folderName) {
        return Paths.get("db", folderName).toString();
    }

    public static File resolveSnapshotWorkDirectory(IgniteConfiguration cfg) {
        try {
            return U.resolveWorkDirectory(cfg.getWorkDirectory() == null ? U.defaultWorkDirectory() : cfg.getWorkDirectory(), cfg.getSnapshotPath(), false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    static void copy(FileIOFactory factory, File from, File to, long length) {
        IgniteSnapshotManager.copy(factory, from, to, length, null);
    }

    static void copy(FileIOFactory factory, File from, File to, long length, @Nullable BasicRateLimiter rateLimiter) {
        try (FileIO src = factory.create(from, StandardOpenOption.READ);
             FileChannel dest = new FileOutputStream(to).getChannel();){
            if (src.size() < length) {
                throw new IgniteException("The source file to copy is not long enough [expected=" + length + ", actual=" + src.size() + ']');
            }
            boolean unlimited = rateLimiter == null || rateLimiter.isUnlimited();
            long written = 0L;
            while (written < length) {
                if (unlimited) {
                    written += src.transferTo(written, length - written, dest);
                    continue;
                }
                long blockLen = Math.min(length - written, 65536L);
                rateLimiter.acquire(blockLen);
                long blockWritten = 0L;
                while ((blockWritten += src.transferTo(written + blockWritten, blockLen - blockWritten, dest)) < blockLen) {
                }
                written += blockWritten;
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteInterruptedException((InterruptedException)e.getCause());
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private IgniteFuture<Boolean> executeRestoreManagementTask(Class<? extends ComputeTask<String, Boolean>> taskCls, String snpName) {
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        Collection<ClusterNode> bltNodes = F.view(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), node -> CU.baselineNode(node, this.cctx.kernalContext().state().clusterState()));
        this.cctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SKIP_AUTH, true);
        this.cctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, bltNodes);
        return new IgniteFutureImpl<Boolean>(this.cctx.kernalContext().task().execute(taskCls, snpName));
    }

    private SnapshotView snapshotViewSupplier(SnapshotMetadata meta) {
        List<File> dirs = this.snapshotCacheDirectories(meta.snapshotName(), null, meta.folderName(), name -> true);
        Collection<String> cacheGrps = F.viewReadOnly(dirs, FilePageStoreManager::cacheGroupName, new IgnitePredicate[0]);
        return new SnapshotView(meta.snapshotName(), meta.consistentId(), F.concat(meta.baselineNodes(), ","), F.concat(cacheGrps, ","));
    }

    protected SnapshotHandlers handlers() {
        return this.handlers;
    }

    private static class IgniteSnapshotFutureImpl
    extends IgniteFutureImpl<Void> {
        public IgniteSnapshotFutureImpl(IgniteInternalFuture<Void> fut) {
            super(fut);
        }

        @Override
        protected IgniteException convertException(IgniteCheckedException e) {
            if (e instanceof IgniteClientDisconnectedCheckedException) {
                return new IgniteException("Client disconnected. Snapshot result is unknown", U.convertException(e));
            }
            return new IgniteException("Snapshot has not been created", U.convertException(e));
        }
    }

    @GridInternal
    private static class CancelSnapshotCallable
    implements IgniteCallable<Void> {
        private static final long serialVersionUID = 0L;
        private final String snpName;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public CancelSnapshotCallable(String snpName) {
            this.snpName = snpName;
        }

        @Override
        public Void call() throws Exception {
            this.ignite.context().cache().context().snapshotMgr().cancelLocalSnapshotTask(this.snpName);
            return null;
        }
    }

    @GridInternal
    private static class CreateSnapshotCallable
    implements IgniteCallable<Void> {
        private static final long serialVersionUID = 0L;
        private final String snpName;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public CreateSnapshotCallable(String snpName) {
            this.snpName = snpName;
        }

        @Override
        public Void call() throws Exception {
            this.ignite.snapshot().createSnapshot(this.snpName).get();
            return null;
        }
    }

    protected static class ClusterSnapshotFuture
    extends GridFutureAdapter<Void> {
        final UUID rqId;
        final String name;
        final long startTime;
        volatile long endTime;
        volatile IgniteCheckedException interruptEx;

        public ClusterSnapshotFuture() {
            this.onDone();
            this.rqId = null;
            this.name = "";
            this.startTime = 0L;
            this.endTime = 0L;
        }

        public ClusterSnapshotFuture(String name, Exception err) {
            this.onDone(err);
            this.name = name;
            this.startTime = U.currentTimeMillis();
            this.endTime = 0L;
            this.rqId = null;
        }

        public ClusterSnapshotFuture(UUID rqId, String name) {
            this.rqId = rqId;
            this.name = name;
            this.startTime = U.currentTimeMillis();
        }

        @Override
        protected boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
            this.endTime = U.currentTimeMillis();
            return super.onDone(res, err, cancel);
        }
    }

    private static class SnapshotStartDiscoveryMessage
    extends InitMessage<SnapshotOperationRequest>
    implements SnapshotDiscoveryMessage {
        private static final long serialVersionUID = 0L;

        public SnapshotStartDiscoveryMessage(UUID processId, SnapshotOperationRequest req) {
            super(processId, DistributedProcess.DistributedProcessType.START_SNAPSHOT, req);
        }

        @Override
        public boolean needExchange() {
            return true;
        }

        @Override
        public boolean needAssignPartitions() {
            return false;
        }

        @Override
        public String toString() {
            return S.toString(SnapshotStartDiscoveryMessage.class, this, super.toString());
        }
    }

    private static class SnapshotOperationResponse
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Map<String, SnapshotHandlerResult<Object>> hndResults;

        public SnapshotOperationResponse() {
            this(null);
        }

        public SnapshotOperationResponse(Map<String, SnapshotHandlerResult<Object>> hndResults) {
            this.hndResults = hndResults;
        }

        @Nullable
        public Map<String, SnapshotHandlerResult<Object>> handlerResults() {
            return this.hndResults;
        }
    }

    private class LocalSnapshotSender
    extends SnapshotSender {
        private final File snpLocDir;
        private File dbDir;
        private final int pageSize;

        public LocalSnapshotSender(@Nullable String snpName, String snpPath) {
            super(IgniteSnapshotManager.this.log, IgniteSnapshotManager.this.cctx.kernalContext().pools().getSnapshotExecutorService());
            this.snpLocDir = IgniteSnapshotManager.this.snapshotLocalDir(snpName, snpPath);
            this.pageSize = IgniteSnapshotManager.this.cctx.kernalContext().config().getDataStorageConfiguration().getPageSize();
        }

        @Override
        protected void init(int partsCnt) {
            this.dbDir = new File(this.snpLocDir, IgniteSnapshotManager.databaseRelativePath(IgniteSnapshotManager.this.pdsSettings.folderName()));
            if (this.dbDir.exists()) {
                throw new IgniteException("Snapshot with given name already exists [snpName=" + this.snpLocDir.getName() + ", absPath=" + this.dbDir.getAbsolutePath() + ']');
            }
            IgniteSnapshotManager.this.cctx.database().checkpointReadLock();
            try {
                assert (IgniteSnapshotManager.this.metaStorage != null && IgniteSnapshotManager.this.metaStorage.read(IgniteSnapshotManager.SNP_RUNNING_DIR_KEY) == null) : "The previous snapshot hasn't been completed correctly";
                IgniteSnapshotManager.this.metaStorage.write(IgniteSnapshotManager.SNP_RUNNING_DIR_KEY, (Serializable)((Object)this.snpLocDir.getAbsolutePath()));
                U.ensureDirectory(this.dbDir, "snapshot work directory for a local snapshot sender", this.log);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                IgniteSnapshotManager.this.cctx.database().checkpointReadUnlock();
            }
        }

        @Override
        public void sendCacheConfig0(File ccfg, String cacheDirName) {
            assert (this.dbDir != null);
            try {
                File cacheDir = U.resolveWorkDirectory(this.dbDir.getAbsolutePath(), cacheDirName, false);
                File targetCacheCfg = new File(cacheDir, ccfg.getName());
                IgniteSnapshotManager.copy(IgniteSnapshotManager.this.ioFactory, ccfg, targetCacheCfg, ccfg.length(), IgniteSnapshotManager.this.transferRateLimiter);
                StoredCacheData cacheData = IgniteSnapshotManager.this.locCfgMgr.readCacheData(targetCacheCfg);
                if (cacheData.config().isEncryptionEnabled()) {
                    EncryptionSpi encSpi = IgniteSnapshotManager.this.cctx.kernalContext().config().getEncryptionSpi();
                    GroupKey gKey = IgniteSnapshotManager.this.cctx.kernalContext().encryption().getActiveKey(CU.cacheGroupId(cacheData.config()));
                    cacheData.groupKeyEncrypted(new GroupKeyEncrypted(gKey.id(), encSpi.encryptKey(gKey.key())));
                    IgniteSnapshotManager.this.locCfgMgr.writeCacheData(cacheData, targetCacheCfg);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendMarshallerMeta0(List<Map<Integer, MappedName>> mappings) {
            if (mappings == null) {
                return;
            }
            try {
                MarshallerContextImpl.saveMappings(IgniteSnapshotManager.this.cctx.kernalContext(), mappings, this.snpLocDir);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendBinaryMeta0(Collection<BinaryType> types) {
            if (types == null) {
                return;
            }
            IgniteSnapshotManager.this.cctx.kernalContext().cacheObjects().saveMetadata(types, this.snpLocDir);
        }

        @Override
        public void sendPart0(File part, String cacheDirName, GroupPartitionId pair, Long len) {
            try {
                if (len == 0L) {
                    return;
                }
                File cacheDir = U.resolveWorkDirectory(this.dbDir.getAbsolutePath(), cacheDirName, false);
                File snpPart = new File(cacheDir, part.getName());
                if (!snpPart.exists() || snpPart.delete()) {
                    snpPart.createNewFile();
                }
                IgniteSnapshotManager.copy(IgniteSnapshotManager.this.ioFactory, part, snpPart, len, IgniteSnapshotManager.this.transferRateLimiter);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition has been snapshot [snapshotDir=" + this.dbDir.getAbsolutePath() + ", cacheDirName=" + cacheDirName + ", part=" + part.getName() + ", length=" + part.length() + ", snapshot=" + snpPart.getName() + ']');
                }
            }
            catch (IOException | IgniteCheckedException ex) {
                throw new IgniteException(ex);
            }
        }

        @Override
        public void sendDelta0(File delta, String cacheDirName, GroupPartitionId pair) {
            boolean encrypted;
            File snpPart = FilePageStoreManager.getPartitionFile(this.dbDir, cacheDirName, pair.getPartitionId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Start partition snapshot recovery with the given delta page file [part=" + snpPart + ", delta=" + delta + ']');
            }
            FileIOFactory ioFactory = (encrypted = IgniteSnapshotManager.this.cctx.cache().isEncrypted(pair.getGroupId())) ? ((FilePageStoreManager)IgniteSnapshotManager.this.cctx.pageStore()).encryptedFileIoFactory(IgniteSnapshotManager.this.ioFactory, pair.getGroupId()) : IgniteSnapshotManager.this.ioFactory;
            try (FileIO fileIo = ioFactory.create(delta, StandardOpenOption.READ);
                 FilePageStore pageStore = (FilePageStore)IgniteSnapshotManager.this.storeMgr.getPageStoreFactory(pair.getGroupId(), encrypted).createPageStore(GroupPartitionId.getTypeByPartId(pair.getPartitionId()), snpPart::toPath, v -> {});){
                ByteBuffer pageBuf = ByteBuffer.allocate(this.pageSize).order(ByteOrder.nativeOrder());
                long totalBytes = fileIo.size();
                assert (totalBytes % (long)this.pageSize == 0L) : "Given file with delta pages has incorrect size: " + fileIo.size();
                pageStore.beginRecover();
                for (long pos = 0L; pos < totalBytes; pos += (long)this.pageSize) {
                    long read = fileIo.readFully(pageBuf, pos);
                    assert (read == (long)pageBuf.capacity());
                    pageBuf.flip();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Read page given delta file [path=" + delta.getName() + ", pageId=" + PageIO.getPageId(pageBuf) + ", pos=" + pos + ", pages=" + totalBytes / (long)this.pageSize + ", crcBuff=" + FastCrc.calcCrc(pageBuf, pageBuf.limit()) + ", crcPage=" + PageIO.getCrc(pageBuf) + ']');
                        pageBuf.rewind();
                    }
                    IgniteSnapshotManager.this.transferRateLimiter.acquire(this.pageSize);
                    pageStore.write(PageIO.getPageId(pageBuf), pageBuf, 0, false);
                    pageBuf.flip();
                }
                pageStore.finishRecover();
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        protected void close0(@Nullable Throwable th) {
            if (th == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("The Local snapshot sender closed. All resources released [dbNodeSnpDir=" + this.dbDir + ']');
                }
            } else {
                IgniteSnapshotManager.this.deleteSnapshot(this.snpLocDir, IgniteSnapshotManager.this.pdsSettings.folderName());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Local snapshot sender closed due to an error occurred: " + th.getMessage());
                }
            }
        }
    }

    private static class RemoteSnapshotSender
    extends SnapshotSender {
        private final GridIoManager.TransmissionSender sndr;
        private final String rqId;
        private int partsCnt;

        public RemoteSnapshotSender(IgniteLogger log, Executor exec, GridIoManager.TransmissionSender sndr, String rqId) {
            super(log, exec);
            this.sndr = sndr;
            this.rqId = rqId;
        }

        @Override
        protected void init(int partsCnt) {
            this.partsCnt = partsCnt;
        }

        @Override
        public void sendPart0(File part, String cacheDirName, GroupPartitionId pair, Long len) {
            try {
                assert (part.exists());
                assert (len > 0L) : "Requested partitions has incorrect file length [pair=" + pair + ", cacheDirName=" + cacheDirName + ']';
                this.sndr.send(part, 0L, len, this.transmissionParams(this.rqId, cacheDirName, pair), TransmissionPolicy.FILE);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Partition file has been send [part=" + part.getName() + ", pair=" + pair + ", length=" + len + ']');
                }
            }
            catch (TransmissionCancelledException e) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Transmission partition file has been interrupted [part=" + part.getName() + ", pair=" + pair + ']');
                }
            }
            catch (IOException | InterruptedException | IgniteCheckedException e) {
                U.error(this.log, "Error sending partition file [part=" + part.getName() + ", pair=" + pair + ", length=" + len + ']', e);
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendDelta0(File delta, String cacheDirName, GroupPartitionId pair) {
            throw new UnsupportedOperationException("Sending files by chunks of data is not supported: " + delta.getAbsolutePath());
        }

        private Map<String, Serializable> transmissionParams(String rqId, String cacheDirName, GroupPartitionId pair) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(IgniteSnapshotManager.SNP_GRP_ID_PARAM, Integer.valueOf(pair.getGroupId()));
            params.put(IgniteSnapshotManager.SNP_PART_ID_PARAM, Integer.valueOf(pair.getPartitionId()));
            params.put(IgniteSnapshotManager.SNP_CACHE_DIR_NAME_PARAM, (Serializable)((Object)cacheDirName));
            params.put(IgniteSnapshotManager.RQ_ID_NAME_PARAM, (Serializable)((Object)rqId));
            params.put(IgniteSnapshotManager.SNP_PARTITIONS_CNT, Integer.valueOf(this.partsCnt));
            return params;
        }

        @Override
        public void close0(@Nullable Throwable th) {
            U.closeQuiet(this.sndr);
            if (th == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("The remote snapshot sender closed normally [snpName=" + this.rqId + ']');
                }
            } else {
                U.warn(this.log, "The remote snapshot sender closed due to an error occurred while processing snapshot operation [snpName=" + this.rqId + ']', th);
            }
        }
    }

    private class SequentialRemoteSnapshotManager
    implements TransmissionHandler,
    GridMessageListener {
        private volatile RemoteSnapshotFilesRecevier active;
        private final Queue<RemoteSnapshotFilesRecevier> queue = new ConcurrentLinkedDeque<RemoteSnapshotFilesRecevier>();
        private boolean stopping;

        private SequentialRemoteSnapshotManager() {
        }

        public synchronized void submit(RemoteSnapshotFilesRecevier next) {
            assert (next != null);
            if (this.stopping) {
                next.acceptException(new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG));
                return;
            }
            RemoteSnapshotFilesRecevier curr = this.active;
            if (curr == null || curr.isDone()) {
                next.listen(f -> this.scheduleNext());
                this.active = next;
                next.init();
            } else {
                this.queue.offer(next);
            }
        }

        private synchronized void scheduleNext() {
            RemoteSnapshotFilesRecevier next = this.queue.poll();
            if (next == null) {
                return;
            }
            this.submit(next);
        }

        public synchronized void stop() {
            RemoteSnapshotFilesRecevier r;
            this.stopping = true;
            if (this.active != null) {
                this.active.acceptException(new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG));
            }
            while ((r = this.queue.poll()) != null) {
                r.acceptException(new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG));
            }
            Set<RemoteSnapshotFilesRecevier> futs = this.activeTasks();
            GridCompoundFuture stopFut = new GridCompoundFuture();
            try {
                for (IgniteInternalFuture igniteInternalFuture : futs) {
                    stopFut.add(igniteInternalFuture);
                }
                stopFut.markInitialized().get();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        public void onNodeLeft(UUID nodeId) {
            Set<RemoteSnapshotFilesRecevier> futs = this.activeTasks();
            ClusterTopologyCheckedException ex = new ClusterTopologyCheckedException("The node from which a snapshot has been requested left the grid");
            futs.forEach(t -> {
                if (((RemoteSnapshotFilesRecevier)t).rmtNodeId.equals(nodeId)) {
                    t.acceptException(ex);
                }
            });
        }

        private Set<RemoteSnapshotFilesRecevier> activeTasks() {
            HashSet<RemoteSnapshotFilesRecevier> futs = new HashSet<RemoteSnapshotFilesRecevier>(this.queue);
            RemoteSnapshotFilesRecevier active0 = this.active;
            if (active0 != null) {
                futs.add(active0);
            }
            return futs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            block18: {
                if (!IgniteSnapshotManager.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof SnapshotFilesRequestMessage) {
                        SnapshotFilesRequestMessage reqMsg0 = (SnapshotFilesRequestMessage)msg;
                        String rqId = reqMsg0.requestId();
                        String snpName = reqMsg0.snapshotName();
                        try {
                            SequentialRemoteSnapshotManager sequentialRemoteSnapshotManager = this;
                            synchronized (sequentialRemoteSnapshotManager) {
                                AbstractSnapshotFutureTask<?> task = IgniteSnapshotManager.this.lastScheduledSnapshotResponseRemoteTask(nodeId);
                                if (task != null) {
                                    task.cancel();
                                    IgniteSnapshotManager.this.log.info("Snapshot request has been cancelled due to another request received [prevSnpResp=" + task + ", msg0=" + reqMsg0 + ']');
                                }
                            }
                            AbstractSnapshotFutureTask task = IgniteSnapshotManager.this.registerTask(rqId, new SnapshotResponseRemoteFutureTask(IgniteSnapshotManager.this.cctx, nodeId, snpName, reqMsg0.snapshotPath(), IgniteSnapshotManager.this.tmpWorkDir, IgniteSnapshotManager.this.ioFactory, (SnapshotSender)IgniteSnapshotManager.this.rmtSndrFactory.apply(rqId, nodeId), reqMsg0.parts()));
                            task.listen(f -> {
                                if (f.error() == null) {
                                    return;
                                }
                                U.error(IgniteSnapshotManager.this.log, "Failed to process request of creating a snapshot [from=" + nodeId + ", msg=" + reqMsg0 + ']', f.error());
                                try {
                                    IgniteSnapshotManager.this.cctx.gridIO().sendToCustomTopic(nodeId, DFLT_INITIAL_SNAPSHOT_TOPIC, (Message)new SnapshotFilesFailureMessage(reqMsg0.requestId(), f.error().getMessage()), (byte)2);
                                }
                                catch (IgniteCheckedException ex0) {
                                    U.error(IgniteSnapshotManager.this.log, "Fail to send the response message with processing snapshot request error [request=" + reqMsg0 + ", nodeId=" + nodeId + ']', ex0);
                                }
                            });
                            task.start();
                        }
                        catch (Throwable t) {
                            U.error(IgniteSnapshotManager.this.log, "Error processing snapshot file request message error [request=" + reqMsg0 + ", nodeId=" + nodeId + ']', t);
                            IgniteSnapshotManager.this.cctx.gridIO().sendToCustomTopic(nodeId, DFLT_INITIAL_SNAPSHOT_TOPIC, (Message)new SnapshotFilesFailureMessage(reqMsg0.requestId(), t.getMessage()), (byte)2);
                        }
                        break block18;
                    }
                    if (msg instanceof SnapshotFilesFailureMessage) {
                        SnapshotFilesFailureMessage respMsg0 = (SnapshotFilesFailureMessage)msg;
                        RemoteSnapshotFilesRecevier task = this.active;
                        if (task == null || !task.reqId.equals(respMsg0.requestId())) {
                            if (IgniteSnapshotManager.this.log.isInfoEnabled()) {
                                IgniteSnapshotManager.this.log.info("A stale snapshot response message has been received. Will be ignored [fromNodeId=" + nodeId + ", response=" + respMsg0 + ']');
                            }
                            return;
                        }
                        if (respMsg0.errorMessage() != null) {
                            task.acceptException(new IgniteCheckedException("Request cancelled. The snapshot operation stopped on the remote node with an error: " + respMsg0.errorMessage()));
                        }
                    }
                }
                catch (Throwable e) {
                    U.error(IgniteSnapshotManager.this.log, "Processing snapshot request from remote node fails with an error", e);
                    IgniteSnapshotManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                }
                finally {
                    IgniteSnapshotManager.this.busyLock.leaveBusy();
                }
            }
        }

        @Override
        public void onEnd(UUID nodeId) {
            RemoteSnapshotFilesRecevier task = this.active;
            if (task == null) {
                return;
            }
            assert (task.partsLeft.get() == 0) : task;
            assert (task.rmtNodeId.equals(nodeId));
            if (IgniteSnapshotManager.this.log.isInfoEnabled()) {
                IgniteSnapshotManager.this.log.info("Requested snapshot from remote node has been fully received [rqId=" + task.reqId + ", task=" + task + ']');
            }
            task.onDone((Void)null);
        }

        @Override
        public void onException(UUID nodeId, Throwable ex) {
            RemoteSnapshotFilesRecevier task = this.active;
            if (task == null) {
                return;
            }
            assert (task.rmtNodeId.equals(nodeId));
            task.acceptException(ex);
        }

        @Override
        public String filePath(UUID nodeId, TransmissionMeta fileMeta) {
            Integer partId = (Integer)fileMeta.params().get(IgniteSnapshotManager.SNP_PART_ID_PARAM);
            String cacheDirName = (String)((Object)fileMeta.params().get(IgniteSnapshotManager.SNP_CACHE_DIR_NAME_PARAM));
            String rqId = (String)((Object)fileMeta.params().get(IgniteSnapshotManager.RQ_ID_NAME_PARAM));
            Integer partsCnt = (Integer)fileMeta.params().get(IgniteSnapshotManager.SNP_PARTITIONS_CNT);
            RemoteSnapshotFilesRecevier task = this.active;
            if (task == null || task.isDone() || !task.reqId.equals(rqId)) {
                throw new TransmissionCancelledException("Stale snapshot transmission will be ignored [rqId=" + rqId + ", meta=" + fileMeta + ", task=" + task + ']');
            }
            assert (task.reqId.equals(rqId) && task.rmtNodeId.equals(nodeId)) : "Another transmission in progress [task=" + task + ", nodeId=" + rqId + ']';
            IgniteSnapshotManager.this.busyLock.enterBusy();
            try {
                task.partsLeft.compareAndSet(-1, partsCnt);
                File cacheDir = FilePageStoreManager.cacheWorkDir(IgniteSnapshotManager.this.storeMgr.workDir(), cacheDirName);
                File tmpCacheDir = U.resolveWorkDirectory(IgniteSnapshotManager.this.storeMgr.workDir().getAbsolutePath(), SnapshotRestoreProcess.formatTmpDirName(cacheDir).getName(), false);
                String string = Paths.get(tmpCacheDir.getAbsolutePath(), FilePageStoreManager.getPartitionFileName(partId)).toString();
                return string;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                IgniteSnapshotManager.this.busyLock.leaveBusy();
            }
        }

        @Override
        public Consumer<ByteBuffer> chunkHandler(UUID nodeId, TransmissionMeta initMeta) {
            throw new UnsupportedOperationException("Loading file by chunks is not supported: " + nodeId);
        }

        @Override
        public Consumer<File> fileHandler(UUID nodeId, TransmissionMeta initMeta) {
            final Integer grpId = (Integer)initMeta.params().get(IgniteSnapshotManager.SNP_GRP_ID_PARAM);
            final Integer partId = (Integer)initMeta.params().get(IgniteSnapshotManager.SNP_PART_ID_PARAM);
            final String rqId = (String)((Object)initMeta.params().get(IgniteSnapshotManager.RQ_ID_NAME_PARAM));
            assert (grpId != null);
            assert (partId != null);
            assert (rqId != null);
            final RemoteSnapshotFilesRecevier task = this.active;
            if (task == null || task.isDone() || !task.reqId.equals(rqId)) {
                throw new TransmissionCancelledException("Stale snapshot transmission will be ignored [rqId=" + rqId + ", meta=" + initMeta + ", task=" + task + ']');
            }
            return new Consumer<File>(){

                @Override
                public void accept(File file) {
                    RemoteSnapshotFilesRecevier task0 = SequentialRemoteSnapshotManager.this.active;
                    if (task0 == null || !task0.equals(task) || task0.isDone()) {
                        throw new TransmissionCancelledException("Snapshot request is cancelled [rqId=" + rqId + ", grpId=" + grpId + ", partId=" + partId + ']');
                    }
                    if (!IgniteSnapshotManager.this.busyLock.enterBusy()) {
                        throw new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG);
                    }
                    try {
                        task0.acceptFile(file);
                    }
                    finally {
                        IgniteSnapshotManager.this.busyLock.leaveBusy();
                    }
                }
            };
        }
    }

    private static class RemoteSnapshotFilesRecevier
    extends GridFutureAdapter<Void> {
        private final String reqId = "snapshot_" + U.maskForFileName(UUID.randomUUID().toString());
        private final IgniteSnapshotManager snpMgr;
        private final SnapshotFilesRequestMessage initMsg;
        private final UUID rmtNodeId;
        private final BooleanSupplier stopChecker;
        private final BiConsumer<File, Throwable> partHnd;
        private final Path dir;
        private final AtomicInteger partsLeft = new AtomicInteger(-1);

        public RemoteSnapshotFilesRecevier(IgniteSnapshotManager snpMgr, UUID rmtNodeId, String snpName, @Nullable String rmtSnpPath, Map<Integer, Set<Integer>> parts, BooleanSupplier stopChecker, BiConsumer<@Nullable File, @Nullable Throwable> partHnd) {
            this.dir = Paths.get(snpMgr.tmpWorkDir.getAbsolutePath(), this.reqId);
            this.initMsg = new SnapshotFilesRequestMessage(this.reqId, snpName, rmtSnpPath, parts);
            this.snpMgr = snpMgr;
            this.rmtNodeId = rmtNodeId;
            this.stopChecker = stopChecker;
            this.partHnd = partHnd;
        }

        public synchronized void init() {
            if (this.isDone()) {
                return;
            }
            try {
                ClusterNode rmtNode = this.snpMgr.cctx.discovery().node(this.rmtNodeId);
                if (rmtNode == null) {
                    throw new ClusterTopologyCheckedException("Snapshot remote request cannot be performed. Remote node left the grid [rmtNodeId=" + this.rmtNodeId + ']');
                }
                this.snpMgr.cctx.gridIO().sendOrderedMessage(rmtNode, DFLT_INITIAL_SNAPSHOT_TOPIC, this.initMsg, (byte)2, Long.MAX_VALUE, true);
                if (this.snpMgr.log.isInfoEnabled()) {
                    this.snpMgr.log.info("Snapshot request is sent to the remote node [rmtNodeId=" + this.rmtNodeId + ", snpName=" + this.initMsg.snapshotName() + ", rqId=" + this.reqId + ']');
                }
            }
            catch (Throwable t) {
                this.onDone(t);
            }
        }

        public synchronized void acceptException(Throwable ex) {
            if (this.isDone()) {
                return;
            }
            try {
                this.partHnd.accept(null, ex);
            }
            catch (Throwable t) {
                ex.addSuppressed(t);
            }
            this.onDone(ex);
        }

        public synchronized void acceptFile(File part) {
            if (this.isDone()) {
                return;
            }
            if (this.stopChecker.getAsBoolean()) {
                throw new TransmissionCancelledException("Future cancelled prior to the all requested partitions processed.");
            }
            try {
                this.partHnd.accept(part, null);
            }
            catch (IgniteInterruptedException e) {
                throw new TransmissionCancelledException(e.getMessage());
            }
            this.partsLeft.decrementAndGet();
        }

        @Override
        protected synchronized boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
            U.delete(this.dir);
            return super.onDone(res, err, cancel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteSnapshotFilesRecevier future = (RemoteSnapshotFilesRecevier)o;
            return Objects.equals(this.reqId, future.reqId);
        }

        public int hashCode() {
            return this.reqId.hashCode();
        }

        @Override
        public String toString() {
            return S.toString(RemoteSnapshotFilesRecevier.class, this);
        }
    }

    private static class DataPageIterator
    extends GridCloseableIteratorAdapter<CacheDataRow> {
        private static final long serialVersionUID = 0L;
        @GridToStringExclude
        private final PageStore store;
        private final int partId;
        private final GridCacheSharedContext<?, ?> sctx;
        private final CacheObjectContext coctx;
        private final ByteBuffer locBuff;
        private final ByteBuffer fragmentBuff;
        private final int pages;
        private final BitSet tailPages;
        private final BitSet readPages;
        private final Deque<CacheDataRow> rows = new LinkedList<CacheDataRow>();
        private boolean secondScanComplete;
        private int currIdx;

        public DataPageIterator(GridCacheSharedContext<?, ?> sctx, CacheObjectContext coctx, PageStore store, int partId) throws IgniteCheckedException {
            this.store = store;
            this.partId = partId;
            this.coctx = coctx;
            this.sctx = sctx;
            store.ensure();
            this.pages = store.pages();
            this.tailPages = new BitSet(this.pages);
            this.readPages = new BitSet(this.pages);
            this.locBuff = ByteBuffer.allocateDirect(store.getPageSize()).order(ByteOrder.nativeOrder());
            this.fragmentBuff = ByteBuffer.allocateDirect(store.getPageSize()).order(ByteOrder.nativeOrder());
        }

        @Override
        protected CacheDataRow onNext() throws IgniteCheckedException {
            if (this.secondScanComplete && this.rows.isEmpty()) {
                throw new NoSuchElementException("[partId=" + this.partId + ", store=" + this.store + ", skipPages=" + this.readPages + ']');
            }
            return this.rows.poll();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected boolean onHasNext() throws IgniteCheckedException {
            if (this.secondScanComplete && this.rows.isEmpty()) {
                return false;
            }
            try {
                while (this.currIdx < 2 * this.pages && this.rows.isEmpty()) {
                    block13: {
                        block14: {
                            first = this.currIdx < this.pages;
                            pageIdx = this.currIdx % this.pages;
                            if (this.readPages.get(pageIdx) || !first && this.tailPages.get(pageIdx)) break block13;
                            if (this.readPageFromStore(PageIdUtils.pageId(this.partId, (byte)1, pageIdx), this.locBuff)) break block14;
                            DataPageIterator.setBit(this.readPages, pageIdx);
                            break block13;
                        }
                        pageAddr = GridUnsafe.bufferAddress(this.locBuff);
                        io = (DataPageIO)PageIO.getPageIO(1, PageIO.getVersion(pageAddr));
                        freeSpace = io.getFreeSpace(pageAddr);
                        rowsCnt = io.getDirectCount(pageAddr);
                        if (!first) ** GOTO lbl-1000
                        if (rowsCnt == 0) {
                            DataPageIterator.setBit(this.readPages, pageIdx);
                        } else if (freeSpace == 0 && rowsCnt == 1) {
                            payload = io.readPayload(pageAddr, 0, this.locBuff.capacity());
                            link = payload.nextLink();
                            if (link != 0L) {
                                DataPageIterator.setBit(this.tailPages, PageIdUtils.pageIndex(PageIdUtils.pageId(link)));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            DataPageIterator.setBit(this.readPages, pageIdx);
                            for (itemId = 0; itemId < rowsCnt; ++itemId) {
                                row = new DataRow();
                                row.partition(this.partId);
                                row.initFromPageBuffer(this.sctx, this.coctx, new IgniteThrowableFunction<Long, ByteBuffer>(){

                                    @Override
                                    public ByteBuffer apply(Long nextPageId) throws IgniteCheckedException {
                                        boolean success = this.readPageFromStore(nextPageId, fragmentBuff);
                                        assert (success) : "Only FLAG_DATA pages allowed: " + PageIdUtils.toDetailString(nextPageId);
                                        DataPageIterator.setBit(readPages, PageIdUtils.pageIndex(nextPageId));
                                        return fragmentBuff;
                                    }
                                }, this.locBuff, itemId, false, CacheDataRowAdapter.RowData.FULL, false);
                                this.rows.add(row);
                            }
                        }
                    }
                    ++this.currIdx;
                }
                if (this.currIdx == 2 * this.pages) {
                    this.secondScanComplete = true;
                    set = true;
                    for (j = 0; j < this.pages; ++j) {
                        set &= this.readPages.get(j);
                    }
                    if (!DataPageIterator.$assertionsDisabled && !set) {
                        throw new AssertionError((Object)("readPages=" + this.readPages + ", pages=" + this.pages));
                    }
                }
                return this.rows.isEmpty() == false;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException("Error during iteration through page store: " + this, e);
            }
        }

        private static void setBit(BitSet bitSet, int idx) {
            boolean bit = bitSet.get(idx);
            assert (!bit) : "Bit with given index already set: " + idx;
            bitSet.set(idx);
        }

        private boolean readPageFromStore(long pageId, ByteBuffer buff) throws IgniteCheckedException {
            buff.clear();
            boolean read = this.store.read(pageId, buff, true);
            assert (read) : PageIdUtils.toDetailString(pageId);
            return PageIO.getType(buff) == PageIdUtils.flag(pageId);
        }

        public String toString() {
            return S.toString(DataPageIterator.class, this, super.toString());
        }
    }

    protected static class SnapshotHandlers {
        private final Map<SnapshotHandlerType, List<SnapshotHandler<Object>>> handlers = new EnumMap<SnapshotHandlerType, List<SnapshotHandler<Object>>>(SnapshotHandlerType.class);
        private ExecutorService execSvc;

        protected SnapshotHandlers() {
        }

        private void initialize(GridKernalContext ctx, ExecutorService execSvc) {
            this.execSvc = execSvc;
            SnapshotPartitionsVerifyHandler sysCheck = new SnapshotPartitionsVerifyHandler(ctx.cache().context());
            this.handlers.put(sysCheck.type(), new ArrayList<SnapshotPartitionsVerifyHandler>(F.asList(sysCheck)));
            SnapshotHandler[] extHnds = (SnapshotHandler[])ctx.plugins().extensions(SnapshotHandler.class);
            if (extHnds == null) {
                return;
            }
            for (SnapshotHandler extHnd : extHnds) {
                this.handlers.computeIfAbsent(extHnd.type(), v -> new ArrayList()).add(extHnd);
            }
        }

        @Nullable
        protected Map<String, SnapshotHandlerResult<Object>> invokeAll(SnapshotHandlerType type, SnapshotHandlerContext ctx) throws IgniteCheckedException {
            List<SnapshotHandler<Object>> handlers = this.handlers.get((Object)type);
            if (F.isEmpty(handlers)) {
                return null;
            }
            if (handlers.size() == 1) {
                SnapshotHandler<Object> hnd2 = handlers.get(0);
                return F.asMap(hnd2.getClass().getName(), this.invoke(hnd2, ctx));
            }
            return U.doInParallel(this.execSvc, handlers, hnd -> new T2<String, SnapshotHandlerResult<Object>>(hnd.getClass().getName(), this.invoke((SnapshotHandler<Object>)hnd, ctx))).stream().collect(Collectors.toMap(IgniteBiTuple::getKey, IgniteBiTuple::getValue));
        }

        protected void completeAll(SnapshotHandlerType type, String snpName, Map<String, List<SnapshotHandlerResult<?>>> res, Collection<UUID> reqNodes) throws Exception {
            if (res.isEmpty()) {
                return;
            }
            List<SnapshotHandler<Object>> hnds = this.handlers.get((Object)type);
            if (hnds == null || hnds.size() != res.size()) {
                throw new IgniteCheckedException("Snapshot handlers configuration mismatch (number of local snapshot handlers differs from the remote one). The current operation will be aborted [locHnds=" + (hnds == null ? "" : F.viewReadOnly(hnds, h -> h.getClass().getName(), new IgnitePredicate[0]).toString()) + ", rmtHnds=" + res.keySet() + "].");
            }
            for (SnapshotHandler<Object> hnd : hnds) {
                List nodesRes = res.get(hnd.getClass().getName());
                if (nodesRes == null || nodesRes.size() < reqNodes.size()) {
                    HashSet<UUID> missing = new HashSet<UUID>(reqNodes);
                    if (nodesRes != null) {
                        missing.removeAll(F.viewReadOnly(nodesRes, r -> r.node().id(), new IgnitePredicate[0]));
                    }
                    throw new IgniteCheckedException("Snapshot handlers configuration mismatch, \"" + hnd.getClass().getName() + "\" handler is missing on the remote node(s). The current operation will be aborted [missing=" + missing + "].");
                }
                hnd.complete(snpName, nodesRes);
            }
        }

        private SnapshotHandlerResult<Object> invoke(SnapshotHandler<Object> hnd, SnapshotHandlerContext ctx) {
            try {
                return new SnapshotHandlerResult<Object>(hnd.invoke(ctx), null, ctx.localNode());
            }
            catch (Exception e) {
                U.error(null, "Error invoking snapshot handler", e);
                return new SnapshotHandlerResult<Object>(null, e, ctx.localNode());
            }
        }
    }
}

