/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.terracotta.angela.common.AngelaProperties;

public class IpUtils {
    private static final Collection<String> LOCAL_HOSTNAMES = new HashSet<String>();
    private static final String LOCAL_HOSTNAME;

    public static boolean isLocal(String name) {
        return LOCAL_HOSTNAMES.contains(name) || name.startsWith("169.254.") || name.startsWith("fe80:") || Arrays.asList(AngelaProperties.ADDED_LOCAL_HOSTNAMES.getValue().split(",")).contains(name);
    }

    public static boolean areAllLocal(Collection<String> targetServerNames) {
        for (String targetServerName : targetServerNames) {
            if (IpUtils.isLocal(targetServerName)) continue;
            return false;
        }
        return true;
    }

    public static String getHostName() {
        return LOCAL_HOSTNAME;
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getHostName();
            LOCAL_HOSTNAMES.add(LOCAL_HOSTNAME);
            LOCAL_HOSTNAMES.add(InetAddress.getLocalHost().getHostAddress());
            LOCAL_HOSTNAMES.add("localhost");
            LOCAL_HOSTNAMES.add("127.0.0.1");
            LOCAL_HOSTNAMES.add("::1");
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

