/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityTracker
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ActivityTracker.class);
    private final Duration inactivityDelay;
    private final Map<String, Collection<Runnable>> listeners = new ConcurrentHashMap<String, Collection<Runnable>>();
    private final TransferQueue<Boolean> activity = new LinkedTransferQueue<Boolean>();
    private final boolean enabled;
    private final AtomicReference<Thread> monitor = new AtomicReference();

    private ActivityTracker(Duration inactivityDelay) {
        this.enabled = !inactivityDelay.equals(Duration.ZERO);
        this.inactivityDelay = inactivityDelay;
    }

    public Duration getInactivityDelay() {
        return this.inactivityDelay;
    }

    @Override
    public void close() {
        this.stop();
    }

    public void onInactivity(Runnable runnable) {
        if (this.enabled) {
            this.getListeners("inactivity").add(runnable);
        }
    }

    public void onStart(Runnable runnable) {
        if (this.enabled) {
            this.getListeners("start").add(runnable);
        }
    }

    public void onStop(Runnable runnable) {
        if (this.enabled) {
            this.getListeners("stop").add(runnable);
        }
    }

    public void touch() {
        if (this.enabled) {
            this.activity.tryTransfer(Boolean.TRUE);
        }
    }

    public boolean isRunning() {
        return this.monitor.get() != null;
    }

    public void stop() {
        this.internalStop().filter(thread -> thread != Thread.currentThread()).ifPresent(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
    }

    public void start() {
        if (this.enabled) {
            CountDownLatch started = new CountDownLatch(1);
            Thread thread = new Thread(() -> {
                Thread currentThread = Thread.currentThread();
                try {
                    this.getListeners("start").forEach(runnable -> {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException e) {
                            logger.error(e.getMessage(), e);
                        }
                    });
                    started.countDown();
                    while (this.monitor.get() == currentThread) {
                        if (this.activity.poll(this.inactivityDelay.toMillis(), TimeUnit.MILLISECONDS) != null) continue;
                        this.getListeners("inactivity").forEach(runnable -> {
                            try {
                                runnable.run();
                            }
                            catch (RuntimeException e) {
                                logger.error(e.getMessage(), e);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.getListeners("stop").forEach(runnable -> {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException e) {
                            logger.error(e.getMessage(), e);
                        }
                    });
                    this.monitor.compareAndSet(currentThread, null);
                }
            });
            thread.setName("ActivityTracker:" + this.inactivityDelay + ":" + thread.hashCode());
            thread.setDaemon(true);
            if (this.monitor.compareAndSet(null, thread)) {
                thread.start();
                try {
                    started.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private Optional<Thread> internalStop() {
        return Optional.ofNullable(this.monitor.getAndSet(null));
    }

    private Collection<Runnable> getListeners(String event) {
        return this.listeners.compute(event, (e, listeners) -> listeners != null ? listeners : new CopyOnWriteArrayList());
    }

    public static ActivityTracker of(Duration inactivityKillerDelay) {
        return new ActivityTracker(inactivityKillerDelay);
    }
}

