/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCountDownLatch;

public class Barrier
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Ignite ignite;
    private final int count;
    private final int index;
    private final String name;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private volatile IgniteCountDownLatch countDownLatch;
    private volatile int resetCount;

    Barrier(Ignite ignite, int count, String name) {
        this.ignite = ignite;
        this.count = count;
        IgniteAtomicLong igniteCounter = ignite.atomicLong("Barrier-Counter-" + name, 0L, true);
        this.index = (int)igniteCounter.getAndIncrement();
        igniteCounter.compareAndSet(count, 0L);
        this.name = name;
        this.resetLatch();
    }

    private void resetLatch() {
        this.countDownLatch = this.ignite.countDownLatch("Barrier-" + this.name + "#" + this.resetCount++, this.count, true, true);
    }

    public int await() {
        int countDown = this.countDownLatch.countDown();
        try {
            if (countDown > 0) {
                this.countDownLatch.await();
            }
            int n = this.index;
            return n;
        }
        finally {
            this.resetLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int await(long time, TimeUnit unit) throws TimeoutException {
        int countDown = this.countDownLatch.countDown();
        try {
            if (countDown > 0 && !this.countDownLatch.await(time, unit)) {
                throw new TimeoutException();
            }
            int n = this.index;
            return n;
        }
        finally {
            this.resetLatch();
        }
    }
}

