/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.io.Closeable;
import java.io.File;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaServerHandle;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.net.DisruptionProvider;
import org.terracotta.angela.common.net.DisruptionProviderFactory;
import org.terracotta.angela.common.net.Disruptor;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.Cmd;
import org.terracotta.angela.common.util.Jcmd;

public class TerracottaServerInstance
implements Closeable {
    private static final DisruptionProvider DISRUPTION_PROVIDER = DisruptionProviderFactory.getDefault();
    private final Map<ServerSymbolicName, Disruptor> disruptionLinks = new ConcurrentHashMap<ServerSymbolicName, Disruptor>();
    private final Map<ServerSymbolicName, Integer> proxiedPorts = new HashMap<ServerSymbolicName, Integer>();
    private final TerracottaServer terracottaServer;
    private final File kitDir;
    private final DistributionController distributionController;
    private final File workingDir;
    private final Distribution distribution;
    private final PortAllocator portAllocator;
    private final String licenseFilename;
    private volatile TerracottaServerHandle serverInstance;
    private final boolean netDisruptionEnabled;
    private final Topology topology;

    public TerracottaServerInstance(TerracottaServer terracottaServer, File kitDir, File workingDir, License license, Distribution distribution, Topology topology, PortAllocator portAllocator) {
        this.terracottaServer = terracottaServer;
        this.kitDir = kitDir;
        this.distributionController = distribution.createDistributionController();
        this.workingDir = workingDir;
        this.distribution = distribution;
        this.portAllocator = portAllocator;
        this.licenseFilename = license == null ? null : license.getFilename();
        this.netDisruptionEnabled = topology.isNetDisruptionEnabled();
        this.topology = topology;
        this.constructLinks();
    }

    private void constructLinks() {
        if (this.netDisruptionEnabled) {
            this.topology.getConfigurationManager().createDisruptionLinks(this.terracottaServer, DISRUPTION_PROVIDER, this.disruptionLinks, this.proxiedPorts, this.portAllocator);
        }
    }

    public Map<ServerSymbolicName, Integer> getProxiedPorts() {
        return this.proxiedPorts;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void create(TerracottaCommandLineEnvironment env, Map<String, String> envOverrides, List<String> startUpArgs, Duration inactivityKillerDelay) {
        this.setServerHandle(this.distributionController.createTsa(this.terracottaServer, this.kitDir, this.workingDir, this.topology, this.proxiedPorts, env, envOverrides, startUpArgs, inactivityKillerDelay));
    }

    private synchronized TerracottaServerHandle getServerHandle() {
        return this.serverInstance;
    }

    private synchronized void setServerHandle(TerracottaServerHandle handle) {
        this.serverInstance = handle;
    }

    public void disrupt(Collection<TerracottaServer> targets) {
        if (!this.netDisruptionEnabled) {
            throw new IllegalArgumentException("Topology not enabled for network disruption");
        }
        for (TerracottaServer server : targets) {
            this.disruptionLinks.get(server.getServerSymbolicName()).disrupt();
        }
    }

    public void undisrupt(Collection<TerracottaServer> targets) {
        if (!this.netDisruptionEnabled) {
            throw new IllegalArgumentException("Topology not enabled for network disruption");
        }
        for (TerracottaServer target : targets) {
            this.disruptionLinks.get(target.getServerSymbolicName()).undisrupt();
        }
    }

    public void stop() {
        this.getServerHandle().stop();
    }

    @Override
    public void close() {
        this.removeDisruptionLinks();
    }

    public ToolExecutionResult jcmd(TerracottaCommandLineEnvironment env, String ... arguments) {
        return Jcmd.jcmd(this.getServerHandle().getJavaPid(), env, arguments);
    }

    public ToolExecutionResult cmd(String terracottaCommand, String[] arguments) {
        return Cmd.cmd(this.kitDir, terracottaCommand, arguments);
    }

    public void waitForState(Set<TerracottaServerState> terracottaServerStates) {
        boolean isStateSame = true;
        TerracottaServerHandle handle = this.getServerHandle();
        while (isStateSame) {
            try {
                Thread.sleep(100L);
                isStateSame = handle.isAlive();
                TerracottaServerState currentState = handle.getState();
                for (TerracottaServerState terracottaServerState : terracottaServerStates) {
                    isStateSame &= terracottaServerState != currentState;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!handle.isAlive()) {
            StringBuilder states = new StringBuilder();
            for (TerracottaServerState terracottaServerState : terracottaServerStates) {
                states.append((Object)terracottaServerState).append(" ");
            }
            throw new RuntimeException("The Terracotta server was in state " + (Object)((Object)handle.getState()) + " and was expected to reach one of the states: " + states.toString() + "but died before reaching it.");
        }
    }

    public TerracottaServerState getTerracottaServerState() {
        TerracottaServerHandle handle = this.getServerHandle();
        if (handle == null) {
            return TerracottaServerState.STOPPED;
        }
        return handle.getState();
    }

    public File getKitDir() {
        return this.kitDir;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public File getLicenseFileLocation() {
        File f = new File(this.workingDir, this.licenseFilename);
        if (f.exists()) {
            return f;
        }
        f = new File(this.workingDir.getParentFile(), this.licenseFilename);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    private void removeDisruptionLinks() {
        if (this.netDisruptionEnabled) {
            this.disruptionLinks.values().forEach(DISRUPTION_PROVIDER::removeLink);
        }
    }
}

