/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.IgniteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.util.FileUtils;

public abstract class KitManager {
    private static final Logger logger = LoggerFactory.getLogger(KitManager.class);
    private static final long STALE_SNAPSHOT_LIMIT_HOURS = TimeUnit.DAYS.toHours(1L);
    protected final Distribution distribution;
    final Path rootInstallationPath;
    Path kitInstallationPath;

    KitManager(Distribution distribution) {
        this.distribution = distribution;
        this.rootInstallationPath = distribution == null ? null : this.buildRootInstallationPath(distribution);
    }

    private Path buildRootInstallationPath(Distribution distribution) {
        PackageType packageType = distribution.getPackageType();
        if (packageType != PackageType.KIT && packageType != PackageType.SAG_INSTALLER) {
            throw new RuntimeException("Can not resolve the local kit distribution package: " + (Object)((Object)packageType));
        }
        Path sagOrKitDir = Agent.ROOT_DIR.resolve(packageType == PackageType.SAG_INSTALLER ? "sag" : "kits");
        FileUtils.createAndValidateDir(sagOrKitDir);
        return sagOrKitDir.resolve(distribution.getVersion().getVersion(true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isValidLocalInstallerFilePath(boolean offline, Path localInstallerFile) {
        String md5FileHash;
        long timeSinceLastModified;
        if (!Files.isRegularFile(localInstallerFile, new LinkOption[0])) {
            logger.debug("Kit {} is not an existing file", (Object)localInstallerFile.toAbsolutePath());
            return false;
        }
        try {
            timeSinceLastModified = System.currentTimeMillis() - Files.getLastModifiedTime(localInstallerFile, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!offline && this.distribution.getVersion().isSnapshot() && timeSinceLastModified > STALE_SNAPSHOT_LIMIT_HOURS * 60L * 60L * 1000L) {
            logger.debug("Mode is online, distribution is snapshot, and {} is older than {} hours", (Object)localInstallerFile.getFileName(), (Object)STALE_SNAPSHOT_LIMIT_HOURS);
            FileUtils.deleteQuietly(localInstallerFile.getParent());
            return false;
        }
        if (this.distribution.getVersion().isSnapshot()) return true;
        if (this.distribution.getPackageType() != PackageType.KIT) {
            return true;
        }
        String md5File = localInstallerFile.toAbsolutePath() + ".md5";
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(md5File, new String[0]));
            md5FileHash = new String(bytes, StandardCharsets.US_ASCII).trim();
        }
        catch (NoSuchFileException nsfe) {
            logger.warn("{} does not have corresponding {} secure hash file on disk, considering it corrupt", (Object)localInstallerFile, (Object)md5File);
            FileUtils.deleteQuietly(localInstallerFile.getParent());
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading " + md5File, ioe);
        }
        try (InputStream fis = Files.newInputStream(localInstallerFile, new OpenOption[0]);){
            if (IgniteUtils.calculateMD5(fis).equalsIgnoreCase(md5FileHash)) return true;
            logger.warn("{} secure hash does not match the contents of {} secure hash file on disk, considering it corrupt", (Object)localInstallerFile, (Object)md5File);
            FileUtils.deleteQuietly(localInstallerFile.getParent());
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading " + localInstallerFile, ioe);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Path getKitInstallationPath() {
        return this.kitInstallationPath;
    }
}

