/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view.sql;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.util.typedef.F;

public class SqlTableView {
    private final TableDescriptor tbl;
    private String affColName;

    public SqlTableView(TableDescriptor tbl) {
        this.tbl = tbl;
        String affCol = tbl.type().affinityKey();
        if (affCol != null && !F.eq(tbl.type().keyFieldName(), affCol) && !F.eq(tbl.type().keyFieldAlias(), affCol)) {
            this.affColName = affCol;
        }
    }

    @Order
    public int cacheGroupId() {
        return this.tbl.cacheInfo().groupId();
    }

    @Order(value=1)
    public String cacheGroupName() {
        return this.tbl.cacheInfo().groupName();
    }

    @Order(value=2)
    public int cacheId() {
        return this.tbl.cacheInfo().cacheId();
    }

    @Order(value=3)
    public String cacheName() {
        return this.tbl.cacheInfo().name();
    }

    @Order(value=4)
    public String schemaName() {
        return this.tbl.type().schemaName();
    }

    @Order(value=5)
    public String tableName() {
        return this.tbl.type().tableName();
    }

    @Order(value=6)
    public String affinityKeyColumn() {
        return this.affColName;
    }

    @Order(value=7)
    public String keyAlias() {
        return this.tbl.type().keyFieldAlias();
    }

    @Order(value=8)
    public String valueAlias() {
        return this.tbl.type().valueFieldAlias();
    }

    @Order(value=9)
    public String keyTypeName() {
        return this.tbl.type().keyTypeName();
    }

    @Order(value=10)
    public String valueTypeName() {
        return this.tbl.type().valueTypeName();
    }

    public boolean isIndexRebuildInProgress() {
        return this.tbl.isIndexRebuildInProgress();
    }
}

