/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.platform.client.ClientCloseableResource;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheEntryEventNotification;

public class ClientCacheQueryContinuousHandle
implements CacheEntryUpdatedListener<Object, Object>,
ClientCloseableResource {
    private final ClientConnectionContext ctx;
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private volatile Long id;
    private volatile QueryCursor<?> cur;

    public ClientCacheQueryContinuousHandle(ClientConnectionContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    @Override
    public void onUpdated(Iterable<CacheEntryEvent<?, ?>> iterable) throws CacheEntryListenerException {
        if (this.id == null) {
            return;
        }
        ClientCacheEntryEventNotification notification = new ClientCacheEntryEventNotification(2007, (long)this.id, iterable);
        this.ctx.notifyClient(notification);
    }

    public void setCursor(QueryCursor<?> cur) {
        this.cur = cur;
    }

    public void startNotifications(long id) {
        this.id = id;
    }

    @Override
    public void close() {
        if (this.closeGuard.compareAndSet(false, true)) {
            assert (this.cur != null);
            this.cur.close();
            this.ctx.decrementCursors();
        }
    }
}

