/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.ThinProtocolFeature;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionAwarenessMappingGroup;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeGetRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeGetResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNameGetRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNameGetResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNamePutRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypePutRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadAckResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadProcessor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCursor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcIndexMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV2;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV3;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV4;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetadataInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCursor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryDescriptor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteMultipleStatementsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequestHandlerWorker;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUpdateBinarySchemaResult;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.MarshallerContext;
import org.jetbrains.annotations.Nullable;

public class JdbcRequestHandler
implements ClientListenerRequestHandler {
    private static final JdbcResponse JDBC_QUERY_CANCELLED_RESPONSE = new JdbcResponse(3014, "The query was cancelled while executing.");
    private final JdbcConnectionContext connCtx;
    private final SqlClientContext cliCtx;
    private final IgniteLogger log;
    private final GridSpinBusyLock busyLock;
    private final JdbcRequestHandlerWorker worker;
    private final int maxCursors;
    private final ConcurrentHashMap<Long, JdbcCursor> jdbcCursors = new ConcurrentHashMap();
    private final PriorityQueue<JdbcOrderedBatchExecuteRequest> orderedBatchesQueue = new PriorityQueue();
    private final Object orderedBatchesMux = new Object();
    private final Object reqMux = new Object();
    private final ClientListenerResponseSender sender;
    private final boolean autoCloseCursors;
    private final NestedTxMode nestedTxMode;
    private final ClientListenerProtocolVersion protocolVer;
    private final JdbcMetadataInfo meta;
    private Map<Long, JdbcQueryDescriptor> reqRegister = new HashMap<Long, JdbcQueryDescriptor>();

    public JdbcRequestHandler(GridSpinBusyLock busyLock, ClientListenerResponseSender sender, int maxCursors, boolean distributedJoins, boolean enforceJoinOrder, boolean collocated, boolean replicatedOnly, boolean autoCloseCursors, boolean lazy, boolean skipReducerOnUpdate, @Nullable String qryEngine, NestedTxMode nestedTxMode, @Nullable Boolean dataPageScanEnabled, @Nullable Integer updateBatchSize, ClientListenerProtocolVersion protocolVer, JdbcConnectionContext connCtx) {
        this.connCtx = connCtx;
        this.sender = sender;
        this.meta = new JdbcMetadataInfo(connCtx.kernalContext());
        Factory<GridWorker> orderedFactory = new Factory<GridWorker>(){

            @Override
            public GridWorker create() {
                return new OrderedBatchWorker();
            }
        };
        this.cliCtx = new SqlClientContext(connCtx.kernalContext(), orderedFactory, distributedJoins, enforceJoinOrder, collocated, replicatedOnly, lazy, skipReducerOnUpdate, dataPageScanEnabled, updateBatchSize, qryEngine);
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.autoCloseCursors = autoCloseCursors;
        this.nestedTxMode = nestedTxMode;
        this.protocolVer = protocolVer;
        this.log = connCtx.kernalContext().log(this.getClass());
        this.worker = new JdbcRequestHandlerWorker(connCtx.kernalContext().igniteInstanceName(), this.log, this, connCtx.kernalContext());
    }

    @Override
    public ClientListenerResponse handle(ClientListenerRequest req0) {
        assert (req0 != null);
        assert (req0 instanceof JdbcRequest);
        JdbcRequest req = (JdbcRequest)req0;
        if (!MvccUtils.mvccEnabled(this.connCtx.kernalContext())) {
            return this.doHandle(req);
        }
        GridFutureAdapter<ClientListenerResponse> fut = this.worker.process(req);
        try {
            return fut.get();
        }
        catch (IgniteCheckedException e) {
            return this.exceptionToResult(e);
        }
    }

    @Override
    public boolean isCancellationCommand(int cmdId) {
        return cmdId == 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRequest(long reqId, int cmdType) {
        assert (reqId != 0L);
        Object object = this.reqMux;
        synchronized (object) {
            if (this.isCancellationSupported() && (cmdType == 2 || cmdType == 6)) {
                this.reqRegister.put(reqId, new JdbcQueryDescriptor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterRequest(long reqId) {
        assert (reqId != 0L);
        Object object = this.reqMux;
        synchronized (object) {
            if (this.isCancellationSupported()) {
                this.reqRegister.remove(reqId);
            }
        }
    }

    void start() {
        if (this.worker != null) {
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdbcResponse doHandle(JdbcRequest req) {
        if (!this.busyLock.enterBusy()) {
            return new JdbcResponse(1, "Failed to handle JDBC request because node is stopping.");
        }
        try {
            JdbcResponse resp;
            switch (req.type()) {
                case 2: {
                    resp = this.executeQuery((JdbcQueryExecuteRequest)req);
                    break;
                }
                case 3: {
                    resp = this.fetchQuery((JdbcQueryFetchRequest)req);
                    break;
                }
                case 4: {
                    resp = this.closeQuery((JdbcQueryCloseRequest)req);
                    break;
                }
                case 5: {
                    resp = this.getQueryMeta((JdbcQueryMetadataRequest)req);
                    break;
                }
                case 6: {
                    resp = this.executeBatch((JdbcBatchExecuteRequest)req);
                    break;
                }
                case 14: {
                    resp = this.dispatchBatchOrdered((JdbcOrderedBatchExecuteRequest)req);
                    break;
                }
                case 7: {
                    resp = this.getTablesMeta((JdbcMetaTablesRequest)req);
                    break;
                }
                case 8: {
                    resp = this.getColumnsMeta((JdbcMetaColumnsRequest)req);
                    break;
                }
                case 9: {
                    resp = this.getIndexesMeta((JdbcMetaIndexesRequest)req);
                    break;
                }
                case 10: {
                    resp = this.getParametersMeta((JdbcMetaParamsRequest)req);
                    break;
                }
                case 11: {
                    resp = this.getPrimaryKeys((JdbcMetaPrimaryKeysRequest)req);
                    break;
                }
                case 12: {
                    resp = this.getSchemas((JdbcMetaSchemasRequest)req);
                    break;
                }
                case 13: {
                    resp = this.processBulkLoadFileBatch((JdbcBulkLoadBatchRequest)req);
                    break;
                }
                case 15: {
                    resp = this.cancelQuery((JdbcQueryCancelRequest)req);
                    break;
                }
                case 16: {
                    resp = this.getCachePartitions((JdbcCachePartitionsRequest)req);
                    break;
                }
                case 20: {
                    resp = this.registerBinaryType((JdbcBinaryTypeNamePutRequest)req);
                    break;
                }
                case 19: {
                    resp = this.getBinaryTypeName((JdbcBinaryTypeNameGetRequest)req);
                    break;
                }
                case 18: {
                    resp = this.putBinaryType((JdbcBinaryTypePutRequest)req);
                    break;
                }
                case 17: {
                    resp = this.getBinaryType((JdbcBinaryTypeGetRequest)req);
                    break;
                }
                default: {
                    resp = new JdbcResponse(1002, "Unsupported JDBC request [req=" + req + ']');
                }
            }
            if (resp != null) {
                resp.activeTransaction(this.connCtx.kernalContext().cache().context().tm().inUserTx());
            }
            JdbcResponse jdbcResponse = resp;
            return jdbcResponse;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse dispatchBatchOrdered(JdbcOrderedBatchExecuteRequest req) {
        if (!this.cliCtx.isStreamOrdered()) {
            this.executeBatchOrdered(req);
        } else {
            Object object = this.orderedBatchesMux;
            synchronized (object) {
                this.orderedBatchesQueue.add(req);
                this.orderedBatchesMux.notifyAll();
            }
        }
        return null;
    }

    private ClientListenerResponse executeBatchOrdered(JdbcOrderedBatchExecuteRequest req) {
        try {
            JdbcResponse resp;
            if (req.isLastStreamBatch()) {
                this.cliCtx.waitTotalProcessedOrderedRequests(req.order());
            }
            if ((resp = this.executeBatch(req)).response() instanceof JdbcBatchExecuteResult) {
                resp = new JdbcResponse(new JdbcOrderedBatchExecuteResult((JdbcBatchExecuteResult)resp.response(), req.order()));
            }
            this.sender.send(resp);
        }
        catch (Exception e) {
            U.error(null, "Error processing file batch", e);
            this.sender.send(new JdbcResponse(1, "Server error: " + e));
        }
        this.cliCtx.orderedRequestProcessed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse processBulkLoadFileBatch(JdbcBulkLoadBatchRequest req) {
        if (this.connCtx.kernalContext() == null) {
            return new JdbcResponse(2001, "Unknown query ID: " + req.cursorId() + ". Bulk load session may have been reclaimed due to timeout.");
        }
        JdbcBulkLoadProcessor processor = (JdbcBulkLoadProcessor)this.jdbcCursors.get(req.cursorId());
        if (!this.prepareQueryCancellationMeta(processor)) {
            return JDBC_QUERY_CANCELLED_RESPONSE;
        }
        boolean unregisterReq = false;
        try {
            processor.processBatch(req);
            switch (req.cmd()) {
                case 1: 
                case 2: {
                    this.jdbcCursors.remove(req.cursorId());
                    processor.close();
                    unregisterReq = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            JdbcResponse jdbcResponse = this.resultToResonse(new JdbcQueryExecuteResult(req.cursorId(), processor.updateCnt(), null));
            return jdbcResponse;
        }
        catch (Exception e) {
            U.error(null, "Error processing file batch", e);
            processor.onFail(e);
            if (X.cause(e, QueryCancelledException.class) != null) {
                JdbcResponse jdbcResponse = this.exceptionToResult(new QueryCancelledException());
                return jdbcResponse;
            }
            JdbcResponse jdbcResponse = new JdbcResponse(1, "Server error: " + e);
            return jdbcResponse;
        }
        finally {
            this.cleanupQueryCancellationMeta(unregisterReq, processor.requestId());
        }
    }

    @Override
    public ClientListenerResponse handleException(Throwable e, ClientListenerRequest req) {
        return this.exceptionToResult(e);
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
        writer.writeByte(IgniteVersionUtils.VER.major());
        writer.writeByte(IgniteVersionUtils.VER.minor());
        writer.writeByte(IgniteVersionUtils.VER.maintenance());
        writer.writeString(IgniteVersionUtils.VER.stage());
        writer.writeLong(IgniteVersionUtils.VER.revisionTimestamp());
        writer.writeByteArray(IgniteVersionUtils.VER.revisionHash());
        if (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            writer.writeUuid(this.connCtx.kernalContext().localNodeId());
        }
        if (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_9_0) >= 0) {
            writer.writeByteArray(ThinProtocolFeature.featuresAsBytes(this.connCtx.protocolContext().features()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect() {
        if (this.worker != null) {
            this.worker.cancel();
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (JdbcCursor cursor : this.jdbcCursors.values()) {
            U.close(cursor, this.log);
        }
        this.jdbcCursors.clear();
        Object object = this.reqMux;
        synchronized (object) {
            this.reqRegister.clear();
        }
        U.close(this.cliCtx, this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse executeQuery(JdbcQueryExecuteRequest req) {
        Object sql;
        Object desc;
        GridQueryCancel cancel = null;
        boolean unregisterReq = false;
        if (this.isCancellationSupported()) {
            Object object = this.reqMux;
            synchronized (object) {
                desc = this.reqRegister.get(req.requestId());
                if (desc == null) {
                    return null;
                }
                cancel = ((JdbcQueryDescriptor)desc).cancelHook();
                ((JdbcQueryDescriptor)desc).incrementUsageCount();
            }
        }
        try {
            SqlFieldsQueryEx qry;
            int cursorCnt = this.jdbcCursors.size();
            if (this.maxCursors > 0 && cursorCnt >= this.maxCursors) {
                desc = new JdbcResponse(1, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + cursorCnt + ']');
                return desc;
            }
            assert (!this.cliCtx.isStream());
            sql = req.sqlQuery();
            switch (req.expectedStatementType()) {
                case ANY_STATEMENT_TYPE: {
                    qry = new SqlFieldsQueryEx((String)sql, null);
                    break;
                }
                case SELECT_STATEMENT_TYPE: {
                    qry = new SqlFieldsQueryEx((String)sql, (Boolean)true);
                    break;
                }
                default: {
                    assert (req.expectedStatementType() == JdbcStatementType.UPDATE_STMT_TYPE);
                    qry = new SqlFieldsQueryEx((String)sql, (Boolean)false);
                    if (!this.cliCtx.isSkipReducerOnUpdate()) break;
                    qry.setSkipReducerOnUpdate(true);
                }
            }
            this.setupQuery(qry, JdbcRequestHandler.prepareSchemaName(req.schemaName()));
            qry.setArgs(req.arguments());
            qry.setAutoCommit(req.autoCommit());
            if (req.explicitTimeout()) {
                qry.setTimeout(0, TimeUnit.MILLISECONDS);
            }
            if (req.pageSize() <= 0) {
                JdbcResponse jdbcResponse = new JdbcResponse(1, "Invalid fetch size: " + req.pageSize());
                return jdbcResponse;
            }
            qry.setPageSize(req.pageSize());
            String schemaName = req.schemaName();
            if (F.isEmpty(schemaName)) {
                schemaName = "PUBLIC";
            }
            qry.setSchema(schemaName);
            List<FieldsQueryCursor<List<?>>> results = this.querySqlFields(qry, cancel);
            FieldsQueryCursor<List<?>> fieldsCur = results.get(0);
            if (fieldsCur instanceof BulkLoadContextCursor) {
                BulkLoadContextCursor blCur = (BulkLoadContextCursor)fieldsCur;
                BulkLoadProcessor blProcessor = blCur.bulkLoadProcessor();
                BulkLoadAckClientParameters clientParams = blCur.clientParams();
                JdbcBulkLoadProcessor processor = new JdbcBulkLoadProcessor(blProcessor, req.requestId());
                this.jdbcCursors.put(processor.cursorId(), processor);
                JdbcResponse jdbcResponse = this.resultToResonse(new JdbcBulkLoadAckResult(processor.cursorId(), clientParams));
                return jdbcResponse;
            }
            if (results.size() == 1) {
                JdbcQueryExecuteResult res;
                JdbcQueryCursor cur = new JdbcQueryCursor(req.pageSize(), req.maxRows(), (QueryCursorEx)((Object)fieldsCur), req.requestId());
                this.jdbcCursors.put(cur.cursorId(), cur);
                cur.openIterator();
                PartitionResult partRes = null;
                if (fieldsCur instanceof QueryCursorImpl) {
                    partRes = ((QueryCursorImpl)fieldsCur).partitionResult();
                }
                if (cur.isQuery()) {
                    res = new JdbcQueryExecuteResult(cur.cursorId(), cur.fetchRows(), !cur.hasNext(), JdbcRequestHandler.isClientPartitionAwarenessApplicable(req.partitionResponseRequest(), partRes) ? partRes : null);
                } else {
                    List<List<Object>> items = cur.fetchRows();
                    assert (items != null && items.size() == 1 && items.get(0).size() == 1 && items.get(0).get(0) instanceof Long) : "Invalid result set for not-SELECT query. [qry=" + (String)sql + ", res=" + S.toString(List.class, items) + ']';
                    res = new JdbcQueryExecuteResult(cur.cursorId(), (Long)items.get(0).get(0), JdbcRequestHandler.isClientPartitionAwarenessApplicable(req.partitionResponseRequest(), partRes) ? partRes : null);
                }
                if (res.last() && (!res.isQuery() || this.autoCloseCursors)) {
                    this.jdbcCursors.remove(cur.cursorId());
                    unregisterReq = true;
                    cur.close();
                }
                JdbcResponse jdbcResponse = this.resultToResonse(res);
                return jdbcResponse;
            }
            ArrayList<JdbcResultInfo> jdbcResults = new ArrayList<JdbcResultInfo>(results.size());
            List<List<Object>> items = null;
            boolean last = true;
            for (FieldsQueryCursor<List<?>> c : results) {
                JdbcResultInfo jdbcRes;
                QueryCursorEx qryCur = (QueryCursorEx)((Object)c);
                if (qryCur.isQuery()) {
                    JdbcQueryCursor cur = new JdbcQueryCursor(req.pageSize(), req.maxRows(), qryCur, req.requestId());
                    this.jdbcCursors.put(cur.cursorId(), cur);
                    jdbcRes = new JdbcResultInfo(true, -1L, cur.cursorId());
                    cur.openIterator();
                    if (items == null) {
                        items = cur.fetchRows();
                        last = cur.hasNext();
                    }
                } else {
                    jdbcRes = new JdbcResultInfo(false, (Long)((List)qryCur.getAll().get(0)).get(0), -1L);
                }
                jdbcResults.add(jdbcRes);
            }
            JdbcResponse jdbcResponse = this.resultToResonse(new JdbcQueryExecuteMultipleStatementsResult(jdbcResults, items, last));
            return jdbcResponse;
        }
        catch (Exception e) {
            this.clearCursors(req.requestId());
            unregisterReq = true;
            if (X.cause(e, QueryCancelledException.class) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to execute SQL query [reqId=" + req.requestId() + ", req=" + req + "]. Error:" + X.getFullStackTrace(e));
                }
                sql = this.exceptionToResult(new QueryCancelledException());
                return sql;
            }
            if (X.cause(e, IgniteSQLException.class) != null) {
                IgniteSQLException e0 = X.cause(e, IgniteSQLException.class);
                if (JdbcRequestHandler.isNeedToNodeLog(e0)) {
                    U.warn(this.log, "Failed to execute SQL query [reqId=" + req.requestId() + ", req=" + req + ']', e);
                }
                JdbcResponse jdbcResponse = this.exceptionToResult(e0);
                return jdbcResponse;
            }
            U.warn(this.log, "Failed to execute SQL query [reqId=" + req.requestId() + ", req=" + req + ']', e);
            JdbcResponse jdbcResponse = this.exceptionToResult(e);
            return jdbcResponse;
        }
        finally {
            this.cleanupQueryCancellationMeta(unregisterReq, req.requestId());
        }
    }

    private List<FieldsQueryCursor<List<?>>> querySqlFields(SqlFieldsQueryEx qry, GridQueryCancel cancel) {
        return this.connCtx.kernalContext().query().querySqlFields(null, qry, this.cliCtx, true, this.protocolVer.compareTo(JdbcConnectionContext.VER_2_3_0) < 0, cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse closeQuery(JdbcQueryCloseRequest req) {
        JdbcCursor cur = this.jdbcCursors.get(req.cursorId());
        if (!this.prepareQueryCancellationMeta(cur)) {
            return new JdbcResponse(null);
        }
        try {
            cur = this.jdbcCursors.remove(req.cursorId());
            if (cur == null) {
                JdbcResponse jdbcResponse = new JdbcResponse(1, "Failed to find query cursor with ID: " + req.cursorId());
                return jdbcResponse;
            }
            cur.close();
            JdbcResponse jdbcResponse = new JdbcResponse(null);
            return jdbcResponse;
        }
        catch (Exception e) {
            this.jdbcCursors.remove(req.cursorId());
            U.error(this.log, "Failed to close SQL query [reqId=" + req.requestId() + ", req=" + req + ']', e);
            if (X.cause(e, QueryCancelledException.class) != null) {
                JdbcResponse jdbcResponse = new JdbcResponse(null);
                return jdbcResponse;
            }
            JdbcResponse jdbcResponse = this.exceptionToResult(e);
            return jdbcResponse;
        }
        finally {
            if (this.isCancellationSupported()) {
                boolean clearCursors = false;
                Object object = this.reqMux;
                synchronized (object) {
                    assert (cur != null);
                    JdbcQueryDescriptor desc = this.reqRegister.get(cur.requestId());
                    if (desc != null) {
                        if (desc.isCanceled()) {
                            clearCursors = true;
                            this.unregisterRequest(req.requestId());
                        } else {
                            this.tryUnregisterRequest(cur.requestId());
                            desc.decrementUsageCount();
                        }
                    }
                }
                if (clearCursors) {
                    this.clearCursors(cur.requestId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse fetchQuery(JdbcQueryFetchRequest req) {
        JdbcQueryCursor cur = (JdbcQueryCursor)this.jdbcCursors.get(req.cursorId());
        if (!this.prepareQueryCancellationMeta(cur)) {
            return JDBC_QUERY_CANCELLED_RESPONSE;
        }
        boolean unregisterReq = false;
        try {
            if (cur == null) {
                JdbcResponse jdbcResponse = new JdbcResponse(1, "Failed to find query cursor with ID: " + req.cursorId());
                return jdbcResponse;
            }
            if (req.pageSize() <= 0) {
                JdbcResponse jdbcResponse = new JdbcResponse(1, "Invalid fetch size : [fetchSize=" + req.pageSize() + ']');
                return jdbcResponse;
            }
            cur.pageSize(req.pageSize());
            JdbcQueryFetchResult res = new JdbcQueryFetchResult(cur.fetchRows(), !cur.hasNext());
            if (res.last() && (!cur.isQuery() || this.autoCloseCursors)) {
                this.jdbcCursors.remove(req.cursorId());
                unregisterReq = true;
                cur.close();
            }
            JdbcResponse jdbcResponse = this.resultToResonse(res);
            return jdbcResponse;
        }
        catch (Exception e) {
            U.error(this.log, "Failed to fetch SQL query result [reqId=" + req.requestId() + ", req=" + req + ']', e);
            if (X.cause(e, QueryCancelledException.class) != null) {
                JdbcResponse jdbcResponse = this.exceptionToResult(new QueryCancelledException());
                return jdbcResponse;
            }
            JdbcResponse jdbcResponse = this.exceptionToResult(e);
            return jdbcResponse;
        }
        finally {
            assert (cur != null);
            this.cleanupQueryCancellationMeta(unregisterReq, cur.requestId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse getQueryMeta(JdbcQueryMetadataRequest req) {
        JdbcQueryCursor cur = (JdbcQueryCursor)this.jdbcCursors.get(req.cursorId());
        if (!this.prepareQueryCancellationMeta(cur)) {
            return JDBC_QUERY_CANCELLED_RESPONSE;
        }
        try {
            if (cur == null) {
                JdbcResponse jdbcResponse = new JdbcResponse(1, "Failed to find query cursor with ID: " + req.cursorId());
                return jdbcResponse;
            }
            JdbcQueryMetadataResult res = new JdbcQueryMetadataResult(req.cursorId(), cur.meta());
            JdbcResponse jdbcResponse = this.resultToResonse(res);
            return jdbcResponse;
        }
        catch (Exception e) {
            U.error(this.log, "Failed to fetch SQL query result [reqId=" + req.requestId() + ", req=" + req + ']', e);
            JdbcResponse jdbcResponse = this.exceptionToResult(e);
            return jdbcResponse;
        }
        finally {
            assert (cur != null);
            this.cleanupQueryCancellationMeta(false, cur.requestId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse executeBatch(JdbcBatchExecuteRequest req) {
        GridQueryCancel cancel = null;
        if (this.isCancellationSupported() && req.type() == 6) {
            Object object = this.reqMux;
            synchronized (object) {
                JdbcQueryDescriptor desc = this.reqRegister.get(req.requestId());
                if (desc == null) {
                    return null;
                }
                cancel = desc.cancelHook();
                desc.incrementUsageCount();
            }
        }
        try {
            String schemaName = JdbcRequestHandler.prepareSchemaName(req.schemaName());
            int qryCnt = req.queries().size();
            ArrayList<Integer> updCntsAcc = new ArrayList<Integer>(qryCnt);
            IgniteBiTuple<Integer, String> firstErr = new IgniteBiTuple<Integer, String>();
            SqlFieldsQueryEx qry = null;
            for (JdbcQuery q : req.queries()) {
                if (q.sql() != null) {
                    if (qry != null) {
                        this.executeBatchedQuery(qry, updCntsAcc, firstErr, cancel);
                    }
                    qry = new SqlFieldsQueryEx(q.sql(), (Boolean)false);
                    this.setupQuery(qry, schemaName);
                    qry.setAutoCommit(req.autoCommit());
                }
                assert (qry != null);
                qry.addBatchedArgs(q.args());
            }
            if (qry != null) {
                this.executeBatchedQuery(qry, updCntsAcc, firstErr, cancel);
            }
            if (req.isLastStreamBatch()) {
                this.cliCtx.disableStreaming();
            }
            int[] updCnts = U.toIntArray(updCntsAcc);
            JdbcResponse jdbcResponse = firstErr.isEmpty() ? this.resultToResonse(new JdbcBatchExecuteResult(updCnts, 0, null)) : this.resultToResonse(new JdbcBatchExecuteResult(updCnts, firstErr.getKey(), firstErr.getValue()));
            return jdbcResponse;
        }
        catch (QueryCancelledException e) {
            JdbcResponse jdbcResponse = this.exceptionToResult(e);
            return jdbcResponse;
        }
        finally {
            this.cleanupQueryCancellationMeta(true, req.requestId());
        }
    }

    private static String prepareSchemaName(@Nullable String schemaName) {
        if (F.isEmpty(schemaName)) {
            schemaName = "PUBLIC";
        }
        return schemaName;
    }

    private void setupQuery(SqlFieldsQueryEx qry, String schemaName) {
        qry.setDistributedJoins(this.cliCtx.isDistributedJoins());
        qry.setEnforceJoinOrder(this.cliCtx.isEnforceJoinOrder());
        qry.setCollocated(this.cliCtx.isCollocated());
        qry.setReplicatedOnly(this.cliCtx.isReplicatedOnly());
        qry.setLazy(this.cliCtx.isLazy());
        qry.setNestedTxMode(this.nestedTxMode);
        qry.setSchema(schemaName);
        qry.setQueryInitiatorId(this.connCtx.clientDescriptor());
        if (this.cliCtx.updateBatchSize() != null) {
            qry.setUpdateBatchSize(this.cliCtx.updateBatchSize());
        }
    }

    private void executeBatchedQuery(SqlFieldsQueryEx qry, List<Integer> updCntsAcc, IgniteBiTuple<Integer, String> firstErr, GridQueryCancel cancel) throws QueryCancelledException {
        try {
            if (this.cliCtx.isStream()) {
                List<Long> cnt = this.connCtx.kernalContext().query().streamBatchedUpdateQuery(qry.getSchema(), this.cliCtx, qry.getSql(), qry.batchedArguments(), this.connCtx.clientDescriptor());
                for (int i = 0; i < cnt.size(); ++i) {
                    updCntsAcc.add(cnt.get(i).intValue());
                }
                return;
            }
            List<FieldsQueryCursor<List<?>>> qryRes = this.connCtx.kernalContext().query().querySqlFields(null, qry, this.cliCtx, true, true, cancel);
            for (FieldsQueryCursor<List<?>> cur : qryRes) {
                if (cur instanceof BulkLoadContextCursor) {
                    throw new IgniteSQLException("COPY command cannot be executed in batch mode.");
                }
                assert (!((QueryCursorEx)((Object)cur)).isQuery());
                Iterator it = cur.iterator();
                if (!it.hasNext()) continue;
                int val = ((Long)((List)it.next()).get(0)).intValue();
                updCntsAcc.add(val);
            }
        }
        catch (Exception e) {
            int code;
            String msg;
            if (X.cause(e, QueryCancelledException.class) != null) {
                throw new QueryCancelledException();
            }
            if (e instanceof IgniteSQLException) {
                BatchUpdateException batchCause = X.cause(e, BatchUpdateException.class);
                if (batchCause != null) {
                    int[] updCntsOnErr = batchCause.getUpdateCounts();
                    for (int i = 0; i < updCntsOnErr.length; ++i) {
                        updCntsAcc.add(updCntsOnErr[i]);
                    }
                    msg = batchCause.getMessage();
                    code = batchCause.getErrorCode();
                } else {
                    for (int i = 0; i < qry.batchedArguments().size(); ++i) {
                        updCntsAcc.add(-3);
                    }
                    msg = e.getMessage();
                    code = ((IgniteSQLException)e).statusCode();
                }
            } else {
                for (int i = 0; i < qry.batchedArguments().size(); ++i) {
                    updCntsAcc.add(-3);
                }
                msg = e.getMessage();
                code = 1;
            }
            if (firstErr.isEmpty()) {
                firstErr.set(code, msg);
            }
            U.error(this.log, "Failed to execute batch query [qry=" + qry + ']', e);
        }
    }

    private JdbcResponse getTablesMeta(JdbcMetaTablesRequest req) {
        try {
            List<JdbcTableMeta> tabMetas = this.meta.getTablesMeta(req.schemaName(), req.tableName(), req.tableTypes());
            JdbcMetaTablesResult res = new JdbcMetaTablesResult(tabMetas);
            return this.resultToResonse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get tables metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getColumnsMeta(JdbcMetaColumnsRequest req) {
        try {
            Collection<JdbcColumnMeta> colsMeta = this.meta.getColumnsMeta(this.protocolVer, req.schemaName(), req.tableName(), req.columnName());
            JdbcMetaColumnsResult res = this.protocolVer.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0 ? new JdbcMetaColumnsResultV4(colsMeta) : (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0 ? new JdbcMetaColumnsResultV3(colsMeta) : (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_3_0) >= 0 ? new JdbcMetaColumnsResultV2(colsMeta) : new JdbcMetaColumnsResult(colsMeta)));
            return this.resultToResonse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get columns metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse putBinaryType(JdbcBinaryTypePutRequest req) {
        try {
            this.getBinaryCtx().updateMetadata(req.meta().typeId(), req.meta(), false);
            return this.resultToResonse(new JdbcUpdateBinarySchemaResult(req.requestId(), true));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to update binary schema [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getBinaryType(JdbcBinaryTypeGetRequest req) {
        try {
            BinaryTypeImpl type = (BinaryTypeImpl)this.connCtx.kernalContext().cacheObjects().binary().type(req.typeId());
            return this.resultToResonse(new JdbcBinaryTypeGetResult(req.requestId(), type != null ? type.metadata() : null));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get binary type name [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getBinaryTypeName(JdbcBinaryTypeNameGetRequest req) {
        try {
            String name = this.getMarshallerCtx().getClassName(req.platformId(), req.typeId());
            return this.resultToResonse(new JdbcBinaryTypeNameGetResult(req.requestId(), name));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get binary type name [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse registerBinaryType(JdbcBinaryTypeNamePutRequest req) {
        try {
            boolean res = this.getMarshallerCtx().registerClassName(req.platformId(), req.typeId(), req.typeName(), false);
            return this.resultToResonse(new JdbcUpdateBinarySchemaResult(req.requestId(), res));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to register new type [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private MarshallerContext getMarshallerCtx() {
        return this.connCtx.kernalContext().marshallerContext();
    }

    private BinaryContext getBinaryCtx() {
        return ((CacheObjectBinaryProcessorImpl)this.connCtx.kernalContext().cacheObjects()).binaryContext();
    }

    private JdbcResponse getIndexesMeta(JdbcMetaIndexesRequest req) {
        try {
            SortedSet<JdbcIndexMeta> idxInfos = this.meta.getIndexesMeta(req.schemaName(), req.tableName());
            return this.resultToResonse(new JdbcMetaIndexesResult(idxInfos));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get parameters metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getParametersMeta(JdbcMetaParamsRequest req) {
        String schemaName = JdbcRequestHandler.prepareSchemaName(req.schemaName());
        SqlFieldsQueryEx qry = new SqlFieldsQueryEx(req.sql(), null);
        this.setupQuery(qry, schemaName);
        try {
            List<JdbcParameterMeta> meta = this.connCtx.kernalContext().query().getIndexing().parameterMetaData(schemaName, qry);
            JdbcMetaParamsResult res = new JdbcMetaParamsResult(meta);
            return this.resultToResonse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get parameters metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getPrimaryKeys(JdbcMetaPrimaryKeysRequest req) {
        try {
            Collection<JdbcPrimaryKeyMeta> pkMeta = this.meta.getPrimaryKeys(req.schemaName(), req.tableName());
            return this.resultToResonse(new JdbcMetaPrimaryKeysResult(pkMeta));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get parameters metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getSchemas(JdbcMetaSchemasRequest req) {
        try {
            String schemaPtrn = req.schemaName();
            SortedSet<String> schemas = this.meta.getSchemasMeta(schemaPtrn);
            return this.resultToResonse(new JdbcMetaSchemasResult(schemas));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get schemas metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse exceptionToResult(Throwable e) {
        return new JdbcResponse(SqlListenerUtils.exceptionToSqlErrorCode(e), e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcResponse cancelQuery(JdbcQueryCancelRequest req) {
        GridQueryCancel cancelHook;
        boolean clearCursors = false;
        Object object = this.reqMux;
        synchronized (object) {
            JdbcQueryDescriptor desc = this.reqRegister.get(req.requestIdToBeCancelled());
            if (desc == null) {
                return null;
            }
            if (!desc.isExecutionStarted()) {
                this.unregisterRequest(req.requestId());
                return this.exceptionToResult(new QueryCancelledException());
            }
            cancelHook = desc.cancelHook();
            desc.markCancelled();
            if (desc.usageCount() == 0) {
                clearCursors = true;
                this.unregisterRequest(req.requestIdToBeCancelled());
            }
        }
        cancelHook.cancel();
        if (clearCursors) {
            this.clearCursors(req.requestIdToBeCancelled());
        }
        return null;
    }

    private JdbcResponse getCachePartitions(JdbcCachePartitionsRequest req) {
        ArrayList<JdbcThinPartitionAwarenessMappingGroup> mappings = new ArrayList<JdbcThinPartitionAwarenessMappingGroup>();
        AffinityTopologyVersion topVer = this.connCtx.kernalContext().cache().context().exchange().readyAffinityVersion();
        for (int cacheId : req.cacheIds()) {
            Map<UUID, Set<Integer>> partitionsMap = this.getPartitionsMap(this.connCtx.kernalContext().cache().cacheDescriptor(cacheId), topVer);
            mappings.add(new JdbcThinPartitionAwarenessMappingGroup(cacheId, partitionsMap));
        }
        return new JdbcResponse(new JdbcCachePartitionsResult(mappings), topVer);
    }

    private Map<UUID, Set<Integer>> getPartitionsMap(DynamicCacheDescriptor cacheDesc, AffinityTopologyVersion affVer) {
        GridCacheContext cacheCtx = this.connCtx.kernalContext().cache().context().cacheContext(cacheDesc.cacheId());
        AffinityAssignment assignment = cacheCtx.affinity().assignment(affVer);
        Set<ClusterNode> nodes = assignment.primaryPartitionNodes();
        HashMap<UUID, Set<Integer>> res = new HashMap<UUID, Set<Integer>>(nodes.size());
        for (ClusterNode node : nodes) {
            UUID nodeId = node.id();
            Set<Integer> parts = assignment.primaryPartitions(nodeId);
            res.put(nodeId, parts);
        }
        return res;
    }

    @Override
    public boolean isCancellationSupported() {
        return this.protocolVer.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0;
    }

    private void tryUnregisterRequest(long reqId) {
        assert (this.isCancellationSupported());
        boolean unregisterReq = true;
        for (JdbcCursor cursor : this.jdbcCursors.values()) {
            if (cursor.requestId() != reqId) continue;
            unregisterReq = false;
            break;
        }
        if (unregisterReq) {
            this.unregisterRequest(reqId);
        }
    }

    private void clearCursors(long reqId) {
        Iterator<Map.Entry<Long, JdbcCursor>> it = this.jdbcCursors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, JdbcCursor> entry = it.next();
            JdbcCursor cursor = entry.getValue();
            if (cursor.requestId() != reqId) continue;
            try {
                cursor.close();
            }
            catch (Exception e) {
                U.error(this.log, "Failed to close cursor [reqId=" + reqId + ", cursor=" + cursor + ']', e);
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareQueryCancellationMeta(JdbcCursor cur) {
        if (this.isCancellationSupported()) {
            if (cur == null) {
                return false;
            }
            Object object = this.reqMux;
            synchronized (object) {
                JdbcQueryDescriptor desc = this.reqRegister.get(cur.requestId());
                if (desc == null) {
                    return false;
                }
                desc.incrementUsageCount();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupQueryCancellationMeta(boolean unregisterReq, long reqId) {
        if (this.isCancellationSupported()) {
            boolean clearCursors = false;
            Object object = this.reqMux;
            synchronized (object) {
                JdbcQueryDescriptor desc = this.reqRegister.get(reqId);
                if (desc != null) {
                    if (desc.isCanceled()) {
                        clearCursors = true;
                        unregisterReq = true;
                    } else {
                        desc.decrementUsageCount();
                    }
                    if (unregisterReq) {
                        this.unregisterRequest(reqId);
                    }
                }
            }
            if (clearCursors) {
                this.clearCursors(reqId);
            }
        }
    }

    private JdbcResponse resultToResonse(JdbcResult res) {
        return new JdbcResponse(res, this.connCtx.getAffinityTopologyVersionIfChanged());
    }

    private static boolean isClientPartitionAwarenessApplicable(boolean partResRequested, PartitionResult partRes) {
        return partResRequested && (partRes == null || partRes.isClientPartitionAwarenessApplicable());
    }

    @Override
    public ClientListenerProtocolVersion protocolVersion() {
        return this.protocolVer;
    }

    private static boolean isNeedToNodeLog(IgniteSQLException e) {
        return "50000".equals(e.sqlState());
    }

    private class OrderedBatchWorker
    extends GridWorker {
        OrderedBatchWorker() {
            super(JdbcRequestHandler.this.connCtx.kernalContext().igniteInstanceName(), "ordered-batch", JdbcRequestHandler.this.log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            long nextBatchOrder = 0L;
            while (JdbcRequestHandler.this.cliCtx.isStream()) {
                JdbcOrderedBatchExecuteRequest req;
                Object object = JdbcRequestHandler.this.orderedBatchesMux;
                synchronized (object) {
                    req = (JdbcOrderedBatchExecuteRequest)JdbcRequestHandler.this.orderedBatchesQueue.peek();
                    if (req == null || req.order() != nextBatchOrder) {
                        JdbcRequestHandler.this.orderedBatchesMux.wait();
                        continue;
                    }
                    JdbcRequestHandler.this.orderedBatchesQueue.poll();
                }
                JdbcRequestHandler.this.executeBatchOrdered(req);
                ++nextBatchOrder;
            }
            return;
        }
    }
}

