/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalState;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class IgniteTxLocalStateAdapter
implements IgniteTxLocalState {
    private static final Function<Integer, Set<Integer>> CREATE_INT_SET = k -> new HashSet();
    private Map<Integer, Set<Integer>> touchedParts;

    protected final void onTxEnd(GridCacheContext cacheCtx, IgniteInternalTx tx, boolean commit) {
        if (cacheCtx.statisticsEnabled()) {
            long durationNanos = U.millisToNanos(U.currentTimeMillis() - tx.startTime());
            if (commit) {
                cacheCtx.cache().metrics0().onTxCommit(durationNanos);
            } else {
                cacheCtx.cache().metrics0().onTxRollback(durationNanos);
            }
        }
    }

    @Override
    public Map<Integer, Set<Integer>> touchedPartitions() {
        Map<Integer, Set<Integer>> parts = this.touchedParts;
        return parts != null ? Collections.unmodifiableMap(parts) : null;
    }

    @Override
    public void touchPartition(int cacheId, int partId) {
        if (this.touchedParts == null) {
            this.touchedParts = new HashMap<Integer, Set<Integer>>();
        }
        this.touchedParts.computeIfAbsent(cacheId, CREATE_INT_SET).add(partId);
    }
}

