/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueryJdbcValidationTask
extends ComputeTaskSplitAdapter<String, Boolean> {
    private static final long serialVersionUID = 0L;

    @Override
    protected Collection<? extends ComputeJob> split(int gridSize, final @Nullable String cacheName) {
        return Collections.singleton(new ComputeJobAdapter(){
            @IgniteInstanceResource
            private Ignite ignite;

            @Override
            public Object execute() {
                if (cacheName == null) {
                    return true;
                }
                GridDiscoveryManager discoMgr = ((IgniteKernal)this.ignite).context().discovery();
                for (ClusterNode n : this.ignite.cluster().nodes()) {
                    if (!discoMgr.cacheNode(n, cacheName)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Boolean reduce(List<ComputeJobResult> results) {
        return (Boolean)F.first(results).getData();
    }
}

