/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientNodeMetrics;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridClientNodeImpl
implements GridClientNode {
    private UUID nodeId;
    private Object consistentId;
    private List<String> tcpAddrs = Collections.emptyList();
    private List<String> tcpHostNames = Collections.emptyList();
    private int tcpPort;
    private Map<String, Object> attrs = Collections.emptyMap();
    private GridClientNodeMetrics metrics;
    private Map<String, GridClientCacheMode> caches = Collections.emptyMap();
    private boolean connectable;
    private final AtomicReference<Collection<InetSocketAddress>> tcpSockAddrs = new AtomicReference();
    private long order;

    private GridClientNodeImpl() {
    }

    public static Builder builder() {
        return new Builder(new GridClientNodeImpl());
    }

    public static Builder builder(GridClientNode from, boolean skipAttrs, boolean skipMetrics) {
        Builder b = new Builder(new GridClientNodeImpl()).nodeId(from.nodeId()).consistentId(from.consistentId()).tcpAddresses(from.tcpAddresses()).tcpPort(from.tcpPort()).caches(from.caches()).connectable(from.connectable()).order(from.order());
        if (!skipAttrs) {
            b.attributes(from.attributes());
        }
        if (!skipMetrics) {
            b.metrics(from.metrics());
        }
        return b;
    }

    @Override
    public UUID nodeId() {
        return this.nodeId;
    }

    @Override
    public Object consistentId() {
        return this.consistentId;
    }

    @Override
    public List<String> tcpAddresses() {
        return this.tcpAddrs;
    }

    @Override
    public List<String> tcpHostNames() {
        return this.tcpHostNames;
    }

    @Override
    public int tcpPort() {
        return this.tcpPort;
    }

    @Override
    public Map<String, Object> attributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    @Override
    @Nullable
    public <T> T attribute(String name) {
        return (T)this.attrs.get(name);
    }

    @Override
    public GridClientNodeMetrics metrics() {
        return this.metrics;
    }

    @Override
    public Map<String, GridClientCacheMode> caches() {
        return this.caches;
    }

    @Override
    public Collection<InetSocketAddress> availableAddresses(GridClientProtocol proto, boolean filterResolved) {
        if (proto != GridClientProtocol.TCP) {
            throw new AssertionError((Object)("Unknown protocol: " + (Object)((Object)proto)));
        }
        AtomicReference<Collection<InetSocketAddress>> addrsCache = this.tcpSockAddrs;
        List<String> addrs = this.tcpAddrs;
        List<String> hostNames = this.tcpHostNames;
        int port = this.tcpPort;
        Collection<InetSocketAddress> addrs0 = addrsCache.get();
        if (addrs0 != null) {
            return this.filterIfNecessary(addrs0, filterResolved);
        }
        addrs0 = U.toSocketAddresses(addrs, hostNames, port);
        if (!addrsCache.compareAndSet(null, addrs0)) {
            return this.filterIfNecessary(addrsCache.get(), filterResolved);
        }
        return this.filterIfNecessary(addrs0, filterResolved);
    }

    @Override
    public long order() {
        return this.order;
    }

    private Collection<InetSocketAddress> filterIfNecessary(Collection<InetSocketAddress> addrs, boolean filter) {
        if (!filter) {
            return addrs;
        }
        ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>(addrs.size());
        for (InetSocketAddress addr : addrs) {
            if (addr.isUnresolved()) continue;
            res.add(addr);
        }
        return res;
    }

    @Override
    public boolean connectable() {
        return this.connectable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridClientNodeImpl)) {
            return false;
        }
        GridClientNodeImpl that = (GridClientNodeImpl)o;
        return this.nodeId.equals(that.nodeId);
    }

    @Override
    public boolean isClient() {
        return Objects.equals(this.attribute("org.apache.ignite.cache.client"), true);
    }

    @Override
    public boolean isDaemon() {
        return "true".equals(this.attribute("org.apache.ignite.daemon"));
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return "GridClientNodeImpl [nodeId=" + this.nodeId + ", consistentId=" + this.consistentId + ", tcpAddrs=" + this.tcpAddrs + ", tcpHostNames=" + this.tcpHostNames + ", binaryPort=" + this.tcpPort + ']';
    }

    public static final class Builder {
        private GridClientNodeImpl impl;
        private boolean built;

        private Builder(GridClientNodeImpl impl2) {
            this.impl = impl2;
        }

        public GridClientNodeImpl build() {
            if (this.built) {
                throw new AssertionError((Object)"Instance already built.");
            }
            this.built = true;
            return this.impl;
        }

        public Builder nodeId(UUID nodeId) {
            this.impl.nodeId = nodeId;
            return this;
        }

        public Builder consistentId(Object consistentId) {
            this.impl.consistentId = consistentId;
            return this;
        }

        public Builder tcpAddresses(Collection<String> tcpAddrs) {
            this.impl.tcpAddrs = U.sealList(tcpAddrs);
            return this;
        }

        public Builder tcpHostNames(Collection<String> tcpHostNames) {
            this.impl.tcpHostNames = U.sealList(tcpHostNames);
            return this;
        }

        public Builder tcpPort(int tcpPort) {
            this.impl.tcpPort = tcpPort;
            return this;
        }

        public Builder attributes(Map<String, Object> attrs) {
            this.impl.attrs = U.sealMap(attrs);
            return this;
        }

        public Builder metrics(GridClientNodeMetrics metrics) {
            this.impl.metrics = metrics;
            return this;
        }

        public Builder caches(Map<String, GridClientCacheMode> caches) {
            this.impl.caches = U.sealMap(caches);
            return this;
        }

        public Builder connectable(boolean connectable) {
            this.impl.connectable = connectable;
            return this;
        }

        public Builder order(long order) {
            this.impl.order = order;
            return this;
        }
    }
}

