/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.ThreadLocalRowHandlerHolder;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.IORowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.LeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccInlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccLeafIO;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;

public abstract class AbstractInlineLeafIO
extends BPlusLeafIO<IndexRow>
implements InlineIO {
    private final int inlineSize;

    AbstractInlineLeafIO(short type, int ver, int metaSize, int inlineSize) {
        super(type, ver, metaSize + inlineSize);
        this.inlineSize = inlineSize;
    }

    public static void register() {
        AbstractInlineLeafIO.register(false);
        AbstractInlineLeafIO.register(true);
    }

    private static void register(boolean mvcc) {
        int type = mvcc ? 23000 : 10000;
        for (int payload = 1; payload <= 2048; payload = (int)((short)(payload + 1))) {
            short ioType = (short)(type + payload - 1);
            AbstractInlineLeafIO io = mvcc ? new MvccInlineLeafIO(ioType, payload) : new InlineLeafIO(ioType, payload);
            IOVersions versions = new IOVersions((PageIO[])new AbstractInlineLeafIO[]{io});
            PageIO.registerH2ExtraLeaf(versions, mvcc);
        }
    }

    @Override
    public final void storeByOffset(long pageAddr, int off, IndexRow row) {
        assert (row.link() != 0L) : row;
        this.assertPageType(pageAddr);
        int fieldOff = 0;
        InlineIndexRowHandler rowHnd = ThreadLocalRowHandlerHolder.rowHandler();
        for (int i = 0; i < rowHnd.inlineIndexKeyTypes().size(); ++i) {
            try {
                InlineIndexKeyType keyType = rowHnd.inlineIndexKeyTypes().get(i);
                int size = keyType.put(pageAddr, off + fieldOff, row.key(i), this.inlineSize - fieldOff);
                if (size == 0) break;
                fieldOff += size;
                continue;
            }
            catch (Exception e) {
                throw new IgniteException("Failed to store new index row.", e);
            }
        }
        IORowHandler.store(pageAddr, off + this.inlineSize, row, this.storeMvccInfo());
    }

    @Override
    public final IndexRow getLookupRow(BPlusTree<IndexRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = PageUtils.getLong(pageAddr, this.offset(idx) + this.inlineSize);
        assert (link != 0L);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.mvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.mvccCounter(pageAddr, idx);
            int mvccOpCntr = this.mvccOperationCounter(pageAddr, idx);
            return ((InlineIndexTree)tree).createMvccIndexRow(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((InlineIndexTree)tree).createIndexRow(link);
    }

    @Override
    public final void store(long dstPageAddr, int dstIdx, BPlusIO<IndexRow> srcIo, long srcPageAddr, int srcIdx) {
        this.assertPageType(dstPageAddr);
        int srcOff = srcIo.offset(srcIdx);
        byte[] payload = PageUtils.getBytes(srcPageAddr, srcOff, this.inlineSize);
        int dstOff = this.offset(dstIdx);
        PageUtils.putBytes(dstPageAddr, dstOff, payload);
        IORowHandler.store(dstPageAddr, dstOff + this.inlineSize, (InlineIO)((Object)srcIo), srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    @Override
    public long link(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + this.inlineSize);
    }

    @Override
    public int inlineSize() {
        return this.inlineSize;
    }

    public static IOVersions<? extends BPlusLeafIO<IndexRow>> versions(int payload, boolean mvccEnabled) {
        assert (payload >= 0 && payload <= 2048);
        if (payload == 0) {
            return mvccEnabled ? MvccLeafIO.VERSIONS : LeafIO.VERSIONS;
        }
        return PageIO.getLeafVersions((short)(payload - 1), mvccEnabled);
    }
}

