/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.internal.U;

public class InlineRecommender {
    public static final int DFLT_THROTTLE_INLINE_SIZE_CALCULATION = 1000;
    private final AtomicLong inlineSizeCalculationCntr = new AtomicLong();
    private final int inlineSizeThrottleThreshold = IgniteSystemProperties.getInteger("IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", 1000);
    private final AtomicInteger maxCalculatedInlineSize = new AtomicInteger();
    private final IgniteLogger log;
    private final SortedIndexDefinition def;

    public InlineRecommender(GridCacheContext<?, ?> cctx, SortedIndexDefinition def) {
        this.log = cctx.kernalContext().indexProcessor().logger();
        this.def = def;
    }

    public void recommend(IndexRow row, int currInlineSize) {
        boolean throttle;
        if (row.indexSearchRow()) {
            return;
        }
        long invokeCnt = this.inlineSizeCalculationCntr.get();
        if (!this.inlineSizeCalculationCntr.compareAndSet(invokeCnt, invokeCnt + 1L)) {
            return;
        }
        boolean bl = throttle = invokeCnt + (long)(1 % this.inlineSizeThrottleThreshold) != 0L;
        if (throttle) {
            return;
        }
        int newSize = 0;
        for (int i = 0; i < row.rowHandler().inlineIndexKeyTypes().size(); ++i) {
            InlineIndexKeyType keyType = row.rowHandler().inlineIndexKeyTypes().get(i);
            newSize += keyType.inlineSize(row.key(i));
        }
        if (newSize > currInlineSize) {
            int oldSize;
            do {
                if ((oldSize = this.maxCalculatedInlineSize.get()) < newSize) continue;
                return;
            } while (!this.maxCalculatedInlineSize.compareAndSet(oldSize, newSize));
            String cols = this.def.indexKeyDefinitions().keySet().stream().collect(Collectors.joining(", ", "(", ")"));
            String type = this.def.primary() ? "PRIMARY KEY" : (this.def.affinity() ? "AFFINITY KEY (implicit)" : "SECONDARY");
            String recommendation = this.def.primary() || this.def.affinity() ? "set system property IGNITE_MAX_INDEX_PAYLOAD_SIZE with recommended size (be aware it will be used by default for all indexes without explicit inline size)" : "use INLINE_SIZE option for CREATE INDEX command, QuerySqlField.inlineSize for annotated classes, or QueryIndex.inlineSize for explicit QueryEntity configuration";
            String warn = "Indexed columns of a row cannot be fully inlined into index what may lead to slowdown due to additional data page reads, increase index inline size if needed (" + recommendation + ") [cacheName=" + this.def.idxName().cacheName() + ", tableName=" + this.def.idxName().tableName() + ", idxName=" + this.def.idxName().idxName() + ", idxCols=" + cols + ", idxType=" + type + ", curSize=" + currInlineSize + ", recommendedInlineSize=" + newSize + "]";
            U.warn(this.log, warn);
        }
    }
}

