/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.net;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.utilities.test.io.CommonFiles;
import org.terracotta.utilities.test.net.PortManager;

class SystemLevelLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemLevelLocker.class);
    private static final Path RELATIVE_LOCK_FILE_PATH = Paths.get(SystemLevelLocker.class.getPackage().getName(), "portLockFile");
    private final Path lockFilePath;
    private FileChannel openChannel;
    private int outstandingLocks;

    SystemLevelLocker() {
        try {
            this.lockFilePath = CommonFiles.createCommonAppFile(RELATIVE_LOCK_FILE_PATH);
            if (!Files.isReadable(this.lockFilePath)) {
                throw new IllegalStateException("File is not readable: " + this.lockFilePath);
            }
            if (!Files.isWritable(this.lockFilePath)) {
                throw new IllegalStateException("File is not writable: " + this.lockFilePath);
            }
            LOGGER.info("Using system-level port lock file: {}", (Object)this.lockFilePath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create " + RELATIVE_LOCK_FILE_PATH + " in system common directory", e);
        }
    }

    synchronized boolean lock(PortManager.PortRef portRef) {
        int port = Objects.requireNonNull(portRef, "portRef").port();
        try {
            FileLock fileLock;
            if (this.openChannel == null) {
                LOGGER.info("Opening system-level port lock file {}", (Object)this.lockFilePath);
                this.openChannel = FileChannel.open(this.lockFilePath, StandardOpenOption.WRITE, StandardOpenOption.READ);
            }
            if ((fileLock = this.openChannel.tryLock(port, 1L, false)) != null) {
                ++this.outstandingLocks;
                portRef.onClose((p, o) -> {
                    assert (p == port);
                    this.release((int)p, fileLock);
                });
                LOGGER.info("Port {} reserved (system-level)", (Object)port);
                boolean bl = true;
                return bl;
            }
            LOGGER.trace("Port {} locked by another process", (Object)port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to obtain lock against \"%s\" for port %d", this.lockFilePath, port), e);
        }
        finally {
            this.closeChannelIfUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void release(int port, FileLock lock) {
        Objects.requireNonNull(lock, "lock");
        try {
            lock.release();
            LOGGER.info("Port {} released (system-level)", (Object)port);
        }
        catch (ClosedChannelException ignored) {
            LOGGER.info("Port {} already released (system-level): channel closed", (Object)port);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error while releasing lock against \"%s\" for port %s", this.lockFilePath, port), e);
        }
        finally {
            --this.outstandingLocks;
            this.closeChannelIfUnused();
        }
    }

    private void closeChannelIfUnused() {
        if (this.openChannel != null && this.outstandingLocks == 0) {
            try {
                LOGGER.info("Closing system-level port lock file {}", (Object)this.lockFilePath);
                this.openChannel.close();
            }
            catch (IOException e) {
                LOGGER.warn(String.format("Failed to close \"%s\"", this.lockFilePath), e);
            }
            finally {
                this.openChannel = null;
            }
        }
    }
}

