/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema.management;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.query.QueryTypeNameKey;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;

public class SchemaDescriptor {
    private final String schemaName;
    private final ConcurrentMap<String, TableDescriptor> tbls = new ConcurrentHashMap<String, TableDescriptor>();
    private final ConcurrentMap<QueryTypeNameKey, TableDescriptor> typeToTbl = new ConcurrentHashMap<QueryTypeNameKey, TableDescriptor>();
    private final boolean predefined;
    private int usageCnt;

    public SchemaDescriptor(String schemaName, boolean predefined) {
        this.schemaName = schemaName;
        this.predefined = predefined;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public void incrementUsageCount() {
        if (!this.predefined) {
            ++this.usageCnt;
        }
    }

    public boolean decrementUsageCount() {
        return !this.predefined && --this.usageCnt == 0;
    }

    public Collection<TableDescriptor> tables() {
        return this.tbls.values();
    }

    public TableDescriptor tableByName(String tblName) {
        return (TableDescriptor)this.tbls.get(tblName);
    }

    public TableDescriptor tableByTypeName(String cacheName, String typeName) {
        return (TableDescriptor)this.typeToTbl.get(new QueryTypeNameKey(cacheName, typeName));
    }

    public void add(TableDescriptor tbl) {
        if (this.tbls.putIfAbsent(tbl.type().tableName(), tbl) != null) {
            throw new IllegalStateException("Table already registered: " + tbl.type().tableName());
        }
        if (this.typeToTbl.putIfAbsent(new QueryTypeNameKey(tbl.cacheInfo().name(), tbl.type().name()), tbl) != null) {
            throw new IllegalStateException("Table already registered: " + tbl.type().tableName());
        }
    }

    public void drop(TableDescriptor tbl) {
        this.tbls.remove(tbl.type().tableName());
        this.typeToTbl.remove(new QueryTypeNameKey(tbl.cacheInfo().name(), tbl.type().name()));
    }

    public boolean predefined() {
        return this.predefined;
    }
}

