/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class SnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final UUID rqId;
    private final String snpName;
    private final String consId;
    private final String folderName;
    private final int pageSize;
    @GridToStringInclude
    private final List<Integer> grpIds;
    @GridToStringInclude
    private final Set<String> bltNodes;
    @GridToStringInclude
    private transient Map<Integer, Set<Integer>> locParts = new HashMap<Integer, Set<Integer>>();
    @GridToStringInclude
    @Nullable
    private final byte[] masterKeyDigest;

    public SnapshotMetadata(UUID rqId, String snpName, String consId, String folderName, int pageSize, List<Integer> grpIds, Set<String> bltNodes, Set<GroupPartitionId> pairs, @Nullable byte[] masterKeyDigest) {
        this.rqId = rqId;
        this.snpName = snpName;
        this.consId = consId;
        this.folderName = folderName;
        this.pageSize = pageSize;
        this.grpIds = grpIds;
        this.bltNodes = bltNodes;
        this.masterKeyDigest = masterKeyDigest;
        pairs.forEach(p -> this.locParts.computeIfAbsent(p.getGroupId(), k -> new HashSet()).add(p.getPartitionId()));
    }

    public UUID requestId() {
        return this.rqId;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public String consistentId() {
        return this.consId;
    }

    public String folderName() {
        return this.folderName;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public List<Integer> cacheGroupIds() {
        return this.grpIds;
    }

    public Set<String> baselineNodes() {
        return this.bltNodes;
    }

    public Map<Integer, Set<Integer>> partitions() {
        return Collections.unmodifiableMap(this.locParts);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.locParts.size());
        for (Map.Entry<Integer, Set<Integer>> e : this.locParts.entrySet()) {
            s.writeInt(e.getKey());
            s.writeInt(e.getValue().size());
            for (Integer partId : e.getValue()) {
                s.writeInt(partId);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        if (size < 0) {
            throw new InvalidObjectException("Illegal size: " + size);
        }
        this.locParts = U.newHashMap(size);
        for (int i = 0; i < size; ++i) {
            int grpId = s.readInt();
            int total = s.readInt();
            if (total < 0) {
                throw new InvalidObjectException("Illegal size: " + total);
            }
            HashSet parts = U.newHashSet(total);
            for (int k = 0; k < total; ++k) {
                parts.add(s.readInt());
            }
            this.locParts.put(grpId, parts);
        }
    }

    public boolean sameSnapshot(SnapshotMetadata compare) {
        return this.requestId().equals(compare.requestId()) && this.snapshotName().equals(compare.snapshotName()) && this.pageSize() == compare.pageSize() && Objects.equals(this.cacheGroupIds(), compare.cacheGroupIds()) && Arrays.equals(this.masterKeyDigest, compare.masterKeyDigest) && Objects.equals(this.baselineNodes(), compare.baselineNodes());
    }

    public byte[] masterKeyDigest() {
        return this.masterKeyDigest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotMetadata meta = (SnapshotMetadata)o;
        return this.rqId.equals(meta.rqId) && this.snpName.equals(meta.snpName) && this.consId.equals(meta.consId) && Objects.equals(this.grpIds, meta.grpIds) && Objects.equals(this.bltNodes, meta.bltNodes);
    }

    public int hashCode() {
        return Objects.hash(this.rqId, this.snpName, this.consId, this.grpIds, this.bltNodes);
    }

    public String toString() {
        return S.toString(SnapshotMetadata.class, this);
    }
}

