/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageSetFreeListPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageListMetaResetCountRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListAddPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListInitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListRemovePageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListSetNextRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListSetPreviousRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RecycleRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RotatedIdPartRecord;
import org.apache.ignite.internal.processors.cache.persistence.DataStructure;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CorruptedFreeListException;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.GridArrays;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public abstract class PagesList
extends DataStructure {
    public static final int DFLT_PAGES_LIST_TRY_LOCK_ATTEMPTS = 10;
    @SystemProperty(value="Maximum count of the stripes", type=Long.class, defaults="Maximum of 8 and available processors count")
    public static final String IGNITE_PAGES_LIST_STRIPES_PER_BUCKET = "IGNITE_PAGES_LIST_STRIPES_PER_BUCKET";
    @SystemProperty(value="Count of tries to lock stripe before fail back to blocking lock", type=Long.class, defaults="10")
    public static final String IGNITE_PAGES_LIST_TRY_LOCK_ATTEMPTS = "IGNITE_PAGES_LIST_TRY_LOCK_ATTEMPTS";
    private static final int TRY_LOCK_ATTEMPTS = IgniteSystemProperties.getInteger("IGNITE_PAGES_LIST_TRY_LOCK_ATTEMPTS", 10);
    private static final int MAX_STRIPES_PER_BUCKET = IgniteSystemProperties.getInteger("IGNITE_PAGES_LIST_STRIPES_PER_BUCKET", Math.max(8, Runtime.getRuntime().availableProcessors()));
    private final boolean pagesListCachingDisabledSysProp = IgniteSystemProperties.getBoolean("IGNITE_PAGES_LIST_DISABLE_ONHEAP_CACHING", false);
    protected final AtomicLongArray bucketsSize;
    protected volatile boolean changed;
    protected volatile boolean pageCacheChanged;
    private final long metaPageId;
    private final int buckets;
    private volatile boolean onheapListCachingEnabled;
    private final PageHandler<Void, Boolean> cutTail = new CutTail();
    private final PageHandler<Void, Boolean> putBucket = new PutBucket();
    protected final IgniteLogger log;

    protected PagesList(int cacheGrpId, String name, PageMemory pageMem, int buckets, @Nullable IgniteWriteAheadLogManager wal, long metaPageId, PageLockTrackerManager pageLockTrackerManager, GridKernalContext ctx, byte pageFlag) {
        super(name, cacheGrpId, null, pageMem, wal, pageLockTrackerManager, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER, pageFlag);
        this.buckets = buckets;
        this.metaPageId = metaPageId;
        this.onheapListCachingEnabled = this.isCachingApplicable();
        this.log = ctx.log(PagesList.class);
        this.bucketsSize = new AtomicLongArray(buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(long metaPageId, boolean initNew) throws IgniteCheckedException {
        if (metaPageId != 0L) {
            if (initNew) {
                this.init(metaPageId, PagesListMetaIO.VERSIONS.latest());
            } else {
                HashMap<Integer, GridLongList> bucketsData = new HashMap<Integer, GridLongList>();
                long nextId = metaPageId;
                while (nextId != 0L) {
                    long pageId = nextId;
                    long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
                    try {
                        long pageAddr = this.readLock(pageId, page);
                        assert (pageAddr != 0L);
                        try {
                            PagesListMetaIO io = PagesListMetaIO.VERSIONS.forPage(pageAddr);
                            io.getBucketsData(pageAddr, bucketsData);
                            nextId = io.getNextMetaPageId(pageAddr);
                            assert (nextId != pageId) : "Loop detected [next=" + U.hexLong(nextId) + ", cur=" + U.hexLong(pageId) + ']';
                        }
                        finally {
                            this.readUnlock(pageId, page, pageAddr);
                        }
                    }
                    finally {
                        this.releasePage(pageId, page);
                    }
                }
                for (Map.Entry e : bucketsData.entrySet()) {
                    int bucket = (Integer)e.getKey();
                    long bucketSize = 0L;
                    Stripe[] old = this.getBucket(bucket);
                    assert (old == null);
                    long[] upd = ((GridLongList)e.getValue()).array();
                    Stripe[] tails = new Stripe[upd.length];
                    for (int i = 0; i < upd.length; ++i) {
                        Stripe stripe;
                        long tailId;
                        long prevId = tailId = upd[i];
                        int cnt = 0;
                        while (prevId != 0L) {
                            long pageId = prevId;
                            long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
                            try {
                                long pageAddr = this.readLock(pageId, page);
                                assert (pageAddr != 0L);
                                try {
                                    PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
                                    cnt += io.getCount(pageAddr);
                                    prevId = io.getPreviousId(pageAddr);
                                    if (!this.isReuseBucket(bucket) || prevId == 0L) continue;
                                    ++cnt;
                                }
                                finally {
                                    this.readUnlock(pageId, page, pageAddr);
                                }
                            }
                            finally {
                                this.releasePage(pageId, page);
                            }
                        }
                        tails[i] = stripe = new Stripe(tailId, cnt == 0);
                        bucketSize += (long)cnt;
                    }
                    boolean ok = this.casBucket(bucket, null, tails);
                    assert (ok);
                    this.bucketsSize.set(bucket, bucketSize);
                }
            }
        }
    }

    private boolean isCachingApplicable() {
        return !this.pagesListCachingDisabledSysProp && this.wal != null;
    }

    public void saveMetadata(IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long nextPageId = this.metaPageId;
        assert (nextPageId != 0L);
        this.flushBucketsCache(statHolder);
        if (!this.changed) {
            return;
        }
        this.changed = false;
        try {
            long unusedPageId = this.writeFreeList(nextPageId);
            this.markUnusedPagesDirty(unusedPageId);
        }
        catch (Throwable e) {
            this.changed = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBucketsCache(IoStatisticsHolder statHolder) throws IgniteCheckedException {
        if (!this.isCachingApplicable() || !this.pageCacheChanged) {
            return;
        }
        this.pageCacheChanged = false;
        this.onheapListCachingEnabled = false;
        int lockedPages = 0;
        try {
            for (int bucket = 0; bucket < this.buckets; ++bucket) {
                GridLongList pages;
                PagesCache pagesCache = this.getBucketCache(bucket, false);
                if (pagesCache == null || (pages = pagesCache.flush()) == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Move pages from heap to PageMemory [list=" + this.name() + ", bucket=" + bucket + ", pages=" + pages + ']');
                }
                for (int i = 0; i < pages.size(); ++i) {
                    Boolean res;
                    long pageId = pages.get(i);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Move page from heap to PageMemory [list=" + this.name() + ", bucket=" + bucket + ", pageId=" + pageId + ']');
                    }
                    if ((res = (Boolean)this.write(pageId, this.putBucket, bucket, null, statHolder)) != null) continue;
                    pagesCache.add(pageId);
                    ++lockedPages;
                }
            }
        }
        finally {
            this.onheapListCachingEnabled = true;
        }
        if (lockedPages != 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Several pages were locked and weren't flushed on disk [grp=" + this.grpName + ", lockedPages=" + lockedPages + ']');
            }
            this.pageCacheChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeFreeList(long nextPageId) throws IgniteCheckedException {
        long curId = 0L;
        long curPage = 0L;
        long curAddr = 0L;
        PagesListMetaIO curIo = null;
        try {
            for (int bucket = 0; bucket < this.buckets; ++bucket) {
                Stripe[] tails = this.getBucket(bucket);
                if (tails == null) continue;
                int tailIdx = 0;
                while (tailIdx < tails.length) {
                    int written;
                    int n = written = curPage != 0L ? curIo.addTails(this.pageMem.realPageSize(this.grpId), curAddr, bucket, tails, tailIdx) : 0;
                    if (written == 0) {
                        if (nextPageId == 0L) {
                            nextPageId = this.allocatePageNoReuse();
                            if (curPage != 0L) {
                                curIo.setNextMetaPageId(curAddr, nextPageId);
                                this.releaseAndClose(curId, curPage, curAddr);
                            }
                            curId = nextPageId;
                            curPage = this.acquirePage(curId, IoStatisticsHolderNoOp.INSTANCE);
                            curAddr = this.writeLock(curId, curPage);
                            curIo = PagesListMetaIO.VERSIONS.latest();
                            curIo.initNewPage(curAddr, curId, this.pageSize(), this.metrics);
                        } else {
                            this.releaseAndClose(curId, curPage, curAddr);
                            curId = nextPageId;
                            curPage = this.acquirePage(curId, IoStatisticsHolderNoOp.INSTANCE);
                            curAddr = this.writeLock(curId, curPage);
                            curIo = PagesListMetaIO.VERSIONS.forPage(curAddr);
                            curIo.resetCount(curAddr);
                        }
                        nextPageId = curIo.getNextMetaPageId(curAddr);
                        continue;
                    }
                    tailIdx += written;
                }
            }
        }
        finally {
            this.releaseAndClose(curId, curPage, curAddr);
        }
        return nextPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnusedPagesDirty(long nextPageId) throws IgniteCheckedException {
        while (nextPageId != 0L) {
            long pageId = nextPageId;
            long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
            try {
                long pageAddr = this.writeLock(pageId, page);
                try {
                    PagesListMetaIO io = PagesListMetaIO.VERSIONS.forPage(pageAddr);
                    io.resetCount(pageAddr);
                    if (this.needWalDeltaRecord(pageId, page, null)) {
                        this.wal.log(new PageListMetaResetCountRecord(this.grpId, pageId));
                    }
                    nextPageId = io.getNextMetaPageId(pageAddr);
                }
                finally {
                    this.writeUnlock(pageId, page, pageAddr, true);
                }
            }
            finally {
                this.releasePage(pageId, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAndClose(long pageId, long page, long pageAddr) {
        if (page != 0L) {
            try {
                this.writeUnlock(pageId, page, pageAddr, Boolean.TRUE, true);
            }
            finally {
                this.releasePage(pageId, page);
            }
        }
    }

    protected abstract int getBucketIndex(int var1);

    protected abstract Stripe[] getBucket(int var1);

    protected abstract boolean casBucket(int var1, Stripe[] var2, Stripe[] var3);

    protected abstract boolean isReuseBucket(int var1);

    protected abstract PagesCache getBucketCache(int var1, boolean var2);

    private void setupNextPage(PagesListNodeIO io, long prevId, long prev, long nextId, long next) {
        assert (io.getNextId(prev) == 0L);
        io.initNewPage(next, nextId, this.pageSize(), this.metrics);
        io.setPreviousId(next, prevId);
        io.setNextId(prev, nextId);
    }

    private Stripe addStripe(int bucket, ReuseBag bag, boolean reuse) throws IgniteCheckedException {
        Stripe[] upd;
        Stripe[] old;
        long pageId = this.allocatePage(bag, reuse);
        this.init(pageId, PagesListNodeIO.VERSIONS.latest());
        Stripe stripe = new Stripe(pageId, true);
        do {
            if ((old = this.getBucket(bucket)) != null) {
                int len = old.length;
                upd = Arrays.copyOf(old, len + 1);
                upd[len] = stripe;
                continue;
            }
            upd = new Stripe[]{stripe};
        } while (!this.casBucket(bucket, old, upd));
        this.changed();
        return stripe;
    }

    private boolean updateTail(int bucket, long oldTailId, long newTailId) {
        int idx = -1;
        try {
            while (true) {
                Object[] tails = this.getBucket(bucket);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Update tail [list=" + this.name() + ", bucket=" + bucket + ", oldTailId=" + oldTailId + ", newTailId=" + newTailId + ", tails=" + Arrays.toString(tails));
                }
                assert (!F.isEmpty(tails)) : "Missing tails [bucket=" + bucket + ", tails=" + Arrays.toString(tails) + ", metaPage=" + U.hexLong(this.metaPageId) + ", grpId=" + this.grpId + ']';
                idx = PagesList.findTailIndex((Stripe[])tails, oldTailId, idx);
                assert (tails[idx].tailId == oldTailId);
                if (newTailId == 0L) {
                    if (tails.length <= MAX_STRIPES_PER_BUCKET / 2) {
                        ((Stripe)tails[idx]).empty = true;
                        boolean bl = false;
                        return bl;
                    }
                    Stripe[] newTails = tails.length != 1 ? (Stripe[])GridArrays.remove(tails, idx) : null;
                    if (this.casBucket(bucket, (Stripe[])tails, newTails)) {
                        ((Stripe)tails[idx]).tailId = 0L;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    tails[idx].tailId = newTailId;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.changed();
        }
    }

    private static int findTailIndex(Stripe[] tails, long tailId, int expIdx) {
        if (expIdx != -1 && tails.length > expIdx && tails[expIdx].tailId == tailId) {
            return expIdx;
        }
        for (int i = 0; i < tails.length; ++i) {
            if (tails[i].tailId != tailId) continue;
            return i;
        }
        throw new IllegalStateException("Tail not found: " + tailId);
    }

    private Stripe getPageForPut(int bucket, ReuseBag bag) throws IgniteCheckedException {
        IgniteThread igniteThread = IgniteThread.current();
        Stripe[] tails = this.getBucket(bucket);
        if (igniteThread != null && igniteThread.policy() == 9) {
            int stripeIdx = igniteThread.stripe();
            assert (stripeIdx != -1) : igniteThread;
            while (tails == null || stripeIdx >= tails.length) {
                this.addStripe(bucket, bag, true);
                tails = this.getBucket(bucket);
            }
            return tails[stripeIdx];
        }
        if (tails == null) {
            return this.addStripe(bucket, bag, true);
        }
        return PagesList.randomTail(tails);
    }

    private static Stripe randomTail(Stripe[] tails) {
        int len = tails.length;
        assert (len != 0);
        return tails[PagesList.randomInt(len)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long storedPagesCount(int bucket) throws IgniteCheckedException {
        long res = 0L;
        Stripe[] tails = this.getBucket(bucket);
        if (tails != null) {
            for (Stripe tail : tails) {
                long tailId = tail.tailId;
                while (tailId != 0L) {
                    long pageId = tailId;
                    long page = this.acquirePage(pageId, IoStatisticsHolderNoOp.INSTANCE);
                    try {
                        long pageAddr = this.readLock(pageId, page);
                        assert (pageAddr != 0L);
                        try {
                            PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
                            int cnt = io.getCount(pageAddr);
                            assert (cnt >= 0);
                            res += (long)cnt;
                            tailId = io.getPreviousId(pageAddr);
                            if (!this.isReuseBucket(bucket) || tailId == 0L) continue;
                            ++res;
                        }
                        finally {
                            this.readUnlock(pageId, page, pageAddr);
                        }
                    }
                    finally {
                        this.releasePage(pageId, page);
                    }
                }
            }
        }
        assert (res == this.bucketsSize.get(bucket)) : "Wrong bucket size counter [exp=" + res + ", cntr=" + this.bucketsSize.get(bucket) + ']';
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void put(@Nullable ReuseBag bag, long dataId, long dataPage, long dataAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (bag == null ^ dataAddr == 0L);
        if (bag != null && bag.isEmpty()) {
            return;
        }
        if (bag == null && this.onheapListCachingEnabled && this.putDataPage(this.getBucketCache(bucket, true), dataId, dataPage, dataAddr, bucket)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Put page to pages list cache [list=" + this.name() + ", bucket=" + bucket + ", dataId=" + dataId + ']');
            }
            return;
        }
        int lockAttempt = 0;
        while (true) {
            Stripe stripe = this.getPageForPut(bucket, bag);
            if (bag != null && bag.isEmpty()) {
                return;
            }
            long tailId = stripe.tailId;
            if (tailId == 0L) continue;
            long tailPage = this.acquirePage(tailId, statHolder);
            try {
                long tailAddr = this.writeLockPage(tailId, tailPage, bucket, lockAttempt++, bag);
                if (tailAddr == 0L) {
                    if (bag == null || !bag.isEmpty()) continue;
                    return;
                }
                if (stripe.tailId != tailId) {
                    this.writeUnlock(tailId, tailPage, tailAddr, false);
                    --lockAttempt;
                    continue;
                }
                assert (PageIO.getPageId(tailAddr) == tailId) : "tailId = " + U.hexLong(tailId) + ", pageId = " + U.hexLong(PageIO.getPageId(tailAddr));
                assert (PageIO.getType(tailAddr) == 13) : "tailId = " + U.hexLong(tailId) + ", type = " + PageIO.getType(tailAddr);
                boolean ok = false;
                try {
                    PagesListNodeIO io = (PagesListNodeIO)PageIO.getPageIO(tailAddr);
                    ok = bag != null ? this.putReuseBag(tailId, tailPage, tailAddr, io, bag, bucket, statHolder) : this.putDataPage(tailId, tailPage, tailAddr, io, dataId, dataPage, dataAddr, bucket, statHolder);
                    if (!ok) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Put page to pages list [list=" + this.name() + ", bucket=" + bucket + ", dataId=" + dataId + ", tailId=" + tailId + ']');
                    }
                    stripe.empty = false;
                    return;
                }
                finally {
                    this.writeUnlock(tailId, tailPage, tailAddr, ok);
                    continue;
                }
            }
            finally {
                this.releasePage(tailId, tailPage);
                continue;
            }
            break;
        }
    }

    private boolean putDataPage(long pageId, long page, long pageAddr, PagesListNodeIO io, long dataId, long dataPage, long dataAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        if (io.getNextId(pageAddr) != 0L) {
            return false;
        }
        int idx = io.addPage(pageAddr, dataId, this.pageSize());
        if (idx == -1) {
            this.handlePageFull(pageId, page, pageAddr, io, dataId, dataPage, dataAddr, bucket, statHolder);
        } else {
            this.incrementBucketSize(bucket);
            if (this.needWalDeltaRecord(pageId, page, null)) {
                this.wal.log(new PagesListAddPageRecord(this.grpId, pageId, dataId));
            }
            AbstractDataPageIO dataIO = (AbstractDataPageIO)PageIO.getPageIO(dataAddr);
            dataIO.setFreeListPageId(dataAddr, pageId);
            if (this.needWalDeltaRecord(dataId, dataPage, null)) {
                this.wal.log(new DataPageSetFreeListPageRecord(this.grpId, dataId, pageId));
            }
        }
        return true;
    }

    private boolean putDataPage(PagesCache pagesCache, long dataId, long dataPage, long dataAddr, int bucket) throws IgniteCheckedException {
        if (pagesCache.add(dataId)) {
            this.incrementBucketSize(bucket);
            AbstractDataPageIO dataIO = (AbstractDataPageIO)PageIO.getPageIO(dataAddr);
            if (dataIO.getFreeListPageId(dataAddr) != 0L) {
                dataIO.setFreeListPageId(dataAddr, 0L);
                if (this.needWalDeltaRecord(dataId, dataPage, null)) {
                    this.wal.log(new DataPageSetFreeListPageRecord(this.grpId, dataId, 0L));
                }
            }
            this.pageCacheChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePageFull(long pageId, long page, long pageAddr, PagesListNodeIO io, long dataId, long data, long dataAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        AbstractDataPageIO dataIO = (AbstractDataPageIO)PageIO.getPageIO(dataAddr);
        if (this.isReuseBucket(bucket)) {
            assert (dataIO.isEmpty(dataAddr));
            long newDataId = PageIdUtils.changeType(dataId, (byte)2);
            this.setupNextPage(io, pageId, pageAddr, newDataId, dataAddr);
            if (this.needWalDeltaRecord(pageId, page, null)) {
                this.wal.log(new PagesListSetNextRecord(this.grpId, pageId, newDataId));
            }
            if (this.needWalDeltaRecord(dataId, data, null)) {
                this.wal.log(new PagesListInitNewPageRecord(this.grpId, dataId, io.getType(), io.getVersion(), newDataId, pageId, 0L));
            }
            this.incrementBucketSize(bucket);
            this.updateTail(bucket, pageId, newDataId);
        } else {
            long nextId = this.allocatePage(null);
            long nextPage = this.acquirePage(nextId, statHolder);
            try {
                long nextPageAddr = this.writeLock(nextId, nextPage);
                assert (nextPageAddr != 0L);
                Boolean nextWalPlc = Boolean.FALSE;
                try {
                    this.setupNextPage(io, pageId, pageAddr, nextId, nextPageAddr);
                    if (this.needWalDeltaRecord(pageId, page, null)) {
                        this.wal.log(new PagesListSetNextRecord(this.grpId, pageId, nextId));
                    }
                    int idx = io.addPage(nextPageAddr, dataId, this.pageSize());
                    if (this.needWalDeltaRecord(nextId, nextPage, nextWalPlc)) {
                        this.wal.log(new PagesListInitNewPageRecord(this.grpId, nextId, io.getType(), io.getVersion(), nextId, pageId, dataId));
                    }
                    assert (idx != -1);
                    dataIO.setFreeListPageId(dataAddr, nextId);
                    if (this.needWalDeltaRecord(dataId, data, null)) {
                        this.wal.log(new DataPageSetFreeListPageRecord(this.grpId, dataId, nextId));
                    }
                    this.incrementBucketSize(bucket);
                    this.updateTail(bucket, pageId, nextId);
                }
                finally {
                    this.writeUnlock(nextId, nextPage, nextPageAddr, nextWalPlc, true);
                }
            }
            finally {
                this.releasePage(nextId, nextPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putReuseBag(long pageId, long page, long pageAddr, PagesListNodeIO io, ReuseBag bag, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (bag != null) : "bag is null";
        assert (!bag.isEmpty()) : "bag is empty";
        if (io.getNextId(pageAddr) != 0L) {
            return false;
        }
        long prevId = pageId;
        long prevPage = page;
        long prevAddr = pageAddr;
        Boolean walPlc = null;
        GridLongList locked = null;
        try {
            long nextId;
            while ((nextId = bag.pollFreePage()) != 0L) {
                assert (PageIdUtils.itemId(nextId) > 0 && PageIdUtils.itemId(nextId) <= 254) : U.hexLong(nextId);
                int idx = io.addPage(prevAddr, nextId, this.pageSize());
                if (idx == -1) {
                    long nextPage = this.acquirePage(nextId, statHolder);
                    try {
                        long nextPageAddr = this.writeLock(nextId, nextPage);
                        assert (nextPageAddr != 0L);
                        if (locked == null) {
                            locked = new GridLongList(6);
                        }
                        locked.add(nextId);
                        locked.add(nextPage);
                        locked.add(nextPageAddr);
                        this.setupNextPage(io, prevId, prevAddr, nextId, nextPageAddr);
                        if (this.needWalDeltaRecord(prevId, prevPage, walPlc)) {
                            this.wal.log(new PagesListSetNextRecord(this.grpId, prevId, nextId));
                        }
                        if (this.needWalDeltaRecord(nextId, nextPage, Boolean.FALSE)) {
                            this.wal.log(new PagesListInitNewPageRecord(this.grpId, nextId, io.getType(), io.getVersion(), nextId, prevId, 0L));
                        }
                        if (this.isReuseBucket(bucket)) {
                            this.incrementBucketSize(bucket);
                        }
                        prevAddr = nextPageAddr;
                        prevId = nextId;
                        prevPage = nextPage;
                        walPlc = Boolean.FALSE;
                        continue;
                    }
                    finally {
                        this.releasePage(nextId, nextPage);
                        continue;
                    }
                }
                if (this.needWalDeltaRecord(prevId, prevPage, walPlc)) {
                    this.wal.log(new PagesListAddPageRecord(this.grpId, prevId, nextId));
                }
                this.incrementBucketSize(bucket);
            }
        }
        finally {
            if (locked != null) {
                this.updateTail(bucket, pageId, prevId);
                for (int i = 0; i < locked.size(); i += 3) {
                    this.writeUnlock(locked.get(i), locked.get(i + 1), locked.get(i + 2), Boolean.FALSE, true);
                }
            }
        }
        return true;
    }

    private Stripe getPageForTake(int bucket) {
        int init;
        Stripe[] tails = this.getBucket(bucket);
        if (tails == null || this.bucketsSize.get(bucket) == 0L) {
            return null;
        }
        int len = tails.length;
        IgniteThread igniteThread = IgniteThread.current();
        if (igniteThread != null && igniteThread.policy() == 9) {
            int stripeIdx = igniteThread.stripe();
            assert (stripeIdx != -1) : igniteThread;
            if (stripeIdx >= len) {
                return null;
            }
            Stripe stripe = tails[stripeIdx];
            return stripe.empty ? null : stripe;
        }
        int cur = init = PagesList.randomInt(len);
        do {
            Stripe stripe = tails[cur];
            if (stripe.empty) continue;
            return stripe;
        } while ((cur = (cur + 1) % len) != init);
        return null;
    }

    private long writeLockPage(long pageId, long page, int bucket, int lockAttempt, ReuseBag bag) throws IgniteCheckedException {
        Stripe[] stripes;
        IgniteThread igniteThread = IgniteThread.current();
        if (igniteThread != null && igniteThread.policy() == 9) {
            assert (igniteThread.stripe() != -1) : igniteThread;
            return this.writeLock(pageId, page);
        }
        long pageAddr = this.tryWriteLock(pageId, page);
        if (pageAddr != 0L) {
            return pageAddr;
        }
        if (lockAttempt == TRY_LOCK_ATTEMPTS && ((stripes = this.getBucket(bucket)) == null || stripes.length < MAX_STRIPES_PER_BUCKET)) {
            this.addStripe(bucket, bag, !this.isReuseBucket(bucket));
            return 0L;
        }
        return lockAttempt < TRY_LOCK_ATTEMPTS ? 0L : this.writeLock(pageId, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long takeEmptyPage(int bucket, @Nullable IOVersions initIoVers, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long pageId;
        PagesCache pagesCache = this.getBucketCache(bucket, false);
        if (pagesCache != null && (pageId = pagesCache.poll()) != 0L) {
            this.decrementBucketSize(bucket);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Take page from pages list cache [list=" + this.name() + ", bucket=" + bucket + ", pageId=" + pageId + ']');
            }
            assert (!this.isReuseBucket(bucket)) : "reuse bucket detected";
            return pageId;
        }
        int lockAttempt = 0;
        Stripe stripe;
        while ((stripe = this.getPageForTake(bucket)) != null) {
            long tailId = stripe.tailId;
            if (tailId == 0L) continue;
            long tailPage = this.acquirePage(tailId, statHolder);
            try {
                long dataPageId;
                long tailAddr;
                if ((tailAddr = this.writeLockPage(tailId, tailPage, bucket, lockAttempt++, null)) == 0L) continue;
                if (stripe.empty || stripe.tailId != tailId) {
                    this.writeUnlock(tailId, tailPage, tailAddr, false);
                    if (this.bucketsSize.get(bucket) > 0L) {
                        --lockAttempt;
                        continue;
                    }
                    long l = 0L;
                    return l;
                }
                assert (PageIO.getPageId(tailAddr) == tailId) : "tailId = " + U.hexLong(tailId) + ", pageId = " + U.hexLong(PageIO.getPageId(tailAddr));
                assert (PageIO.getType(tailAddr) == 13) : "tailId = " + U.hexLong(tailId) + ", type = " + PageIO.getType(tailAddr);
                boolean dirty = false;
                long recycleId = 0L;
                try {
                    PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(tailAddr);
                    if (io.getNextId(tailAddr) != 0L) continue;
                    pageId = io.takeAnyPage(tailAddr);
                    if (pageId != 0L) {
                        this.decrementBucketSize(bucket);
                        if (this.needWalDeltaRecord(tailId, tailPage, null)) {
                            this.wal.log(new PagesListRemovePageRecord(this.grpId, tailId, pageId));
                        }
                        dirty = true;
                        if (this.isReuseBucket(bucket) && (PageIdUtils.itemId(pageId) <= 0 || PageIdUtils.itemId(pageId) > 254)) {
                            throw this.corruptedFreeListException("Incorrectly recycled pageId in reuse bucket: " + U.hexLong(pageId), pageId);
                        }
                        if (this.isReuseBucket(bucket)) {
                            byte flag = this.getFlag(initIoVers);
                            PageIO initIO = initIoVers == null ? null : (PageIO)initIoVers.latest();
                            dataPageId = this.initRecycledPage0(pageId, flag, initIO);
                        } else {
                            dataPageId = pageId;
                        }
                        if (io.isEmpty(tailAddr)) {
                            long prevId = io.getPreviousId(tailAddr);
                            if (!this.isReuseBucket(bucket)) {
                                if (prevId != 0L) {
                                    Boolean ok = this.write(prevId, this.cutTail, null, bucket, Boolean.FALSE, statHolder);
                                    assert (ok == Boolean.TRUE) : ok;
                                    recycleId = this.recyclePage(tailId, tailPage, tailAddr, null);
                                } else {
                                    stripe.empty = true;
                                }
                            } else {
                                stripe.empty = prevId == 0L;
                            }
                        }
                    } else {
                        assert (this.isReuseBucket(bucket));
                        long prevId = io.getPreviousId(tailAddr);
                        assert (prevId != 0L);
                        Boolean ok = this.write(prevId, this.cutTail, bucket, Boolean.FALSE, statHolder);
                        assert (ok == Boolean.TRUE) : ok;
                        this.decrementBucketSize(bucket);
                        byte flag = this.getFlag(initIoVers);
                        PageIO pageIO = initIoVers != null ? (PageIO)initIoVers.latest() : null;
                        dataPageId = this.initReusedPage(tailId, tailPage, tailAddr, PageIdUtils.partId(tailId), flag, pageIO);
                        dirty = true;
                    }
                }
                finally {
                    this.writeUnlock(tailId, tailPage, tailAddr, dirty);
                    continue;
                }
                if (recycleId != 0L) {
                    assert (!this.isReuseBucket(bucket));
                    this.reuseList.addForRecycle(new SingletonReuseBag(recycleId));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Take page from pages list [list=" + this.name() + ", bucket=" + bucket + ", dataPageId=" + dataPageId + ", tailId=" + tailId + ']');
                }
                long l = dataPageId;
                return l;
            }
            finally {
                this.releasePage(tailId, tailPage);
                continue;
            }
            break;
        }
        return 0L;
    }

    private byte getFlag(IOVersions<?> initIoVers) {
        if (initIoVers != null) {
            Object pageIO = initIoVers.latest();
            switch (((PageIO)pageIO).getType()) {
                case 1: 
                case 11: 
                case 21: 
                case 32: {
                    return 1;
                }
            }
        }
        return this.pageFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long initRecycledPage0(long pageId, byte flag, PageIO initIO) throws IgniteCheckedException {
        long page = this.pageMem.acquirePage(this.grpId, pageId);
        try {
            long l;
            long pageAddr = this.pageMem.writeLock(this.grpId, pageId, page);
            try {
                l = this.initReusedPage(pageId, page, pageAddr, PageIdUtils.partId(pageId), flag, initIO);
            }
            catch (Throwable throwable) {
                this.pageMem.writeUnlock(this.grpId, pageId, page, null, true);
                throw throwable;
            }
            this.pageMem.writeUnlock(this.grpId, pageId, page, null, true);
            return l;
        }
        finally {
            this.pageMem.releasePage(this.grpId, pageId, page);
        }
    }

    protected final long initReusedPage(long reusedPageId, long reusedPage, long reusedPageAddr, int partId, byte flag, PageIO initIo) throws IgniteCheckedException {
        long storedPageId;
        int itemId;
        if (flag == 2) {
            partId = 65535;
        }
        long newPageId = PageIdUtils.pageId(partId, flag, PageIdUtils.pageIndex(reusedPageId));
        boolean needWalDeltaRecord = this.needWalDeltaRecord(reusedPageId, reusedPage, null);
        if (initIo != null) {
            initIo.initNewPage(reusedPageAddr, newPageId, this.pageSize(), this.metrics);
            if (needWalDeltaRecord) {
                assert (PageIdUtils.partId(reusedPageId) == PageIdUtils.partId(newPageId)) : "Partition consistency failure: newPageId=" + Long.toHexString(newPageId) + " (newPartId: " + PageIdUtils.partId(newPageId) + ") reusedPageId=" + Long.toHexString(reusedPageId) + " (partId: " + PageIdUtils.partId(reusedPageId) + ")";
                this.wal.log(new InitNewPageRecord(this.grpId, reusedPageId, initIo.getType(), initIo.getVersion(), newPageId));
            }
        }
        if ((itemId = PageIdUtils.itemId(reusedPageId)) != 0) {
            if (flag == 1) {
                PageIO.setRotatedIdPart(reusedPageAddr, itemId);
                if (needWalDeltaRecord) {
                    this.wal.log(new RotatedIdPartRecord(this.grpId, newPageId, itemId));
                }
            } else {
                newPageId = PageIdUtils.link(newPageId, itemId);
            }
        }
        if ((storedPageId = PageIO.getPageId(reusedPageAddr)) != newPageId) {
            PageIO.setPageId(reusedPageAddr, newPageId);
            if (needWalDeltaRecord) {
                this.wal.log(new RecycleRecord(this.grpId, storedPageId, newPageId));
            }
        }
        return newPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean removeDataPage(long dataId, long dataPage, long dataAddr, AbstractDataPageIO dataIO, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long pageId = dataIO.getFreeListPageId(dataAddr);
        if (pageId == 0L) {
            assert (this.isCachingApplicable()) : "pageId==0L, but caching is not applicable for this pages list: " + this.name();
            PagesCache pagesCache = this.getBucketCache(bucket, false);
            if (pagesCache != null && pagesCache.removePage(dataId)) {
                this.decrementBucketSize(bucket);
                if (!this.log.isDebugEnabled()) return true;
                this.log.debug("Remove page from pages list cache [list=" + this.name() + ", bucket=" + bucket + ", dataId=" + dataId + ']');
                return true;
            }
            if (!this.log.isDebugEnabled()) return false;
            this.log.debug("Remove page from pages list cache failed [list=" + this.name() + ", bucket=" + bucket + ", dataId=" + dataId + "]: " + (pagesCache == null ? "cache is null" : "page not found"));
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove page from pages list [list=" + this.name() + ", bucket=" + bucket + ", dataId=" + dataId + ", pageId=" + pageId + ']');
        }
        long page = this.acquirePage(pageId, statHolder);
        try {
            long nextId;
            long recycleId = 0L;
            long pageAddr = this.writeLock(pageId, page);
            if (pageAddr == 0L) {
                boolean bl = false;
                return bl;
            }
            boolean rmvd = false;
            try {
                PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
                rmvd = io.removePage(pageAddr, dataId);
                if (!rmvd) {
                    boolean bl = false;
                    return bl;
                }
                this.decrementBucketSize(bucket);
                if (this.needWalDeltaRecord(pageId, page, null)) {
                    this.wal.log(new PagesListRemovePageRecord(this.grpId, pageId, dataId));
                }
                dataIO.setFreeListPageId(dataAddr, 0L);
                if (this.needWalDeltaRecord(dataId, dataPage, null)) {
                    this.wal.log(new DataPageSetFreeListPageRecord(this.grpId, dataId, 0L));
                }
                if (!io.isEmpty(pageAddr)) {
                    boolean bl = true;
                    return bl;
                }
                nextId = io.getNextId(pageAddr);
                if (nextId == 0L) {
                    long prevId = io.getPreviousId(pageAddr);
                    recycleId = this.mergeNoNext(pageId, page, pageAddr, prevId, bucket, statHolder);
                }
            }
            finally {
                this.writeUnlock(pageId, page, pageAddr, rmvd);
            }
            if (nextId != 0L) {
                recycleId = this.merge(pageId, page, nextId, bucket, statHolder);
            }
            if (recycleId != 0L) {
                this.reuseList.addForRecycle(new SingletonReuseBag(recycleId));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    private long mergeNoNext(long pageId, long page, long pageAddr, long prevId, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        if (this.isReuseBucket(bucket)) {
            return 0L;
        }
        if (prevId != 0L) {
            Boolean ok = this.write(prevId, this.cutTail, null, bucket, Boolean.FALSE, statHolder);
            assert (ok == Boolean.TRUE) : ok;
        } else {
            boolean rmvd = this.updateTail(bucket, pageId, 0L);
            if (!rmvd) {
                return 0L;
            }
        }
        return this.recyclePage(pageId, page, pageAddr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long merge(long pageId, long page, long nextId, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (nextId != 0L);
        while (true) {
            long curId;
            long curPage = (curId = nextId) == 0L ? 0L : this.acquirePage(curId, statHolder);
            try {
                boolean write = false;
                long curAddr = curPage == 0L ? 0L : this.writeLock(curId, curPage);
                long pageAddr = this.writeLock(pageId, page);
                if (pageAddr == 0L) {
                    if (curAddr != 0L) {
                        this.writeUnlock(curId, curPage, curAddr, false);
                    }
                    long l = 0L;
                    return l;
                }
                try {
                    PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
                    if (!io.isEmpty(pageAddr)) {
                        long l = 0L;
                        return l;
                    }
                    if (io.getNextId(pageAddr) == curId && curId == 0L == (curAddr == 0L)) {
                        long recycleId = this.doMerge(pageId, page, pageAddr, io, curId, curPage, curAddr, bucket, statHolder);
                        write = true;
                        long l = recycleId;
                        return l;
                    }
                    nextId = io.getNextId(pageAddr);
                    continue;
                }
                finally {
                    if (curAddr != 0L) {
                        this.writeUnlock(curId, curPage, curAddr, write);
                    }
                    this.writeUnlock(pageId, page, pageAddr, write);
                    continue;
                }
            }
            finally {
                if (curPage == 0L) continue;
                this.releasePage(curId, curPage);
                continue;
            }
            break;
        }
    }

    private long doMerge(long pageId, long page, long pageAddr, PagesListNodeIO io, long nextId, long nextPage, long nextAddr, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long prevId = io.getPreviousId(pageAddr);
        if (nextId == 0L) {
            return this.mergeNoNext(pageId, page, pageAddr, prevId, bucket, statHolder);
        }
        assert (PageIO.getPageId(nextAddr) == nextId);
        if (prevId == 0L) {
            assert (PagesListNodeIO.VERSIONS.forPage(nextAddr).getPreviousId(nextAddr) == pageId);
            PagesListNodeIO nextIO = PagesListNodeIO.VERSIONS.forPage(nextAddr);
            nextIO.setPreviousId(nextAddr, 0L);
            if (this.needWalDeltaRecord(nextId, nextPage, null)) {
                this.wal.log(new PagesListSetPreviousRecord(this.grpId, nextId, 0L));
            }
        } else {
            this.fairMerge(prevId, pageId, nextId, nextPage, nextAddr, statHolder);
        }
        return this.recyclePage(pageId, page, pageAddr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fairMerge(long prevId, long pageId, long nextId, long nextPage, long nextAddr, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        long prevPage = this.acquirePage(prevId, statHolder);
        try {
            long prevAddr = this.writeLock(prevId, prevPage);
            assert (prevAddr != 0L);
            try {
                PagesListNodeIO prevIO = PagesListNodeIO.VERSIONS.forPage(prevAddr);
                PagesListNodeIO nextIO = PagesListNodeIO.VERSIONS.forPage(nextAddr);
                assert (prevIO.getNextId(prevAddr) == pageId);
                assert (nextIO.getPreviousId(nextAddr) == pageId);
                prevIO.setNextId(prevAddr, nextId);
                if (this.needWalDeltaRecord(prevId, prevPage, null)) {
                    this.wal.log(new PagesListSetNextRecord(this.grpId, prevId, nextId));
                }
                nextIO.setPreviousId(nextAddr, prevId);
                if (this.needWalDeltaRecord(nextId, nextPage, null)) {
                    this.wal.log(new PagesListSetPreviousRecord(this.grpId, nextId, prevId));
                }
            }
            finally {
                this.writeUnlock(prevId, prevPage, prevAddr, true);
            }
        }
        finally {
            this.releasePage(prevId, prevPage);
        }
    }

    private void incrementBucketSize(int bucket) {
        this.bucketsSize.incrementAndGet(bucket);
    }

    private void decrementBucketSize(int bucket) {
        this.bucketsSize.decrementAndGet(bucket);
    }

    private void changed() {
        if (!this.changed) {
            this.changed = true;
        }
    }

    private void pageCacheChanged() {
        if (!this.pageCacheChanged) {
            this.pageCacheChanged = true;
        }
    }

    public int bucketsCount() {
        return this.buckets;
    }

    public long bucketSize(int bucket) {
        return this.bucketsSize.get(bucket);
    }

    public int stripesCount(int bucket) {
        Stripe[] stripes = this.getBucket(bucket);
        return stripes == null ? 0 : stripes.length;
    }

    public int cachedPagesCount(int bucket) {
        PagesCache pagesCache = this.getBucketCache(bucket, false);
        return pagesCache == null ? 0 : pagesCache.size();
    }

    public long metaPageId() {
        return this.metaPageId;
    }

    protected CorruptedFreeListException corruptedFreeListException(Throwable err, long ... pageIds) {
        return this.corruptedFreeListException(err.getMessage(), err, pageIds);
    }

    protected CorruptedFreeListException corruptedFreeListException(String msg, long ... pageIds) {
        return this.corruptedFreeListException(msg, null, pageIds);
    }

    protected CorruptedFreeListException corruptedFreeListException(String msg, @Nullable Throwable err, long ... pageIds) {
        return new CorruptedFreeListException(msg, err, this.grpId, pageIds);
    }

    public static final class Stripe {
        public volatile long tailId;
        public volatile boolean empty;

        public Stripe(long tailId, boolean empty) {
            this.tailId = tailId;
            this.empty = empty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stripe stripe = (Stripe)o;
            return F.eq(this.tailId, stripe.tailId) && F.eq(this.empty, stripe.empty);
        }

        public int hashCode() {
            return Objects.hash(this.tailId, this.empty);
        }

        public String toString() {
            return Long.toString(this.tailId);
        }
    }

    public static class PagesCache {
        public static final int DFLT_PAGES_LIST_CACHING_MAX_CACHE_SIZE = 64;
        public static final int DFLT_PAGES_LIST_CACHING_STRIPES_COUNT = 4;
        public static final int DFLT_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD = 10;
        @SystemProperty(value="Pages cache maximum size", type=Long.class, defaults="64")
        public static final String IGNITE_PAGES_LIST_CACHING_MAX_CACHE_SIZE = "IGNITE_PAGES_LIST_CACHING_MAX_CACHE_SIZE";
        @SystemProperty(value="Stripes count. Must be power of 2", type=Long.class, defaults="4")
        public static final String IGNITE_PAGES_LIST_CACHING_STRIPES_COUNT = "IGNITE_PAGES_LIST_CACHING_STRIPES_COUNT";
        @SystemProperty(value="The threshold of flush calls on empty caches to allow GC of stripes (the flush is triggered two times per checkpoint)", type=Long.class, defaults="10")
        public static final String IGNITE_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD = "IGNITE_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD";
        private static final int MAX_SIZE = IgniteSystemProperties.getInteger("IGNITE_PAGES_LIST_CACHING_MAX_CACHE_SIZE", 64);
        private static final int STRIPES_COUNT = IgniteSystemProperties.getInteger("IGNITE_PAGES_LIST_CACHING_STRIPES_COUNT", 4);
        private static final int EMPTY_FLUSH_GC_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_PAGES_LIST_CACHING_EMPTY_FLUSH_GC_THRESHOLD", 10);
        private final Object[] stripeLocks = new Object[STRIPES_COUNT];
        private final GridLongList[] stripes = new GridLongList[STRIPES_COUNT];
        private static final AtomicIntegerFieldUpdater<PagesCache> nextStripeUpdater = AtomicIntegerFieldUpdater.newUpdater(PagesCache.class, "nextStripeIdx");
        private static final AtomicIntegerFieldUpdater<PagesCache> sizeUpdater = AtomicIntegerFieldUpdater.newUpdater(PagesCache.class, "size");
        private volatile int nextStripeIdx;
        private volatile int size;
        private int emptyFlushCnt;
        private final AtomicLong pagesCacheLimit;

        public PagesCache(@Nullable AtomicLong pagesCacheLimit) {
            assert (U.isPow2(STRIPES_COUNT)) : STRIPES_COUNT;
            for (int i = 0; i < STRIPES_COUNT; ++i) {
                this.stripeLocks[i] = new Object();
            }
            this.pagesCacheLimit = pagesCacheLimit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removePage(long pageId) {
            int stripeIdx = (int)pageId & STRIPES_COUNT - 1;
            Object object = this.stripeLocks[stripeIdx];
            synchronized (object) {
                boolean rmvd;
                GridLongList stripe = this.stripes[stripeIdx];
                boolean bl = rmvd = stripe != null && stripe.removeValue(0, pageId) >= 0;
                if (rmvd && sizeUpdater.decrementAndGet(this) == 0 && this.pagesCacheLimit != null) {
                    this.pagesCacheLimit.incrementAndGet();
                }
                return rmvd;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long poll() {
            if (this.size == 0) {
                return 0L;
            }
            for (int i = 0; i < STRIPES_COUNT; ++i) {
                int stripeIdx = nextStripeUpdater.getAndIncrement(this) & STRIPES_COUNT - 1;
                Object object = this.stripeLocks[stripeIdx];
                synchronized (object) {
                    GridLongList stripe = this.stripes[stripeIdx];
                    if (stripe != null && !stripe.isEmpty()) {
                        if (sizeUpdater.decrementAndGet(this) == 0 && this.pagesCacheLimit != null) {
                            this.pagesCacheLimit.incrementAndGet();
                        }
                        return stripe.remove();
                    }
                    continue;
                }
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GridLongList flush() {
            GridLongList res = null;
            if (this.size == 0) {
                boolean stripesChanged = false;
                if (this.emptyFlushCnt >= 0 && ++this.emptyFlushCnt >= EMPTY_FLUSH_GC_THRESHOLD) {
                    for (int i = 0; i < STRIPES_COUNT; ++i) {
                        Object object = this.stripeLocks[i];
                        synchronized (object) {
                            GridLongList stripe = this.stripes[i];
                            if (stripe != null) {
                                if (stripe.isEmpty()) {
                                    this.stripes[i] = null;
                                } else {
                                    stripesChanged = true;
                                    break;
                                }
                            }
                            continue;
                        }
                    }
                    if (!stripesChanged) {
                        this.emptyFlushCnt = -1;
                    }
                }
                if (!stripesChanged) {
                    return null;
                }
            }
            this.emptyFlushCnt = 0;
            for (int i = 0; i < STRIPES_COUNT; ++i) {
                Object object = this.stripeLocks[i];
                synchronized (object) {
                    GridLongList stripe = this.stripes[i];
                    if (stripe != null && !stripe.isEmpty()) {
                        if (res == null) {
                            res = new GridLongList(this.size);
                        }
                        if (sizeUpdater.addAndGet(this, -stripe.size()) == 0 && this.pagesCacheLimit != null) {
                            this.pagesCacheLimit.incrementAndGet();
                        }
                        res.addAll(stripe);
                        stripe.clear();
                    }
                    continue;
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(long pageId) {
            assert (pageId != 0L);
            if (this.size == 0 && this.pagesCacheLimit != null && this.pagesCacheLimit.get() <= 0L) {
                return false;
            }
            if (this.size >= MAX_SIZE) {
                return false;
            }
            int stripeIdx = (int)pageId & STRIPES_COUNT - 1;
            Object object = this.stripeLocks[stripeIdx];
            synchronized (object) {
                GridLongList stripe = this.stripes[stripeIdx];
                if (stripe == null) {
                    this.stripes[stripeIdx] = stripe = new GridLongList(MAX_SIZE / STRIPES_COUNT);
                }
                if (stripe.size() >= MAX_SIZE / STRIPES_COUNT) {
                    return false;
                }
                stripe.add(pageId);
                if (sizeUpdater.getAndIncrement(this) == 0 && this.pagesCacheLimit != null) {
                    this.pagesCacheLimit.decrementAndGet();
                }
                return true;
            }
        }

        public int size() {
            return this.size;
        }
    }

    private static final class SingletonReuseBag
    implements ReuseBag {
        long pageId;

        SingletonReuseBag(long pageId) {
            this.pageId = pageId;
        }

        @Override
        public void addFreePage(long pageId) {
            throw new IllegalStateException("Should never be called.");
        }

        @Override
        public long pollFreePage() {
            long res = this.pageId;
            this.pageId = 0L;
            return res;
        }

        @Override
        public boolean isEmpty() {
            return this.pageId == 0L;
        }

        public String toString() {
            return S.toString(SingletonReuseBag.class, this, "pageId", (Object)U.hexLong(this.pageId));
        }
    }

    private final class PutBucket
    extends PageHandler<Void, Boolean> {
        private PutBucket() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, Void ignore, int oldBucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            PagesList.this.decrementBucketSize(oldBucket);
            int freeSpace = ((AbstractDataPageIO)iox).getFreeSpace(pageAddr);
            int newBucket = PagesList.this.getBucketIndex(freeSpace);
            if (newBucket != oldBucket && PagesList.this.log.isDebugEnabled()) {
                PagesList.this.log.debug("Bucket changed when moving from heap to PageMemory [list=" + PagesList.this.name() + ", oldBucket=" + oldBucket + ", newBucket=" + newBucket + ", pageId=" + pageId + ']');
            }
            if (newBucket >= 0) {
                PagesList.this.put(null, pageId, page, pageAddr, newBucket, statHolder);
            }
            return Boolean.TRUE;
        }
    }

    private final class CutTail
    extends PageHandler<Void, Boolean> {
        private CutTail() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, Void ignore, int bucket, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            assert (PageIO.getPageId(pageAddr) == pageId);
            PagesListNodeIO io = (PagesListNodeIO)iox;
            long tailId = io.getNextId(pageAddr);
            assert (tailId != 0L);
            io.setNextId(pageAddr, 0L);
            if (PagesList.this.needWalDeltaRecord(pageId, page, walPlc)) {
                PagesList.this.wal.log(new PagesListSetNextRecord(cacheId, pageId, 0L));
            }
            PagesList.this.updateTail(bucket, tailId, pageId);
            return Boolean.TRUE;
        }
    }
}

