/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccDataPageClosure;
import org.apache.ignite.internal.transactions.IgniteTxUnexpectedStateCheckedException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;

public class InlineTreeFilterClosure
implements BPlusTree.TreeRowClosure<IndexRow, IndexRow>,
MvccDataPageClosure {
    private final MvccSnapshot mvccSnapshot;
    private final IndexingQueryCacheFilter cacheFilter;
    private final BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter;
    private final GridCacheContext<?, ?> cctx;
    private final IgniteLogger log;

    public InlineTreeFilterClosure(IndexingQueryCacheFilter cacheFilter, BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter, MvccSnapshot mvccSnapshot, GridCacheContext<?, ?> cctx, IgniteLogger log) {
        assert ((cacheFilter != null || mvccSnapshot != null) && cctx != null);
        this.cacheFilter = cacheFilter;
        this.rowFilter = rowFilter;
        this.mvccSnapshot = mvccSnapshot;
        this.cctx = cctx;
        this.log = log;
    }

    @Override
    public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        boolean val;
        boolean bl = val = this.cacheFilter == null || this.applyFilter((InlineIO)((Object)io), pageAddr, idx);
        if (!val) {
            return false;
        }
        if (this.rowFilter != null) {
            val = this.rowFilter.apply(tree, io, pageAddr, idx);
        }
        if (val && this.mvccSnapshot != null) {
            return this.applyMvcc((InlineIO)((Object)io), pageAddr, idx);
        }
        return val;
    }

    private boolean applyFilter(InlineIO io, long pageAddr, int idx) {
        assert (this.cacheFilter != null);
        return this.cacheFilter.applyPartition(PageIdUtils.partId(PageIdUtils.pageId(io.link(pageAddr, idx))));
    }

    private boolean applyMvcc(InlineIO io, long pageAddr, int idx) throws IgniteCheckedException {
        assert (io.storeMvccInfo()) : io;
        long rowCrdVer = io.mvccCoordinatorVersion(pageAddr, idx);
        long rowCntr = io.mvccCounter(pageAddr, idx);
        int rowOpCntr = io.mvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid(rowCrdVer, rowCntr, rowOpCntr));
        try {
            return MvccUtils.isVisible(this.cctx, this.mvccSnapshot, rowCrdVer, rowCntr, rowOpCntr, io.link(pageAddr, idx));
        }
        catch (IgniteTxUnexpectedStateCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unexpected tx state on index lookup. " + X.getFullStackTrace(e));
            }
            return false;
        }
    }

    @Override
    public boolean applyMvcc(DataPageIO io, long dataPageAddr, int itemId, int pageSize) throws IgniteCheckedException {
        try {
            return MvccUtils.isVisible(this.cctx, this.mvccSnapshot, io, dataPageAddr, itemId, pageSize);
        }
        catch (IgniteTxUnexpectedStateCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unexpected tx state on index lookup. " + X.getFullStackTrace(e));
            }
            return false;
        }
    }

    public String toString() {
        return S.toString(InlineTreeFilterClosure.class, this);
    }
}

