/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.FileUtils;
import org.terracotta.angela.common.util.IpUtils;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.ProcessUtil;
import org.zeroturnaround.process.Processes;

public class Agent
implements AutoCloseable {
    public static final String AGENT_TYPE_ORCHESTRATOR = "orchestrator-agent";
    public static final String AGENT_TYPE_REMOTE = "remote-agent";
    public static final String AGENT_IS_READY_MARKER_LOG = "Agent is ready";
    public static final Path ROOT_DIR;
    public static final Path WORK_DIR;
    private static final Path IGNITE_DIR;
    private static final Logger logger;
    private final UUID group;
    private final AgentID agentID;
    private final Ignite ignite;

    public Agent(UUID group, AgentID agentID, Ignite ignite) {
        this.group = group;
        this.agentID = agentID;
        this.ignite = ignite;
    }

    public UUID getGroupId() {
        return this.group;
    }

    public AgentID getAgentID() {
        return this.agentID;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public String toString() {
        return this.agentID.toString();
    }

    @Override
    public void close() {
        logger.info("Shutting down agent: {}", (Object)this.agentID);
        if (this.ignite != null) {
            try {
                this.ignite.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        String instanceName = System.getProperty("angela.instanceName");
        if (instanceName == null) {
            throw new AssertionError((Object)"angela.instanceName is missing");
        }
        String group = System.getProperty("angela.group");
        if (group == null) {
            throw new AssertionError((Object)"angela.group is missing");
        }
        DefaultPortAllocator portAllocator = new DefaultPortAllocator();
        Agent agent = Agent.ignite(UUID.fromString(group), instanceName, portAllocator, Arrays.asList(System.getProperty("angela.directJoin", "").split(",")));
        AgentID localAgentID = agent.getAgentID();
        logger.info("Agent: {} Root directory: {}", (Object)localAgentID, (Object)ROOT_DIR);
        logger.info("Agent: {} Work directory: {}", (Object)localAgentID, (Object)WORK_DIR);
        logger.info("Agent: {} Ignite directory: {}", (Object)localAgentID, (Object)IGNITE_DIR);
        AgentController agentController = new AgentController(localAgentID, portAllocator);
        AgentController.setUniqueInstance(agentController);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        1.sleep(5000L);
                        logger.warn("Forcefully killing agent after 10 seconds");
                        ProcessUtil.destroyForcefullyAndWait(Processes.newPidProcess(PidUtil.getMyPid()));
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            logger.info("Closing Ignite...");
            agent.close();
            try {
                portAllocator.close();
            }
            catch (Exception exception) {
            }
            finally {
                AgentController.removeUniqueInstance(agentController);
            }
        }));
        System.out.println("Agent is ready: " + localAgentID);
        System.out.flush();
    }

    public static Agent local(UUID group) {
        return new Agent(group, AgentID.local(), null);
    }

    public static Agent igniteOrchestrator(UUID group, PortAllocator portAllocator) {
        return Agent.ignite(group, AGENT_TYPE_ORCHESTRATOR, portAllocator, Collections.emptyList());
    }

    public static Agent ignite(UUID group, String instanceName, PortAllocator portAllocator, Collection<String> peers) {
        Ignite ignite;
        System.setProperty("IGNITE_NO_SHUTDOWN_HOOK", "true");
        System.setProperty("IGNITE_UPDATE_NOTIFIER", "false");
        FileUtils.createAndValidateDir(ROOT_DIR);
        FileUtils.createAndValidateDir(WORK_DIR);
        FileUtils.createAndValidateDir(IGNITE_DIR);
        PortAllocator.PortReservation portReservation = portAllocator.reserve(2);
        int igniteDiscoveryPort = (Integer)portReservation.next();
        int igniteComPort = (Integer)portReservation.next();
        String hostname = IpUtils.getHostName();
        final AgentID agentID = new AgentID(instanceName, hostname, igniteDiscoveryPort, PidUtil.getMyPid());
        logger.info("Starting Ignite agent: {} with com port: {}...", (Object)agentID, (Object)igniteComPort);
        IgniteConfiguration cfg = new IgniteConfiguration();
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        userAttributes.put("angela.version", AngelaVersion.getAngelaVersion());
        userAttributes.put("angela.nodeName", agentID.toString());
        userAttributes.put("angela.group", group.toString());
        userAttributes.put("angela.process", System.getProperty("angela.process", "inline"));
        cfg.setUserAttributes(userAttributes);
        boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
        cfg.setShutdownPolicy(ShutdownPolicy.IMMEDIATE);
        cfg.setGridLogger(enableLogging ? new Slf4jLogger() : new NullLogger());
        cfg.setPeerClassLoadingEnabled(true);
        cfg.setMetricsLogFrequency(0L);
        cfg.setIgniteInstanceName(agentID.getNodeName());
        cfg.setIgniteHome(IGNITE_DIR.resolve(System.getProperty("user.name")).toString());
        cfg.setDiscoverySpi(new TcpDiscoverySpi().setLocalPort(igniteDiscoveryPort).setLocalPortRange(0).setIpFinder(new TcpDiscoveryVmIpFinder(true).setAddresses(peers)));
        cfg.setCommunicationSpi(new TcpCommunicationSpi().setLocalPort(igniteComPort).setLocalPortRange(0));
        logger.info("Connecting agent: {} to peers: {}", (Object)agentID, (Object)peers);
        try {
            ignite = Ignition.start(cfg);
        }
        catch (IgniteException e) {
            throw new RuntimeException("Error starting node " + agentID, e);
        }
        ignite.message(ignite.cluster().forRemotes()).localListen("SYSTEM", (uuid, msg) -> {
            switch (String.valueOf(msg)) {
                case "close": {
                    new Thread(){
                        {
                            this.setDaemon(true);
                        }

                        @Override
                        @SuppressFBWarnings(value={"DM_EXIT"})
                        public void run() {
                            logger.info("Agent: {} received a shutdown request. Exiting...", (Object)agentID);
                            System.exit(0);
                        }
                    }.start();
                    return false;
                }
            }
            return true;
        });
        Agent agent = new Agent(group, agentID, ignite);
        logger.info("Started agent: {} in group: {}", (Object)agentID, (Object)agent.getGroupId());
        return agent;
    }

    static {
        System.setProperty("logback.configurationFile", Boolean.getBoolean("angela.agent.debug") ? "angela-logback-debug.xml" : "angela-logback.xml");
        logger = LoggerFactory.getLogger(Agent.class);
        ROOT_DIR = Paths.get(AngelaProperties.getEitherOf(AngelaProperties.ROOT_DIR, AngelaProperties.KITS_DIR), new String[0]);
        if (!ROOT_DIR.isAbsolute()) {
            throw new IllegalArgumentException("Expected ROOT_DIR to be an absolute path, got: " + ROOT_DIR);
        }
        WORK_DIR = ROOT_DIR.resolve("work");
        IGNITE_DIR = ROOT_DIR.resolve("ignite");
    }
}

