/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.index.IndexListInfoContainer;
import org.apache.ignite.internal.visor.cache.index.IndexListTaskArg;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class IndexListTask
extends VisorOneNodeTask<IndexListTaskArg, Set<IndexListInfoContainer>> {
    private static final long serialVersionUID = 0L;
    public static final String EMPTY_GROUP_NAME = "no_group";

    protected IndexListJob job(IndexListTaskArg arg) {
        return new IndexListJob(arg, this.debug);
    }

    private static class IndexListJob
    extends VisorJob<IndexListTaskArg, Set<IndexListInfoContainer>> {
        private static final long serialVersionUID = 0L;

        protected IndexListJob(@Nullable IndexListTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Set<IndexListInfoContainer> run(@Nullable IndexListTaskArg arg) throws IgniteException {
            if (arg == null) {
                throw new IgniteException("IndexListTaskArg is null");
            }
            Pattern indexesPtrn = this.getPattern(arg.indexesRegEx());
            Pattern groupsPtrn = this.getPattern(arg.groupsRegEx());
            Pattern cachesPtrn = this.getPattern(arg.cachesRegEx());
            HashSet<IndexListInfoContainer> idxInfos = new HashSet<IndexListInfoContainer>();
            for (GridCacheContext ctx : this.ignite.context().cache().context().cacheContexts()) {
                String cacheName = ctx.name();
                String grpName = ctx.config().getGroupName();
                String grpNameToValidate = grpName == null ? IndexListTask.EMPTY_GROUP_NAME : grpName;
                if (!IndexListJob.isNameValid(groupsPtrn, grpNameToValidate) || !IndexListJob.isNameValid(cachesPtrn, cacheName)) continue;
                Collection<Index> idxs = this.ignite.context().indexProcessor().indexes(cacheName);
                for (Index idx : idxs) {
                    InlineIndexImpl idx0;
                    if (!IndexListJob.isNameValid(indexesPtrn, idx.name()) || (idx0 = idx.unwrap(InlineIndexImpl.class)) == null) continue;
                    idxInfos.add(IndexListJob.constructContainer(ctx, idx0));
                }
            }
            return idxInfos;
        }

        @Nullable
        private Pattern getPattern(String regex) {
            return regex == null ? null : Pattern.compile(regex.toLowerCase());
        }

        private static IndexListInfoContainer constructContainer(GridCacheContext<?, ?> ctx, InlineIndexImpl idx) {
            return new IndexListInfoContainer(ctx, idx.indexDefinition().idxName().idxName(), idx.indexDefinition().indexKeyDefinitions().keySet(), idx.indexDefinition().idxName().tableName());
        }

        private static boolean isNameValid(Pattern pattern, String name) {
            if (pattern == null) {
                return true;
            }
            return pattern.matcher(name.toLowerCase()).find();
        }
    }
}

