/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.management.JMException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mxbean.IgniteMXBean;

public class IgniteMXBeanImpl
implements IgniteMXBean {
    private final IgniteKernal kernal;
    private final GridKernalContext ctx;

    public IgniteMXBeanImpl(IgniteKernal kernal) {
        this.kernal = kernal;
        this.ctx = kernal.context();
    }

    @Override
    public boolean active() {
        return this.kernal.active();
    }

    @Override
    public void active(boolean active) throws JMException {
        this.clusterState(active ? ClusterState.ACTIVE.toString() : ClusterState.INACTIVE.toString(), false);
    }

    @Override
    public String getCopyright() {
        return IgniteVersionUtils.COPYRIGHT;
    }

    @Override
    public long getStartTimestamp() {
        return this.kernal.startTimestamp();
    }

    @Override
    public String getStartTimestampFormatted() {
        return this.kernal.startTimeFormatted();
    }

    @Override
    public long getUpTime() {
        return this.kernal.upTime();
    }

    @Override
    public long getLongJVMPausesCount() {
        return this.kernal.longJVMPausesCount();
    }

    @Override
    public long getLongJVMPausesTotalDuration() {
        return this.kernal.longJVMPausesTotalDuration();
    }

    @Override
    public Map<Long, Long> getLongJVMPauseLastEvents() {
        return this.kernal.longJVMPauseLastEvents();
    }

    @Override
    public String getUpTimeFormatted() {
        return this.kernal.upTimeFormatted();
    }

    @Override
    public String getFullVersion() {
        return this.kernal.fullVersion();
    }

    @Override
    public String getCheckpointSpiFormatted() {
        return this.kernal.checkpointSpiFormatted();
    }

    @Override
    public String getCurrentCoordinatorFormatted() {
        return this.kernal.currentCoordinatorFormatted();
    }

    @Override
    public boolean isNodeInBaseline() {
        return this.kernal.nodeInBaseline();
    }

    @Override
    public String getCommunicationSpiFormatted() {
        return this.kernal.communicationSpiFormatted();
    }

    @Override
    public String getDeploymentSpiFormatted() {
        return this.kernal.deploymentSpiFormatted();
    }

    @Override
    public String getDiscoverySpiFormatted() {
        return this.kernal.discoverySpiFormatted();
    }

    @Override
    public String getEventStorageSpiFormatted() {
        return this.kernal.eventStorageSpiFormatted();
    }

    @Override
    public String getCollisionSpiFormatted() {
        return this.kernal.collisionSpiFormatted();
    }

    @Override
    public String getFailoverSpiFormatted() {
        return this.kernal.failoverSpiFormatted();
    }

    @Override
    public String getLoadBalancingSpiFormatted() {
        return this.kernal.loadBalancingSpiFormatted();
    }

    @Override
    public String getOsInformation() {
        return this.kernal.osInformation();
    }

    @Override
    public String getJdkInformation() {
        return this.kernal.jdkInformation();
    }

    @Override
    public String getOsUser() {
        return this.kernal.osUser();
    }

    @Override
    public void printLastErrors() {
        this.kernal.printLastErrors();
    }

    @Override
    public String getVmName() {
        return this.kernal.vmName();
    }

    @Override
    public String getInstanceName() {
        return this.kernal.name();
    }

    @Override
    public String getExecutorServiceFormatted() {
        return this.kernal.executorServiceFormatted();
    }

    @Override
    public String getIgniteHome() {
        return this.kernal.igniteHome();
    }

    @Override
    public String getGridLoggerFormatted() {
        return this.kernal.gridLoggerFormatted();
    }

    @Override
    public String getMBeanServerFormatted() {
        return this.kernal.mbeanServerFormatted();
    }

    @Override
    public UUID getLocalNodeId() {
        return this.kernal.localNodeId();
    }

    @Override
    public List<String> getUserAttributesFormatted() {
        return this.kernal.userAttributesFormatted();
    }

    @Override
    public boolean isPeerClassLoadingEnabled() {
        return this.kernal.peerClassLoadingEnabled();
    }

    @Override
    public List<String> getLifecycleBeansFormatted() {
        return this.kernal.lifecycleBeansFormatted();
    }

    @Override
    public String clusterState() {
        return this.kernal.clusterState();
    }

    @Override
    public long lastClusterStateChangeTime() {
        return this.kernal.lastClusterStateChangeTime();
    }

    @Override
    public boolean removeCheckpoint(String key) {
        A.notNull(key, "key");
        return this.kernal.removeCheckpoint(key);
    }

    @Override
    public boolean pingNode(String nodeId) {
        A.notNull(nodeId, "nodeId");
        return this.kernal.cluster().pingNode(UUID.fromString(nodeId));
    }

    @Override
    public void undeployTaskFromGrid(String taskName) throws JMException {
        A.notNull(taskName, "taskName");
        try {
            this.kernal.compute().undeployTask(taskName);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public String executeTask(String taskName, String arg) throws JMException {
        try {
            return (String)this.kernal.compute().execute(taskName, arg);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public boolean pingNodeByAddress(String host) throws JMException {
        this.ctx.gateway().readLock();
        try {
            for (ClusterNode n : this.kernal.cluster().nodes()) {
                if (!n.addresses().contains(host)) continue;
                boolean bl = this.ctx.discovery().pingNode(n.id());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.jmException(U.convertException(e));
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public void dumpDebugInfo() {
        this.kernal.dumpDebugInfo();
    }

    @Override
    public void runIoTest(long warmup, long duration, int threads, long maxLatency, int rangesCnt, int payLoadSize, boolean procFromNioThread) {
        this.ctx.io().runIoTest(warmup, duration, threads, maxLatency, rangesCnt, payLoadSize, procFromNioThread, new ArrayList<ClusterNode>(this.ctx.cluster().get().forServers().forRemotes().nodes()));
    }

    @Override
    public void clearNodeLocalMap() {
        this.ctx.cluster().get().clearNodeMap();
    }

    @Override
    public void clusterState(String state) throws JMException {
        this.clusterState(state, false);
    }

    @Override
    public void clusterState(String state, boolean forceDeactivation) throws JMException {
        ClusterState newState = ClusterState.valueOf(state);
        this.ctx.gateway().readLock();
        try {
            this.ctx.state().changeGlobalState(newState, forceDeactivation, this.ctx.cluster().get().forServers().nodes(), false).get();
        }
        catch (IgniteCheckedException e) {
            throw U.jmException(e);
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public boolean isRebalanceEnabled() {
        return this.kernal.isRebalanceEnabled();
    }

    @Override
    public void rebalanceEnabled(boolean rebalanceEnabled) {
        this.kernal.rebalanceEnabled(rebalanceEnabled);
    }
}

