/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class SecurityRootDirectory
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String TRUSTED_AUTHORITY_DIR_NAME = "trusted-authority";
    static final String IDENTITY_DIR_NAME = "identity";
    static final String ACCESS_CONTROL_DIR_NAME = "access-control";
    @Deprecated
    public static final String WHITE_LIST_DEPRECATED_DIR_NAME = "whitelist-deprecated";
    @Deprecated
    public static final String WHITE_LIST_DEPRECATED_FILE_NAME = "whitelist-deprecated.txt";
    static final String WHITE_LIST_FILE_NAME = "whitelist.txt";
    private final Map<String, byte[]> identityMap;
    private final Map<String, byte[]> trustedAuthorityMap;
    private final Map<String, byte[]> accessControlMap;
    private final Map<String, byte[]> whiteListDeprecatedMap;
    private byte[] whiteListFileContent;

    private SecurityRootDirectory(Path securityRootDirectory) {
        Path identityDir = securityRootDirectory.resolve(IDENTITY_DIR_NAME);
        if (Files.exists(identityDir, new LinkOption[0])) {
            this.identityMap = new HashMap<String, byte[]>();
            SecurityRootDirectory.storeContentsToMap(identityDir, this.identityMap);
        } else {
            this.identityMap = null;
        }
        Path trustedAuthorityDir = securityRootDirectory.resolve(TRUSTED_AUTHORITY_DIR_NAME);
        if (Files.exists(trustedAuthorityDir, new LinkOption[0])) {
            this.trustedAuthorityMap = new HashMap<String, byte[]>();
            SecurityRootDirectory.storeContentsToMap(trustedAuthorityDir, this.trustedAuthorityMap);
        } else {
            this.trustedAuthorityMap = null;
        }
        Path accessControlDir = securityRootDirectory.resolve(ACCESS_CONTROL_DIR_NAME);
        if (Files.exists(accessControlDir, new LinkOption[0])) {
            this.accessControlMap = new HashMap<String, byte[]>();
            SecurityRootDirectory.storeContentsToMap(accessControlDir, this.accessControlMap);
        } else {
            this.accessControlMap = null;
        }
        Path whiteListDeprecatedDir = securityRootDirectory.resolve(WHITE_LIST_DEPRECATED_DIR_NAME);
        if (Files.exists(whiteListDeprecatedDir, new LinkOption[0])) {
            this.whiteListDeprecatedMap = new HashMap<String, byte[]>();
            SecurityRootDirectory.storeContentsToMap(whiteListDeprecatedDir, this.whiteListDeprecatedMap);
        } else {
            this.whiteListDeprecatedMap = null;
        }
        Path whiteListFile = securityRootDirectory.resolve(WHITE_LIST_FILE_NAME);
        if (Files.exists(whiteListFile, new LinkOption[0])) {
            try {
                this.whiteListFileContent = IOUtils.toByteArray(Files.newInputStream(whiteListFile, new OpenOption[0]));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read file " + whiteListFile, ioe);
            }
        } else {
            this.whiteListFileContent = null;
        }
    }

    public static SecurityRootDirectory securityRootDirectory(URL securityRootDirectoryUrl) {
        try {
            return new SecurityRootDirectory(Paths.get(securityRootDirectoryUrl.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static SecurityRootDirectory securityRootDirectory(Path securityRootDirectoryPath) {
        return new SecurityRootDirectory(securityRootDirectoryPath);
    }

    private static void storeContentsToDir(Map<String, byte[]> map, Path directory) {
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            Path filePath = directory.resolve(entry.getKey());
            byte[] fileContents = entry.getValue();
            try {
                Files.write(filePath, fileContents, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create file " + filePath, e);
            }
        }
    }

    private static void storeContentsToMap(Path directory, Map<String, byte[]> map) {
        try {
            Files.list(directory).forEach(path -> {
                try {
                    map.put(path.getFileName().toString(), IOUtils.toByteArray(Files.newInputStream(path, new OpenOption[0])));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read file " + path, e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read directory " + directory, e);
        }
    }

    public void createSecurityRootDirectory(Path newSecurityRootDirectory) {
        Path identityDir = newSecurityRootDirectory.resolve(IDENTITY_DIR_NAME);
        if (this.identityMap != null) {
            try {
                Files.createDirectories(identityDir, new FileAttribute[0]);
                SecurityRootDirectory.storeContentsToDir(this.identityMap, identityDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + identityDir, e);
            }
        }
        Path trustedAuthorityDir = newSecurityRootDirectory.resolve(TRUSTED_AUTHORITY_DIR_NAME);
        if (this.trustedAuthorityMap != null) {
            try {
                Files.createDirectories(trustedAuthorityDir, new FileAttribute[0]);
                SecurityRootDirectory.storeContentsToDir(this.trustedAuthorityMap, trustedAuthorityDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + trustedAuthorityDir, e);
            }
        }
        Path accessControlDir = newSecurityRootDirectory.resolve(ACCESS_CONTROL_DIR_NAME);
        if (this.accessControlMap != null) {
            try {
                Files.createDirectories(accessControlDir, new FileAttribute[0]);
                SecurityRootDirectory.storeContentsToDir(this.accessControlMap, accessControlDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + accessControlDir, e);
            }
        }
        Path whiteListDeprecatedDir = newSecurityRootDirectory.resolve(WHITE_LIST_DEPRECATED_DIR_NAME);
        if (this.whiteListDeprecatedMap != null) {
            try {
                Files.createDirectories(whiteListDeprecatedDir, new FileAttribute[0]);
                SecurityRootDirectory.storeContentsToDir(this.whiteListDeprecatedMap, whiteListDeprecatedDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + whiteListDeprecatedDir, e);
            }
        }
        if (this.whiteListFileContent != null) {
            try {
                Files.createDirectories(newSecurityRootDirectory, new FileAttribute[0]);
                Path whiteListFile = newSecurityRootDirectory.resolve(WHITE_LIST_FILE_NAME);
                Files.write(whiteListFile, this.whiteListFileContent, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create whitelist file ", e);
            }
        }
    }
}

