/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.cache.query.index.AbstractIndex;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.SingleCursor;
import org.apache.ignite.internal.cache.query.index.sorted.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexValueCursor;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.ThreadLocalRowHandlerHolder;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineTreeFilterClosure;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.jetbrains.annotations.Nullable;

public class InlineIndexImpl
extends AbstractIndex
implements InlineIndex {
    private final UUID id = UUID.randomUUID();
    private final InlineIndexTree[] segments;
    private final SortedIndexDefinition def;
    private final String treeName;
    private final GridCacheContext<?, ?> cctx;
    private final IoStatisticsHolderIndex stats;
    private final InlineIndexRowHandler rowHnd;
    private final AtomicBoolean destroyed = new AtomicBoolean();

    public InlineIndexImpl(GridCacheContext<?, ?> cctx, SortedIndexDefinition def, InlineIndexTree[] segments, IoStatisticsHolderIndex stats) {
        this.cctx = cctx;
        this.segments = (InlineIndexTree[])segments.clone();
        this.def = def;
        this.treeName = def.treeName();
        this.stats = stats;
        this.rowHnd = segments[0].rowHandler();
    }

    @Override
    public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, int segment) throws IgniteCheckedException {
        return this.find(lower, upper, segment, null);
    }

    @Override
    public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, int segment, IndexQueryContext qryCtx) throws IgniteCheckedException {
        InlineTreeFilterClosure closure = this.filterClosure(qryCtx);
        if (this.isSingleRowLookup(lower, upper)) {
            IndexRowImpl row = (IndexRowImpl)this.segments[segment].findOne(lower, closure, null);
            if (row == null || InlineIndexImpl.isExpired(row)) {
                return IndexValueCursor.EMPTY;
            }
            return new SingleCursor<IndexRow>(row);
        }
        return this.segments[segment].find(lower, upper, closure, null);
    }

    @Override
    public long count(int segment) throws IgniteCheckedException {
        return this.segments[segment].size();
    }

    @Override
    public long count(int segment, IndexQueryContext qryCtx) throws IgniteCheckedException {
        return this.segments[segment].size(this.filterClosure(qryCtx));
    }

    @Override
    public long totalCount() throws IgniteCheckedException {
        long ret = 0L;
        for (int i = 0; i < this.segmentsCount(); ++i) {
            ret += this.segments[i].size();
        }
        return ret;
    }

    private boolean isSingleRowLookup(IndexRow lower, IndexRow upper) throws IgniteCheckedException {
        return !this.cctx.mvccEnabled() && this.def.primary() && lower != null && this.isFullSchemaSearch(lower) && this.checkRowsTheSame(lower, upper);
    }

    private boolean isFullSchemaSearch(IndexRow key) {
        int schemaLength = this.def.indexKeyDefinitions().size();
        for (int i = 0; i < schemaLength; ++i) {
            if (key.key(i) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkRowsTheSame(IndexRow r1, IndexRow r2) throws IgniteCheckedException {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        int keysLen = this.def.indexKeyDefinitions().size();
        for (int i = 0; i < keysLen; ++i) {
            IndexKey v1 = r1.key(i);
            IndexKey v2 = r2.key(i);
            if (v1 == null && v2 == null) continue;
            if (v1 == null || v2 == null) {
                return false;
            }
            if (this.def.rowComparator().compareRow(r1, r2, i) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public GridCursor<IndexRow> findFirst(int segment, IndexQueryContext qryCtx) throws IgniteCheckedException {
        InlineTreeFilterClosure closure = this.filterClosure(qryCtx);
        IndexRow found = this.segments[segment].findFirst(closure);
        if (found == null || InlineIndexImpl.isExpired(found)) {
            return IndexValueCursor.EMPTY;
        }
        return new SingleCursor<IndexRow>(found);
    }

    @Override
    public GridCursor<IndexRow> findLast(int segment, IndexQueryContext qryCtx) throws IgniteCheckedException {
        InlineTreeFilterClosure closure = this.filterClosure(qryCtx);
        IndexRow found = this.segments[segment].findLast(closure);
        if (found == null || InlineIndexImpl.isExpired(found)) {
            return IndexValueCursor.EMPTY;
        }
        return new SingleCursor<IndexRow>(found);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.def.idxName().idxName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(@Nullable CacheDataRow oldRow, @Nullable CacheDataRow newRow, boolean prevRowAvailable) throws IgniteCheckedException {
        try {
            if (this.destroyed.get()) {
                return;
            }
            ThreadLocalRowHandlerHolder.rowHandler(this.rowHnd);
            boolean replaced = false;
            if (newRow != null) {
                int segment = this.segmentForRow(newRow);
                IndexRowImpl row0 = new IndexRowImpl(this.rowHnd, newRow);
                row0.prepareCache();
                for (int i = 0; i < this.def.indexKeyDefinitions().size(); ++i) {
                    row0.key(i);
                }
                replaced = this.putx(row0, segment, prevRowAvailable && !this.rebuildInProgress());
            }
            if (!replaced && oldRow != null) {
                this.remove(oldRow);
            }
        }
        finally {
            ThreadLocalRowHandlerHolder.clearRowHandler();
        }
    }

    private boolean putx(IndexRowImpl idxRow, int segment, boolean flag) throws IgniteCheckedException {
        try {
            IndexRow prevRow0;
            boolean replaced = flag ? this.segments[segment].putx(idxRow) : (prevRow0 = (IndexRow)this.segments[segment].put(idxRow)) != null;
            return replaced;
        }
        catch (Throwable t) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
            throw t;
        }
    }

    private void remove(CacheDataRow row) throws IgniteCheckedException {
        try {
            int segment = this.segmentForRow(row);
            IndexRowImpl idxRow = new IndexRowImpl(this.rowHnd, row);
            idxRow.prepareCache();
            this.segments[segment].removex(idxRow);
        }
        catch (Throwable t) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
            throw t;
        }
    }

    public void putIndexRow(IndexRowImpl row) throws IgniteCheckedException {
        int segment = this.segmentForRow(row.cacheDataRow());
        try {
            ThreadLocalRowHandlerHolder.rowHandler(this.rowHnd);
            this.segments[segment].putx(row);
        }
        finally {
            ThreadLocalRowHandlerHolder.clearRowHandler();
        }
    }

    @Override
    public <T extends Index> T unwrap(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)((Index)clazz.cast(this));
        }
        throw new IllegalArgumentException(String.format("Cannot unwrap [%s] to [%s]", this.getClass().getName(), clazz.getName()));
    }

    @Override
    public int inlineSize() {
        return this.segments[0].inlineSize();
    }

    public IndexKeyTypeSettings keyTypeSettings() {
        return this.rowHnd.indexKeyTypeSettings();
    }

    @Override
    public int segmentsCount() {
        return this.segments.length;
    }

    public int segmentForRow(CacheDataRow row) {
        return InlineIndexImpl.calculateSegment(this.segmentsCount(), this.segmentsCount() == 1 ? 0 : this.rowHnd.partition(row));
    }

    public static int calculateSegment(int segmentsCnt, int part) {
        return segmentsCnt == 1 ? 0 : part % segmentsCnt;
    }

    private InlineTreeFilterClosure filterClosure(IndexQueryContext qryCtx) {
        if (qryCtx == null) {
            return null;
        }
        IndexingQueryCacheFilter cacheFilter = qryCtx.filter() == null ? null : qryCtx.filter().forCache(this.cctx.cache().name());
        MvccSnapshot v = qryCtx.mvccSnapshot();
        assert (!this.cctx.mvccEnabled() || v != null);
        if (cacheFilter == null && v == null) {
            return null;
        }
        return new InlineTreeFilterClosure(cacheFilter, v, this.cctx, this.cctx.kernalContext().config().getGridLogger());
    }

    @Override
    public boolean created() {
        assert (this.segments != null);
        for (int i = 0; i < this.segments.length; ++i) {
            try {
                InlineIndexTree segment = this.segments[i];
                if (!segment.created()) continue;
                return true;
            }
            catch (Exception e) {
                throw new IgniteException("Failed to check index tree root page existence [cacheName=" + this.cctx.name() + ", tblName=" + this.def.idxName().tableName() + ", idxName=" + this.def.idxName().idxName() + ", segment=" + i + ']');
            }
        }
        return false;
    }

    @Override
    public InlineIndexTree segment(int segment) {
        return this.segments[segment];
    }

    private static boolean isExpired(IndexRow row) {
        return row.cacheDataRow().expireTime() > 0L && row.cacheDataRow().expireTime() <= U.currentTimeMillis();
    }

    @Override
    public void destroy(boolean softDel) {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        if (this.cctx.affinityNode() && !softDel) {
            for (InlineIndexTree segment : this.segments) {
                segment.markDestroyed();
                segment.close();
            }
            this.cctx.kernalContext().metric().remove(this.stats.metricRegistryName());
            if (this.cctx.group().persistenceEnabled() || this.cctx.shared().kernalContext().state().clusterState().state() != ClusterState.INACTIVE) {
                DurableBackgroundCleanupIndexTreeTaskV2 task = new DurableBackgroundCleanupIndexTreeTaskV2(this.cctx.group().name(), this.cctx.name(), this.def.idxName().idxName(), this.treeName, UUID.randomUUID().toString(), this.segments.length, this.segments);
                this.cctx.kernalContext().durableBackgroundTask().executeAsync(task, this.cctx.config());
            }
        }
    }

    @Override
    public boolean canHandle(CacheDataRow row) throws IgniteCheckedException {
        return this.cctx.kernalContext().query().belongsToTable(this.cctx, this.def.idxName().cacheName(), this.def.idxName().tableName(), row.key(), row.value());
    }
}

