/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineRecommender;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;

public class InlineIndexFactory
implements IndexFactory {
    public static final InlineIndexFactory INSTANCE = new InlineIndexFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index createIndex(GridCacheContext<?, ?> cctx, IndexDefinition def) {
        SortedIndexDefinition sdef = (SortedIndexDefinition)def;
        InlineIndexTree[] trees = new InlineIndexTree[sdef.segments()];
        InlineRecommender recommender = new InlineRecommender(cctx, sdef);
        IoStatisticsHolderIndex stats = new IoStatisticsHolderIndex(IoStatisticsType.SORTED_INDEX, cctx.name(), sdef.idxName().idxName(), cctx.kernalContext().metric());
        try {
            for (int i = 0; i < sdef.segments(); ++i) {
                IgniteCacheDatabaseSharedManager db = cctx.shared().database();
                db.checkpointReadLock();
                try {
                    RootPage page = this.rootPage(cctx, sdef.treeName(), i);
                    trees[i] = this.createIndexSegment(cctx, sdef, page, stats, recommender, i);
                    continue;
                }
                finally {
                    db.checkpointReadUnlock();
                }
            }
            return new InlineIndexImpl(cctx, sdef, trees, stats);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected InlineIndexTree createIndexSegment(GridCacheContext<?, ?> cctx, SortedIndexDefinition def, RootPage rootPage, IoStatisticsHolder stats, InlineRecommender recommender, int segmentNum) throws Exception {
        return new InlineIndexTree(def, cctx.group(), def.treeName(), cctx.offheap(), cctx.offheap().reuseListForIndex(def.treeName()), cctx.dataRegion().pageMemory(), PageIoResolver.DEFAULT_PAGE_IO_RESOLVER, rootPage.pageId().pageId(), rootPage.isAllocated(), def.inlineSize(), cctx.config().getSqlIndexMaxInlineSize(), def.keyTypeSettings(), def.idxRowCache(), stats, def.rowHandlerFactory(), recommender);
    }

    protected RootPage rootPage(GridCacheContext<?, ?> ctx, String treeName, int segment) throws Exception {
        return ctx.offheap().rootPageForIndex(ctx.cacheId(), treeName, segment);
    }
}

