/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.terracotta.angela.common.util.IpUtils;
import org.zeroturnaround.process.PidUtil;

public class AgentID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AgentID LOCAL = new AgentID("local", IpUtils.getHostName(), 0, PidUtil.getMyPid());
    private final String name;
    private final String hostname;
    private final int port;
    private final int pid;

    public AgentID(String name, String hostname, int port, int pid) {
        this.name = Objects.requireNonNull(name);
        this.hostname = Objects.requireNonNull(hostname);
        this.port = port;
        this.pid = pid;
        if (name.contains("@") || name.contains("#") || name.contains(":")) {
            throw new IllegalArgumentException("Invalid characters in name: @ # :");
        }
        if (hostname.contains("@") || hostname.contains("#") || hostname.contains(":")) {
            throw new IllegalArgumentException("Invalid characters in hostname: @ # :");
        }
    }

    public int getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getAddress() {
        return InetSocketAddress.createUnresolved(this.hostname, this.port);
    }

    public boolean isIgniteFree() {
        return this.port == 0 && this.name.equals("local");
    }

    public String getNodeName() {
        return this.name + "#" + this.pid + "@" + this.hostname + "#" + this.port;
    }

    public String toString() {
        return this.getNodeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentID)) {
            return false;
        }
        AgentID agentID = (AgentID)o;
        return this.getPort() == agentID.getPort() && this.getPid() == agentID.getPid() && this.getName().equals(agentID.getName()) && this.getHostName().equals(agentID.getHostName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getHostName(), this.getPort(), this.getPid());
    }

    public static AgentID valueOf(String s) {
        try {
            int p1 = s.indexOf("#");
            int p2 = s.indexOf("@", p1);
            int p3 = s.indexOf("#", p2);
            String instanceName = s.substring(0, p1);
            int pid = Integer.parseInt(s.substring(p1 + 1, p2));
            String hostname = s.substring(p2 + 1, p3);
            int port = Integer.parseInt(s.substring(p3 + 1));
            return new AgentID(instanceName, hostname, port, pid);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid AgentID: " + s, e);
        }
    }

    public static AgentID local() {
        return LOCAL;
    }
}

