/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.jetbrains.annotations.Nullable;

public abstract class NullableInlineIndexKeyType<T extends IndexKey>
implements InlineIndexKeyType {
    public static final int CANT_BE_COMPARE = -2;
    public static final int COMPARE_UNSUPPORTED = Integer.MIN_VALUE;
    private final int type;
    protected final short keySize;

    protected NullableInlineIndexKeyType(int type, short keySize) {
        this.type = type;
        this.keySize = keySize;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public int inlineSize(long pageAddr, int off) {
        byte type = PageUtils.getByte(pageAddr, off);
        if (type == 0) {
            return 1;
        }
        if (this.keySize > 0) {
            return this.keySize + 1;
        }
        return (PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE) + 3;
    }

    @Override
    public int inlineSize() {
        if (this.type == 0) {
            return 1;
        }
        return this.keySize < 0 ? this.keySize : this.keySize + 1;
    }

    @Override
    public int inlineSize(IndexKey key) {
        if (key == NullIndexKey.INSTANCE) {
            return 1;
        }
        this.ensureKeyType(key);
        return this.inlineSize0(key);
    }

    @Override
    public IndexKey get(long pageAddr, int off, int maxSize) {
        if (this.keySize > 0 && this.keySize + 1 > maxSize) {
            return null;
        }
        if (maxSize < 1) {
            return null;
        }
        byte type = PageUtils.getByte(pageAddr, off);
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return NullIndexKey.INSTANCE;
        }
        this.ensureKeyType(type);
        T o = this.get0(pageAddr, off);
        if (o == null) {
            return NullIndexKey.INSTANCE;
        }
        return o;
    }

    @Override
    public int put(long pageAddr, int off, IndexKey key, int maxSize) {
        if (this.keySize > 0 && this.keySize + 1 > maxSize) {
            return 0;
        }
        if (this.keySize < 0 && maxSize < 4) {
            PageUtils.putByte(pageAddr, off, (byte)-1);
            return 0;
        }
        if (key == NullIndexKey.INSTANCE) {
            PageUtils.putByte(pageAddr, off, (byte)0);
            return 1;
        }
        this.ensureKeyType(key);
        return this.put0(pageAddr, off, key, maxSize);
    }

    protected abstract int put0(long var1, int var3, T var4, int var5);

    @Nullable
    protected abstract T get0(long var1, int var3);

    protected byte[] readBytes(long pageAddr, int off) {
        int size = PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE;
        return PageUtils.getBytes(pageAddr, off + 3, size);
    }

    @Override
    public int compare(long pageAddr, int off, int maxSize, IndexKey key) {
        byte type;
        if (this.keySize > 0 && this.keySize + 1 > maxSize || maxSize < 1 || (type = PageUtils.getByte(pageAddr, off)) == -1) {
            return -2;
        }
        if (type == 0) {
            if (key == NullIndexKey.INSTANCE) {
                return 0;
            }
            return -1;
        }
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        if (key == NullIndexKey.INSTANCE) {
            return 1;
        }
        return this.compare0(pageAddr, off, key);
    }

    private void ensureKeyType(int type) {
        if (this.type != type) {
            throw new UnsupportedOperationException("Value type doesn't match: exp=" + this.type + ", act=" + type);
        }
    }

    private void ensureKeyType(IndexKey key) {
        if (key != NullIndexKey.INSTANCE && this.type != key.type()) {
            throw new UnsupportedOperationException(key.type() + " cannot be used for inline type " + this.type());
        }
    }

    public abstract int compare0(long var1, int var3, T var4);

    protected abstract int inlineSize0(T var1);
}

