/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.cipher;

import com.hierynomus.sshj.transport.cipher.StreamCipher;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.cipher.Cipher;

public class StreamCiphers {
    public static Factory Arcfour() {
        return new Factory(128, "arcfour", "ARCFOUR", "ECB");
    }

    public static Factory Arcfour128() {
        return new Factory(128, "arcfour128", "RC4", "ECB");
    }

    public static Factory Arcfour256() {
        return new Factory(256, "arcfour256", "RC4", "ECB");
    }

    public static class Factory
    implements Factory.Named<Cipher> {
        private int keysize;
        private String cipher;
        private String mode;
        private String name;

        public Factory(int keysize, String name, String cipher, String mode) {
            this.name = name;
            this.keysize = keysize;
            this.cipher = cipher;
            this.mode = mode;
        }

        @Override
        public Cipher create() {
            return new StreamCipher(this.keysize / 8, this.cipher, this.cipher + "/" + this.mode + "/NoPadding");
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

