/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.terracotta.angela.common.util.ActivityTracker;

public class TrackedOutputStream
extends OutputStream {
    private final ActivityTracker activityTracker;
    private final OutputStream delegate;

    public TrackedOutputStream(ActivityTracker activityTracker, OutputStream delegate) {
        this.activityTracker = activityTracker;
        this.delegate = delegate;
    }

    public ActivityTracker getActivityTracker() {
        return this.activityTracker;
    }

    @Override
    public void write(int b) throws IOException {
        this.activityTracker.touch();
        this.delegate.write(b);
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        this.activityTracker.touch();
        this.delegate.write(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        this.activityTracker.touch();
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

