/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Exceptions;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.LogOutputStream;
import org.terracotta.angela.common.util.OS;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.process.PidUtil;

public class RemoteClientManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteClientManager.class);
    private static final String CLASSPATH_SUBDIR_NAME = "lib";
    private final Path kitInstallationPath;
    private final InstanceId instanceId;

    public RemoteClientManager(InstanceId instanceId) {
        this.kitInstallationPath = Agent.WORK_DIR.resolve(instanceId.toString());
        this.instanceId = instanceId;
    }

    public Path getClientInstallationPath() {
        return this.kitInstallationPath;
    }

    public Path getClientClasspathRoot() {
        return this.kitInstallationPath.resolve(CLASSPATH_SUBDIR_NAME);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public AgentID spawnClient(TerracottaCommandLineEnvironment tcEnv, AgentGroup group) {
        try {
            Path javaHome = tcEnv.getJavaHome();
            final AtomicBoolean started = new AtomicBoolean(false);
            final AtomicReference agentID = new AtomicReference();
            ArrayList<String> cmdLine = new ArrayList<String>();
            if (OS.INSTANCE.isWindows()) {
                cmdLine.add(javaHome + "\\bin\\java.exe");
            } else {
                cmdLine.add(javaHome + "/bin/java");
            }
            cmdLine.add("-classpath");
            cmdLine.add(this.buildClasspath());
            if (!tcEnv.getJavaOpts().isEmpty()) {
                cmdLine.addAll(tcEnv.getJavaOpts());
            }
            cmdLine.add("-Dangela.java.resolver=user");
            cmdLine.add("-Dangela.process=spawned");
            cmdLine.add("-Dangela.directJoin=" + String.join((CharSequence)",", group.getPeerAddresses()));
            cmdLine.add("-Dangela.group=" + group.getId());
            cmdLine.add("-Dangela.instanceName=" + this.instanceId);
            cmdLine.add("-D" + AngelaProperties.ROOT_DIR.getPropertyName() + "=" + Agent.ROOT_DIR);
            cmdLine.add(Agent.class.getName());
            if (logger.isDebugEnabled()) {
                logger.info("Spawning client agent: {} with: {}", (Object)this.instanceId, (Object)String.join((CharSequence)" ", cmdLine));
            } else {
                logger.info("Spawning client agent: {}", (Object)this.instanceId);
            }
            ProcessExecutor processExecutor = new ProcessExecutor().command((List<String>)cmdLine).redirectOutput(new LogOutputStream(){

                @Override
                protected void processLine(String line) {
                    ExternalLoggers.clientLogger.info("[{}] {}", (Object)RemoteClientManager.this.instanceId, (Object)line);
                    if (line.startsWith("Agent is ready")) {
                        agentID.set(AgentID.valueOf(line.substring("Agent is ready".length() + 2)));
                        started.set(true);
                    }
                }
            }).redirectErrorStream(true).directory(this.getClientInstallationPath().toFile());
            StartedProcess startedProcess = processExecutor.start();
            logger.info("Waiting for spawned agent with PID: {} to be ready...", (Object)PidUtil.getPid(startedProcess.getProcess()));
            while (startedProcess.getProcess().isAlive() && !started.get()) {
                Thread.sleep(200L);
            }
            if (!startedProcess.getProcess().isAlive()) {
                throw new RuntimeException("Client process died in infancy");
            }
            AgentID id = (AgentID)agentID.get();
            if (id == null) {
                throw new AssertionError((Object)"No AgentID");
            }
            logger.info("Spawned client with PID {}", (Object)id.getPid());
            return id;
        }
        catch (IOException | InterruptedException e) {
            throw Exceptions.asRuntime("Error spawning client " + this.instanceId, e);
        }
    }

    private String buildClasspath() throws IOException {
        Path root = this.getClientClasspathRoot();
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new RuntimeException("Cannot build client classpath before the classpath root is uploaded");
        }
        StringBuilder sb = new StringBuilder();
        try (Stream<Path> list = Files.list(root);){
            list.forEach(cpentry -> sb.append(CLASSPATH_SUBDIR_NAME).append(File.separator).append(cpentry.getFileName()).append(File.pathSeparator));
        }
        String agentClassName = Agent.class.getName().replace('.', '/');
        String agentClassPath = Agent.class.getResource("/" + agentClassName + ".class").getPath();
        if (agentClassPath.startsWith("file:")) {
            sb.append(agentClassPath, "file:".length(), agentClassPath.lastIndexOf(33));
        } else {
            sb.append(agentClassPath, 0, agentClassPath.lastIndexOf(agentClassName));
        }
        return sb.toString();
    }
}

