/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.encryption;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTask;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTaskArg;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorReencryptionStatusTask
extends VisorCacheGroupEncryptionTask<Long> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorCacheGroupEncryptionTaskArg, VisorCacheGroupEncryptionTask.VisorSingleFieldDto<Long>> job(VisorCacheGroupEncryptionTaskArg arg) {
        return new VisorReencryptionStatusJob(arg, this.debug);
    }

    protected static class VisorReencryptionStatusResult
    extends VisorCacheGroupEncryptionTask.VisorSingleFieldDto<Long> {
        private static final long serialVersionUID = 0L;

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeLong((Long)this.value());
        }

        @Override
        protected void readExternalData(byte ver, ObjectInput in) throws IOException, ClassNotFoundException {
            this.value(in.readLong());
        }
    }

    private static class VisorReencryptionStatusJob
    extends VisorCacheGroupEncryptionTask.VisorReencryptionBaseJob<Long> {
        private static final long serialVersionUID = 0L;

        protected VisorReencryptionStatusJob(@Nullable VisorCacheGroupEncryptionTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheGroupEncryptionTask.VisorSingleFieldDto<Long> run0(CacheGroupContext grp) {
            long res = !this.ignite.context().encryption().reencryptionInProgress(grp.groupId()) ? -1L : this.ignite.context().encryption().getBytesLeftForReencryption(grp.groupId());
            return new VisorReencryptionStatusResult().value(res);
        }
    }
}

