/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CompactablePageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;

public class PagesListNodeIO
extends PageIO
implements CompactablePageIO {
    public static final IOVersions<PagesListNodeIO> VERSIONS = new IOVersions((PageIO[])new PagesListNodeIO[]{new PagesListNodeIO(1)});
    private static final int PREV_PAGE_ID_OFF = 40;
    private static final int NEXT_PAGE_ID_OFF = 48;
    private static final int CNT_OFF = 56;
    private static final int PAGE_IDS_OFF = 58;

    protected PagesListNodeIO(int ver) {
        super(13, ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setEmpty(pageAddr);
        this.setPreviousId(pageAddr, 0L);
        this.setNextId(pageAddr, 0L);
    }

    private void setEmpty(long pageAddr) {
        this.setCount(pageAddr, 0);
    }

    public long getNextId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 48);
    }

    public void setNextId(long pageAddr, long nextId) {
        PageUtils.putLong(pageAddr, 48, nextId);
    }

    public long getPreviousId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 40);
    }

    public void setPreviousId(long pageAddr, long prevId) {
        PageUtils.putLong(pageAddr, 40, prevId);
    }

    public int getCount(long pageAddr) {
        return PageUtils.getShort(pageAddr, 56);
    }

    private void setCount(long pageAddr, int cnt) {
        assert (cnt >= 0 && cnt <= Short.MAX_VALUE) : cnt;
        PageUtils.putShort(pageAddr, 56, (short)cnt);
    }

    private int getCapacity(int pageSize) {
        return pageSize - 58 >>> 3;
    }

    private int offset(int idx) {
        return 58 + 8 * idx;
    }

    public long getAt(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    private void setAt(long pageAddr, int idx, long pageId) {
        PageUtils.putLong(pageAddr, this.offset(idx), pageId);
    }

    public int addPage(long pageAddr, long pageId, int pageSize) {
        int cnt = this.getCount(pageAddr);
        if (cnt == this.getCapacity(pageSize)) {
            return -1;
        }
        this.setAt(pageAddr, cnt, pageId);
        this.setCount(pageAddr, cnt + 1);
        return cnt;
    }

    public long takeAnyPage(long pageAddr) {
        int cnt = this.getCount(pageAddr);
        if (cnt == 0) {
            return 0L;
        }
        this.setCount(pageAddr, --cnt);
        return this.getAt(pageAddr, cnt);
    }

    public boolean removePage(long pageAddr, long dataPageId) {
        assert (dataPageId != 0L);
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            if (PageIdUtils.maskPartitionId(this.getAt(pageAddr, i)) != PageIdUtils.maskPartitionId(dataPageId)) continue;
            if (i != cnt - 1) {
                PageHandler.copyMemory(pageAddr, (long)this.offset(i + 1), pageAddr, (long)this.offset(i), (long)(8 * (cnt - i - 1)));
            }
            this.setCount(pageAddr, cnt - 1);
            return true;
        }
        return false;
    }

    public boolean isEmpty(long pageAddr) {
        return this.getCount(pageAddr) == 0;
    }

    @Override
    public void compactPage(ByteBuffer page, ByteBuffer out, int pageSize) {
        this.copyPage(page, out, pageSize);
        long pageAddr = GridUnsafe.bufferAddress(out);
        out.limit(this.offset(this.getCount(pageAddr)));
    }

    @Override
    public void restorePage(ByteBuffer compactPage, int pageSize) {
        assert (compactPage.isDirect());
        assert (compactPage.position() == 0);
        assert (compactPage.limit() <= pageSize);
        compactPage.limit(pageSize);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("PagesListNode [\n\tpreviousPageId=").appendHex(this.getPreviousId(addr)).a(",\n\tnextPageId=").appendHex(this.getNextId(addr)).a(",\n\tcount=").a(this.getCount(addr)).a(",\n\tpages={");
        for (int i = 0; i < this.getCount(addr); ++i) {
            sb.a("\n\t\t").a(this.getAt(addr, i));
        }
        sb.a("\n\t}\n]");
    }
}

