/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.userauth.keyprovider;

import com.hierynomus.sshj.common.KeyDecryptionFailedException;
import com.hierynomus.sshj.transport.cipher.BlockCiphers;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyFileUtil;
import com.hierynomus.sshj.userauth.keyprovider.bcrypt.BCrypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyV1KeyFile
extends BaseFileKeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenSSHKeyV1KeyFile.class);
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";
    private static final byte[] AUTH_MAGIC = "openssh-key-v1\u0000".getBytes();
    public static final String OPENSSH_PRIVATE_KEY = "OPENSSH PRIVATE KEY-----";
    public static final String BCRYPT = "bcrypt";
    private PublicKey pubKey;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void init(File location) {
        File pubKey = OpenSSHKeyFileUtil.getPublicKeyFile(location);
        if (pubKey != null) {
            try {
                this.initPubKey(new FileReader(pubKey));
            }
            catch (IOException e) {
                this.log.warn("Error reading public key file: {}", (Object)e.toString());
            }
        }
        super.init(location);
    }

    @Override
    protected KeyPair readKeyPair() throws IOException {
        KeyPair keyPair;
        BufferedReader reader = new BufferedReader(this.resource.getReader());
        try {
            if (!this.checkHeader(reader)) {
                throw new IOException("This key is not in 'openssh-key-v1' format");
            }
            String keyFile = this.readKeyFile(reader);
            byte[] decode = Base64.decode(keyFile);
            Buffer.PlainBuffer keyBuffer = new Buffer.PlainBuffer(decode);
            keyPair = this.readDecodedKeyPair(keyBuffer);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new SSHRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return keyPair;
    }

    private void initPubKey(Reader publicKey) throws IOException {
        OpenSSHKeyFileUtil.ParsedPubKey parsed = OpenSSHKeyFileUtil.initPubKey(publicKey);
        this.type = parsed.getType();
        this.pubKey = parsed.getPubKey();
    }

    private KeyPair readDecodedKeyPair(Buffer.PlainBuffer keyBuffer) throws IOException, GeneralSecurityException {
        byte[] bytes = new byte[AUTH_MAGIC.length];
        keyBuffer.readRawBytes(bytes);
        if (!ByteArrayUtils.equals(bytes, 0, AUTH_MAGIC, 0, AUTH_MAGIC.length)) {
            throw new IOException("This key does not contain the 'openssh-key-v1' format magic header");
        }
        String cipherName = keyBuffer.readString();
        String kdfName = keyBuffer.readString();
        byte[] kdfOptions = keyBuffer.readBytes();
        int nrKeys = keyBuffer.readUInt32AsInt();
        if (nrKeys != 1) {
            throw new IOException("We don't support having more than 1 key in the file (yet).");
        }
        PublicKey publicKey = this.pubKey;
        if (publicKey == null) {
            publicKey = this.readPublicKey(new Buffer.PlainBuffer(keyBuffer.readBytes()));
        } else {
            keyBuffer.readBytes();
        }
        Buffer.PlainBuffer privateKeyBuffer = new Buffer.PlainBuffer(keyBuffer.readBytes());
        if ("none".equals(cipherName)) {
            logger.debug("Reading unencrypted keypair");
            return this.readUnencrypted(privateKeyBuffer, publicKey);
        }
        logger.info("Keypair is encrypted with: " + cipherName + ", " + kdfName + ", " + Arrays.toString(kdfOptions));
        while (true) {
            Buffer.PlainBuffer decryptionBuffer = new Buffer.PlainBuffer(privateKeyBuffer);
            Buffer.PlainBuffer decrypted = this.decryptBuffer(decryptionBuffer, cipherName, kdfName, kdfOptions);
            try {
                return this.readUnencrypted(decrypted, publicKey);
            }
            catch (KeyDecryptionFailedException e) {
                if (this.pwdf != null && this.pwdf.shouldRetry(this.resource)) continue;
                throw e;
            }
            break;
        }
    }

    private Buffer.PlainBuffer decryptBuffer(Buffer.PlainBuffer privateKeyBuffer, String cipherName, String kdfName, byte[] kdfOptions) throws IOException {
        Cipher cipher = this.createCipher(cipherName);
        this.initializeCipher(kdfName, kdfOptions, cipher);
        byte[] array = privateKeyBuffer.array();
        cipher.update(array, 0, privateKeyBuffer.available());
        return new Buffer.PlainBuffer(array);
    }

    private void initializeCipher(String kdfName, byte[] kdfOptions, Cipher cipher) throws Buffer.BufferException {
        byte[] passphrase;
        Buffer.PlainBuffer opts;
        if (kdfName.equals(BCRYPT)) {
            opts = new Buffer.PlainBuffer(kdfOptions);
            passphrase = new byte[]{};
            if (this.pwdf != null) {
                CharBuffer charBuffer = CharBuffer.wrap(this.pwdf.reqPassword(null));
                ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
                passphrase = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                Arrays.fill(charBuffer.array(), '\u0000');
                Arrays.fill(byteBuffer.array(), (byte)0);
            }
        } else {
            throw new IllegalStateException("No support for KDF '" + kdfName + "'.");
        }
        byte[] keyiv = new byte[48];
        new BCrypt().pbkdf(passphrase, opts.readBytes(), opts.readUInt32AsInt(), keyiv);
        Arrays.fill(passphrase, (byte)0);
        byte[] key = Arrays.copyOfRange(keyiv, 0, 32);
        byte[] iv = Arrays.copyOfRange(keyiv, 32, 48);
        cipher.init(Cipher.Mode.Decrypt, key, iv);
    }

    private Cipher createCipher(String cipherName) {
        if (cipherName.equals(BlockCiphers.AES256CTR().getName())) {
            return BlockCiphers.AES256CTR().create();
        }
        if (cipherName.equals(BlockCiphers.AES256CBC().getName())) {
            return BlockCiphers.AES256CBC().create();
        }
        throw new IllegalStateException("Cipher '" + cipherName + "' not currently implemented for openssh-key-v1 format");
    }

    private PublicKey readPublicKey(Buffer.PlainBuffer plainBuffer) throws Buffer.BufferException, GeneralSecurityException {
        return KeyType.fromString(plainBuffer.readString()).readPubKeyFromBuffer(plainBuffer);
    }

    private String readKeyFile(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        while (!line.startsWith(END)) {
            sb.append(line);
            line = reader.readLine();
        }
        return sb.toString();
    }

    private boolean checkHeader(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && !line.startsWith(BEGIN)) {
            line = reader.readLine();
        }
        line = line.substring(BEGIN.length());
        return line.startsWith(OPENSSH_PRIVATE_KEY);
    }

    private KeyPair readUnencrypted(Buffer.PlainBuffer keyBuffer, PublicKey publicKey) throws IOException, GeneralSecurityException {
        KeyPair kp;
        int checkInt2;
        int privKeyListSize = keyBuffer.available();
        if (privKeyListSize % 8 != 0) {
            throw new IOException("The private key section must be a multiple of the block size (8)");
        }
        int checkInt1 = keyBuffer.readUInt32AsInt();
        if (checkInt1 != (checkInt2 = keyBuffer.readUInt32AsInt())) {
            throw new KeyDecryptionFailedException();
        }
        String keyType = keyBuffer.readString();
        KeyType kt = KeyType.fromString(keyType);
        logger.info("Read key type: {}", (Object)keyType, (Object)kt);
        switch (kt) {
            case ED25519: {
                keyBuffer.readBytes();
                keyBuffer.readUInt32();
                byte[] privKey = new byte[32];
                keyBuffer.readRawBytes(privKey);
                keyBuffer.readRawBytes(new byte[32]);
                kp = new KeyPair(publicKey, new EdDSAPrivateKey(new EdDSAPrivateKeySpec(privKey, EdDSANamedCurveTable.getByName("Ed25519"))));
                break;
            }
            case RSA: {
                RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = this.readRsaPrivateKeySpec(keyBuffer);
                PrivateKey privateKey = SecurityUtils.getKeyFactory("RSA").generatePrivate(rsaPrivateCrtKeySpec);
                kp = new KeyPair(publicKey, privateKey);
                break;
            }
            case ECDSA256: {
                kp = new KeyPair(publicKey, this.createECDSAPrivateKey(kt, keyBuffer, "P-256"));
                break;
            }
            case ECDSA384: {
                kp = new KeyPair(publicKey, this.createECDSAPrivateKey(kt, keyBuffer, "P-384"));
                break;
            }
            case ECDSA521: {
                kp = new KeyPair(publicKey, this.createECDSAPrivateKey(kt, keyBuffer, "P-521"));
                break;
            }
            default: {
                throw new IOException("Cannot decode keytype " + keyType + " in openssh-key-v1 files (yet).");
            }
        }
        keyBuffer.readString();
        byte[] padding = new byte[keyBuffer.available()];
        keyBuffer.readRawBytes(padding);
        for (int i = 0; i < padding.length; ++i) {
            if (padding[i] == i + 1) continue;
            throw new IOException("Padding of key format contained wrong byte at position: " + i);
        }
        return kp;
    }

    private PrivateKey createECDSAPrivateKey(KeyType kt, Buffer.PlainBuffer buffer, String name) throws GeneralSecurityException, Buffer.BufferException {
        kt.readPubKeyFromBuffer(buffer);
        BigInteger s = new BigInteger(1, buffer.readBytes());
        X9ECParameters ecParams = NISTNamedCurves.getByName(name);
        ECNamedCurveSpec ecCurveSpec = new ECNamedCurveSpec(name, ecParams.getCurve(), ecParams.getG(), ecParams.getN());
        ECPrivateKeySpec pks = new ECPrivateKeySpec(s, ecCurveSpec);
        return SecurityUtils.getKeyFactory("ECDSA").generatePrivate(pks);
    }

    private RSAPrivateCrtKeySpec readRsaPrivateKeySpec(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        BigInteger modulus = buffer.readMPInt();
        BigInteger publicExponent = buffer.readMPInt();
        BigInteger privateExponent = buffer.readMPInt();
        BigInteger crtCoefficient = buffer.readMPInt();
        BigInteger primeP = buffer.readMPInt();
        BigInteger primeQ = buffer.readMPInt();
        BigInteger primeExponentP = privateExponent.remainder(primeP.subtract(BigInteger.ONE));
        BigInteger primeExponentQ = privateExponent.remainder(primeQ.subtract(BigInteger.ONE));
        return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new OpenSSHKeyV1KeyFile();
        }

        @Override
        public String getName() {
            return KeyFormat.OpenSSHv1.name();
        }
    }
}

