/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.client.RemoteClientManager;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.kit.MonitoringInstance;
import org.terracotta.angela.agent.kit.RemoteKitManager;
import org.terracotta.angela.agent.kit.TerracottaInstall;
import org.terracotta.angela.agent.kit.TmsInstall;
import org.terracotta.angela.agent.kit.ToolInstall;
import org.terracotta.angela.agent.kit.VoterInstall;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.TerracottaToolInstance;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.TerracottaVoterState;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.metrics.HardwareMetric;
import org.terracotta.angela.common.metrics.MonitoringCommand;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.tms.security.config.TmsServerSecurityConfig;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.FileUtils;
import org.terracotta.angela.common.util.Jcmd;
import org.terracotta.angela.common.util.ProcessUtil;

public class AgentController {
    private static final Logger logger = LoggerFactory.getLogger(AgentController.class);
    private final Map<InstanceId, TerracottaInstall> tsaInstalls = new HashMap<InstanceId, TerracottaInstall>();
    private final Map<InstanceId, TmsInstall> tmsInstalls = new HashMap<InstanceId, TmsInstall>();
    private final Map<InstanceId, VoterInstall> voterInstalls = new HashMap<InstanceId, VoterInstall>();
    private final Map<InstanceId, ToolInstall> clusterToolInstalls = new HashMap<InstanceId, ToolInstall>();
    private final Map<InstanceId, ToolInstall> configToolInstalls = new HashMap<InstanceId, ToolInstall>();
    private final AgentID localAgentID;
    private final PortAllocator portAllocator;
    private volatile MonitoringInstance monitoringInstance;
    private static volatile AgentController instance;

    public AgentController(AgentID localAgentID, PortAllocator portAllocator) {
        this.localAgentID = localAgentID;
        this.portAllocator = portAllocator;
    }

    public boolean installTsa(InstanceId instanceId, TerracottaServer terracottaServer, License license, String kitInstallationName, Distribution distribution, Topology topology, String kitInstallationPath) {
        File kitLocation;
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        if (terracottaInstall == null || !terracottaInstall.installed(distribution)) {
            if (kitInstallationPath == null) {
                RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
                if (!kitManager.isKitAvailable()) {
                    return false;
                }
                logger.debug("[{}] Installing kit for {} from {}", this.localAgentID, terracottaServer, distribution);
                kitLocation = kitManager.installKit(license, topology.getServersHostnames());
                terracottaInstall = this.tsaInstalls.computeIfAbsent(instanceId, iid -> new TerracottaInstall(this.portAllocator));
            } else {
                kitLocation = new File(kitInstallationPath);
                if (license != null) {
                    license.writeToFile(kitLocation);
                }
                terracottaInstall = this.tsaInstalls.computeIfAbsent(instanceId, iid -> new TerracottaInstall(this.portAllocator));
            }
        } else {
            kitLocation = terracottaInstall.kitLocation(distribution);
            logger.debug("[{}] Kit for {} already installed", (Object)this.localAgentID, (Object)terracottaServer);
        }
        Path workingPath = Agent.WORK_DIR.resolve(instanceId.toString());
        try {
            Files.createDirectories(workingPath, new FileAttribute[0]);
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
        Path nodeHome = workingPath.resolve(terracottaServer.getServerSymbolicName().getSymbolicName());
        int index = 0;
        while (true) {
            try {
                Files.createDirectory(nodeHome, new FileAttribute[0]);
            }
            catch (IOException io) {
                if (index > 9) {
                    throw new UncheckedIOException(io);
                }
                nodeHome = workingPath.resolve(terracottaServer.getServerSymbolicName().getSymbolicName() + "_" + index++);
                continue;
            }
            break;
        }
        terracottaInstall.addServer(terracottaServer, kitLocation, nodeHome.toFile(), license, distribution, topology);
        return true;
    }

    public String getTsaInstallPath(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        TerracottaServerInstance terracottaServerInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (terracottaServerInstance == null) {
            throw new IllegalStateException("Server " + terracottaServer + " has not been installed");
        }
        return terracottaInstall.getInstallLocation(terracottaServer).getPath();
    }

    public String getConfigToolInstallPath(InstanceId instanceId) {
        ToolInstall toolInstall = this.configToolInstalls.get(instanceId);
        TerracottaToolInstance configToolInstance = toolInstall.getInstance();
        if (configToolInstance == null) {
            throw new IllegalStateException("Config tool has not been installed");
        }
        return toolInstall.getWorkingDir().getPath();
    }

    public String getClusterToolInstallPath(InstanceId instanceId) {
        ToolInstall toolInstall = this.clusterToolInstalls.get(instanceId);
        TerracottaToolInstance clusterToolInstance = toolInstall.getInstance();
        if (clusterToolInstance == null) {
            throw new IllegalStateException("Cluster tool has not been installed");
        }
        return toolInstall.getWorkingDir().getPath();
    }

    public String getTsaKitLocation(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        TerracottaServerInstance terracottaServerInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (terracottaServerInstance == null) {
            throw new IllegalStateException("Server " + terracottaServer + " has not been installed");
        }
        return terracottaInstall.getKitLocation(terracottaServer).getPath();
    }

    public String getTsaLicensePath(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        if (terracottaInstall == null) {
            throw new IllegalStateException("Server has not been installed");
        }
        File licenseFileLocation = terracottaInstall.getLicenseFileLocation(terracottaServer);
        return licenseFileLocation == null ? null : licenseFileLocation.getPath();
    }

    public boolean installTms(InstanceId instanceId, String tmsHostname, Distribution distribution, License license, TmsServerSecurityConfig tmsServerSecurityConfig, String kitInstallationName, TerracottaCommandLineEnvironment tcEnv, String hostName, String kitInstallationPath) {
        TmsInstall tmsInstall = this.tmsInstalls.get(instanceId);
        if (tmsInstall != null) {
            logger.debug("Kit for " + tmsHostname + " already installed");
            tmsInstall.addTerracottaManagementServer();
            return true;
        }
        Optional<Dirs> dirs = Dirs.discover(instanceId, hostName, distribution, license, kitInstallationName, kitInstallationPath);
        if (!dirs.isPresent()) {
            return false;
        }
        distribution.createDistributionController().prepareTMS(dirs.get().kitDir, dirs.get().workingDir, tmsServerSecurityConfig);
        this.tmsInstalls.put(instanceId, new TmsInstall(distribution, dirs.get().kitDir, dirs.get().workingDir, tcEnv));
        return true;
    }

    public boolean installVoter(InstanceId instanceId, TerracottaVoter terracottaVoter, Distribution distribution, License license, String kitInstallationName, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, String kitInstallationPath) {
        VoterInstall voterInstall = this.voterInstalls.get(instanceId);
        if (voterInstall == null) {
            Optional<Dirs> dirs = Dirs.discover(instanceId, terracottaVoter.getHostName(), distribution, license, kitInstallationName, kitInstallationPath);
            if (!dirs.isPresent()) {
                return false;
            }
            voterInstall = this.voterInstalls.computeIfAbsent(instanceId, id -> new VoterInstall(distribution, ((Dirs)dirs.get()).kitDir, ((Dirs)dirs.get()).workingDir, securityRootDirectory, tcEnv));
        }
        voterInstall.addVoter(terracottaVoter);
        return true;
    }

    public boolean installClusterTool(InstanceId instanceId, String hostName, Distribution distribution, License license, String kitInstallationName, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, String kitInstallationPath) {
        ToolInstall clusterToolInstall = this.clusterToolInstalls.get(instanceId);
        if (clusterToolInstall == null) {
            Optional<Dirs> dirs = Dirs.discover(instanceId, hostName, distribution, license, kitInstallationName, kitInstallationPath);
            if (!dirs.isPresent()) {
                return false;
            }
            this.clusterToolInstalls.computeIfAbsent(instanceId, id -> {
                BiFunction<Map<String, String>, String[], ToolExecutionResult> operation = (env, command) -> {
                    DistributionController distributionController = distribution.createDistributionController();
                    return distributionController.invokeClusterTool(((Dirs)dirs.get()).kitDir, ((Dirs)dirs.get()).workingDir, securityRootDirectory, tcEnv, (Map<String, String>)env, (String)command);
                };
                return new ToolInstall(((Dirs)dirs.get()).kitDir, ((Dirs)dirs.get()).workingDir, distribution, operation);
            });
        }
        return true;
    }

    public boolean installConfigTool(InstanceId instanceId, String hostName, Distribution distribution, License license, String kitInstallationName, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, String kitInstallationPath) {
        ToolInstall configToolInstall = this.configToolInstalls.get(instanceId);
        if (configToolInstall == null) {
            Optional<Dirs> dirs = Dirs.discover(instanceId, hostName, distribution, license, kitInstallationName, kitInstallationPath);
            if (!dirs.isPresent()) {
                return false;
            }
            this.configToolInstalls.computeIfAbsent(instanceId, id -> {
                BiFunction<Map<String, String>, String[], ToolExecutionResult> operation = (env, command) -> {
                    DistributionController distributionController = distribution.createDistributionController();
                    return distributionController.invokeConfigTool(((Dirs)dirs.get()).kitDir, ((Dirs)dirs.get()).workingDir, securityRootDirectory, tcEnv, (Map<String, String>)env, (String)command);
                };
                return new ToolInstall(((Dirs)dirs.get()).kitDir, ((Dirs)dirs.get()).workingDir, distribution, operation);
            });
        }
        return true;
    }

    public int startTms(InstanceId instanceId, Map<String, String> envOverrides) {
        TerracottaManagementServerInstance serverInstance = this.tmsInstalls.get(instanceId).getTerracottaManagementServerInstance();
        int port = (Integer)this.portAllocator.reserve(1).next();
        envOverrides = new LinkedHashMap<String, String>(envOverrides);
        envOverrides.put("SERVER_PORT", String.valueOf(port));
        serverInstance.start(envOverrides);
        return port;
    }

    public void stopTms(InstanceId instanceId) {
        TerracottaManagementServerInstance serverInstance = this.tmsInstalls.get(instanceId).getTerracottaManagementServerInstance();
        serverInstance.stop();
    }

    public String getTmsInstallationPath(InstanceId instanceId) {
        TmsInstall serverInstance = this.tmsInstalls.get(instanceId);
        return serverInstance.getWorkingDir().getPath();
    }

    public TerracottaManagementServerState getTmsState(InstanceId instanceId) {
        TmsInstall terracottaInstall = this.tmsInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return TerracottaManagementServerState.NOT_INSTALLED;
        }
        TerracottaManagementServerInstance serverInstance = terracottaInstall.getTerracottaManagementServerInstance();
        if (serverInstance == null) {
            return TerracottaManagementServerState.NOT_INSTALLED;
        }
        return serverInstance.getTerracottaManagementServerState();
    }

    public void uninstallTsa(InstanceId instanceId, Topology topology, TerracottaServer terracottaServer, String kitInstallationName, String kitInstallationPath) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        if (terracottaInstall != null) {
            int installationsCount = terracottaInstall.removeServer(terracottaServer);
            if (installationsCount == 0) {
                RemoteKitManager kitManager = new RemoteKitManager(instanceId, topology.getDistribution(), kitInstallationName);
                if (kitInstallationPath == null) {
                    File installLocation = Agent.WORK_DIR.resolve(instanceId.toString()).toFile();
                    logger.debug("[{}] Uninstalling kit(s) from {} for TSA", (Object)this.localAgentID, (Object)installLocation);
                    kitManager.deleteInstall(installLocation);
                }
                this.tsaInstalls.remove(instanceId);
            } else {
                logger.debug("[{}] Kit installation still in use by {} instances. Skipping uninstall", (Object)this.localAgentID, (Object)this.tsaInstalls.size());
            }
        } else {
            logger.debug("[{}] No installed kit for " + topology, (Object)this.localAgentID);
        }
    }

    public void uninstallTms(InstanceId instanceId, Distribution distribution, TmsServerSecurityConfig tmsServerSecurityConfig, String kitInstallationName, String tmsHostname, String kitInstallationPath) {
        TmsInstall tmsInstall = this.tmsInstalls.get(instanceId);
        if (tmsInstall != null) {
            tmsInstall.removeServer();
            this.tmsInstalls.remove(instanceId);
            File installLocation = tmsInstall.getWorkingDir();
            logger.debug("[{}] Uninstalling kit(s) from {} for TMS", (Object)this.localAgentID, (Object)installLocation);
            RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            kitManager.deleteInstall(installLocation);
        } else {
            logger.debug("[{}] No installed kit for " + tmsHostname, (Object)this.localAgentID);
        }
    }

    public void uninstallVoter(InstanceId instanceId, Distribution distribution, TerracottaVoter terracottaVoter, String kitInstallationName) {
        VoterInstall voterInstall = this.voterInstalls.get(instanceId);
        if (voterInstall != null) {
            int installationsCount = voterInstall.removeVoter(terracottaVoter);
            if (installationsCount == 0) {
                File installLocation = voterInstall.getWorkingDir();
                logger.debug("[{}] Uninstalling kit(s) from {} for voter", (Object)this.localAgentID, (Object)installLocation);
                RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
                kitManager.deleteInstall(installLocation);
                this.voterInstalls.remove(instanceId);
            } else {
                logger.debug("[{}] Kit installation still in use by {} voter instances. Skipping uninstall", (Object)this.localAgentID, (Object)this.voterInstalls.size());
            }
        } else {
            logger.debug("[{}] No installed kit for " + terracottaVoter.getHostName());
        }
    }

    public void uninstallClusterTool(InstanceId instanceId, Distribution distribution, String hostName, String kitInstallationName) {
        ToolInstall clusterToolInstall = this.clusterToolInstalls.get(instanceId);
        if (clusterToolInstall != null) {
            this.clusterToolInstalls.remove(instanceId);
            File installLocation = clusterToolInstall.getWorkingDir();
            logger.debug("[{}] Uninstalling kit(s) from {} for cluster tool", (Object)this.localAgentID, (Object)installLocation);
            RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            kitManager.deleteInstall(installLocation);
        } else {
            logger.debug("[{}] No installed kit for " + hostName);
        }
    }

    public void uninstallConfigTool(InstanceId instanceId, Distribution distribution, String hostName, String kitInstallationName) {
        ToolInstall configToolInstall = this.configToolInstalls.get(instanceId);
        if (configToolInstall != null) {
            this.configToolInstalls.remove(instanceId);
            File installLocation = configToolInstall.getWorkingDir();
            logger.debug("[{}] Uninstalling kit(s) from {} for config tool", (Object)this.localAgentID, (Object)installLocation);
            RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            kitManager.deleteInstall(installLocation);
        } else {
            logger.debug("[{}] No installed kit for " + hostName, (Object)this.localAgentID);
        }
    }

    public void createTsa(InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv, Map<String, String> envOverrides, List<String> startUpArgs, Duration inactivityKillerDelay) {
        TerracottaServerInstance serverInstance = this.tsaInstalls.get(instanceId).getTerracottaServerInstance(terracottaServer);
        serverInstance.create(tcEnv, envOverrides, startUpArgs, inactivityKillerDelay);
    }

    public void stopTsa(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return;
        }
        TerracottaServerInstance serverInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        serverInstance.stop();
    }

    public void waitForTsaInState(InstanceId instanceId, TerracottaServer terracottaServer, Set<TerracottaServerState> wanted) {
        TerracottaServerInstance serverInstance = this.tsaInstalls.get(instanceId).getTerracottaServerInstance(terracottaServer);
        serverInstance.waitForState(wanted);
    }

    public ToolExecutionResult configure(InstanceId instanceId, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPorts, License license, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, Map<String, String> env, List<String> command) {
        ToolInstall clusterToolInstall = this.clusterToolInstalls.get(instanceId);
        if (clusterToolInstall == null) {
            throw new IllegalStateException("Cluster tool has not been installed");
        }
        DistributionController distributionController = clusterToolInstall.getDistribution().createDistributionController();
        return distributionController.configureCluster(clusterToolInstall.getKitDir(), clusterToolInstall.getWorkingDir(), topology, proxyTsaPorts, license, securityRootDirectory, tcEnv, env, command.toArray(new String[0]));
    }

    public ToolExecutionResult activate(InstanceId instanceId, License license, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, Map<String, String> env, List<String> command) {
        ToolInstall configToolInstall = this.configToolInstalls.get(instanceId);
        if (configToolInstall == null) {
            throw new IllegalStateException("Config tool has not been installed");
        }
        DistributionController distributionController = configToolInstall.getDistribution().createDistributionController();
        return distributionController.activateCluster(configToolInstall.getKitDir(), configToolInstall.getWorkingDir(), license, securityRootDirectory, tcEnv, env, command.toArray(new String[0]));
    }

    public TerracottaServerState getTsaState(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return TerracottaServerState.NOT_INSTALLED;
        }
        TerracottaServerInstance serverInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (serverInstance == null) {
            return TerracottaServerState.NOT_INSTALLED;
        }
        return serverInstance.getTerracottaServerState();
    }

    public Map<ServerSymbolicName, Integer> getProxyGroupPortsForServer(InstanceId instanceId, TerracottaServer terracottaServer) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        if (terracottaInstall == null) {
            return Collections.emptyMap();
        }
        TerracottaServerInstance serverInstance = terracottaInstall.getTerracottaServerInstance(terracottaServer);
        if (serverInstance == null) {
            return Collections.emptyMap();
        }
        return serverInstance.getProxiedPorts();
    }

    public void disrupt(InstanceId instanceId, TerracottaServer src, TerracottaServer target) {
        this.disrupt(instanceId, src, Collections.singleton(target));
    }

    public void disrupt(InstanceId instanceId, TerracottaServer src, Collection<TerracottaServer> targets) {
        TerracottaServerInstance serverInstance = this.tsaInstalls.get(instanceId).getTerracottaServerInstance(src);
        serverInstance.disrupt(targets);
    }

    public void undisrupt(InstanceId instanceId, TerracottaServer src, TerracottaServer target) {
        this.undisrupt(instanceId, src, Collections.singleton(target));
    }

    public void undisrupt(InstanceId instanceId, TerracottaServer src, Collection<TerracottaServer> targets) {
        TerracottaServerInstance serverInstance = this.tsaInstalls.get(instanceId).getTerracottaServerInstance(src);
        serverInstance.undisrupt(targets);
    }

    public TerracottaVoterState getVoterState(InstanceId instanceId, TerracottaVoter terracottaVoter) {
        VoterInstall voterInstall = this.voterInstalls.get(instanceId);
        if (voterInstall == null) {
            return TerracottaVoterState.NOT_INSTALLED;
        }
        TerracottaVoterInstance terracottaVoterInstance = voterInstall.getTerracottaVoterInstance(terracottaVoter);
        if (terracottaVoterInstance == null) {
            return TerracottaVoterState.NOT_INSTALLED;
        }
        return terracottaVoterInstance.getTerracottaVoterState();
    }

    public void startVoter(InstanceId instanceId, TerracottaVoter terracottaVoter, Map<String, String> envOverrides) {
        TerracottaVoterInstance terracottaVoterInstance = this.voterInstalls.get(instanceId).getTerracottaVoterInstance(terracottaVoter);
        terracottaVoterInstance.start(envOverrides);
    }

    public void stopVoter(InstanceId instanceId, TerracottaVoter terracottaVoter) {
        TerracottaVoterInstance terracottaVoterInstance = this.voterInstalls.get(instanceId).getTerracottaVoterInstance(terracottaVoter);
        terracottaVoterInstance.stop();
    }

    public ToolExecutionResult clusterTool(InstanceId instanceId, Map<String, String> env, String ... command) {
        ToolInstall clusterToolInstall = this.clusterToolInstalls.get(instanceId);
        if (clusterToolInstall == null) {
            throw new IllegalStateException("Cluster tool has not been installed");
        }
        return clusterToolInstall.getInstance().execute(env, command);
    }

    public ToolExecutionResult configTool(InstanceId instanceId, Map<String, String> env, String ... command) {
        ToolInstall configToolInstall = this.configToolInstalls.get(instanceId);
        if (configToolInstall == null) {
            throw new IllegalStateException("Config tool has not been installed");
        }
        return configToolInstall.getInstance().execute(env, command);
    }

    public ToolExecutionResult serverJcmd(InstanceId instanceId, TerracottaServer terracottaServer, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        TerracottaServerState tsaState = this.getTsaState(instanceId, terracottaServer);
        if (!EnumSet.of(TerracottaServerState.STARTED_AS_ACTIVE, TerracottaServerState.STARTED_AS_PASSIVE).contains((Object)tsaState)) {
            throw new IllegalStateException("Cannot control jcmd: server " + terracottaServer.getServerSymbolicName() + " has not started");
        }
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        return terracottaInstall.getTerracottaServerInstance(terracottaServer).jcmd(tcEnv, arguments);
    }

    public ToolExecutionResult clientJcmd(int clientPid, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        return Jcmd.jcmd(clientPid, tcEnv, arguments);
    }

    public ToolExecutionResult serverCmd(InstanceId instanceId, TerracottaServer terracottaServer, String terracottaCommand) {
        TerracottaInstall terracottaInstall = this.tsaInstalls.get(instanceId);
        return terracottaInstall.getTerracottaServerInstance(terracottaServer).cmd(terracottaCommand);
    }

    public void startHardwareMonitoring(Path workingPath, Map<HardwareMetric, MonitoringCommand> commands) {
        if (this.monitoringInstance == null) {
            logger.debug("[{}] Starting monitoring: {}...", (Object)this.localAgentID, (Object)commands.keySet());
            this.monitoringInstance = new MonitoringInstance(workingPath);
            this.monitoringInstance.startHardwareMonitoring(commands);
        } else {
            logger.debug("[{}] Monitoring was already started", (Object)this.localAgentID);
        }
    }

    public boolean isMonitoringRunning(HardwareMetric hardwareMetric) {
        return this.monitoringInstance.isMonitoringRunning(hardwareMetric);
    }

    public void stopHardwareMonitoring() {
        if (this.monitoringInstance != null) {
            this.monitoringInstance.stopHardwareMonitoring();
            this.monitoringInstance = null;
        }
    }

    public void stopClient(InstanceId instanceId, int pid) {
        try {
            logger.info("[{}] killing client '{}' with PID {}", this.localAgentID, instanceId, pid);
            if (!this.localAgentID.isLocal()) {
                ProcessUtil.destroyGracefullyOrForcefullyAndWait(pid);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error stopping client " + instanceId, e);
        }
    }

    public void deleteClient(InstanceId instanceId) {
        Path subAgentRoot = new RemoteClientManager(instanceId).getClientInstallationPath();
        logger.debug("[{}] Cleaning up directory structure '{}' of client {}", this.localAgentID, subAgentRoot, instanceId);
        FileUtils.deleteTree(subAgentRoot);
    }

    public String instanceWorkDir(InstanceId instanceId) {
        return Agent.WORK_DIR.resolve(instanceId.toString()).toAbsolutePath().toString();
    }

    public AgentID spawnClient(InstanceId instanceId, TerracottaCommandLineEnvironment tcEnv, AgentGroup group) {
        if (this.localAgentID.isLocal()) {
            return this.localAgentID;
        }
        RemoteClientManager remoteClientManager = new RemoteClientManager(instanceId);
        return remoteClientManager.spawnClient(tcEnv, group);
    }

    public List<String> listFiles(String folder) {
        File[] files = new File(folder).listFiles((File pathname) -> !pathname.isDirectory());
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    public List<String> listFolders(String folder) {
        File[] files = new File(folder).listFiles(File::isDirectory);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    public byte[] downloadFile(String file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)baos);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error downloading file " + file, ioe);
        }
        return baos.toByteArray();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void uploadFile(String filename, byte[] data) {
        File file = new File(filename);
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Error uploading file " + filename, ioe);
        }
    }

    public byte[] downloadFolder(String file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            File root = new File(file);
            this.zipFolder(zos, "", root);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Error downloading folder " + file, ioe);
        }
        return baos.toByteArray();
    }

    private void zipFolder(ZipOutputStream zos, String parent, File folder) throws IOException {
        if (!folder.canRead()) {
            throw new IOException("Folder does not exist or is not readable : " + folder);
        }
        File[] files = folder.listFiles();
        if (files == null) {
            throw new IOException("Error listing folder " + folder);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.zipFolder(zos, parent + file.getName() + "/", file);
                continue;
            }
            ZipEntry zipEntry = new ZipEntry(parent + file.getName());
            zipEntry.setTime(file.lastModified());
            zos.putNextEntry(zipEntry);
            try (FileInputStream fis = new FileInputStream(file);){
                IOUtils.copy((InputStream)fis, (OutputStream)zos);
            }
            zos.closeEntry();
        }
    }

    public String toString() {
        return this.localAgentID.toString();
    }

    public static synchronized AgentController getInstance() {
        if (instance == null) {
            throw new IllegalStateException("AgentController not initialized");
        }
        return instance;
    }

    public static synchronized void setUniqueInstance(AgentController agentController) {
        if (instance != null) {
            throw new IllegalStateException("AgentController already initialized to: " + instance);
        }
        instance = agentController;
        logger.info("Installed AgentController: " + agentController);
    }

    public static void removeUniqueInstance(AgentController agentController) {
        if (instance == null) {
            throw new IllegalStateException("AgentController not initialized");
        }
        if (instance != agentController) {
            throw new IllegalStateException("Unable to remove installed AgentController: " + instance + ": caller has another AgentController: " + agentController);
        }
        instance = null;
        logger.info("Uninstalled AgentController: " + agentController);
    }

    private static class Dirs {
        final File kitDir;
        final File workingDir;
        final RemoteKitManager kitManager;

        public Dirs(File kitDir, File workingDir, RemoteKitManager kitManager) {
            this.kitDir = kitDir;
            this.workingDir = workingDir;
            this.kitManager = kitManager;
        }

        static Optional<Dirs> discover(InstanceId instanceId, String hostName, Distribution distribution, License license, String kitInstallationName, String kitInstallationPath) {
            File kitPath;
            if (kitInstallationPath == null) {
                RemoteKitManager kitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
                if (!kitManager.isKitAvailable()) {
                    return Optional.empty();
                }
                kitPath = kitManager.installKit(license, Collections.singletonList(hostName));
                logger.debug("Installing kit on host {} from {}", (Object)hostName, (Object)distribution);
            } else {
                kitPath = new File(kitInstallationPath);
            }
            Path workingPath = Agent.WORK_DIR.resolve(instanceId.toString());
            try {
                Files.createDirectories(workingPath, new FileAttribute[0]);
                if (license != null) {
                    license.writeToFile(workingPath.toFile());
                }
            }
            catch (IOException e) {
                logger.debug("Can not create {}", (Object)workingPath, (Object)e);
                throw new UncheckedIOException(e);
            }
            return Optional.of(new Dirs(kitPath, workingPath.toFile(), null));
        }
    }
}

