/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;

public class JdbcProtocolContext {
    private final ClientListenerProtocolVersion ver;
    private final EnumSet<JdbcThinFeature> features;
    private final boolean keepBinary;

    public JdbcProtocolContext(ClientListenerProtocolVersion ver, EnumSet<JdbcThinFeature> features, boolean keepBinary) {
        assert (Objects.nonNull(features));
        this.ver = ver;
        this.features = features;
        this.keepBinary = keepBinary;
    }

    public boolean isStreamingSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0;
    }

    public boolean isAutoCommitSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0;
    }

    public boolean isTableTypesSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0;
    }

    public boolean isAffinityAwarenessSupported() {
        return this.ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0;
    }

    public boolean isFeatureSupported(JdbcThinFeature feature) {
        return this.features.contains(feature);
    }

    EnumSet<JdbcThinFeature> features() {
        return this.features;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }
}

