/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin.io.gridnioserver;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.client.thin.io.ClientMessageDecoder;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.jetbrains.annotations.Nullable;

class GridNioClientParser
implements GridNioParser {
    private static final int SES_META_DECODER = GridNioSessionMetaKey.nextUniqueKey();

    GridNioClientParser() {
    }

    @Override
    @Nullable
    public Object decode(GridNioSession ses, ByteBuffer buf) {
        byte[] bytes;
        ClientMessageDecoder decoder = (ClientMessageDecoder)ses.meta(SES_META_DECODER);
        if (decoder == null) {
            decoder = new ClientMessageDecoder();
            ses.addMeta(SES_META_DECODER, decoder);
        }
        if ((bytes = decoder.apply(buf)) == null) {
            return null;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) {
        return (ByteBuffer)msg;
    }
}

