/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.terracotta.angela.common.util.JDK;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavaLocationResolver {
    private final List<JDK> jdks;

    public JavaLocationResolver() {
        this.jdks = JavaLocationResolver.findJDKs();
    }

    public JavaLocationResolver(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        try {
            this.jdks = JavaLocationResolver.findJDKs(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<JDK> resolveJavaLocations(String version, Set<String> vendors, boolean checkLocalValidity) {
        Objects.requireNonNull(vendors);
        List<JDK> list = this.jdks.stream().filter(jdk -> !checkLocalValidity || jdk.canBeLocated()).filter(jdk -> jdk.matches(version, vendors)).collect(Collectors.toList());
        if (list.isEmpty()) {
            String message = "Missing JDK with version [" + version + "]";
            if (!vendors.isEmpty()) {
                message = message + " and one vendor in [" + vendors + "]";
            }
            message = message + " config in toolchains.xml. Available JDKs: " + this.jdks;
            throw new RuntimeException(message);
        }
        return list;
    }

    private static List<JDK> findJDKs() {
        try {
            List<JDK> jdks = JavaLocationResolver.findJDKs(new File(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "toolchains.xml").toURI().toURL());
            return Collections.unmodifiableList(jdks);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<JDK> findJDKs(URL toolchainsLocation) {
        try (InputStream is = toolchainsLocation.openStream();){
            List<JDK> list = JavaLocationResolver.findJDKs(is);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<JDK> findJDKs(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<JDK> jdks = new ArrayList<JDK>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        NodeList toolchainList = doc.getElementsByTagName("toolchain");
        for (int i = 0; i < toolchainList.getLength(); ++i) {
            String home;
            Element toolchainElement = (Element)toolchainList.item(i);
            Element configurationElement = (Element)toolchainElement.getElementsByTagName("configuration").item(0);
            if (configurationElement == null || (home = configurationElement.getElementsByTagName("jdkHome").item(0).getTextContent()).trim().isEmpty()) continue;
            Element providesElement = (Element)toolchainElement.getElementsByTagName("provides").item(0);
            if (providesElement == null) {
                jdks.add(new JDK(home, null, null));
                continue;
            }
            String version = JavaLocationResolver.textContentOf(providesElement, "version");
            String vendor = JavaLocationResolver.textContentOf(providesElement, "vendor");
            jdks.add(new JDK(home, version, vendor));
        }
        return jdks;
    }

    private static String textContentOf(Element element, String subElementName) {
        NodeList nodeList = element.getElementsByTagName(subElementName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }
}

