/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.angela.agent.com.AgentID;

public abstract class AgentGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UUID id;
    private final AgentID agentID;

    public AgentGroup(UUID id, AgentID agentID) {
        this.id = id;
        this.agentID = agentID;
    }

    public final UUID getId() {
        return this.id;
    }

    public final AgentID getLocalAgentID() {
        return this.agentID;
    }

    public abstract Collection<AgentID> getAllAgents();

    public final Collection<AgentID> getClientAgents() {
        return this.getAllAgents().stream().filter(agentID -> !agentID.isLocal()).filter(agentID -> !agentID.getName().equals("orchestrator-agent") && !agentID.getName().equals("remote-agent")).collect(Collectors.toList());
    }

    public final Collection<AgentID> getSpawnedAgents() {
        return this.getAllAgents().stream().filter(agentID -> !agentID.isLocal()).filter(agentID -> !agentID.getName().equals("orchestrator-agent")).collect(Collectors.toList());
    }

    public final Collection<AgentID> getRemoteAgentIDs() {
        return this.getAllAgents().stream().filter(agentID -> !agentID.isLocal()).filter(agentID -> agentID.getName().equals("remote-agent")).collect(Collectors.toList());
    }

    public final Collection<String> getPeerAddresses() {
        return this.getAllAgents().stream().map(AgentID::getAddress).map(Objects::toString).collect(Collectors.toList());
    }

    public final String toString() {
        return this.getId() + "=" + this.getAllAgents();
    }

    public final int size() {
        return this.getAllAgents().size();
    }

    public final boolean isEmpty() {
        return this.getAllAgents().isEmpty();
    }

    public final boolean contains(AgentID agentID) {
        return this.getAllAgents().contains(agentID);
    }

    public final Stream<AgentID> stream() {
        return this.getAllAgents().stream();
    }

    public final void forEach(Consumer<? super AgentID> action) {
        this.getAllAgents().forEach(action);
    }
}

