/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpHelper;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.diagnostic.VisorPageLocksResult;
import org.apache.ignite.internal.visor.diagnostic.VisorPageLocksTrackerArgs;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorPageLocksTask
extends VisorMultiNodeTask<VisorPageLocksTrackerArgs, Map<ClusterNode, VisorPageLocksResult>, VisorPageLocksResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorPageLocksTrackerArgs, VisorPageLocksResult> job(VisorPageLocksTrackerArgs arg) {
        return new VisorPageLocksTrackerJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorPageLocksTrackerArgs> arg) {
        HashSet<UUID> nodeIds = new HashSet<UUID>();
        Set<String> nodeIds0 = arg.getArgument().nodeIds();
        for (ClusterNode node : this.ignite.cluster().nodes()) {
            if (!nodeIds0.contains(String.valueOf(node.consistentId())) && !nodeIds0.contains(node.id().toString())) continue;
            nodeIds.add(node.id());
        }
        if (F.isEmpty(nodeIds)) {
            nodeIds.add(this.ignite.localNode().id());
        }
        return nodeIds;
    }

    @Override
    @Nullable
    protected Map<ClusterNode, VisorPageLocksResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        TreeMap<ClusterNode, VisorPageLocksResult> mapRes = new TreeMap<ClusterNode, VisorPageLocksResult>(NodeOrderComparator.getInstance());
        results.forEach(j -> {
            if (j.getException() == null) {
                mapRes.put(j.getNode(), (VisorPageLocksResult)j.getData());
            } else if (j.getException() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                j.getException().printStackTrace(pw);
                mapRes.put(j.getNode(), new VisorPageLocksResult(sw.toString()));
            }
        });
        return mapRes;
    }

    private static class VisorPageLocksTrackerJob
    extends VisorJob<VisorPageLocksTrackerArgs, VisorPageLocksResult> {
        private static final long serialVersionUID = 0L;

        private VisorPageLocksTrackerJob(VisorPageLocksTrackerArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorPageLocksResult run(VisorPageLocksTrackerArgs arg) {
            String result;
            PageLockTrackerManager lockTrackerMgr = this.ignite.context().cache().context().diagnostic().pageLockTracker();
            switch (arg.operation()) {
                case DUMP_LOG: {
                    lockTrackerMgr.dumpLocksToLog();
                    result = "Page locks dump was printed to console " + ToStringDumpHelper.DATE_FMT.format(Instant.now());
                    break;
                }
                case DUMP_FILE: {
                    String filePath = arg.filePath() != null ? lockTrackerMgr.dumpLocksToFile(arg.filePath()) : lockTrackerMgr.dumpLocksToFile();
                    result = "Page locks dump was writtern to file " + filePath;
                    break;
                }
                default: {
                    result = "Unsupported operation: " + (Object)((Object)arg.operation());
                }
            }
            return new VisorPageLocksResult(result);
        }

        public String toString() {
            return S.toString(VisorPageLocksTrackerJob.class, this);
        }
    }
}

