/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcBatchExecuteRequest
extends JdbcRequest {
    private String schemaName;
    @GridToStringInclude(sensitive=true)
    private List<JdbcQuery> queries;
    private boolean autoCommit;
    private boolean lastStreamBatch;

    public JdbcBatchExecuteRequest() {
        super((byte)6);
    }

    protected JdbcBatchExecuteRequest(byte type) {
        super(type);
    }

    public JdbcBatchExecuteRequest(String schemaName, List<JdbcQuery> queries, boolean autoCommit, boolean lastStreamBatch) {
        super((byte)6);
        assert (lastStreamBatch || !F.isEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.autoCommit = autoCommit;
        this.lastStreamBatch = lastStreamBatch;
    }

    protected JdbcBatchExecuteRequest(byte type, String schemaName, List<JdbcQuery> queries, boolean autoCommit, boolean lastStreamBatch) {
        super(type);
        assert (lastStreamBatch || !F.isEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.autoCommit = autoCommit;
        this.lastStreamBatch = lastStreamBatch;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    public List<JdbcQuery> queries() {
        return this.queries;
    }

    boolean autoCommit() {
        return this.autoCommit;
    }

    public boolean isLastStreamBatch() {
        return this.lastStreamBatch;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeString(this.schemaName);
        if (!F.isEmpty(this.queries)) {
            writer.writeInt(this.queries.size());
            for (JdbcQuery q : this.queries) {
                q.writeBinary(writer, protoCtx);
            }
        } else {
            writer.writeInt(0);
        }
        if (protoCtx.isStreamingSupported()) {
            writer.writeBoolean(this.lastStreamBatch);
        }
        if (protoCtx.isAutoCommitSupported()) {
            writer.writeBoolean(this.autoCommit);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.schemaName = reader.readString();
        int n = reader.readInt();
        this.queries = new ArrayList<JdbcQuery>(n);
        for (int i = 0; i < n; ++i) {
            JdbcQuery qry = new JdbcQuery();
            qry.readBinary(reader, protoCtx);
            this.queries.add(qry);
        }
        if (protoCtx.isStreamingSupported()) {
            this.lastStreamBatch = reader.readBoolean();
        }
        if (protoCtx.isAutoCommitSupported()) {
            this.autoCommit = reader.readBoolean();
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcBatchExecuteRequest.class, this, super.toString());
    }
}

